/*
 * Decompiled with CFR 0.152.
 */
package oracle.ideri.navigator.dnd;

import java.awt.datatransfer.DataFlavor;
import java.awt.datatransfer.Transferable;
import java.io.File;
import java.net.URL;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import javax.swing.tree.DefaultMutableTreeNode;
import oracle.ide.Context;
import oracle.ide.Ide;
import oracle.ide.cmd.AddContentCommand;
import oracle.ide.controller.IdeAction;
import oracle.ide.explorer.TNode;
import oracle.ide.explorer.TreeExplorer;
import oracle.ide.model.ContentSetProvider;
import oracle.ide.model.Element;
import oracle.ide.model.Locatable;
import oracle.ide.model.Node;
import oracle.ide.model.NodeFactory;
import oracle.ide.model.Project;
import oracle.ide.model.ProjectContent;
import oracle.ide.model.RelativeDirectoryContextFolder;
import oracle.ide.net.URLFactory;
import oracle.ide.util.ModelUtil;
import oracle.ide.util.dnd.DefaultDropTargetListener;
import oracle.ide.util.dnd.DropHelper;
import oracle.ide.util.dnd.TransferableTreeNode;

public class ProjectNodeDropHelper
implements DropHelper {
    public static final Class DROP_NODE_TYPE = Project.class;

    public float getWeight() {
        return 10.0f;
    }

    public boolean canTransferData(Object object, DataFlavor[] dataFlavorArray, int n) {
        TNode tNode;
        TNode tNode2;
        if ((n & 3) > 0 && object instanceof TNode && (tNode2 = (tNode = (TNode)object).getAncestorTNode(Project.class, true)) != null) {
            int n2 = 0;
            while (n2 < dataFlavorArray.length) {
                if (dataFlavorArray[n2].equals(DefaultDropTargetListener.JAVA_FILELIST_FLAVOR)) {
                    return true;
                }
                if (dataFlavorArray[n2].equals(TransferableTreeNode.TREE_NODE_FLAVOR)) {
                    return true;
                }
                ++n2;
            }
        }
        return false;
    }

    public boolean transferData(Object object, Transferable[] transferableArray, int n) {
        if (!(object instanceof TNode)) {
            return false;
        }
        try {
            if (transferableArray.length == 1) {
                DefaultMutableTreeNode defaultMutableTreeNode;
                Transferable transferable = transferableArray[0];
                if (transferable.isDataFlavorSupported(DefaultDropTargetListener.JAVA_FILELIST_FLAVOR)) {
                    List list = (List)transferable.getTransferData(DefaultDropTargetListener.JAVA_FILELIST_FLAVOR);
                    if (list.size() == 1) {
                        this.transferExternalFileList(object, list);
                    }
                } else if (transferable.isDataFlavorSupported(TransferableTreeNode.TREE_NODE_FLAVOR) && (defaultMutableTreeNode = (DefaultMutableTreeNode)transferable.getTransferData(TransferableTreeNode.TREE_NODE_FLAVOR)) instanceof TNode) {
                    this.transferTNode(object, (TNode)((Object)defaultMutableTreeNode), n);
                }
            }
            boolean bl = true;
            return bl;
        }
        catch (Exception exception) {
            exception.printStackTrace();
            return false;
        }
    }

    private void transferTNode(Object object, TNode tNode, int n) throws Exception {
        URL[] uRLArray;
        TNode tNode2 = tNode.getAncestorTNode(Project.class, false);
        if (ModelUtil.areEqual((Object)object, (Object)tNode2)) {
            return;
        }
        if (tNode == tNode2) {
            return;
        }
        Element element = tNode.getData();
        if (element instanceof Locatable) {
            URL uRL = ((Locatable)((Object)element)).getURL();
            uRLArray = new URL[]{uRL};
        } else if (element instanceof RelativeDirectoryContextFolder) {
            ArrayList arrayList = new ArrayList();
            this.addChildren((RelativeDirectoryContextFolder)element, arrayList);
            uRLArray = new URL[arrayList.size()];
            arrayList.toArray(uRLArray);
        } else {
            uRLArray = new URL[]{};
        }
        if (uRLArray.length > 0) {
            ArrayList<Node> arrayList = new ArrayList<Node>(uRLArray.length);
            Element element2 = tNode.getAncestor(Project.class);
            if (element2 != null) {
                Project project = (Project)element2;
                ProjectContent projectContent = ProjectContent.getInstance(project);
                ContentSetProvider[] contentSetProviderArray = ProjectContent.getContentSetProviders();
                TNode tNode3 = (TNode)object;
                Project project2 = (Project)tNode3.getData();
                int n2 = 0;
                while (n2 < uRLArray.length) {
                    Node node = null;
                    try {
                        int n3 = 0;
                        while (n3 < contentSetProviderArray.length) {
                            String string = contentSetProviderArray[n3].getKey();
                            if (projectContent.getContentSet(string).canHaveMember(uRLArray[n2])) {
                                if (node == null) {
                                    node = NodeFactory.findOrCreate(uRLArray[n2]);
                                    arrayList.add(node);
                                }
                                project2.add(node, string);
                            }
                            ++n3;
                        }
                    }
                    catch (Exception exception) {}
                    ++n2;
                }
                Element[] elementArray = new Element[arrayList.size()];
                arrayList.toArray(elementArray);
                if (n == 2) {
                    Context context = new Context(Ide.getActiveWorkspace(), project);
                    context.setSelection(elementArray);
                    IdeAction ideAction = IdeAction.find(21);
                    ideAction.performAction(context);
                }
                TreeExplorer treeExplorer = tNode3.getOwner();
                TNode tNode4 = treeExplorer.findTNode(elementArray[0], tNode3);
                treeExplorer.setSelected(tNode4);
            }
        }
    }

    private void addChildren(RelativeDirectoryContextFolder relativeDirectoryContextFolder, List list) {
        Iterator iterator = relativeDirectoryContextFolder.getChildren();
        while (iterator.hasNext()) {
            URL uRL;
            Element element = (Element)iterator.next();
            if (element instanceof RelativeDirectoryContextFolder) {
                this.addChildren((RelativeDirectoryContextFolder)element, list);
                continue;
            }
            if (!(element instanceof Locatable) || list.contains(uRL = ((Locatable)((Object)element)).getURL())) continue;
            list.add(uRL);
        }
    }

    private void transferExternalFileList(Object object, List list) throws Exception {
        Iterator iterator = list.iterator();
        ArrayList<Node> arrayList = new ArrayList<Node>();
        while (iterator.hasNext()) {
            File file = (File)iterator.next();
            URL uRL = URLFactory.newFileURL(file);
            try {
                arrayList.add(NodeFactory.findOrCreate(uRL));
            }
            catch (Exception exception) {}
        }
        if (arrayList.size() == 1) {
            TNode tNode = (TNode)object;
            Project project = (Project)tNode.getData();
            Context context = new Context(Ide.getActiveWorkspace(), project);
            context.setNode((Node)arrayList.get(0));
            AddContentCommand addContentCommand = new AddContentCommand();
            addContentCommand.setContext(context);
            if (addContentCommand.doit(true) == 0) {
                TreeExplorer treeExplorer = tNode.getOwner();
                TNode tNode2 = treeExplorer.findTNode((Element)arrayList.get(0), tNode);
                treeExplorer.setSelected(tNode2);
            }
        }
    }
}

