/*
 * Decompiled with CFR 0.152.
 */
package oracle.ideri.navigator.dnd;

import java.awt.datatransfer.DataFlavor;
import java.awt.datatransfer.Transferable;
import java.awt.datatransfer.UnsupportedFlavorException;
import java.io.IOException;
import javax.swing.tree.DefaultMutableTreeNode;
import javax.swing.tree.TreeNode;
import oracle.ide.explorer.TNode;
import oracle.ide.model.Element;
import oracle.ide.model.Project;
import oracle.ide.model.Workspace;
import oracle.ide.util.dnd.DropHelper;
import oracle.ide.util.dnd.TransferableTreeNode;
import oracle.ideri.navigator.dnd.TransferableProject;

public class WorkspaceNodeDropHelper
implements DropHelper {
    public static final Class DROP_TARGET_TYPE = Workspace.class;

    public float getWeight() {
        return 1.0f;
    }

    public boolean canTransferData(Object object, DataFlavor[] dataFlavorArray, int n) {
        if (!(object instanceof TNode)) {
            return false;
        }
        int n2 = 0;
        while (n2 < dataFlavorArray.length) {
            if (dataFlavorArray[n2].equals(TransferableProject.PROJECT_NODE_FLAVOR)) {
                return true;
            }
            ++n2;
        }
        return false;
    }

    public boolean transferData(Object object, Transferable[] transferableArray, int n) {
        if (transferableArray.length == 0) {
            return false;
        }
        if (!(object instanceof TNode)) {
            return false;
        }
        TNode tNode = (TNode)object;
        Element element = tNode.getData();
        if (!(element instanceof Workspace)) {
            return false;
        }
        Workspace workspace = (Workspace)element;
        try {
            int n2 = 0;
            while (n2 < transferableArray.length) {
                Transferable transferable = transferableArray[n2];
                if (this.canTransferData(object, transferable.getTransferDataFlavors(), n)) {
                    this.doTransfer(workspace, transferable, n);
                }
                ++n2;
            }
            boolean bl = true;
            return bl;
        }
        catch (Exception exception) {
            exception.printStackTrace();
            return false;
        }
    }

    private void doTransfer(Workspace workspace, Transferable transferable, int n) throws IOException, UnsupportedFlavorException {
        if (n == 2 || n == 1) {
            DefaultMutableTreeNode defaultMutableTreeNode;
            Workspace workspace2;
            Project project = (Project)transferable.getTransferData(TransferableProject.PROJECT_NODE_FLAVOR);
            if (n == 1) {
                project.open();
                Project project2 = (Project)project.copyTo(null);
                workspace.add(project2, true);
            } else if (n == 2 && transferable.isDataFlavorSupported(TransferableTreeNode.TREE_NODE_FLAVOR) && (workspace2 = this.getWorkspaceForProjectNode(defaultMutableTreeNode = (DefaultMutableTreeNode)transferable.getTransferData(TransferableTreeNode.TREE_NODE_FLAVOR))) != workspace && !workspace.containsChild(project)) {
                workspace2.remove(project, true);
                workspace.add(project, true);
            }
        }
    }

    private Workspace getWorkspaceForProjectNode(DefaultMutableTreeNode defaultMutableTreeNode) {
        TreeNode[] treeNodeArray = defaultMutableTreeNode.getPath();
        int n = treeNodeArray.length;
        int n2 = n - 1;
        while (n2 >= 0) {
            DefaultMutableTreeNode defaultMutableTreeNode2 = (DefaultMutableTreeNode)treeNodeArray[n2];
            Object object = defaultMutableTreeNode2.getUserObject();
            if (object instanceof Workspace) {
                return (Workspace)object;
            }
            --n2;
        }
        return null;
    }
}

