/*
 * Decompiled with CFR 0.152.
 */
package oracle.ideri.util;

import java.net.URL;
import java.util.Map;
import java.util.MissingResourceException;
import java.util.ResourceBundle;
import javax.swing.ImageIcon;
import oracle.bali.share.nls.StringUtils;
import oracle.ide.controller.PropertyResolver;
import oracle.ide.util.GraphicsUtils;
import oracle.javatools.util.BundleLoader;
import oracle.javatools.util.NullResourceBundle;

public class BundlePropertyResolver
extends PropertyResolver {
    private String _resBundleClass;
    private ClassLoader _resBundleClassLoader;
    private Map _actionKeyToBundleKey;
    private String _actionNameBundleKey;
    private ResourceBundle _resBundle;

    public BundlePropertyResolver(String string, ClassLoader classLoader, Map map) {
        if (string == null) {
            throw new NullPointerException("bundleClass is null");
        }
        if (string.trim().length() == 0) {
            throw new IllegalArgumentException("bundleClass is an empty string");
        }
        if (classLoader == null) {
            classLoader = Thread.currentThread().getContextClassLoader();
        }
        this._resBundleClass = string;
        this._resBundleClassLoader = classLoader;
        this._actionKeyToBundleKey = map;
        this._actionNameBundleKey = this._actionKeyToBundleKey != null ? (String)this._actionKeyToBundleKey.get("Name") : null;
    }

    public Object get(String string) {
        try {
            String string2 = this.getFromBundle(string);
            if (string2 != null) {
                if (string == "SmallIcon") {
                    URL uRL;
                    if (string2.length() != 0 && (uRL = this.getBundle().getClass().getResource(string2)) != null) {
                        ImageIcon imageIcon = GraphicsUtils.createImageIcon(uRL);
                        this.free();
                        return imageIcon;
                    }
                    Object var7_5 = null;
                    this.free();
                    return var7_5;
                }
                if (string == "Name") {
                    if (string2 == null) {
                        String string3 = "!NLS: " + string;
                        this.free();
                        return string3;
                    }
                    string2 = StringUtils.stripMnemonic((String)string2);
                }
            }
            if (string == "MnemonicKey") {
                if (string2 != null && string2.length() > 0) {
                    Integer n = new Integer(string2.charAt(0));
                    this.free();
                    return n;
                }
                try {
                    int n;
                    String string4 = this.getFromBundleImpl(this._actionNameBundleKey);
                    if (string4 != null && (n = StringUtils.getMnemonicKeyCode((String)string4)) != 0) {
                        Integer n2 = new Integer(n);
                        this._actionNameBundleKey = null;
                        this.free();
                        return n2;
                    }
                    Integer n3 = new Integer(0);
                    this._actionNameBundleKey = null;
                    this.free();
                    return n3;
                }
                catch (Throwable throwable) {
                    this._actionNameBundleKey = null;
                    throw throwable;
                }
            }
            String string5 = string2;
            this.free();
            return string5;
        }
        catch (Throwable throwable) {
            this.free();
            throw throwable;
        }
    }

    private String getFromBundle(String string) {
        if (this._actionKeyToBundleKey == null) {
            return null;
        }
        try {
            String string2 = this.getFromBundleImpl((String)this._actionKeyToBundleKey.get(string));
            this._actionKeyToBundleKey.remove(string);
            if (this._actionKeyToBundleKey.isEmpty()) {
                this._actionKeyToBundleKey = null;
            }
            return string2;
        }
        catch (Throwable throwable) {
            this._actionKeyToBundleKey.remove(string);
            if (this._actionKeyToBundleKey.isEmpty()) {
                this._actionKeyToBundleKey = null;
            }
            throw throwable;
        }
    }

    private String getFromBundleImpl(String string) {
        if (string != null) {
            try {
                String string2 = this.getBundle().getString(string);
                return string2;
            }
            catch (MissingResourceException missingResourceException) {
                String string3 = null;
                return string3;
            }
        }
        return null;
    }

    private ResourceBundle getBundle() {
        if (this._resBundle == null && this._resBundleClass != null) {
            try {
                try {
                    this._resBundle = BundleLoader.getBundle((String)this._resBundleClass, (ClassLoader)this._resBundleClassLoader);
                }
                catch (Exception exception) {
                    exception.printStackTrace();
                    NullResourceBundle nullResourceBundle = NullResourceBundle.instance();
                    this._resBundleClass = null;
                    this._resBundleClassLoader = null;
                    return nullResourceBundle;
                }
            }
            finally {
                this._resBundleClass = null;
                this._resBundleClassLoader = null;
            }
        }
        if (this._resBundle == null) {
            this._resBundle = NullResourceBundle.instance();
        }
        return this._resBundle;
    }

    private void free() {
        if (this._actionKeyToBundleKey == null || this._actionKeyToBundleKey.isEmpty()) {
            this._actionKeyToBundleKey = null;
            this._resBundle = null;
            this._resBundleClass = null;
            this._resBundleClassLoader = null;
        }
    }
}

