/*
 * Decompiled with CFR 0.152.
 */
package oracle.jdevimpl.uieditor.proxy;

import java.awt.Component;
import java.beans.BeanDescriptor;
import java.beans.BeanInfo;
import java.beans.EventSetDescriptor;
import java.beans.IndexedPropertyDescriptor;
import java.beans.Introspector;
import java.beans.MethodDescriptor;
import java.beans.PropertyDescriptor;
import java.lang.reflect.Method;
import java.util.ArrayList;
import java.util.Vector;
import oracle.jdeveloper.java.legacy.JotNames;

public class BeanInfoGenerator {
    public static void main(String[] args) {
        if (args.length < 2 || args.length / 2 * 2 != args.length) {
            System.out.println("\r\nThis program will take a class name and package as argument and generate to stdout a BeanInfo for a proxy implementation of that class.  It is assumed that the BeanInfo is to reside in the same package as the proxy implementation of the original, as provided by the second argument.  Additional attribute name/value pairs may be provided for assignment to the BeanDescriptor.  e.g. BeanInfoGenerator java.awt.Frame oracle.jdevimpl.uieditor.proxy isContainer Boolean.TRUE");
            System.out.println("\r\n\r\nUsage:\r\n  BeanInfoGenerator <class_name> <proxy_package> [<attribute1> <value1> [, <attribute2> <value2> ...]]");
            return;
        }
        try {
            Class<Object> base;
            String cls = args[0];
            String pkg = args[1];
            BeanInfo info = Introspector.getBeanInfo(Class.forName(cls));
            ArrayList<String> attributes = new ArrayList<String>();
            int i = 2;
            while (i < args.length) {
                attributes.add(args[i]);
                attributes.add(args[i + 1]);
                i += 2;
            }
            System.out.println("// This file was generated by");
            System.out.println("// oracle.jdevimpl.uieditor.proxy.BeanInfoGenerator.");
            System.out.println("// Any changes made to this file will be lost the next time it is generated.");
            System.out.println();
            System.out.println("\r\npackage " + pkg + ";");
            System.out.println("\r\n");
            if (attributes.size() > 0) {
                System.out.println("import java.beans.BeanDescriptor;");
            }
            System.out.println("import java.beans.EventSetDescriptor;");
            System.out.println("import java.beans.IndexedPropertyDescriptor;");
            System.out.println("import java.beans.MethodDescriptor;");
            System.out.println("import java.beans.PropertyDescriptor;");
            System.out.println("import java.beans.SimpleBeanInfo;");
            cls = cls.substring(cls.lastIndexOf(46) + 1);
            System.out.println("\r\n\r\npublic class " + cls + "BeanInfo extends SimpleBeanInfo {");
            try {
                base = Class.forName(pkg + "." + cls);
            }
            catch (Exception e) {
                System.err.println("Error: Failed trying to load class " + pkg + "." + cls);
                base = Component.class;
            }
            BeanInfoGenerator.dumpData(info, base, attributes);
            System.out.println("}");
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    public static void dumpData(BeanInfo info, Class base, ArrayList attributes) {
        PropertyDescriptor[] p = info.getPropertyDescriptors();
        MethodDescriptor[] m = info.getMethodDescriptors();
        EventSetDescriptor[] e = info.getEventSetDescriptors();
        String results = "";
        Class<?> cls = null;
        if (attributes.size() != 0) {
            BeanDescriptor b = info.getBeanDescriptor();
            Class<?> beanCls = b.getBeanClass();
            String beanName = JotNames.getShortClassName((String)beanCls.getName());
            System.out.println("  public BeanDescriptor getBeanDescriptor() {");
            System.out.println("    try {");
            System.out.println("      BeanDescriptor  _desc = new BeanDescriptor(" + beanName + ".class, null);");
            int i = 0;
            while (i < attributes.size()) {
                System.out.println("      _desc.setValue(\"" + attributes.get(i) + "\", " + attributes.get(i + 1) + ");");
                i += 2;
            }
            System.out.println("      return _desc;");
            System.out.println("    } catch (Exception e) {");
            System.out.println("      e.printStackTrace();");
            System.out.println("      return null;\r\n    }");
            System.out.println("  }");
            System.out.println("\r\n");
        }
        System.out.println("  public PropertyDescriptor[] getPropertyDescriptors() {");
        System.out.println("    try {");
        int i = 0;
        while (i < p.length) {
            String writer;
            String decl;
            Method getter = p[i].getReadMethod();
            Method setter = p[i].getWriteMethod();
            Method iGetter = null;
            Method iSetter = null;
            boolean indexed = p[i] instanceof IndexedPropertyDescriptor;
            cls = null;
            if (indexed) {
                iGetter = ((IndexedPropertyDescriptor)p[i]).getIndexedReadMethod();
                iSetter = ((IndexedPropertyDescriptor)p[i]).getIndexedWriteMethod();
            }
            if (getter != null) {
                cls = getter.getDeclaringClass();
            } else if (setter != null) {
                cls = setter.getDeclaringClass();
            } else if (iGetter != null) {
                cls = iGetter.getDeclaringClass();
            } else if (iSetter != null) {
                cls = iSetter.getDeclaringClass();
            }
            if (cls == null || !cls.isAssignableFrom(base)) {
                System.err.println("Warning: Class " + cls + " not assignable from " + base + ".");
                cls = base;
            }
            String simpleDecl = "_" + p[i].getName() + " = new PropertyDescriptor(\"" + p[i].getName() + "\", " + cls.getName() + ".class";
            String indexedDecl = "_" + p[i].getName() + " = new IndexedPropertyDescriptor(\"" + p[i].getName() + "\", " + cls.getName() + ".class";
            if (indexed) {
                System.out.println("      PropertyDescriptor\t_" + p[i].getName() + ";");
                System.out.println("      try {");
                decl = "        " + indexedDecl;
            } else {
                decl = "      PropertyDescriptor\t" + simpleDecl;
            }
            String reader = getter != null ? "\"" + getter.getName() + "\"" : "null";
            String string = writer = setter != null ? "\"" + setter.getName() + "\"" : "null";
            if (!indexed) {
                System.out.println(decl + ", " + reader + ", " + writer + ");");
            } else {
                String iReader = iGetter != null ? "\"" + iGetter.getName() + "\"" : "null";
                String iWriter = iSetter != null ? "\"" + iSetter.getName() + "\"" : "null";
                System.out.println(decl + ", " + reader + ", " + writer + ", " + iReader + ", " + iWriter + ");");
                System.out.println("      } catch (Exception e) {");
                System.out.println("        " + simpleDecl + ", " + reader + ", " + writer + ");");
                System.out.println("      }");
            }
            results = results + "        _" + p[i].getName() + ",\r\n";
            if (p[i].isBound()) {
                System.out.println("      _" + p[i].getName() + ".setBound(true);");
            }
            if (p[i].isConstrained()) {
                System.out.println("      _" + p[i].getName() + ".setConstrained(true);");
            }
            if (p[i].getPropertyEditorClass() != null) {
                System.out.println("      _" + p[i].getName() + ".setPropertyEditorClass(" + p[i].getPropertyEditorClass().getName() + ".class);");
            }
            System.out.println();
            ++i;
        }
        System.out.println("      return new PropertyDescriptor[] {");
        System.out.println(results + "      };");
        System.out.println("    } catch (Exception e) {");
        System.out.println("      e.printStackTrace();");
        System.out.println("      return null;\r\n    }");
        System.out.println("  }");
        Vector<String> used = new Vector<String>();
        results = "";
        System.out.println("\r\n");
        System.out.println("  public MethodDescriptor[] getMethodDescriptors() {");
        System.out.println("    try {");
        int i2 = 0;
        while (i2 < m.length) {
            Method t = m[i2].getMethod();
            String var = t.getName();
            int counter = 1;
            while (used.contains(var)) {
                var = t.getName() + counter++;
            }
            counter = 1;
            used.addElement(var);
            cls = t.getDeclaringClass();
            if (cls == null || !cls.isAssignableFrom(base)) {
                System.err.println("Warning: Method " + var + " using bad declaring class.");
                cls = base;
            }
            String decl = "      MethodDescriptor \t_" + var + " = new MethodDescriptor(" + cls.getName() + ".class.getMethod(\"" + t.getName() + "\", new Class[] {";
            Class<?>[] args = t.getParameterTypes();
            if (args != null) {
                int j = 0;
                while (j < args.length) {
                    decl = decl + args[j].getName() + ".class, ";
                    ++j;
                }
            }
            decl = decl + "}));";
            System.out.println(decl);
            System.out.println();
            results = results + "        _" + var + ",\r\n";
            ++i2;
        }
        System.out.println("      return new MethodDescriptor[] {");
        System.out.println(results + "      };");
        System.out.println("    } catch (Exception e) {");
        System.out.println("      e.printStackTrace();");
        System.out.println("      return null;\r\n    }");
        System.out.println("  }");
        results = "";
        System.out.println("\r\n");
        System.out.println("  public EventSetDescriptor[] getEventSetDescriptors() {");
        System.out.println("    try {");
        int i3 = 0;
        while (i3 < e.length) {
            Method t = e[i3].getAddListenerMethod();
            if (t != null) {
                cls = t.getDeclaringClass();
            } else {
                t = e[i3].getRemoveListenerMethod();
                cls = t.getDeclaringClass();
            }
            if (cls == null || !cls.isAssignableFrom(base)) {
                System.err.println("Warning: EventSet _" + e[i3].getName() + " using bad declaring class.");
                cls = base;
            }
            String decl = "      EventSetDescriptor \t_" + e[i3].getName() + " = new EventSetDescriptor(" + cls.getName() + ".class, \"" + e[i3].getName() + "\", " + e[i3].getListenerType().getName() + ".class, new String[] {";
            Method[] events = e[i3].getListenerMethods();
            if (events != null) {
                int j = 0;
                while (j < events.length) {
                    decl = decl + "\"" + events[j].getName() + "\", ";
                    ++j;
                }
            }
            decl = decl + "}, ";
            decl = decl + "\"" + e[i3].getAddListenerMethod().getName() + "\", ";
            decl = decl + "\"" + e[i3].getRemoveListenerMethod().getName() + "\");";
            System.out.println(decl);
            System.out.println();
            results = results + "        _" + e[i3].getName() + ",\r\n";
            ++i3;
        }
        System.out.println("      return new EventSetDescriptor[] {");
        System.out.println(results + "      };");
        System.out.println("    } catch (Exception e) {");
        System.out.println("      e.printStackTrace();");
        System.out.println("      return null;\r\n    }");
        System.out.println("  }");
    }
}

