/*
 * Decompiled with CFR 0.152.
 */
package oracle.jdevimpl.uieditor.proxy;

import java.lang.reflect.Constructor;
import java.lang.reflect.Method;
import java.lang.reflect.Modifier;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;

public class ProxyStubGenerator {
    public static void main(String[] args) {
        if (args.length == 0) {
            System.out.println("\r\nThis program will take a class and closest comparable class as arguments and generate to stdout a stub implementation for a proxy of that class.  The developer will very likely have to hand modify the proxy in order to have a legitimate proxy class.");
            System.out.println("\r\n\r\nUsage:\r\n  ProxyStubGenerator <class_name> <nearest_proxy> > <file_name>");
            return;
        }
        try {
            String clsName = args[0];
            String proxyName = args[1];
            Class<?> cls = Class.forName(clsName);
            Class<?> proxy = Class.forName(proxyName);
            System.out.println("// This file was generated by oracle.jdevimpl.uieditor.proxy.ProxyStubGenerator.");
            System.out.println("// Any changes made to this file will be lost the next time it is generated.");
            System.out.println();
            System.out.println("\r\npackage oracle.jdevimpl.uieditor.proxy;");
            clsName = clsName.substring(clsName.lastIndexOf(46) + 1);
            System.out.println("\r\n\r\npublic class " + clsName + " extends " + proxyName + " {");
            ProxyStubGenerator.dumpData(cls, proxy);
            System.out.println("}");
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    public static void dumpData(Class cls, Class proxy) {
        Constructor<?>[] ctors = cls.getConstructors();
        String clsName = cls.getName();
        clsName = clsName.substring(clsName.lastIndexOf(46) + 1);
        int i = 0;
        while (i < ctors.length) {
            Constructor<?> ctor = ctors[i];
            Class<?>[] paramTypes = ctor.getParameterTypes();
            Constructor proxyCtor = null;
            try {
                proxyCtor = proxy.getConstructor(paramTypes);
            }
            catch (Exception e) {
                // empty catch block
            }
            System.out.println();
            System.out.print("  " + Modifier.toString(ctor.getModifiers()));
            System.out.print(" " + clsName + "(");
            if (paramTypes.length > 0) {
                System.out.print(paramTypes[0].getName() + " p0");
            }
            int j = 1;
            while (j < paramTypes.length) {
                System.out.print(", " + paramTypes[j].getName() + " p" + j);
                ++j;
            }
            System.out.println(") {");
            if (proxyCtor != null) {
                System.out.print("    super(");
                if (paramTypes.length > 0) {
                    System.out.print("p0");
                }
                int j2 = 1;
                while (j2 < paramTypes.length) {
                    System.out.print(", p" + j2);
                    ++j2;
                }
                System.out.println(");");
            }
            System.out.println("  }");
            ++i;
        }
        Class ancestorCls = cls;
        HashMap<String, ArrayList<Class<?>[]>> signaturesMap = new HashMap<String, ArrayList<Class<?>[]>>();
        while (ancestorCls != null) {
            Method[] clsMethods = ancestorCls.getDeclaredMethods();
            int i2 = 0;
            while (i2 < clsMethods.length) {
                Method clsMethod = clsMethods[i2];
                String name = clsMethod.getName();
                Class<?>[] paramTypes = clsMethod.getParameterTypes();
                Class proxyAncestor = proxy;
                Method proxyMethod = null;
                while (proxyAncestor != null) {
                    try {
                        proxyMethod = proxyAncestor.getDeclaredMethod(name, paramTypes);
                    }
                    catch (Exception e) {
                        // empty catch block
                    }
                    proxyAncestor = proxyMethod != null ? null : proxyAncestor.getSuperclass();
                }
                if (proxyMethod == null) {
                    Iterator iter;
                    ArrayList<Class<?>[]> signatures = (ArrayList<Class<?>[]>)signaturesMap.get(name);
                    Iterator iterator = iter = signatures != null ? signatures.iterator() : null;
                    if (iter != null) {
                        while (iter.hasNext()) {
                            Class[] signature = (Class[])iter.next();
                            if (signature.length != paramTypes.length) continue;
                            boolean same = true;
                            int j = 0;
                            while (j < signature.length) {
                                if (signature[j] != paramTypes[j]) {
                                    same = false;
                                    break;
                                }
                                ++j;
                            }
                            if (!same) {
                                continue;
                            }
                            break;
                        }
                    } else {
                        if (signatures != null) {
                            signatures.add(paramTypes);
                        } else {
                            signatures = new ArrayList<Class<?>[]>();
                            signatures.add(paramTypes);
                            signaturesMap.put(name, signatures);
                        }
                        System.out.println();
                        System.out.print("  " + Modifier.toString(clsMethod.getModifiers()));
                        System.out.print(" " + clsMethod.getReturnType().getName() + " " + name + "(");
                        if (paramTypes.length > 0) {
                            System.out.print(paramTypes[0].getName() + " p0");
                        }
                        int j = 1;
                        while (j < paramTypes.length) {
                            System.out.print(", " + paramTypes[j].getName() + " p" + j);
                            ++j;
                        }
                        System.out.println(") {");
                        System.out.println("  }");
                    }
                }
                ++i2;
            }
            ancestorCls = ancestorCls.getSuperclass();
        }
    }
}

