/*
 * Decompiled with CFR 0.152.
 */
package oracle.jdeveloper.ant;

import java.io.ByteArrayInputStream;
import java.io.File;
import java.io.FilenameFilter;
import java.io.InputStream;
import java.net.MalformedURLException;
import java.net.URL;
import java.net.URLClassLoader;
import java.util.ArrayList;
import java.util.List;
import oracle.ide.Ide;
import oracle.ide.model.Project;
import oracle.ide.net.URLFactory;
import oracle.ide.net.URLFileSystem;
import oracle.ide.net.URLPath;
import oracle.javatools.data.HashStructure;
import oracle.javatools.data.HashStructureAdapter;
import oracle.javatools.data.ListStructure;
import oracle.javatools.data.PropertyStorage;
import oracle.javatools.marshal.TransientMarker;
import oracle.jdeveloper.library.JDK;
import oracle.jdeveloper.library.JLibraryManager;
import oracle.jdeveloper.library.JProjectLibraryList;
import oracle.jdeveloper.library.LibraryReference;
import oracle.jdeveloper.model.JProjectLibraries;
import oracle.jdevimpl.ant.AntVersion;
import oracle.jdevimpl.ant.registry.AntRegistry;

public class AntRunConfiguration
extends HashStructureAdapter {
    public static final String DATA_KEY = AntRunConfiguration.class.getName();
    public static final String ANT_HOME = "antHome";
    public static final String BUILDFILE_URL = "buildfileURL";
    public static final String TARGET_LIST = "targetList";
    public static final String JDK_VERSION = "jdkVersion";
    public static final String CLASSPATH = "classpath";
    public static final String PROPERTY_NAMES = "propertyNames";
    public static final String PROPERTY_VALUES = "propertyValues";
    public static final String PROPERTY_FILES = "propertyFiles";
    public static final String RUN_IN_PROCESS = "runInProcess";
    public static final String OUTPUT_LEVEL = "outputLevel";
    public static final String KEEP_GOING = "keepGoing";
    public static final String INPUT_FILE = "inputFile";
    public static final String USE_INPUT_FILE = "useInputFile";
    public static final String JAVA_ARGS = "javaArgs";
    public static final String WORKING_DIR = "workingDir";
    public static final String ENV_NAMES = "envNames";
    public static final String ENV_VALUES = "envValues";
    public static final String USER_JARS = "userJars";
    private static final String JDEV_ANT_JAR = "jdev.jar";
    private static final String USER_LIBDIR = ".ant/lib";
    private static final String SAX_PARSER_FACTORY = "META-INF/services/javax.xml.parsers.SAXParserFactory";
    private static final String DOCUMENT_BUILDER_FACTORY = "META-INF/services/javax.xml.parsers.DocumentBuilderFactory";
    private static final String TRANSFORMER_FACTORY = "META-INF/services/javax.xml.transform.TransformerFactory";
    private static final String MIME_MAILER = "org.apache.tools.ant.taskdefs.email.MimeMailer";
    private static final String MESSAGING_EXCEPTION = "javax.mail.MessagingException";
    private static final String DATA_SOURCE = "javax.activation.DataSource";
    private JDK jdk;

    public AntRunConfiguration() {
        this(HashStructure.newInstance());
    }

    private AntRunConfiguration(HashStructure hashStructure) {
        super(hashStructure);
    }

    public static AntRunConfiguration getInstance(PropertyStorage propertyStorage) {
        return new AntRunConfiguration(propertyStorage.getProperties().getOrCreateHashStructure(DATA_KEY));
    }

    public boolean isInProcess() {
        return this._hash.getBoolean(RUN_IN_PROCESS, true);
    }

    public void setInProcess(boolean bl) {
        this._hash.putBoolean(RUN_IN_PROCESS, bl);
    }

    public int getOutputLevel() {
        return this._hash.getInt(OUTPUT_LEVEL, 2);
    }

    public void setOutputLevel(int n) {
        this._hash.putInt(OUTPUT_LEVEL, n);
    }

    public boolean getKeepGoing() {
        return this._hash.getBoolean(KEEP_GOING, false);
    }

    public void setKeepGoing(boolean bl) {
        this._hash.putBoolean(KEEP_GOING, bl);
    }

    public boolean getUseInputFile() {
        return this._hash.getBoolean(USE_INPUT_FILE, false);
    }

    public void setUseInputFile(boolean bl) {
        this._hash.putBoolean(USE_INPUT_FILE, bl);
    }

    public URL getInputFile() {
        return this._hash.getURL(INPUT_FILE, null);
    }

    public void setInputFile(URL uRL) {
        this._hash.putURL(INPUT_FILE, uRL, true);
    }

    public URL getAntHome() {
        return this._hash.getURL(ANT_HOME, null);
    }

    public void setAntHome(URL uRL) {
        this._hash.putURL(ANT_HOME, uRL, true);
    }

    public void setJDKReference(LibraryReference libraryReference) {
        if (libraryReference != null) {
            HashStructure hashStructure = this._hash.getOrCreateHashStructure(JDK_VERSION);
            LibraryReference libraryReference2 = new LibraryReference(hashStructure);
            libraryReference.copyTo((Object)libraryReference2);
        } else {
            this._hash.remove(JDK_VERSION);
        }
    }

    public LibraryReference getJDKReference() {
        HashStructure hashStructure = this._hash.getHashStructure(JDK_VERSION);
        if (hashStructure != null) {
            return new LibraryReference(hashStructure);
        }
        return null;
    }

    public void setJDK(JDK jDK) throws TransientMarker {
        this.jdk = jDK;
        if (jDK == null) {
            this._hash.remove(JDK_VERSION);
        } else {
            HashStructure hashStructure = this._hash.getOrCreateHashStructure(JDK_VERSION);
            LibraryReference libraryReference = new LibraryReference(hashStructure);
            libraryReference.setLibrary(jDK);
        }
    }

    public JDK getJDK(Project project) throws TransientMarker {
        JDK jDK = this.jdk;
        if (jDK == null) {
            LibraryReference libraryReference;
            HashStructure hashStructure = this._hash.getHashStructure(JDK_VERSION);
            if (hashStructure != null && (libraryReference = new LibraryReference(hashStructure)) != null) {
                if (project != null) {
                    JProjectLibraryList jProjectLibraryList = JProjectLibraries.getInstance((PropertyStorage)project).getProjectLibraryList();
                    JDK jDK2 = jDK = jProjectLibraryList != null ? jProjectLibraryList.findJDK(libraryReference.getID()) : null;
                }
                if (jDK == null && libraryReference.isJDK()) {
                    jDK = (JDK)libraryReference.getLibrary();
                }
            }
            if (jDK == null) {
                jDK = project != null ? JProjectLibraries.getInstance((PropertyStorage)project).getJDK() : JLibraryManager.getDefaultJDK();
            }
        }
        return jDK;
    }

    public URL getBuildfile() {
        return this._hash.getURL(BUILDFILE_URL, null);
    }

    public void setBuildfile(URL uRL) {
        this._hash.putURL(BUILDFILE_URL, uRL, true);
    }

    public List getTargetList() {
        ListStructure listStructure = this._hash.getListStructure(TARGET_LIST);
        ArrayList arrayList = new ArrayList();
        if (listStructure != null) {
            arrayList.addAll(listStructure);
        }
        return arrayList;
    }

    public void setTargetList(List list) {
        if (list == null) {
            this._hash.remove(TARGET_LIST);
        } else {
            ListStructure listStructure = this._hash.getOrCreateListStructure(TARGET_LIST);
            listStructure.mirror(list);
        }
    }

    public void addTarget(String string) {
        ListStructure listStructure = this._hash.getOrCreateListStructure(TARGET_LIST);
        if (!listStructure.contains((Object)string)) {
            listStructure.add((Object)string);
        }
    }

    public void removeTarget(String string) {
        ListStructure listStructure = this._hash.getListStructure(TARGET_LIST);
        if (listStructure != null) {
            listStructure.remove((Object)string);
        }
    }

    public void setClassPath(URLPath uRLPath) {
        if (uRLPath == null || uRLPath.size() == 0) {
            this._hash.remove(CLASSPATH);
        } else {
            ListStructure listStructure = this._hash.getOrCreateListStructure(CLASSPATH);
            listStructure.mirror(uRLPath.asList());
        }
    }

    public URLPath getClassPath() {
        return new URLPath(this._hash.getListStructure(CLASSPATH));
    }

    public boolean getIncludeUserJars() {
        return this._hash.getBoolean(USER_JARS, true);
    }

    public void setIncludeUserJars(boolean bl) {
        this._hash.putBoolean(USER_JARS, bl);
    }

    public void addProperty(String string, String string2) {
        ListStructure listStructure = this._hash.getOrCreateListStructure(PROPERTY_NAMES);
        ListStructure listStructure2 = this._hash.getOrCreateListStructure(PROPERTY_VALUES);
        int n = listStructure.indexOf((Object)string);
        if (n > 0) {
            listStructure2.set(n, (Object)string2);
        } else {
            listStructure.add((Object)string);
            listStructure2.add((Object)string2);
        }
    }

    public void removeProperty(String string) {
        ListStructure listStructure = this._hash.getOrCreateListStructure(PROPERTY_NAMES);
        ListStructure listStructure2 = this._hash.getOrCreateListStructure(PROPERTY_VALUES);
        int n = listStructure.indexOf((Object)string);
        if (n > 0) {
            listStructure.remove(n);
            listStructure2.remove(n);
        }
    }

    public List getPropertyNames() {
        ListStructure listStructure = this._hash.getListStructure(PROPERTY_NAMES);
        ArrayList arrayList = new ArrayList();
        if (listStructure != null) {
            arrayList.addAll(listStructure);
        }
        return arrayList;
    }

    public void setPropertyNames(List list) {
        if (list == null) {
            this._hash.remove(PROPERTY_NAMES);
        } else {
            ListStructure listStructure = this._hash.getOrCreateListStructure(PROPERTY_NAMES);
            listStructure.mirror(list);
        }
    }

    public List getPropertyValues() {
        ListStructure listStructure = this._hash.getListStructure(PROPERTY_VALUES);
        ArrayList arrayList = new ArrayList();
        if (listStructure != null) {
            arrayList.addAll(listStructure);
        }
        return arrayList;
    }

    public void setPropertyValues(List list) {
        if (list == null) {
            this._hash.remove(PROPERTY_VALUES);
        } else {
            ListStructure listStructure = this._hash.getOrCreateListStructure(PROPERTY_VALUES);
            listStructure.mirror(list);
        }
    }

    public void addPropertyFile(String string) {
        this._hash.getOrCreateListStructure(PROPERTY_FILES).add((Object)string);
    }

    public void removePropertyFile(String string) {
        int n;
        ListStructure listStructure = this._hash.getListStructure(PROPERTY_FILES);
        if (listStructure != null && (n = listStructure.indexOf((Object)string)) > 0) {
            listStructure.remove(n);
        }
    }

    public List getPropertyFiles() {
        ListStructure listStructure = this._hash.getListStructure(PROPERTY_FILES);
        ArrayList arrayList = new ArrayList();
        if (listStructure != null) {
            arrayList.addAll(listStructure);
        }
        return arrayList;
    }

    public void setPropertyFiles(List list) {
        if (list == null) {
            this._hash.remove(PROPERTY_FILES);
        } else {
            ListStructure listStructure = this._hash.getOrCreateListStructure(PROPERTY_FILES);
            listStructure.mirror(list);
        }
    }

    public void setJavaArgs(String string) {
        this._hash.putString(JAVA_ARGS, string, true);
    }

    public String getJavaArgs() {
        return this._hash.getString(JAVA_ARGS, null);
    }

    public void setWorkingDirectory(URL uRL) {
        this._hash.putURL(WORKING_DIR, uRL, true);
    }

    public URL getWorkingDirectory() {
        return this._hash.getURL(WORKING_DIR, null);
    }

    public List getEnvironmentNames() {
        ListStructure listStructure = this._hash.getListStructure(ENV_NAMES);
        ArrayList arrayList = new ArrayList();
        if (listStructure != null) {
            arrayList.addAll(listStructure);
        }
        return arrayList;
    }

    public void setEnvironmentNames(List list) {
        if (list == null) {
            this._hash.remove(ENV_NAMES);
        } else {
            ListStructure listStructure = this._hash.getOrCreateListStructure(ENV_NAMES);
            listStructure.mirror(list);
        }
    }

    public List getEnvironmentValues() {
        ListStructure listStructure = this._hash.getListStructure(ENV_VALUES);
        ArrayList arrayList = new ArrayList();
        if (listStructure != null) {
            arrayList.addAll(listStructure);
        }
        return arrayList;
    }

    public void setEnvironmentValues(List list) {
        if (list == null) {
            this._hash.remove(ENV_VALUES);
        } else {
            ListStructure listStructure = this._hash.getOrCreateListStructure(ENV_VALUES);
            listStructure.mirror(list);
        }
    }

    public void setEnvironmentVariable(String string, String string2) {
        ListStructure listStructure = this._hash.getOrCreateListStructure(ENV_NAMES);
        ListStructure listStructure2 = this._hash.getOrCreateListStructure(ENV_VALUES);
        int n = listStructure.indexOf((Object)string);
        if (n > 0) {
            listStructure2.set(n, (Object)string2);
        } else {
            listStructure.add((Object)string);
            listStructure2.add((Object)string2);
        }
    }

    public String getEnvironmentVariable(String string) {
        ListStructure listStructure = this._hash.getOrCreateListStructure(ENV_NAMES);
        int n = listStructure.indexOf((Object)string);
        if (n > 0) {
            ListStructure listStructure2 = this._hash.getOrCreateListStructure(ENV_VALUES);
            return (String)listStructure2.get(n);
        }
        return null;
    }

    public ClassLoader getAntClassLoader(Project project) {
        URLPath uRLPath = this.getAntClassPath(project);
        return new 2(uRLPath.getEntries(), null);
    }

    public URLPath getAntClassPath(Project project) {
        URLPath uRLPath = new URLPath();
        uRLPath.add(this.getClassPath());
        if (this.getIncludeUserJars()) {
            uRLPath.add(this.getUserJars());
        }
        uRLPath.add(AntRegistry.getExtensionAntRegistry().getClassPath());
        URL uRL = URLFactory.newFileURL((File)new File(Ide.getLibDirectory(), JDEV_ANT_JAR));
        uRLPath.add(uRL);
        AntVersion antVersion = null;
        URL uRL2 = this.getAntHome();
        if (uRL2 != null) {
            antVersion = AntVersion.createAntVersion(uRL2);
        }
        if (antVersion == null) {
            antVersion = AntVersion.getDefaultAntVersion();
        }
        uRLPath.add(antVersion.getClassPath());
        this.jdk = this.getJDK(project);
        if (this.jdk == null) {
            this.jdk = JLibraryManager.getDefaultJDK();
        }
        uRLPath.add(this.getJDKToolsJar(this.jdk));
        return uRLPath;
    }

    private URLPath getUserJars() {
        URLPath uRLPath = new URLPath();
        String string = System.getProperty("user.home");
        File file = new File(string, USER_LIBDIR);
        if (file.isDirectory()) {
            File[] fileArray = file.listFiles(new 1());
            int n = 0;
            while (n < fileArray.length) {
                try {
                    uRLPath.add(fileArray[n].toURL());
                }
                catch (MalformedURLException malformedURLException) {
                    // empty catch block
                }
                ++n;
            }
        }
        return uRLPath;
    }

    private URL getJDKToolsJar(JDK jDK) {
        URL uRL;
        URL uRL2 = null;
        URL uRL3 = jDK.getSDKBinDir();
        if (uRL3 != null && (uRL = URLFileSystem.getParent((URL)uRL3)) != null) {
            URL uRL4 = URLFactory.newURL((URL)uRL, (String)"lib");
            uRL2 = URLFactory.newURL((URL)uRL4, (String)"tools.jar");
        }
        return uRL2;
    }

    public final class 2
    extends URLClassLoader {
        protected Class findClass(String string) throws ClassNotFoundException {
            if (AntRunConfiguration.MIME_MAILER.equals(string)) {
                this.findClass(AntRunConfiguration.MESSAGING_EXCEPTION);
                this.findClass(AntRunConfiguration.DATA_SOURCE);
            }
            return super.findClass(string);
        }

        public InputStream getResourceAsStream(String string) {
            InputStream inputStream = super.getResourceAsStream(string);
            if (inputStream == null && (AntRunConfiguration.SAX_PARSER_FACTORY.equals(string) || AntRunConfiguration.DOCUMENT_BUILDER_FACTORY.equals(string) || AntRunConfiguration.TRANSFORMER_FACTORY.equals(string))) {
                return new ByteArrayInputStream(new byte[0]);
            }
            return inputStream;
        }

        public 2(URL[] uRLArray, ClassLoader classLoader) {
            super(uRLArray, classLoader);
        }
    }

    public final class 1
    implements FilenameFilter {
        public boolean accept(File file, String string) {
            return string.toLowerCase().endsWith(".jar");
        }
    }
}

