/*
 * Decompiled with CFR 0.152.
 */
package oracle.jdeveloper.builder;

import java.net.URL;
import javax.swing.SwingUtilities;
import javax.swing.tree.TreeNode;
import oracle.ide.Context;
import oracle.ide.editor.EditorManager;
import oracle.ide.editor.OpenEditorOptions;
import oracle.ide.explorer.ExplorerContext;
import oracle.ide.explorer.TNode;
import oracle.ide.model.Element;
import oracle.ide.model.Locatable;
import oracle.ide.model.Node;
import oracle.ide.model.Project;
import oracle.ide.model.RelativeDirectoryContextFolder;
import oracle.ide.model.Subject;
import oracle.ide.model.TextNode;
import oracle.ide.model.UpdateMessage;
import oracle.ide.net.URLFactory;
import oracle.ide.net.URLFileSystem;
import oracle.ide.net.URLPath;
import oracle.ide.resource.IdeArb;
import oracle.ide.util.ModelUtil;
import oracle.javatools.buffer.TextBuffer;
import oracle.jdeveloper.builder.SourceModel;
import oracle.jdeveloper.builder.resource.BuilderArb;
import oracle.jdeveloper.model.PackagedSource;
import oracle.jdeveloper.wizard.common.BaliWizardState;

public abstract class AbstractBuilderModel
implements BaliWizardState {
    private SourceModel _src;
    private boolean _clearExistingFiles;
    private boolean _raiseEditor;

    void $init$() {
        this._clearExistingFiles = true;
        this._raiseEditor = true;
    }

    public abstract String getBuilderType();

    protected abstract String getBaseName();

    public AbstractBuilderModel() {
        this.$init$();
    }

    protected void initializeFromContext(Context context) {
        Project project = context.getProject();
        this.setProject(project);
        this.initializeSourceDir(context);
        this.getSourceModel().generateDefaultFileName(this.getBaseName());
    }

    protected void initializeSourceDir(Context context) {
        TreeNode treeNode;
        TNode tNode;
        SourceModel sourceModel = this.getSourceModel();
        Element element = context.getElement();
        if ((element == null || !element.mayHaveChildren()) && (tNode = ExplorerContext.getFirstTNode((Context)context)) != null && (treeNode = tNode.getParent()) instanceof TNode) {
            tNode = (TNode)treeNode;
            element = tNode.getData();
        }
        if (element instanceof RelativeDirectoryContextFolder) {
            URLPath uRLPath;
            RelativeDirectoryContextFolder relativeDirectoryContextFolder = (RelativeDirectoryContextFolder)element;
            String string = relativeDirectoryContextFolder.getRelativePath();
            if (string == null) {
                string = sourceModel.getRelativeDirectory();
            }
            if ((uRLPath = relativeDirectoryContextFolder.getRootDirectories()) != null && uRLPath.size() == 1) {
                URL uRL = URLFactory.newDirURL((URL)uRLPath.getFirstEntry(), (String)string);
                sourceModel.setDirectory(uRL);
                if (!ModelUtil.hasLength((String)sourceModel.getDirectoryString())) {
                    sourceModel.setRelativeDirectory(this.getDefaultRelativeDirectory(this.getProject()));
                }
            } else if (ModelUtil.hasLength((String)string)) {
                sourceModel.setRelativeDirectory(string);
            } else {
                sourceModel.setRelativeDirectory(this.getDefaultRelativeDirectory(this.getProject()));
            }
        } else {
            URL uRL = null;
            String string = null;
            if (element instanceof Locatable) {
                Project project;
                PackagedSource packagedSource;
                URL uRL2 = ((Locatable)element).getURL();
                if (uRL2 != null) {
                    uRL = URLFileSystem.getParent((URL)uRL2);
                }
                if (element instanceof PackagedSource && (string = (packagedSource = (PackagedSource)element).getPackage(project = context.getProject())) != null) {
                    string = string.replace('.', '/');
                }
            }
            if (sourceModel.isInSourcePath(uRL)) {
                sourceModel.setDirectory(uRL);
                if (string != null) {
                    sourceModel.setRelativeDirectory(string);
                }
            } else {
                sourceModel.setRelativeDirectory(this.getDefaultRelativeDirectory(this.getProject()));
            }
        }
    }

    protected String getDefaultRelativeDirectory(Project project) {
        return "";
    }

    protected final void setClearExistingFiles(boolean bl) {
        this._clearExistingFiles = bl;
    }

    public boolean isRaiseEditor() {
        return this._raiseEditor;
    }

    public void setRaiseEditor(boolean bl) {
        this._raiseEditor = bl;
    }

    public final void setProject(Project project) {
        this.getSourceModel().setProject(project);
    }

    public final Project getProject() {
        return this.getSourceModel().getProject();
    }

    public final void setFileName(String string) {
        this.getSourceModel().setFileName(string);
    }

    public final String getFileName() {
        return this.getSourceModel().getFileName();
    }

    public final void setDirectory(URL uRL) {
        this.getSourceModel().setDirectory(uRL);
    }

    public final URL getDirectory() {
        return this.getSourceModel().getDirectory();
    }

    public final void setRelativeDirectory(String string) {
        this.getSourceModel().setRelativeDirectory(string);
    }

    public final String getRelativeDirectory() {
        return this.getSourceModel().getRelativeDirectory();
    }

    public final URL getURL() {
        return this.getSourceModel().getURL();
    }

    public final void setURL(URL uRL) {
        this.getSourceModel().setURL(uRL);
    }

    public final void commitWizardState() {
        Node node = this.getSourceModel().createNode();
        if (node != null) {
            if (!node.isReadOnly()) {
                if (this.buildFile(node)) {
                    this.getProject().add(node, this.getSourceModel().getContentSetKey());
                    this.postProcess(node);
                }
            } else {
                this.reportError(BuilderArb.getString(34), BuilderArb.format(35, URLFileSystem.getPlatformPathName((URL)this.getURL())), null);
            }
        } else {
            this.reportError(BuilderArb.getString(21), BuilderArb.format(22, this.getURL()), null);
        }
    }

    protected boolean buildFile(Node node) {
        if (node instanceof TextNode && this._clearExistingFiles) {
            TextNode textNode = (TextNode)node;
            TextBuffer textBuffer = null;
            try {
                textBuffer = textNode.acquireTextBuffer();
                int n = textBuffer.getLength();
                if (n > 0) {
                    textBuffer.remove(0, n);
                    UpdateMessage.fireStructureChanged((Subject)textNode);
                }
            }
            finally {
                if (textBuffer != null) {
                    textNode.releaseTextBuffer();
                }
            }
        }
        return true;
    }

    protected void postProcess(Node node) {
        if (node != null) {
            try {
                node.save();
            }
            catch (Exception exception) {
                exception.printStackTrace();
            }
            SwingUtilities.invokeLater(new 1(this, node));
        }
    }

    protected SourceModel createSourceModel() {
        return new SourceModel();
    }

    public final void reportError(String string) {
        this.reportError(IdeArb.getString((int)2), string, null);
    }

    public void reportError(String string, String string2, String string3) {
    }

    protected final SourceModel getSourceModel() {
        if (this._src == null) {
            this._src = this.createSourceModel();
        }
        return this._src;
    }

    public final class 1
    implements Runnable {
        private final /* synthetic */ Node v$node;
        final /* synthetic */ AbstractBuilderModel this$0;

        public void run() {
            Context context = Context.newIdeContext((Node)this.v$node);
            EditorManager editorManager = EditorManager.getEditorManager();
            OpenEditorOptions openEditorOptions = new OpenEditorOptions(context);
            if (!this.this$0.isRaiseEditor()) {
                openEditorOptions.setFlags(2);
            }
            openEditorOptions.setFlags(8, true);
            editorManager.openEditor(openEditorOptions);
        }

        public 1(AbstractBuilderModel abstractBuilderModel, Node node) {
            this.v$node = node;
            this.this$0 = abstractBuilderModel;
        }
    }
}

