/*
 * Decompiled with CFR 0.152.
 */
package oracle.jdeveloper.builder;

import java.awt.Component;
import java.net.URL;
import oracle.ide.Ide;
import oracle.ide.dialogs.MessageDialog;
import oracle.ide.model.Element;
import oracle.ide.model.Node;
import oracle.ide.model.NodeFactory;
import oracle.ide.model.Project;
import oracle.ide.model.ProjectContent;
import oracle.ide.net.DefaultNameGenerator;
import oracle.ide.net.NameGenerator;
import oracle.ide.net.URLFactory;
import oracle.ide.net.URLFileSystem;
import oracle.ide.net.URLPath;
import oracle.javatools.data.PropertyStorage;
import oracle.jdeveloper.builder.resource.BuilderArb;
import oracle.jdeveloper.model.PathsConfiguration;

public class SourceModel {
    private String _fileName;
    private String _directory;
    private URL _baseURL;
    private Project _proj;
    private URL _url;
    private boolean _allowUrlsNotInSourcePath;

    void $init$() {
        this._directory = "";
    }

    public SourceModel() {
        this.$init$();
    }

    public final URL getURL() {
        URL uRL;
        if (this._url == null && (uRL = this.getDirectory()) != null) {
            this._url = URLFactory.newURL((URL)uRL, (String)(this._fileName + this.getExtension()));
        }
        return this._url;
    }

    public final void setURL(URL uRL) {
        this._url = null;
        if (uRL != null) {
            this.setDirectory(URLFileSystem.getParent((URL)uRL));
            this._url = uRL;
        }
    }

    public final boolean verifyPath() {
        URL uRL = this.getURL();
        URL uRL2 = URLFileSystem.getParent((URL)uRL);
        return URLFileSystem.exists((URL)uRL2) || URLFileSystem.mkdirs((URL)uRL2);
    }

    public final Node createNode() {
        URL uRL = this.getURL();
        Node node = null;
        try {
            Class clazz = this.getNodeType();
            node = clazz != null ? NodeFactory.findOrCreate((Class)clazz, (URL)uRL) : NodeFactory.findOrCreate((URL)uRL);
            if (node != null && !this._proj.canAdd((Element)node)) {
                String string = BuilderArb.format(112, URLFileSystem.getPlatformPathName((URL)node.getURL()), URLFileSystem.getPlatformPathName((URL)this._proj.getURL()));
                MessageDialog.error((Component)Ide.getMainWindow(), (Object)string, null, null);
                node = null;
            }
        }
        catch (IllegalAccessException illegalAccessException) {
        }
        catch (InstantiationException instantiationException) {
            // empty catch block
        }
        return node;
    }

    public final boolean checkForExistingFile() {
        URL uRL = this.getURL();
        Node node = NodeFactory.find((URL)uRL);
        return node != null && node.isOpen() || URLFileSystem.exists((URL)uRL);
    }

    public void generateDefaultFileName(String string) {
        URL uRL = this.getDirectory();
        int n = this.getDefaultNameStartIndex();
        DefaultNameGenerator defaultNameGenerator = new DefaultNameGenerator(string, this.getExtension(), n);
        this._url = URLFactory.newUniqueURL((URL)uRL, (NameGenerator)defaultNameGenerator);
        String string2 = URLFileSystem.getFileName((URL)this._url);
        this._fileName = string2.substring(0, string2.indexOf(46));
    }

    public String getFileName() {
        return this._fileName;
    }

    public void setFileName(String string) {
        this._fileName = string;
        this._url = null;
    }

    public final String getRelativeDirectory() {
        return this._directory;
    }

    public void setRelativeDirectory(String string) {
        if (this._baseURL == null) {
            this.updateBaseURLFromProject();
        }
        this._directory = string != null ? string : "";
        this._url = null;
    }

    public URL getDirectory() {
        return this._directory.length() == 0 ? this._baseURL : URLFactory.newDirURL((URL)this._baseURL, (String)this._directory);
    }

    protected String getDirectoryString() {
        return this._directory;
    }

    public final void setDirectory(URL uRL) {
        if (uRL != null && !URLFileSystem.isDirectoryPath((URL)uRL)) {
            uRL = URLFileSystem.getParent((URL)uRL);
        }
        if (uRL == null) {
            this.updateBaseURLFromProject();
            this._directory = "";
            this._url = null;
            return;
        }
        if (!this.isInSourcePath(uRL)) {
            if (this._allowUrlsNotInSourcePath) {
                this._baseURL = uRL;
                this._directory = "";
            } else {
                this._baseURL = null;
                this._directory = "";
            }
        }
        this._url = null;
    }

    public boolean isInSourcePath(URL uRL) {
        if (uRL == null) {
            return false;
        }
        URL[] uRLArray = this.getSourcePath().getEntries();
        boolean bl = false;
        int n = 0;
        while (n < uRLArray.length) {
            URL uRL2 = uRLArray[n];
            String string = URLFileSystem.toRelativeSpec((URL)uRL, (URL)uRL2, (boolean)true);
            if (string != null) {
                if (string.endsWith("/")) {
                    string = string.substring(0, string.length() - 1);
                }
                this._baseURL = uRL2;
                this.setRelativeDirectory(string);
                bl = true;
                break;
            }
            ++n;
        }
        return bl;
    }

    public final URL getBaseURL() {
        return this._baseURL;
    }

    public final Project getProject() {
        return this._proj;
    }

    public void setProject(Project project) throws IllegalArgumentException {
        if (project == null) {
            throw new IllegalArgumentException("SourceModel: project cannot be null");
        }
        this._proj = project;
        this.updateBaseURLFromProject();
        this._url = null;
    }

    protected void updateBaseURLFromProject() {
        if (this._proj == null) {
            return;
        }
        this._baseURL = this.getSourcePath().getFirstEntry();
        if (this._baseURL == null) {
            this._baseURL = URLFileSystem.getParent((URL)this._proj.getURL());
        }
    }

    public String getExtension() {
        return ".txt";
    }

    protected int getDefaultNameStartIndex() {
        return 1;
    }

    protected Class getNodeType() {
        return null;
    }

    protected URLPath getSourcePath() {
        URLPath uRLPath = PathsConfiguration.getInstance(this._proj).getProjectSourcePath();
        uRLPath.add(ProjectContent.getInstance((PropertyStorage)this._proj).getAllContents().getAllRootDirs());
        return uRLPath;
    }

    protected String getContentSetKey() {
        return "oracle.ide.model.ResourcePaths/resourcesContentSet";
    }

    public void setAllowUrlsNotInSourcePath(boolean bl) {
        this._allowUrlsNotInSourcePath = bl;
    }

    public boolean getAllowUrlsNotInSourcePath() {
        return this._allowUrlsNotInSourcePath;
    }
}

