/*
 * Decompiled with CFR 0.152.
 */
package oracle.jdeveloper.builder.applet;

import java.awt.Component;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.event.ItemEvent;
import java.awt.event.ItemListener;
import javax.swing.AbstractButton;
import javax.swing.JCheckBox;
import javax.swing.JComponent;
import javax.swing.JPanel;
import oracle.ide.util.ResourceUtils;
import oracle.javatools.parser.java.v2.SourceFactory;
import oracle.javatools.parser.java.v2.model.JavaClass;
import oracle.javatools.parser.java.v2.model.JavaType;
import oracle.javatools.parser.java.v2.model.SourceBlock;
import oracle.javatools.parser.java.v2.model.SourceClass;
import oracle.javatools.parser.java.v2.model.SourceFile;
import oracle.javatools.parser.java.v2.model.SourceMember;
import oracle.javatools.parser.java.v2.model.SourceMethod;
import oracle.jdeveloper.builder.resource.BuilderArb;
import oracle.jdeveloper.builder.ui.UIGenerator;
import oracle.jdeveloper.java.JavaManager;
import oracle.jdeveloper.java.legacy.JotNames;
import oracle.jdeveloper.java.util.SourceUtils;

public class AppletGenerator
extends UIGenerator
implements ItemListener {
    private boolean _isStandalone;
    private boolean _hasStandardMethods;
    private Boolean _isJApplet;
    private JPanel _attrPanel;
    public static final String ACTION_STANDALONE = "standalone";
    public static final String ACTION_STANDARD_METHODS = "standard";
    public static final String START_METHOD_NAME = "start";
    public static final String STOP_METHOD_NAME = "stop";
    public static final String DESTROY_METHOD_NAME = "destroy";

    public void setStandalone(boolean bl) {
        this._isStandalone = bl;
    }

    public boolean isStandalone() {
        return this._isStandalone;
    }

    public void setStandardMethods(boolean bl) {
        this._hasStandardMethods = bl;
    }

    public boolean isStandardMethods() {
        return this._hasStandardMethods;
    }

    public JComponent getAttributes(String string) {
        if (this._attrPanel == null) {
            this._attrPanel = this._createPanel();
        }
        return this._attrPanel;
    }

    protected void addMethods() {
        SourceFile sourceFile = this.getSourceFile();
        SourceClass sourceClass = this.getSourceClass();
        boolean bl = this._isJApplet();
        SourceMethod sourceMethod = sourceClass.getSourceMethod("init", new JavaType[0]);
        if (this._hasStandardMethods) {
            SourceMethod sourceMethod2 = sourceMethod;
            sourceMethod2 = SourceUtils.addMethod(sourceClass, "void", START_METHOD_NAME, 1, (SourceMember)sourceMethod2, false);
            sourceMethod2 = SourceUtils.addMethod(sourceClass, "void", STOP_METHOD_NAME, 1, (SourceMember)sourceMethod2, false);
            sourceMethod2 = SourceUtils.addMethod(sourceClass, "void", DESTROY_METHOD_NAME, 1, (SourceMember)sourceMethod2, false);
        }
        if (this._isStandalone) {
            SourceMethod sourceMethod3 = SourceUtils.createMainMethod(sourceClass);
            SourceUtils.addMember(sourceClass, (SourceMember)sourceMethod3, (SourceMember)sourceMethod, false);
            SourceBlock sourceBlock = sourceMethod3.getBlock();
            String string = JotNames.getShortClassName(sourceClass.getName());
            SourceUtils.addLocalVariableDeclaration(sourceBlock, string, "applet", "new " + string + "()");
            if (bl) {
                SourceUtils.addLocalVariableDeclaration(sourceBlock, "JFrame", "frame", "new JFrame()");
                SourceUtils.addExpressionStatement(sourceBlock, "frame.setDefaultCloseOperation( JFrame.EXIT_ON_CLOSE )");
                SourceUtils.addExpressionStatement(sourceBlock, "frame.getContentPane().add(applet, BorderLayout.CENTER)");
            } else {
                SourceUtils.addLocalVariableDeclaration(sourceBlock, "Frame", "frame", "new Frame()");
                SourceUtils.addExpressionStatement(sourceBlock, "frame.addWindowListener(new WindowAdapter() { public void windowClosing(WindowEvent e) { System.exit(0); } } )");
                SourceUtils.addExpressionStatement(sourceBlock, "frame.add(applet, BorderLayout.CENTER)");
            }
            SourceUtils.addExpressionStatement(sourceBlock, "frame.setTitle( \"Applet Frame\" )");
            SourceUtils.addExpressionStatement(sourceBlock, "applet.init()");
            SourceUtils.addExpressionStatement(sourceBlock, "applet.start()");
            SourceUtils.addExpressionStatement(sourceBlock, "frame.setSize(300, 300)");
            SourceUtils.addLocalVariableDeclaration(sourceBlock, "Dimension", "d", "Toolkit.getDefaultToolkit().getScreenSize();");
            SourceUtils.addLocalVariableDeclaration(sourceBlock, "Dimension", "frameSize", "frame.getSize();");
            SourceUtils.addExpressionStatement(sourceBlock, "frame.setLocation((d.width-frameSize.width)/2, (d.height-frameSize.height)/2)");
            SourceUtils.addExpressionStatement(sourceBlock, "frame.setVisible(true);");
        }
        if (bl) {
            SourceFactory sourceFactory = sourceFile.getFactory();
            SourceBlock sourceBlock = sourceFactory.createBlock();
            SourceUtils.addStaticClassInitializer(sourceClass, sourceBlock);
            SourceBlock sourceBlock2 = sourceFactory.createBlock();
            SourceBlock sourceBlock3 = sourceFactory.createBlock();
            SourceUtils.addTryCatchStatement(sourceBlock, sourceBlock2, "Exception", "e", sourceBlock3);
            SourceUtils.addLineComment(sourceBlock2, "UIManager.setLookAndFeel(UIManager.getSystemLookAndFeelClassName());");
            SourceUtils.addLineComment(sourceBlock2, "UIManager.setLookAndFeel(UIManager.getCrossPlatformLookAndFeelClassName());");
        }
    }

    protected void addImports() {
        this.addImport("java.awt.Dimension");
        this.addImport("java.awt.Toolkit");
        this.addImport("java.awt.BorderLayout");
        if (this._isJApplet()) {
            this.addImport("javax.swing.JFrame");
            this.addImport("javax.swing.UIManager");
        } else {
            this.addImport("java.awt.Frame");
            this.addImport("java.awt.event.WindowAdapter");
            this.addImport("java.awt.event.WindowEvent");
        }
    }

    protected void setProperties() {
        if (this._isJApplet()) {
            this.addProperty("this.getContentPane().setLayout", "null");
        } else {
            this.addProperty("this.setLayout", "null");
        }
    }

    private boolean _isJApplet() {
        if (this._isJApplet == null) {
            SourceClass sourceClass = this.getSourceClass();
            JavaManager javaManager = this.getJavaManager();
            JavaClass javaClass = javaManager.getClass("javax.swing.RootPaneContainer");
            this._isJApplet = javaClass != null && javaClass.isAssignableFrom((JavaType)sourceClass) ? Boolean.TRUE : Boolean.FALSE;
        }
        return this._isJApplet;
    }

    public void itemStateChanged(ItemEvent itemEvent) {
        Object object = itemEvent.getSource();
        if (object instanceof JCheckBox) {
            JCheckBox jCheckBox = (JCheckBox)object;
            String string = jCheckBox.getActionCommand();
            if (ACTION_STANDALONE.equals(string)) {
                this._isStandalone = jCheckBox.isSelected();
            } else if (ACTION_STANDARD_METHODS.equals(string)) {
                this._hasStandardMethods = jCheckBox.isSelected();
            }
        }
    }

    private JPanel _createPanel() {
        JPanel jPanel = new JPanel();
        jPanel.setLayout(new GridBagLayout());
        JCheckBox jCheckBox = new JCheckBox();
        jCheckBox.setActionCommand(ACTION_STANDALONE);
        jCheckBox.addItemListener(this);
        ResourceUtils.resButton((AbstractButton)jCheckBox, (String)BuilderArb.getString(90));
        JCheckBox jCheckBox2 = new JCheckBox();
        jCheckBox2.setActionCommand(ACTION_STANDARD_METHODS);
        jCheckBox2.addItemListener(this);
        ResourceUtils.resButton((AbstractButton)jCheckBox2, (String)BuilderArb.getString(91));
        jPanel.add((Component)jCheckBox, new GridBagConstraints(0, 0, 1, 1, 1.0, 0.0, 18, 0, new Insets(2, 2, 2, 2), 0, 0));
        jPanel.add((Component)jCheckBox2, new GridBagConstraints(0, 1, 1, 1, 1.0, 0.0, 18, 0, new Insets(2, 2, 2, 2), 0, 0));
        return jPanel;
    }
}

