/*
 * Decompiled with CFR 0.152.
 */
package oracle.jdeveloper.builder.application;

import javax.swing.JComponent;
import oracle.ide.Context;
import oracle.ide.model.Project;
import oracle.ide.model.Workspace;
import oracle.ide.wizard.Wizard;
import oracle.ide.wizard.WizardManager;
import oracle.javatools.parser.java.v2.SourceFactory;
import oracle.javatools.parser.java.v2.model.JavaClass;
import oracle.javatools.parser.java.v2.model.JavaType;
import oracle.javatools.parser.java.v2.model.SourceBlock;
import oracle.javatools.parser.java.v2.model.SourceClass;
import oracle.javatools.parser.java.v2.model.SourceFile;
import oracle.javatools.parser.java.v2.model.SourceMethod;
import oracle.javatools.parser.java.v2.model.statement.SourceStatement;
import oracle.javatools.parser.java.v2.model.statement.SourceTryStatement;
import oracle.jdeveloper.builder.application.ApplicationBuilderModel;
import oracle.jdeveloper.builder.application.ApplicationChained;
import oracle.jdeveloper.builder.application.FrameTypePanel;
import oracle.jdeveloper.builder.cls.AbstractGenerator;
import oracle.jdeveloper.builder.cls.ClassBuilderModel;
import oracle.jdeveloper.java.JavaManager;
import oracle.jdeveloper.java.util.SourceUtils;

public class ApplicationGenerator
extends AbstractGenerator {
    FrameTypePanel _panel;
    private static final String FRAME_BUILDER_CLASS = "oracle.jdeveloper.builder.ui.frame.TopLevelFrameBuilder";

    public JComponent getAttributes(String string) {
        if (this._panel == null) {
            this._panel = new FrameTypePanel();
            this._panel.setSelectedChoice("Empty");
            this._panel.setCenter(true);
            this._panel.setProject(this.getProject());
        }
        return this._panel;
    }

    public boolean validateAttributes() {
        return this._panel.doValidation();
    }

    public void setEnabled(boolean bl) {
        ApplicationGenerator.enableTree(this._panel, bl);
    }

    protected void addDetails(JavaManager javaManager, SourceFile sourceFile, SourceClass sourceClass) {
        String string;
        super.addDetails(javaManager, sourceFile, sourceClass);
        if (this._panel != null && !"None".equals(string = this._panel.getSelectedChoice())) {
            String string2 = null;
            if ("Existing".equals(string)) {
                string2 = this._resolveExistingFrame(javaManager, sourceFile, this._panel.getExistingFrameName());
            } else if ("Empty".equals(string)) {
                string2 = this._getNewFrame(this.getProject(), this.getWorkspace(), sourceClass.getName());
            }
            if (string2 != null) {
                SourceMethod sourceMethod;
                int n = string2.lastIndexOf(46);
                String string3 = n != -1 ? string2.substring(0, n) : "";
                String string4 = sourceFile.getPackageName();
                if (string4 == null) {
                    string4 = "";
                }
                if (!string3.equals(string4)) {
                    SourceUtils.addImport(sourceFile, string2);
                }
                boolean bl = false;
                try {
                    JavaClass javaClass = javaManager.getClass(string2);
                    JavaClass javaClass2 = javaManager.getClass("javax.swing.JFrame");
                    if (javaClass2 != null && javaClass != null && javaClass2.isAssignableFrom((JavaType)javaClass)) {
                        bl = true;
                    }
                }
                catch (Exception exception) {
                    // empty catch block
                }
                if (bl) {
                    SourceUtils.addImport(sourceFile, "javax.swing.JFrame");
                } else {
                    SourceUtils.addImport(sourceFile, "java.awt.Frame");
                    SourceUtils.addImport(sourceFile, "java.awt.event.WindowAdapter");
                    SourceUtils.addImport(sourceFile, "java.awt.event.WindowEvent");
                }
                SourceUtils.addImport(sourceFile, "javax.swing.UIManager");
                string2 = string2.substring(n + 1);
                SourceFactory sourceFactory = sourceFile.getFactory();
                SourceMethod sourceMethod2 = SourceUtils.getMainMethod(sourceClass);
                if (sourceMethod2 != null) {
                    SourceBlock sourceBlock = sourceMethod2.getBlock();
                    SourceBlock sourceBlock2 = sourceFactory.createBlock();
                    SourceBlock sourceBlock3 = sourceFactory.createBlock();
                    SourceTryStatement sourceTryStatement = SourceUtils.addTryCatchStatement(sourceBlock, sourceBlock2, "java.lang.Exception", "e", sourceBlock3);
                    SourceUtils.addExpressionStatement(sourceBlock2, "UIManager.setLookAndFeel(UIManager.getSystemLookAndFeelClassName())");
                    SourceUtils.addExpressionStatement(sourceBlock3, "e.printStackTrace()");
                    sourceTryStatement.removeSelf();
                    SourceUtils.addStatement(sourceBlock, (SourceStatement)sourceTryStatement, null, true);
                }
                if ((sourceMethod = SourceUtils.getDefaultConstructor(sourceClass)) != null) {
                    SourceBlock sourceBlock = sourceMethod.getBlock();
                    String string5 = bl ? "javax.swing.JFrame" : "java.awt.Frame";
                    SourceUtils.addLocalVariableDeclaration(sourceBlock, string5, "frame", "new " + string2 + "()");
                    if (this._panel.isCenter()) {
                        SourceUtils.addImport(sourceFile, "java.awt.Dimension");
                        SourceUtils.addImport(sourceFile, "java.awt.Toolkit");
                        SourceUtils.addLocalVariableDeclaration(sourceBlock, "Dimension", "screenSize", "Toolkit.getDefaultToolkit().getScreenSize()");
                        SourceUtils.addLocalVariableDeclaration(sourceBlock, "Dimension", "frameSize", "frame.getSize()");
                        SourceBlock sourceBlock4 = sourceFactory.createBlock();
                        SourceUtils.addIfStatement(sourceBlock, "frameSize.height > screenSize.height", sourceBlock4);
                        SourceUtils.addExpressionStatement(sourceBlock4, "frameSize.height = screenSize.height");
                        SourceBlock sourceBlock5 = sourceFactory.createBlock();
                        SourceUtils.addIfStatement(sourceBlock, "frameSize.width > screenSize.width", sourceBlock5);
                        SourceUtils.addExpressionStatement(sourceBlock5, "frameSize.width = screenSize.width");
                        SourceUtils.addExpressionStatement(sourceBlock, "frame.setLocation( ( screenSize.width - frameSize.width ) / 2, ( screenSize.height - frameSize.height ) / 2 )");
                    }
                    if (bl) {
                        SourceUtils.addExpressionStatement(sourceBlock, "frame.setDefaultCloseOperation( JFrame.EXIT_ON_CLOSE )");
                    } else {
                        SourceUtils.addExpressionStatement(sourceBlock, "frame.addWindowListener( new WindowAdapter() { public void windowClosing(WindowEvent e) { System.exit(0); } })");
                    }
                    SourceUtils.addExpressionStatement(sourceBlock, "frame.setVisible(true)");
                    ClassBuilderModel classBuilderModel = (ClassBuilderModel)this.getContext().getProperty(ClassBuilderModel.MODEL);
                    if (classBuilderModel instanceof ApplicationBuilderModel) {
                        classBuilderModel.setRaiseEditor(false);
                    }
                }
            }
        }
    }

    private String _resolveExistingFrame(JavaManager javaManager, SourceFile sourceFile, String string) {
        String string2;
        int n;
        String string3 = string;
        if (string != null && (n = string.lastIndexOf(46)) == -1 && (string2 = sourceFile.getPackageName()) != null && string2.length() > 0) {
            String string4 = string2 + "." + string;
            JavaClass javaClass = javaManager.getClass(string4);
            string3 = javaClass != null ? string4 : ((javaClass = javaManager.getClass(string)) != null ? string : string4);
        }
        return string3;
    }

    private String _getNewFrame(Project project, Workspace workspace, String string) {
        String string2 = null;
        Wizard wizard = WizardManager.getInstance().getWizard(FRAME_BUILDER_CLASS);
        if (wizard instanceof ApplicationChained) {
            Context context = new Context(workspace, project);
            Wizard.setLegacyParams((Context)context, (String[])new String[]{string});
            if (wizard.invoke(context)) {
                string2 = ((ApplicationChained)wizard).getResult();
            }
        }
        return string2;
    }
}

