/*
 * Decompiled with CFR 0.152.
 */
package oracle.jdeveloper.builder.application;

import java.awt.Component;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.ItemEvent;
import java.awt.event.ItemListener;
import java.lang.reflect.Modifier;
import javax.swing.AbstractButton;
import javax.swing.ButtonGroup;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JPanel;
import javax.swing.JRadioButton;
import javax.swing.JTextField;
import oracle.ide.model.Project;
import oracle.ide.util.ResourceUtils;
import oracle.javatools.dialogs.MessageDialog;
import oracle.javatools.parser.java.v2.model.JavaClass;
import oracle.javatools.parser.java.v2.model.JavaType;
import oracle.jdeveloper.builder.resource.BuilderArb;
import oracle.jdeveloper.dialogs.ClassPackageBrowserFilterV2;
import oracle.jdeveloper.dialogs.ClassPackageBrowserV2;
import oracle.jdeveloper.java.JavaManager;
import oracle.jdeveloper.java.legacy.JotNames;

public class FrameTypePanel
extends JPanel {
    GridBagLayout gridBagLayout1;
    JCheckBox radFrame;
    JPanel pnlFrameTypes;
    GridBagLayout gridBagLayout3;
    JRadioButton radEmpty;
    JRadioButton radExisting;
    JButton btnBrowse;
    JTextField fldFrameName;
    JCheckBox chkCenter;
    ButtonGroup grpFrame;
    private Project _proj;
    public static final String EXISTING_CMD = "Existing";
    public static final String EMPTY_CMD = "Empty";
    public static final String NONE_CMD = "None";

    void $init$() {
        this.gridBagLayout1 = new GridBagLayout();
        this.radFrame = new JCheckBox();
        this.pnlFrameTypes = new JPanel();
        this.gridBagLayout3 = new GridBagLayout();
        this.radEmpty = new JRadioButton();
        this.radExisting = new JRadioButton();
        this.btnBrowse = new JButton();
        this.fldFrameName = new JTextField();
        this.chkCenter = new JCheckBox();
        this.grpFrame = new ButtonGroup();
    }

    public FrameTypePanel() {
        this.$init$();
        try {
            this.jbInit();
        }
        catch (Exception exception) {
            exception.printStackTrace();
        }
    }

    private void jbInit() throws Exception {
        this.grpFrame.add(this.radEmpty);
        this.grpFrame.add(this.radExisting);
        ResourceUtils.resButton((AbstractButton)this.radFrame, (String)BuilderArb.getString(81));
        this.radFrame.addItemListener(new 3());
        ResourceUtils.resButton((AbstractButton)this.radEmpty, (String)BuilderArb.getString(82));
        ResourceUtils.resButton((AbstractButton)this.radExisting, (String)BuilderArb.getString(83));
        this.radExisting.addItemListener(new 2());
        ResourceUtils.resButton((AbstractButton)this.chkCenter, (String)BuilderArb.getString(86));
        ResourceUtils.resButton((AbstractButton)this.btnBrowse, (String)BuilderArb.getString(84));
        this.btnBrowse.addActionListener(new 1());
        this.setLayout(this.gridBagLayout1);
        this.add((Component)this.radFrame, new GridBagConstraints(0, 0, 1, 1, 0.0, 0.0, 18, 0, new Insets(0, 0, 0, 0), 0, 0));
        this.add((Component)this.pnlFrameTypes, new GridBagConstraints(0, 1, 1, 1, 1.0, 1.0, 11, 2, new Insets(0, 15, 0, 0), 0, 0));
        this.pnlFrameTypes.setLayout(this.gridBagLayout3);
        this.pnlFrameTypes.add((Component)this.radEmpty, new GridBagConstraints(0, 1, 2, 1, 0.0, 0.0, 17, 0, new Insets(3, 0, 0, 0), 0, 0));
        this.pnlFrameTypes.add((Component)this.radExisting, new GridBagConstraints(0, 2, 2, 1, 0.0, 0.0, 17, 0, new Insets(3, 0, 0, 0), 0, 0));
        this.pnlFrameTypes.add((Component)this.fldFrameName, new GridBagConstraints(0, 3, 1, 1, 1.0, 0.0, 10, 2, new Insets(0, 15, 0, 0), 100, 0));
        this.pnlFrameTypes.add((Component)this.btnBrowse, new GridBagConstraints(3, 3, 1, 1, 0.0, 0.0, 10, 0, new Insets(0, 8, 0, 0), 0, 0));
        this.pnlFrameTypes.add((Component)this.chkCenter, new GridBagConstraints(0, 4, 2, 1, 0.0, 0.0, 17, 0, new Insets(5, 0, 0, 0), 0, 0));
    }

    public void setSelectedChoice(String string) {
        if (EXISTING_CMD.equals(string)) {
            this.radFrame.setSelected(true);
            this.radExisting.setSelected(true);
        }
        if (EMPTY_CMD.equals(string)) {
            this.radFrame.setSelected(true);
            this.radEmpty.setSelected(true);
        }
        if (NONE_CMD.equals(string)) {
            this.radFrame.setSelected(false);
        }
    }

    public String getSelectedChoice() {
        String string = NONE_CMD;
        if (this.radFrame.isSelected()) {
            if (this.radExisting.isSelected()) {
                string = EXISTING_CMD;
            } else if (this.radEmpty.isSelected()) {
                string = EMPTY_CMD;
            }
        }
        return string;
    }

    public void setCenter(boolean bl) {
        this.chkCenter.setSelected(bl);
    }

    public boolean isCenter() {
        return this.chkCenter.isSelected();
    }

    public void setExistingFrameName(String string) {
        this.fldFrameName.setText(string);
    }

    public String getExistingFrameName() {
        String string = this.fldFrameName.getText();
        return string != null ? string : "";
    }

    public void setProject(Project project) {
        this._proj = project;
    }

    boolean doValidation() {
        if (!this.radFrame.isSelected() || !this.radExisting.isSelected()) {
            return true;
        }
        String string = this.fldFrameName.getText().trim();
        if (string.length() == 0 || !JotNames.isValidClassName(string)) {
            String string2 = BuilderArb.format(27, string, BuilderArb.getString(28));
            String string3 = BuilderArb.getString(25);
            MessageDialog.error((Component)this, (Object)string2, (String)string3, null);
            this.fldFrameName.requestFocus();
            return false;
        }
        JavaManager javaManager = JavaManager.getJavaManager(this._proj);
        JavaClass javaClass = javaManager.getClass(string);
        if (javaClass != null && !this.validateFrameClass(javaClass)) {
            String string4 = BuilderArb.format(87, string);
            String string5 = BuilderArb.getString(25);
            MessageDialog.error((Component)this, (Object)string4, (String)string5, null);
            this.fldFrameName.requestFocus();
            return false;
        }
        return true;
    }

    private void _itemStateChanged(ItemEvent itemEvent) {
        Object object = itemEvent.getSource();
        if (object == this.radFrame) {
            this._updateFrameChoices();
        } else if (object == this.radExisting) {
            this._updateExisting();
        }
    }

    private void _updateFrameChoices() {
        boolean bl = this.radFrame.isSelected();
        this.radExisting.setEnabled(bl);
        this.radEmpty.setEnabled(bl);
        this.chkCenter.setEnabled(bl);
        this._updateExisting();
    }

    private void _updateExisting() {
        boolean bl = this.radExisting.isEnabled() && this.radExisting.isSelected();
        this.fldFrameName.setEnabled(bl);
        this.btnBrowse.setEnabled(bl);
    }

    private void _browse(ActionEvent actionEvent) {
        String string = ClassPackageBrowserV2.browseClassOrPackage((Component)this, this._proj, 2, new FrameFilter(null));
        if (string != null) {
            this.setExistingFrameName(string);
        }
    }

    private boolean validateFrameClass(JavaClass javaClass) {
        JavaManager javaManager = JavaManager.getJavaManager(this._proj);
        JavaClass javaClass2 = javaManager.getClass("java.awt.Frame");
        return javaClass != null && !Modifier.isAbstract(javaClass.getModifiers()) && javaClass2 != null && javaClass2.isAssignableFrom((JavaType)javaClass);
    }

    static void mav$_itemStateChanged(FrameTypePanel frameTypePanel, ItemEvent itemEvent) {
        frameTypePanel._itemStateChanged(itemEvent);
    }

    static void mav$_browse(FrameTypePanel frameTypePanel, ActionEvent actionEvent) {
        frameTypePanel._browse(actionEvent);
    }

    static boolean mav$validateFrameClass(FrameTypePanel frameTypePanel, JavaClass javaClass) {
        return frameTypePanel.validateFrameClass(javaClass);
    }

    public final class 3
    implements ItemListener {
        public void itemStateChanged(ItemEvent itemEvent) {
            FrameTypePanel.mav$_itemStateChanged(FrameTypePanel.this, itemEvent);
        }
    }

    public final class 2
    implements ItemListener {
        public void itemStateChanged(ItemEvent itemEvent) {
            FrameTypePanel.mav$_itemStateChanged(FrameTypePanel.this, itemEvent);
        }
    }

    public final class 1
    implements ActionListener {
        public void actionPerformed(ActionEvent actionEvent) {
            FrameTypePanel.mav$_browse(FrameTypePanel.this, actionEvent);
        }
    }

    private class FrameFilter
    implements ClassPackageBrowserFilterV2 {
        public boolean acceptPackage(String string) {
            return true;
        }

        public boolean acceptClass(JavaClass javaClass) {
            return FrameTypePanel.mav$validateFrameClass(FrameTypePanel.this, javaClass);
        }

        private FrameFilter() {
        }

        FrameFilter(1 var2_2) {
            this();
        }

        public final class 1 {
        }
    }
}

