/*
 * Decompiled with CFR 0.152.
 */
package oracle.jdeveloper.builder.bean;

import java.lang.reflect.Modifier;
import java.net.URL;
import java.util.Iterator;
import javax.swing.MutableComboBoxModel;
import oracle.bali.ewt.dialog.JEWTDialog;
import oracle.ide.Context;
import oracle.ide.controls.AbstractPicker;
import oracle.ide.model.Node;
import oracle.ide.model.Project;
import oracle.ide.net.URLFileSystem;
import oracle.javatools.parser.java.v2.model.JavaClass;
import oracle.javatools.parser.java.v2.model.JavaMethod;
import oracle.javatools.parser.java.v2.model.JavaType;
import oracle.javatools.parser.java.v2.model.SourceClass;
import oracle.javatools.parser.java.v2.model.SourceFile;
import oracle.jdeveloper.builder.BuilderComboBoxModel;
import oracle.jdeveloper.builder.cls.ClassBuilderModel;
import oracle.jdeveloper.builder.resource.BuilderArb;
import oracle.jdeveloper.java.JavaManager;
import oracle.jdeveloper.model.JavaNode;

public class BeanInfoBuilderModel
extends ClassBuilderModel {
    private static final String[] BASE_CLASSES = new String[]{"java.beans.SimpleBeanInfo"};
    private BuilderComboBoxModel _beanModel;
    private JEWTDialog _dlg;
    private AbstractPicker.PickerResultValidator _validator;

    void $init$() {
        this._validator = new BeanValidator(null);
    }

    public BeanInfoBuilderModel(Context context) {
        super(context);
        this.$init$();
        this.setKeepDefaultPackage(true);
        this._beanModel = new BuilderComboBoxModel();
        Project project = this.getProject();
        JavaManager javaManager = JavaManager.getJavaManager(project);
        Iterator iterator = project.findChildren(JavaNode.class);
        while (iterator.hasNext()) {
            JavaNode javaNode = (JavaNode)((Object)iterator.next());
            SourceFile sourceFile = javaManager.getSourceFile(javaNode.getURL());
            if (sourceFile == null) continue;
            String string = URLFileSystem.getFileName((URL)javaNode.getURL());
            SourceClass sourceClass = sourceFile.getSourceClass(string = string.substring(0, string.lastIndexOf(46)));
            if (!this._isValidBean((JavaClass)sourceClass)) continue;
            this._beanModel.addElement(sourceClass.getName());
        }
    }

    private boolean _isValidBean(JavaClass javaClass) {
        boolean bl = false;
        if (javaClass != null && Modifier.isPublic(javaClass.getModifiers()) && !javaClass.isInterface() && !javaClass.isPrimitive() && !javaClass.isArray()) {
            JavaMethod javaMethod = javaClass.getDeclaredConstructor(new JavaType[0]);
            bl = javaMethod != null ? Modifier.isPublic(javaMethod.getModifiers()) : javaClass.getDeclaredConstructors().size() == 0;
        }
        return bl;
    }

    private boolean _isValidBean(String string) {
        JavaManager javaManager = this.getJavaManager();
        JavaClass javaClass = javaManager.getClass(string);
        return this._isValidBean(javaClass);
    }

    public AbstractPicker.PickerResultValidator getBeanValidator() {
        return this._validator;
    }

    public MutableComboBoxModel getBeanModel() {
        return this._beanModel;
    }

    protected String[] getDefaultBaseClasses() {
        return BASE_CLASSES;
    }

    protected String getDefaultBaseClass() {
        return BASE_CLASSES[0];
    }

    public String getBuilderType() {
        return "BeanInfo";
    }

    protected void postProcess(Node node) {
        super.postProcess(node);
        Object object = this._beanModel.getSelectedItem();
        if (object != null) {
            String string = object.toString();
            String string2 = this.getQualifiedClassName();
        }
    }

    static boolean mav$_isValidBean(BeanInfoBuilderModel beanInfoBuilderModel, JavaClass javaClass) {
        return beanInfoBuilderModel._isValidBean(javaClass);
    }

    static boolean mav$_isValidBean(BeanInfoBuilderModel beanInfoBuilderModel, String string) {
        return beanInfoBuilderModel._isValidBean(string);
    }

    private class BeanValidator
    implements AbstractPicker.PickerResultValidator {
        public boolean isResultValid(Object object) {
            boolean bl = false;
            if (object instanceof JavaClass) {
                bl = BeanInfoBuilderModel.mav$_isValidBean(BeanInfoBuilderModel.this, (JavaClass)object);
            } else if (object != null) {
                bl = BeanInfoBuilderModel.mav$_isValidBean(BeanInfoBuilderModel.this, object.toString());
            }
            return bl;
        }

        public String getInvalidValueMsg(Object object) {
            return BuilderArb.format(27, object, BuilderArb.getString(49));
        }

        private BeanValidator() {
        }

        BeanValidator(1 var2_2) {
            this();
        }

        public final class 1 {
        }
    }
}

