/*
 * Decompiled with CFR 0.152.
 */
package oracle.jdeveloper.builder.bean;

import java.awt.Component;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.event.ActionListener;
import java.awt.event.ItemEvent;
import java.awt.event.ItemListener;
import javax.swing.AbstractButton;
import javax.swing.JButton;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JTextField;
import javax.swing.MutableComboBoxModel;
import javax.swing.event.ListDataEvent;
import javax.swing.event.ListDataListener;
import oracle.bali.ewt.dialog.JEWTDialog;
import oracle.ide.controls.JWrappedLabel;
import oracle.ide.model.Project;
import oracle.ide.util.ResourceUtils;
import oracle.jdeveloper.builder.bean.BeanInfoBuilderModel;
import oracle.jdeveloper.builder.cls.AttributePanel;
import oracle.jdeveloper.builder.cls.ClassBuilderModel;
import oracle.jdeveloper.builder.cls.ClassBuilderPanel;
import oracle.jdeveloper.builder.resource.BuilderArb;
import oracle.jdeveloper.common.OracleTextField;
import oracle.jdeveloper.controls.ClassPicker;
import oracle.jdeveloper.controls.PackagePopup;
import oracle.jdeveloper.java.legacy.JotNames;
import oracle.jdeveloper.wizard.common.BaliWizardPanel;
import oracle.jdeveloper.wizard.common.BaliWizardState;

public class BeanInfoBuilderPanel
extends JPanel
implements ItemListener,
BaliWizardPanel {
    protected GridBagLayout mainLayout;
    protected JWrappedLabel topLabel;
    protected JLabel clsLabel;
    protected JTextField clsField;
    protected JLabel pkgLabel;
    protected PackagePopup pkgPopup;
    protected JButton pkgBrowse;
    protected JLabel baseLabel;
    protected ClassPicker basePanel;
    protected JButton baseBrowse;
    protected AttributePanel attrPanel;
    protected JLabel beanLabel;
    protected ClassPicker beanPicker;
    protected JButton beanBrowse;
    private MutableComboBoxModel beanModel;
    private BeanInfoBuilderModel savedState;
    private transient JEWTDialog _dlg;

    void $init$() {
        this.mainLayout = new GridBagLayout();
        this.topLabel = new JWrappedLabel();
        this.clsLabel = new JLabel();
        this.clsField = new OracleTextField();
        this.pkgLabel = new JLabel();
        this.pkgPopup = new PackagePopup();
        this.pkgBrowse = new JButton();
        this.baseLabel = new JLabel();
        this.basePanel = new ClassPicker();
        this.baseBrowse = new JButton();
        this.attrPanel = new AttributePanel();
        this.beanLabel = new JLabel();
        this.beanPicker = new ClassPicker();
        this.beanBrowse = new JButton();
    }

    public BeanInfoBuilderPanel() {
        this.$init$();
        try {
            this.jbInit();
        }
        catch (Exception exception) {
            exception.printStackTrace();
        }
    }

    private void jbInit() throws Exception {
        this.topLabel.setPreferredAspectRatio(15.0f);
        this.topLabel.setVerticalShrinking(false);
        this.topLabel.setText(BuilderArb.getString(2));
        this.beanPicker.addItemListener(this);
        this.clsField.setEnabled(false);
        ResourceUtils.resLabel((JLabel)this.clsLabel, (Component)this.clsField, (String)BuilderArb.getString(3));
        ResourceUtils.resLabel((JLabel)this.pkgLabel, (Component)this.pkgPopup, (String)BuilderArb.getString(4));
        ResourceUtils.resButton((AbstractButton)this.pkgBrowse, (String)BuilderArb.getString(8));
        this.pkgBrowse.addActionListener(this.pkgPopup);
        ResourceUtils.resLabel((JLabel)this.baseLabel, (Component)((Object)this.basePanel), (String)BuilderArb.getString(6));
        this.baseBrowse.addActionListener((ActionListener)((Object)this.basePanel));
        ResourceUtils.resButton((AbstractButton)this.baseBrowse, (String)BuilderArb.getString(9));
        ResourceUtils.resLabel((JLabel)this.beanLabel, (Component)((Object)this.beanPicker), (String)BuilderArb.getString(46));
        this.beanBrowse.addActionListener((ActionListener)((Object)this.beanPicker));
        ResourceUtils.resButton((AbstractButton)this.beanBrowse, (String)BuilderArb.getString(47));
        this.setLayout(this.mainLayout);
        Insets insets = new Insets(0, 0, 5, 0);
        Insets insets2 = new Insets(0, 8, 5, 8);
        this.add((Component)this.topLabel, new GridBagConstraints(0, 0, 3, 1, 0.0, 0.0, 17, 2, insets, 0, 0));
        this.add((Component)this.beanLabel, new GridBagConstraints(0, 1, 1, 1, 0.0, 0.0, 17, 0, insets, 0, 0));
        this.add((Component)((Object)this.beanPicker), new GridBagConstraints(1, 1, 1, 1, 1.0, 0.0, 10, 2, insets2, 0, 0));
        this.add((Component)this.beanBrowse, new GridBagConstraints(2, 1, 1, 1, 0.0, 0.0, 10, 0, insets, 0, 0));
        this.add((Component)this.clsLabel, new GridBagConstraints(0, 2, 1, 1, 0.0, 0.0, 17, 0, insets, 0, 0));
        this.add((Component)this.clsField, new GridBagConstraints(1, 2, 1, 1, 0.5, 0.0, 10, 2, insets2, 0, 0));
        this.add((Component)this.pkgLabel, new GridBagConstraints(0, 3, 1, 1, 0.0, 0.0, 17, 0, insets, 0, 0));
        this.add((Component)this.pkgPopup, new GridBagConstraints(1, 3, 1, 1, 1.0, 0.0, 10, 2, insets2, 0, 0));
        this.add((Component)this.pkgBrowse, new GridBagConstraints(2, 3, 1, 1, 0.0, 0.0, 10, 0, insets, 0, 0));
        insets.bottom = 0;
        insets2.bottom = 0;
        this.add((Component)this.baseLabel, new GridBagConstraints(0, 4, 1, 1, 0.0, 0.0, 17, 0, insets, 0, 0));
        this.add((Component)((Object)this.basePanel), new GridBagConstraints(1, 4, 1, 1, 1.0, 0.0, 10, 2, insets2, 0, 0));
        this.add((Component)this.baseBrowse, new GridBagConstraints(2, 4, 1, 1, 0.0, 0.0, 10, 0, insets, 0, 0));
        insets.top = 8;
        this.add((Component)this.attrPanel, new GridBagConstraints(0, 5, 3, 1, 1.0, 1.0, 10, 1, insets, 0, 0));
    }

    private void updateSelection() {
        Object object = this.beanModel.getSelectedItem();
        if (object != null) {
            String string = object.toString();
            this.pkgPopup.setText(this.savedState.getPackage());
            this.clsField.setText(JotNames.getShortClassName(string) + "BeanInfo");
            this._dlg.setOKButtonEnabled(true);
        } else {
            this.clsField.setText(BuilderArb.getString(48));
            this._dlg.setOKButtonEnabled(false);
        }
    }

    public void initializeFromState(BaliWizardState baliWizardState) {
        this.savedState = (BeanInfoBuilderModel)baliWizardState;
        Project project = this.savedState.getProject();
        this._dlg = this.savedState.getBuilderDialog();
        this._dlg.setInitialFocus((Component)((Object)this.beanPicker));
        this.beanModel = this.savedState.getBeanModel();
        this.beanModel.addListDataListener(new 1());
        this.beanPicker.setModel(this.beanModel);
        this.beanPicker.setProject(project);
        this.beanPicker.setValidator(this.savedState.getBeanValidator());
        if (this.beanModel.getSize() > 0) {
            this.beanModel.setSelectedItem(this.beanModel.getElementAt(0));
        }
        this.updateSelection();
        if (!this.savedState.hasAttributes()) {
            this.attrPanel.setVisible(false);
        }
        MutableComboBoxModel mutableComboBoxModel = this.savedState.getModel();
        this.attrPanel.setModel(mutableComboBoxModel);
        this.basePanel.setModel(mutableComboBoxModel);
        Object object = this.savedState.getDefaultType();
        if (object != null) {
            mutableComboBoxModel.setSelectedItem(object);
        }
        this.pkgPopup.setProject(project);
        this.basePanel.setProject(project);
        this.basePanel.setValidator(new ClassBuilderPanel.ClassValidator(this.savedState, this.pkgPopup));
        this.basePanel.setEncoder(this.savedState);
    }

    public boolean validateAndWriteToState(BaliWizardState baliWizardState) {
        String string;
        BeanInfoBuilderModel beanInfoBuilderModel = (BeanInfoBuilderModel)baliWizardState;
        boolean bl = false;
        String string2 = this.pkgPopup.getPackage();
        if (string2 != null) {
            string2 = string2.trim();
        }
        if ((string = this.clsField.getText()) != null) {
            string = string.trim();
        }
        try {
            beanInfoBuilderModel.setPackage(string2);
            beanInfoBuilderModel.setClassName(string);
            this.basePanel.setValidator(null);
            this.basePanel.setEncoder(null);
            this._dlg = null;
            this.beanModel = null;
            bl = true;
        }
        catch (ClassBuilderModel.IllegalPackageNameException illegalPackageNameException) {
            beanInfoBuilderModel.reportError(BuilderArb.format(27, string2, BuilderArb.getString(29)));
            this.pkgPopup.requestFocus();
        }
        catch (ClassBuilderModel.IllegalClassNameException illegalClassNameException) {
            beanInfoBuilderModel.reportError(BuilderArb.format(27, string, BuilderArb.getString(28)));
            this.clsField.requestFocus();
        }
        catch (ClassBuilderModel.DuplicateClassException duplicateClassException) {
            this.clsField.requestFocus();
        }
        return bl;
    }

    public void itemStateChanged(ItemEvent itemEvent) {
        this.updateSelection();
    }

    public final class 1
    implements ListDataListener {
        public void intervalAdded(ListDataEvent listDataEvent) {
        }

        public void intervalRemoved(ListDataEvent listDataEvent) {
        }

        public void contentsChanged(ListDataEvent listDataEvent) {
        }
    }
}

