/*
 * Decompiled with CFR 0.152.
 */
package oracle.jdeveloper.builder.cls;

import java.awt.CardLayout;
import java.awt.Component;
import java.util.ArrayList;
import java.util.HashMap;
import javax.swing.BorderFactory;
import javax.swing.JComponent;
import javax.swing.JPanel;
import javax.swing.MutableComboBoxModel;
import javax.swing.border.Border;
import javax.swing.event.ListDataEvent;
import javax.swing.event.ListDataListener;
import oracle.jdeveloper.builder.cls.Generator;
import oracle.jdeveloper.builder.cls.GeneratorElement;
import oracle.jdeveloper.builder.resource.BuilderArb;

public class AttributePanel
extends JPanel
implements ListDataListener {
    Border attrBorder;
    CardLayout attrLayout;
    JPanel emptyPanel;
    private HashMap mapClassToAttributePanel;
    private ArrayList attributePanels;
    private MutableComboBoxModel model;
    private GeneratorElement currGen;

    void $init$() {
        this.attrBorder = BorderFactory.createCompoundBorder(BorderFactory.createTitledBorder(BuilderArb.getString(14)), BorderFactory.createEmptyBorder(0, 8, 8, 8));
        this.attrLayout = new CardLayout();
        this.emptyPanel = new JPanel();
        this.mapClassToAttributePanel = new HashMap();
        this.attributePanels = new ArrayList();
    }

    public AttributePanel() {
        this.$init$();
        try {
            this.jbInit();
        }
        catch (Exception exception) {
            exception.printStackTrace();
        }
    }

    boolean validateAttributes() {
        Object object = this.model.getSelectedItem();
        if (object == null || object.toString().trim().length() == 0) {
            return true;
        }
        GeneratorElement generatorElement = (GeneratorElement)object;
        Generator generator = generatorElement.getGenerator();
        return generator != null ? generator.validateAttributes() : true;
    }

    public void setModel(MutableComboBoxModel mutableComboBoxModel) {
        MutableComboBoxModel mutableComboBoxModel2 = this.model;
        if (mutableComboBoxModel2 != null) {
            mutableComboBoxModel2.removeListDataListener(this);
        }
        this.removeAll();
        this.add((Component)this.emptyPanel, "void");
        if (mutableComboBoxModel != null) {
            mutableComboBoxModel.addListDataListener(this);
            int n = mutableComboBoxModel.getSize() - 1;
            while (n >= 0) {
                GeneratorElement generatorElement = (GeneratorElement)mutableComboBoxModel.getElementAt(n);
                this.updateClassAttributeMap(generatorElement);
                --n;
            }
        }
        this.model = mutableComboBoxModel;
        this.updateAttributes();
    }

    public void intervalAdded(ListDataEvent listDataEvent) {
    }

    public void intervalRemoved(ListDataEvent listDataEvent) {
    }

    public void contentsChanged(ListDataEvent listDataEvent) {
        this.updateAttributes();
    }

    public void setEnabled(boolean bl) {
        super.setEnabled(bl);
        this.currGen.setEnabled(bl);
    }

    private void jbInit() throws Exception {
        this.setLayout(this.attrLayout);
        this.setBorder(this.attrBorder);
        this.add((Component)this.emptyPanel, "void");
    }

    private void updateAttributes() {
        GeneratorElement generatorElement = null;
        Object object = this.model.getSelectedItem();
        String string = object.toString();
        if (string.trim().length() == 0) {
            return;
        }
        generatorElement = object instanceof GeneratorElement ? (GeneratorElement)object : new GeneratorElement(string, null);
        if (generatorElement != this.currGen) {
            this.updateClassAttributeMap(generatorElement);
            if (generatorElement.getAttributes() != null) {
                String string2 = generatorElement.toString();
                String string3 = this.mapClassToAttributePanel.get(string2).toString();
                this.attrLayout.show(this, string3);
            } else {
                this.attrLayout.show(this, "void");
            }
        }
        this.currGen = generatorElement;
    }

    private void updateClassAttributeMap(GeneratorElement generatorElement) {
        JComponent jComponent = generatorElement.getAttributes();
        if (jComponent != null) {
            String string;
            String string2 = string = generatorElement.toString();
            int n = this.attributePanels.size();
            if (n == 0) {
                this.attributePanels.add(new AttributeInfo(string, jComponent));
                this.add((Component)jComponent, string);
            } else {
                boolean bl = false;
                for (AttributeInfo attributeInfo : this.attributePanels) {
                    if (!attributeInfo.getKey().equals(string) && attributeInfo.getAttributes() != jComponent) continue;
                    string2 = attributeInfo.getKey();
                    bl = true;
                    break;
                }
                if (!bl) {
                    this.attributePanels.add(new AttributeInfo(string, jComponent));
                    this.add((Component)jComponent, string);
                }
            }
            this.mapClassToAttributePanel.put(string, string2);
        }
    }

    private static class AttributeInfo {
        String key;
        JComponent attributes;

        AttributeInfo(String string, JComponent jComponent) {
            this.key = string;
            this.attributes = jComponent;
        }

        public String getKey() {
            return this.key;
        }

        public JComponent getAttributes() {
            return this.attributes;
        }
    }
}

