/*
 * Decompiled with CFR 0.152.
 */
package oracle.jdeveloper.builder.cls;

import java.awt.Component;
import java.io.File;
import java.io.IOException;
import java.lang.reflect.Modifier;
import java.net.URL;
import java.text.MessageFormat;
import java.util.ArrayList;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Properties;
import javax.swing.MutableComboBoxModel;
import oracle.bali.ewt.dialog.JEWTDialog;
import oracle.ide.Context;
import oracle.ide.Ide;
import oracle.ide.config.ClientSetting;
import oracle.ide.controller.CommandProcessor;
import oracle.ide.controls.AbstractPicker;
import oracle.ide.dialogs.MessageDialog;
import oracle.ide.editor.EditorManager;
import oracle.ide.editor.EditorUtil;
import oracle.ide.editor.OpenEditorOptions;
import oracle.ide.gallery.GalleryManager;
import oracle.ide.model.Element;
import oracle.ide.model.Node;
import oracle.ide.model.Project;
import oracle.ide.net.URLFileSystem;
import oracle.ide.util.IdeUtil;
import oracle.ide.util.ModelUtil;
import oracle.javatools.parser.java.v2.model.JavaClass;
import oracle.javatools.parser.java.v2.model.JavaType;
import oracle.javatools.parser.java.v2.model.SourceClass;
import oracle.javatools.parser.java.v2.model.SourceFile;
import oracle.javatools.parser.java.v2.write.SourceTransaction;
import oracle.javatools.util.Copyable;
import oracle.jdeveloper.builder.AbstractBuilderModel;
import oracle.jdeveloper.builder.BuilderComboBoxModel;
import oracle.jdeveloper.builder.DataList;
import oracle.jdeveloper.builder.SourceModel;
import oracle.jdeveloper.builder.cls.ClassSourceModel;
import oracle.jdeveloper.builder.cls.Generator;
import oracle.jdeveloper.builder.cls.GeneratorElement;
import oracle.jdeveloper.builder.resource.BuilderArb;
import oracle.jdeveloper.java.JavaManager;
import oracle.jdeveloper.java.TransactionDescriptor;
import oracle.jdeveloper.java.legacy.JotNames;
import oracle.jdeveloper.java.util.SourceUtils;
import oracle.jdeveloper.model.JavaProject;
import oracle.jdeveloper.model.JavaSourceNode;
import oracle.jdevimpl.uieditor.UIEditorImpl;

public class ClassBuilderModel
extends AbstractBuilderModel
implements AbstractPicker.PickerValueEncoder {
    public static final String MODEL = ClassBuilderModel.class.getName();
    private HashMap clsHash;
    private Generator defaultGenerator;
    private MutableComboBoxModel model;
    private boolean keepDefaultPackage;
    private boolean _openInEditor;
    private boolean _confirmOverwrite;
    private String propertiesKey;
    private DataList _history;
    private ArrayList _classList;
    private transient Component _panel;
    private transient JEWTDialog _dlg;
    private Context _ctx;
    private static final String PROP_START = "jdeveloper.{0}.generator.";
    public static final String DEFAULT_BASE_CLASS = "java.lang.Object";
    private static final int MAX_LENGTH = 10;

    void $init$() {
        this.clsHash = new HashMap();
        this._openInEditor = true;
        this._confirmOverwrite = true;
    }

    public ClassBuilderModel(Context context) {
        this.$init$();
        this._ctx = context;
        this._ctx.setProperty(MODEL, (Object)this);
        this.initializeFromContext(context);
        this.loadGenerators();
    }

    protected String getBaseName() {
        return BuilderArb.getString(42);
    }

    protected final boolean buildFile(Node node) {
        super.buildFile(node);
        boolean bl = false;
        Object object = null;
        if (node instanceof JavaSourceNode) {
            SourceFile sourceFile;
            JavaSourceNode javaSourceNode = (JavaSourceNode)node;
            JavaManager javaManager = this.getJavaManager();
            URL uRL = javaSourceNode.getURL();
            if (javaSourceNode.isNew()) {
                try {
                    sourceFile = javaManager.createSourceFile(uRL);
                }
                catch (IOException iOException) {
                    sourceFile = null;
                }
            } else {
                sourceFile = javaManager.getSourceFile(uRL);
            }
            if (sourceFile != null) {
                SourceTransaction sourceTransaction = javaManager.beginTransaction(sourceFile);
                try {
                    Generator generator;
                    String string;
                    GeneratorElement generatorElement;
                    String string2 = this.getPackage();
                    if (string2 != null && string2.length() > 0) {
                        sourceFile.setPackageName(string2);
                    }
                    if (!this.keepDefaultPackage) {
                        Project project = this.getProject();
                        JavaProject.getInstance(project).setMostRecentPackage(string2);
                    }
                    if ((object = this.model.getSelectedItem()) == null || object.toString().length() == 0) {
                        object = this.encodeValue(this.getDefaultBaseClass());
                    }
                    string = (generatorElement = (GeneratorElement)object) != null ? (string = generatorElement.getClassName()) : null;
                    String[] stringArray = this.getOtherImports();
                    if (stringArray != null) {
                        int n = 0;
                        while (n < stringArray.length) {
                            SourceUtils.addImport(sourceFile, stringArray[n]);
                            ++n;
                        }
                    }
                    String string3 = this.getClassName();
                    SourceClass sourceClass = SourceUtils.addClass(sourceFile, string3, 1);
                    if (string != null && !string.equals(DEFAULT_BASE_CLASS)) {
                        SourceUtils.setSuperclass(sourceClass, string);
                    }
                    if (this.hasDefaultConstructor()) {
                        SourceUtils.addConstructor(sourceClass, 1);
                    }
                    this.generate(sourceFile, sourceClass);
                    if (generatorElement != null && (generator = generatorElement.getGenerator()) != null) {
                        generator.generate(javaManager, sourceFile);
                    }
                    javaManager.commitTransaction(sourceTransaction, new TransactionDescriptor("Class Generation"));
                }
                catch (RuntimeException runtimeException) {
                    sourceTransaction.abort();
                }
                this._panel = null;
                bl = true;
            }
        }
        if (bl && object != null) {
            this.storeSettings(object.toString());
        }
        return bl;
    }

    protected SourceModel createSourceModel() {
        return new ClassSourceModel();
    }

    protected String getDefaultRelativeDirectory(Project project) {
        String string = JavaProject.getInstance(project).getMostRecentPackage();
        if (string != null) {
            string = string.replace('.', '/');
        }
        return string;
    }

    protected void validateClassNameIsUnique() {
    }

    public final void setClassName(String string) throws IllegalArgumentException {
        if (string == null || !JotNames.isValidIdentifier(string)) {
            throw new IllegalClassNameException();
        }
        this.setFileName(string);
        URL uRL = this.getSourceModel().getURL();
        if (uRL == null) {
            throw new UserCancelledFileException();
        }
        if (!URLFileSystem.isValid((URL)uRL)) {
            throw new InvalidFileException(URLFileSystem.getPlatformPathName((URL)uRL));
        }
        this.validateClassNameIsUnique();
        if (this.getConfirmOverwrite() && this.getSourceModel().checkForExistingFile()) {
            String string2 = BuilderArb.format(31, BuilderArb.getString(16), URLFileSystem.getPlatformPathName((URL)this.getURL()));
            if (!MessageDialog.confirm((Component)this._getDialogOwner(), (Object)string2, (String)BuilderArb.getString(30), null)) {
                throw new DuplicateClassException();
            }
        }
    }

    public final String getClassName() {
        return this.getFileName();
    }

    public final String getQualifiedClassName() {
        String string = this.getPackage();
        String string2 = this.getClassName();
        return string.length() > 0 ? string + "." + string2 : string2;
    }

    public final void setPackage(String string) throws IllegalArgumentException {
        if (string != null && string.length() > 0 && !JotNames.isValidClassName(string)) {
            throw new IllegalPackageNameException();
        }
        String string2 = string != null ? string.replace('.', '/') : "";
        this.setRelativeDirectory(string2);
    }

    public final String getPackage() {
        String string = this.getRelativeDirectory();
        return string != null ? string.replace('/', '.') : "";
    }

    public final void setKeepDefaultPackage(boolean bl) {
        this.keepDefaultPackage = bl;
    }

    public final boolean getKeepDefaultPackage() {
        return this.keepDefaultPackage;
    }

    public final void setOpenInEditor(boolean bl) {
        this._openInEditor = bl;
    }

    public final boolean getOpenInEditor() {
        return this._openInEditor;
    }

    public final void setConfirmOverwrite(boolean bl) {
        this._confirmOverwrite = bl;
    }

    public final boolean getConfirmOverwrite() {
        return this._confirmOverwrite;
    }

    public final void generateDefaultFileName() {
        SourceModel sourceModel = this.getSourceModel();
        sourceModel.generateDefaultFileName(this.getBaseName());
    }

    public final MutableComboBoxModel getModel() {
        return this.model;
    }

    public final Object getDefaultType() {
        String string = this.getDefaultBaseClass();
        return string != null ? this.clsHash.get(string) : null;
    }

    public final void setActivePanel(Component component) {
        this._panel = component;
    }

    public Component getPanel() {
        return this._panel;
    }

    public void setBuilderDialog(JEWTDialog jEWTDialog) {
        this._dlg = jEWTDialog;
    }

    public JEWTDialog getBuilderDialog() {
        return this._dlg;
    }

    public final boolean hasAttributes() {
        int n = 0;
        while (n < this.model.getSize()) {
            GeneratorElement generatorElement = (GeneratorElement)this.model.getElementAt(n);
            if (generatorElement.getAttributes() != null) {
                return true;
            }
            ++n;
        }
        return false;
    }

    public String getBuilderType() {
        return "Class";
    }

    protected String[] getDefaultBaseClasses() {
        return new String[]{DEFAULT_BASE_CLASS};
    }

    protected String getDefaultBaseClass() {
        return DEFAULT_BASE_CLASS;
    }

    protected String[] getOtherImports() {
        return new String[0];
    }

    protected String[] getLibraries() {
        return new String[0];
    }

    private void initializeDataList() {
        String string = this.propertiesKey = this._dlg == null ? null : this._dlg.getTitle();
        if (this.propertiesKey == null || this.propertiesKey.length() == 0) {
            this._history = new DataList();
            return;
        }
        this.formatPropertyString(this.propertiesKey);
        if (this._history == null) {
            this._history = (DataList)Ide.getSettings().getData(this.propertiesKey);
            if (this._history == null) {
                this._history = new DataList();
                ClientSetting.findOrCreate((String)"oracle.jdeveloper").putData(this.propertiesKey, (Copyable)this._history);
            }
        }
    }

    protected void updateStoredBaseClasses() {
        this.initializeDataList();
        Iterator iterator = this._history.getList().iterator();
        this._classList = new ArrayList();
        while (iterator.hasNext()) {
            Object e = iterator.next();
            if (!this.validateClassType(e.toString(), this.getPackage())) continue;
            this._classList.add(e);
        }
        int n = this._classList.size();
        if (n == 0) {
            return;
        }
        String[] stringArray = this._classList.toArray(new String[n]);
        this.updateModel(stringArray);
        this.updateGenerators();
        Object object = this.getDefaultType();
        if (object != null && this.model != null) {
            this.model.setSelectedItem(object);
        }
    }

    private void storeSettings(String string) {
        if (this.propertiesKey == null) {
            return;
        }
        this.initializeDataList();
        ArrayList arrayList = (ArrayList)this._history.getList();
        if (arrayList.contains(string)) {
            arrayList.remove(string);
        }
        arrayList.add(0, string);
        int n = arrayList.size() - 1;
        while (n >= 10) {
            arrayList.remove(n);
            --n;
        }
        this._history.setSelectedItem(string);
    }

    protected boolean validateClass(JavaClass javaClass, String string) {
        boolean bl = false;
        if (!(javaClass == null || javaClass.isArray() || javaClass.isInterface() || javaClass.isPrimitive() || Modifier.isFinal(javaClass.getModifiers()) || !this._isClassAccessible(javaClass, string))) {
            String[] stringArray = this.getDefaultBaseClasses();
            int n = 0;
            while (n < stringArray.length) {
                JavaClass javaClass2 = this.getJavaManager().getClass(stringArray[n]);
                if (javaClass2.isAssignableFrom((JavaType)javaClass)) {
                    bl = true;
                    break;
                }
                ++n;
            }
        }
        return bl;
    }

    protected final boolean _isClassAccessible(JavaClass javaClass, String string) {
        boolean bl;
        int n = javaClass.getModifiers();
        boolean bl2 = bl = javaClass.getOwningClass() == null || Modifier.isStatic(n);
        if (bl && !(bl = Modifier.isPublic(n)) && !Modifier.isPrivate(n)) {
            String string2 = javaClass.getPackageName();
            bl = ModelUtil.areEqual((Object)string, (Object)string2);
        }
        return bl;
    }

    protected boolean validateClassType(String string, String string2) {
        boolean bl = false;
        try {
            JavaManager javaManager = this.getJavaManager();
            JavaClass javaClass = javaManager.getClass(string);
            bl = this.validateClass(javaClass, string2);
        }
        catch (Exception exception) {
            // empty catch block
        }
        return bl;
    }

    protected boolean hasDefaultConstructor() {
        return false;
    }

    protected boolean isObjectBaseClass() {
        return DEFAULT_BASE_CLASS.equals(this.getDefaultBaseClass());
    }

    protected boolean isSuperclassEditable() {
        return this.isObjectBaseClass();
    }

    protected void generate(SourceFile sourceFile, SourceClass sourceClass) {
    }

    protected final JavaManager getJavaManager() {
        return JavaManager.getJavaManager(this.getProject());
    }

    protected final Context getContext() {
        return this._ctx;
    }

    public final void reportError(String string, String string2, String string3) {
        MessageDialog.error((Component)this._getDialogOwner(), (Object)string2, (String)string, (String)string3);
    }

    private Component _getDialogOwner() {
        return this._panel != null ? this._panel : Ide.getMainWindow();
    }

    private void formatPropertyString(String string) {
        String string2 = string.toLowerCase() + BuilderArb.getString(15);
        if (string2.indexOf(" ") > 0) {
            string2 = string2.replaceAll(" ", "-");
        }
        this.propertiesKey = string2;
    }

    private void updateModel(String[] stringArray) {
        int n = 0;
        while (n < stringArray.length) {
            String string = stringArray[n];
            if (!this.clsHash.containsKey(string)) {
                GeneratorElement generatorElement = new GeneratorElement(string, null);
                this.clsHash.put(string, generatorElement);
                this.model.addElement(generatorElement);
            }
            ++n;
        }
    }

    private void loadGenerators() {
        this.model = new BuilderComboBoxModel();
        String[] stringArray = this.getDefaultBaseClasses();
        if (stringArray != null) {
            this.updateModel(stringArray);
        }
        Properties properties = GalleryManager.getGalleryManager().getBuilderProperties();
        Object[] objectArray = new Object[]{this.getBuilderType().toLowerCase()};
        String string = MessageFormat.format(PROP_START, objectArray);
        Enumeration<?> enumeration = properties.propertyNames();
        while (enumeration.hasMoreElements()) {
            String string2 = (String)enumeration.nextElement();
            if (!string2.startsWith(string)) continue;
            String string3 = string2.substring(string.length());
            String string4 = properties.getProperty(string2, null);
            Generator generator = null;
            try {
                Object obj;
                Class<?> clazz;
                Class<?> clazz2 = clazz = string4 != null ? Class.forName(string4) : null;
                if (clazz != null && (obj = clazz.newInstance()) instanceof Generator) {
                    generator = (Generator)obj;
                    generator.setContext(this.getContext());
                }
            }
            catch (Exception exception) {
                // empty catch block
            }
            if (string3.equals("*")) {
                this.defaultGenerator = generator;
                continue;
            }
            GeneratorElement generatorElement = (GeneratorElement)this.clsHash.get(string3);
            if (generatorElement != null) {
                generatorElement.setGenerator(generator);
                continue;
            }
            generatorElement = new GeneratorElement(string3, generator);
            this.clsHash.put(string3, generatorElement);
            this.model.addElement(generatorElement);
        }
        this.updateGenerators();
        Object object = this.getDefaultType();
        if (object != null) {
            this.model.setSelectedItem(object);
        }
    }

    public void updateGenerators() {
        if (this.defaultGenerator != null) {
            for (Object k : this.clsHash.keySet()) {
                GeneratorElement generatorElement = (GeneratorElement)this.clsHash.get(k);
                if (generatorElement == null || generatorElement.getGenerator() != null) continue;
                generatorElement.setGenerator(this.defaultGenerator);
            }
        }
    }

    public Object encodeValue(Object object) {
        String string = object.toString();
        GeneratorElement generatorElement = (GeneratorElement)this.clsHash.get(string);
        if (generatorElement == null) {
            generatorElement = new GeneratorElement(string, this.defaultGenerator);
            this.clsHash.put(string, generatorElement);
        }
        return generatorElement;
    }

    protected void postProcess(Node node) {
        if (node != null) {
            CommandProcessor.getInstance().flush((Object)node);
            try {
                node.save();
            }
            catch (Exception exception) {
                exception.printStackTrace();
            }
            1 var3_3 = new 1(this, node);
            IdeUtil.invokeAfterRepaint((Runnable)var3_3);
        }
    }

    static boolean ra$_openInEditor(ClassBuilderModel classBuilderModel) {
        return classBuilderModel._openInEditor;
    }

    public static class IllegalClassNameException
    extends IllegalArgumentException {
    }

    public static class IllegalPackageNameException
    extends IllegalArgumentException {
    }

    public static class IllegalBaseClassException
    extends IllegalArgumentException {
    }

    public static class DuplicateClassException
    extends IllegalArgumentException {
    }

    public static class UserCancelledFileException
    extends IllegalArgumentException {
    }

    public static class InvalidFileException
    extends IllegalArgumentException {
        String _path;

        InvalidFileException(String string) {
            this._path = string;
        }

        public String getPath() {
            return this._path;
        }
    }

    public final class 1
    implements Runnable {
        private final /* synthetic */ Node v$node;
        final /* synthetic */ ClassBuilderModel this$0;

        public void run() {
            String string = URLFileSystem.getFileName((URL)this.v$node.getURL());
            if (string != null) {
                JavaClass javaClass;
                SourceClass sourceClass;
                int n = string.lastIndexOf(File.separatorChar);
                int n2 = string.lastIndexOf(".");
                n2 = n2 < 0 ? string.length() : n2;
                string = string.substring(n + 1, n2).replace('/', '.');
                JavaManager javaManager = JavaManager.getJavaManager(this.this$0.getProject());
                SourceFile sourceFile = javaManager != null ? javaManager.getSourceFile(this.v$node.getURL()) : null;
                SourceClass sourceClass2 = sourceClass = sourceFile != null ? sourceFile.getSourceClass(string) : null;
                if (sourceClass != null && (javaClass = javaManager.getClass("java.awt.Component")) != null && javaClass.isAssignableFrom((JavaType)sourceClass)) {
                    Context context = this.this$0.getContext() != null ? new Context(this.this$0.getContext()) : Context.newIdeContext();
                    context.setNode(this.v$node);
                    context.setSelection(new Element[]{this.v$node});
                    if (EditorManager.getEditorManager().isEditorRegistered(UIEditorImpl.class)) {
                        EditorUtil.openExplicitEditorInFrame(UIEditorImpl.class, (Context)context);
                        return;
                    }
                }
            }
            if (ClassBuilderModel.ra$_openInEditor(this.this$0)) {
                Context context = Context.newIdeContext((Node)this.v$node);
                EditorManager editorManager = EditorManager.getEditorManager();
                OpenEditorOptions openEditorOptions = new OpenEditorOptions(context);
                if (!this.this$0.isRaiseEditor()) {
                    openEditorOptions.setFlags(2);
                }
                openEditorOptions.setFlags(8, true);
                editorManager.openEditor(openEditorOptions);
            }
        }

        public 1(ClassBuilderModel classBuilderModel, Node node) {
            this.v$node = node;
            this.this$0 = classBuilderModel;
        }
    }
}

