/*
 * Decompiled with CFR 0.152.
 */
package oracle.jdeveloper.builder.cls;

import java.awt.Component;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.event.ActionListener;
import javax.swing.AbstractButton;
import javax.swing.JButton;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JTextField;
import javax.swing.MutableComboBoxModel;
import javax.swing.event.DocumentEvent;
import javax.swing.event.DocumentListener;
import javax.swing.text.BadLocationException;
import javax.swing.text.Document;
import oracle.ide.controls.AbstractPicker;
import oracle.ide.util.ResourceUtils;
import oracle.javatools.parser.java.v2.model.JavaClass;
import oracle.jdeveloper.builder.cls.AttributePanel;
import oracle.jdeveloper.builder.cls.ClassBuilderModel;
import oracle.jdeveloper.builder.resource.BuilderArb;
import oracle.jdeveloper.common.OracleTextField;
import oracle.jdeveloper.controls.ClassPicker;
import oracle.jdeveloper.controls.PackagePopup;
import oracle.jdeveloper.dialogs.ClassPackageBrowserV2;
import oracle.jdeveloper.wizard.common.BaliWizardPanel;
import oracle.jdeveloper.wizard.common.BaliWizardState;

public final class ClassBuilderPanel
extends JPanel
implements BaliWizardPanel {
    protected GridBagLayout mainLayout;
    protected JLabel clsLabel;
    protected JTextField clsField;
    protected JLabel pkgLabel;
    protected PackagePopup pkgPopup;
    protected JButton pkgBrowse;
    protected ClassPackageBrowserV2 pkgBrowser;
    protected JLabel baseLabel;
    protected ClassPicker basePanel;
    protected JButton baseBrowse;
    protected AttributePanel attrPanel;
    private ClassBuilderModel savedState;
    private static int FILENAME_DISPLAY_MAX_LENGTH = 80;

    void $init$() {
        this.mainLayout = new GridBagLayout();
        this.clsLabel = new JLabel();
        this.clsField = new OracleTextField();
        this.pkgLabel = new JLabel();
        this.pkgPopup = new PackagePopup();
        this.pkgBrowse = new JButton();
        this.pkgBrowser = new ClassPackageBrowserV2();
        this.baseLabel = new JLabel();
        this.basePanel = new ClassPicker();
        this.baseBrowse = new JButton();
        this.attrPanel = new AttributePanel();
    }

    public ClassBuilderPanel() {
        this.$init$();
        try {
            this.jbInit();
        }
        catch (Exception exception) {
            exception.printStackTrace();
        }
    }

    private void jbInit() throws Exception {
        DataFieldDocumentListener dataFieldDocumentListener = new DataFieldDocumentListener(null);
        this.clsField.getDocument().addDocumentListener(dataFieldDocumentListener);
        this.pkgBrowse.addActionListener(this.pkgPopup);
        ResourceUtils.resLabel((JLabel)this.clsLabel, (Component)this.clsField, (String)BuilderArb.getString(3));
        ResourceUtils.resLabel((JLabel)this.pkgLabel, (Component)this.pkgPopup, (String)BuilderArb.getString(4));
        ResourceUtils.resButton((AbstractButton)this.pkgBrowse, (String)BuilderArb.getString(8));
        this.baseBrowse.addActionListener((ActionListener)((Object)this.basePanel));
        ResourceUtils.resButton((AbstractButton)this.baseBrowse, (String)BuilderArb.getString(9));
        ResourceUtils.resLabel((JLabel)this.baseLabel, (Component)((Object)this.basePanel), (String)BuilderArb.getString(6));
        this.setLayout(this.mainLayout);
        Insets insets = new Insets(0, 0, 5, 0);
        Insets insets2 = new Insets(0, 8, 5, 8);
        this.add((Component)this.clsLabel, new GridBagConstraints(0, 0, 1, 1, 0.0, 0.0, 17, 0, insets, 0, 0));
        this.add((Component)this.clsField, new GridBagConstraints(1, 0, 1, 1, 1.0, 0.0, 17, 2, insets2, 0, 0));
        this.add((Component)this.pkgLabel, new GridBagConstraints(0, 1, 1, 1, 0.0, 0.0, 17, 0, insets, 0, 0));
        this.add((Component)this.pkgPopup, new GridBagConstraints(1, 1, 1, 1, 0.0, 0.0, 17, 2, insets2, 0, 0));
        this.add((Component)this.pkgBrowse, new GridBagConstraints(2, 1, 1, 1, 0.0, 0.0, 17, 0, insets, 0, 0));
        insets.bottom = 0;
        insets2.bottom = 0;
        this.add((Component)this.baseLabel, new GridBagConstraints(0, 2, 1, 1, 0.0, 0.0, 17, 0, insets, 0, 0));
        this.add((Component)((Object)this.basePanel), new GridBagConstraints(1, 2, 1, 1, 0.0, 0.0, 17, 2, insets2, 0, 0));
        this.add((Component)this.baseBrowse, new GridBagConstraints(2, 2, 1, 1, 0.0, 0.0, 17, 0, insets, 0, 0));
        insets.top = 8;
        this.add((Component)this.attrPanel, new GridBagConstraints(0, 3, 3, 1, 1.0, 1.0, 17, 1, insets, 0, 0));
    }

    public void initializeFromState(BaliWizardState baliWizardState) {
        ClassBuilderModel classBuilderModel;
        this.savedState = classBuilderModel = (ClassBuilderModel)baliWizardState;
        this.pkgPopup.setProject(classBuilderModel.getProject());
        this.basePanel.setProject(classBuilderModel.getProject());
        this.basePanel.setValidator(new ClassValidator(classBuilderModel, this.pkgPopup));
        this.basePanel.setEncoder(classBuilderModel);
        if (classBuilderModel.isSuperclassEditable()) {
            this.basePanel.setEditable(true);
        }
        this.clsField.setText(classBuilderModel.getClassName());
        this.pkgPopup.setText(classBuilderModel.getPackage());
        if (!classBuilderModel.hasAttributes()) {
            this.attrPanel.setVisible(false);
        }
        MutableComboBoxModel mutableComboBoxModel = classBuilderModel.getModel();
        Object object = mutableComboBoxModel.getSelectedItem();
        this.attrPanel.setModel(mutableComboBoxModel);
        this.basePanel.setModel(mutableComboBoxModel);
        mutableComboBoxModel.setSelectedItem(object);
        classBuilderModel.getBuilderDialog().setInitialFocus((Component)this.clsField);
    }

    public boolean validateAndWriteToState(BaliWizardState baliWizardState) {
        Object object;
        String string;
        String string2;
        ClassBuilderModel classBuilderModel = (ClassBuilderModel)baliWizardState;
        boolean bl = false;
        String string3 = this.pkgPopup.getText();
        if (string3 != null) {
            string3 = string3.trim();
        }
        if ((string2 = this.clsField.getText()) != null) {
            string2 = string2.trim();
        }
        if ((string = (object = this.basePanel.getSelectedItem()).toString()) != null && (string = string.trim()).length() == 0 && this.savedState.isObjectBaseClass()) {
            string = "java.lang.Object";
        }
        try {
            classBuilderModel.setPackage(string3);
            classBuilderModel.setClassName(string2);
            ClassValidator classValidator = (ClassValidator)this.basePanel.getValidator();
            if (classValidator != null && !classValidator.isResultValid(string)) {
                classBuilderModel.reportError(BuilderArb.getString(32), BuilderArb.format(33, string), null);
                this.basePanel.requestFocus();
                bl = false;
            } else {
                bl = this.attrPanel.validateAttributes();
            }
        }
        catch (ClassBuilderModel.IllegalPackageNameException illegalPackageNameException) {
            classBuilderModel.reportError(BuilderArb.getString(26), BuilderArb.format(27, string3, BuilderArb.getString(29)), "f1_idedclassnameinvalid_html");
            this.pkgPopup.requestFocus();
        }
        catch (ClassBuilderModel.IllegalClassNameException illegalClassNameException) {
            classBuilderModel.reportError(BuilderArb.getString(25), BuilderArb.format(27, this._getDisplayName(string2, false), BuilderArb.getString(28)), "f1_idedclassnameinvalid_html");
            this.clsField.requestFocus();
        }
        catch (ClassBuilderModel.DuplicateClassException duplicateClassException) {
            this.clsField.requestFocus();
        }
        catch (ClassBuilderModel.InvalidFileException invalidFileException) {
            classBuilderModel.reportError(BuilderArb.getString(19), BuilderArb.format(105, this._getDisplayName(invalidFileException.getPath(), true)), null);
        }
        catch (ClassBuilderModel.UserCancelledFileException userCancelledFileException) {
            this.clsField.requestFocus();
        }
        return bl;
    }

    private String _getDisplayName(String string, boolean bl) {
        String string2 = string;
        if (string.length() > FILENAME_DISPLAY_MAX_LENGTH) {
            string2 = bl ? BuilderArb.format(104, string.substring(0, FILENAME_DISPLAY_MAX_LENGTH / 2), string.substring(string.length() - FILENAME_DISPLAY_MAX_LENGTH / 2)) : BuilderArb.format(103, string.substring(0, FILENAME_DISPLAY_MAX_LENGTH));
        }
        return string2;
    }

    public final void setTopLabel(String string) {
        throw new UnsupportedOperationException("setTopLabel() no longer supported");
    }

    static ClassBuilderModel ra$savedState(ClassBuilderPanel classBuilderPanel) {
        return classBuilderPanel.savedState;
    }

    public static class ClassValidator
    implements AbstractPicker.PickerResultValidator {
        private ClassBuilderModel _model;
        private PackagePopup _packagePopup;

        public ClassValidator(ClassBuilderModel classBuilderModel, PackagePopup packagePopup) {
            this._model = classBuilderModel;
            this._packagePopup = packagePopup;
        }

        public boolean isResultValid(Object object) {
            String string;
            boolean bl = false;
            String string2 = this._packagePopup.getPackage();
            if (string2 == null) {
                string2 = "";
            }
            bl = object instanceof JavaClass ? this._model.validateClass((JavaClass)object, string2) : (string = object.toString()).length() > 0 && this._model.validateClassType(string, string2);
            return bl;
        }

        public String getInvalidValueMsg(Object object) {
            return BuilderArb.format(33, object.toString());
        }
    }

    private class DataFieldDocumentListener
    implements DocumentListener {
        public void changedUpdate(DocumentEvent documentEvent) {
            this.enableOK(documentEvent);
        }

        public void insertUpdate(DocumentEvent documentEvent) {
            this.enableOK(documentEvent);
        }

        public void removeUpdate(DocumentEvent documentEvent) {
            this.enableOK(documentEvent);
        }

        private void enableOK(DocumentEvent documentEvent) {
            Document document = documentEvent.getDocument();
            try {
                boolean bl = document.getText(0, document.getLength()).trim().length() > 0;
                ClassBuilderPanel.ra$savedState(ClassBuilderPanel.this).getBuilderDialog().setOKButtonEnabled(bl);
            }
            catch (BadLocationException badLocationException) {
                // empty catch block
            }
        }

        private DataFieldDocumentListener() {
        }

        DataFieldDocumentListener(1 var2_2) {
            this();
        }

        public final class 1 {
        }
    }
}

