/*
 * Decompiled with CFR 0.152.
 */
package oracle.jdeveloper.builder.cls;

import java.awt.Component;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import javax.swing.AbstractButton;
import javax.swing.JCheckBox;
import javax.swing.JComponent;
import javax.swing.JPanel;
import oracle.ide.util.ResourceUtils;
import oracle.javatools.parser.java.v2.model.SourceBlock;
import oracle.javatools.parser.java.v2.model.SourceClass;
import oracle.javatools.parser.java.v2.model.SourceFile;
import oracle.javatools.parser.java.v2.model.SourceMethod;
import oracle.jdeveloper.builder.cls.AbstractGenerator;
import oracle.jdeveloper.builder.resource.BuilderArb;
import oracle.jdeveloper.java.JavaManager;
import oracle.jdeveloper.java.legacy.JotNames;
import oracle.jdeveloper.java.util.SourceUtils;

public class ClassGenerator
extends AbstractGenerator {
    private JPanel attributes;
    private JCheckBox publicCheck;
    private JCheckBox mainCheck;
    private JCheckBox ctorCheck;

    void $init$() {
        this.attributes = null;
        this.publicCheck = null;
        this.mainCheck = null;
        this.ctorCheck = null;
    }

    public ClassGenerator() {
        this.$init$();
    }

    public JComponent getAttributes(String string) {
        if (this.attributes == null) {
            this.publicCheck = new JCheckBox();
            ResourceUtils.resButton((AbstractButton)this.publicCheck, (String)BuilderArb.getString(7));
            this.ctorCheck = new JCheckBox();
            ResourceUtils.resButton((AbstractButton)this.ctorCheck, (String)BuilderArb.getString(10));
            this.mainCheck = new JCheckBox();
            ResourceUtils.resButton((AbstractButton)this.mainCheck, (String)BuilderArb.getString(11));
            this.attributes = new JPanel();
            this.publicCheck.setSelected(true);
            this.ctorCheck.setSelected(true);
            this.mainCheck.setSelected(false);
            this.attributes.setLayout(new GridBagLayout());
            this.attributes.add((Component)this.publicCheck, new GridBagConstraints(0, 0, 1, 1, 1.0, 0.0, 18, 0, new Insets(2, 2, 2, 2), 0, 0));
            this.attributes.add((Component)this.ctorCheck, new GridBagConstraints(0, 1, 1, 1, 1.0, 0.0, 18, 0, new Insets(2, 2, 2, 2), 0, 0));
            this.attributes.add((Component)this.mainCheck, new GridBagConstraints(0, 2, 1, 1, 1.0, 0.0, 18, 0, new Insets(2, 2, 2, 2), 0, 0));
        }
        return this.attributes;
    }

    public void setEnabled(boolean bl) {
        ClassGenerator.enableTree(this.attributes, bl);
    }

    protected void addDetails(JavaManager javaManager, SourceFile sourceFile, SourceClass sourceClass) {
        if (this.isDefaultConstructor()) {
            SourceUtils.addConstructor(sourceClass, 1);
        }
        if (this.isMain()) {
            SourceMethod sourceMethod = SourceUtils.addMainMethod(sourceClass);
            String string = JotNames.getShortClassName(sourceClass.getName());
            String string2 = string.substring(0, 1).toLowerCase() + string.substring(1);
            String string3 = "new " + string + "()";
            SourceBlock sourceBlock = sourceMethod.getBlock();
            SourceUtils.addLocalVariableDeclaration(sourceBlock, string, string2, string3);
        }
        int n = sourceClass.getModifiers();
        if (this.isPublicClass()) {
            sourceClass.setModifiers(n | 1);
        } else {
            sourceClass.setModifiers(n & 0xFFFFFFFE);
        }
    }

    boolean isMain() {
        return this.mainCheck != null && this.mainCheck.isSelected();
    }

    boolean isDefaultConstructor() {
        return this.ctorCheck == null || this.ctorCheck.isSelected();
    }

    boolean isPublicClass() {
        return this.publicCheck == null || this.publicCheck.isSelected();
    }
}

