/*
 * Decompiled with CFR 0.152.
 */
package oracle.jdeveloper.builder.iface;

import java.awt.Component;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import javax.swing.AbstractButton;
import javax.swing.JButton;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JTextField;
import javax.swing.event.DocumentEvent;
import javax.swing.event.DocumentListener;
import javax.swing.text.BadLocationException;
import javax.swing.text.Document;
import oracle.ide.util.ResourceUtils;
import oracle.jdeveloper.builder.cls.ClassBuilderModel;
import oracle.jdeveloper.builder.iface.InterfaceBuilderModel;
import oracle.jdeveloper.builder.resource.BuilderArb;
import oracle.jdeveloper.common.OracleTextField;
import oracle.jdeveloper.controls.PackagePopup;
import oracle.jdeveloper.wizard.common.BaliWizardPanel;
import oracle.jdeveloper.wizard.common.BaliWizardState;

public final class InterfaceBuilderPanel
extends JPanel
implements BaliWizardPanel {
    protected GridBagLayout mainLayout;
    protected JLabel clsLabel;
    protected JTextField clsField;
    protected JLabel pkgLabel;
    protected PackagePopup pkgField;
    protected JButton pkgBrowse;
    private InterfaceBuilderModel savedState;
    private static int FILENAME_DISPLAY_MAX_LENGTH = 80;

    void $init$() {
        this.mainLayout = new GridBagLayout();
        this.clsLabel = new JLabel();
        this.clsField = new OracleTextField();
        this.pkgLabel = new JLabel();
        this.pkgField = new PackagePopup();
        this.pkgBrowse = new JButton();
    }

    public InterfaceBuilderPanel() {
        this.$init$();
        try {
            this.jbInit();
        }
        catch (Exception exception) {
            exception.printStackTrace();
        }
    }

    private void jbInit() throws Exception {
        ResourceUtils.resLabel((JLabel)this.clsLabel, (Component)this.clsField, (String)BuilderArb.getString(3));
        ResourceUtils.resLabel((JLabel)this.pkgLabel, (Component)this.pkgField, (String)BuilderArb.getString(4));
        ResourceUtils.resButton((AbstractButton)this.pkgBrowse, (String)BuilderArb.getString(8));
        this.clsField.getDocument().addDocumentListener(new DataFieldDocumentListener(null));
        this.pkgBrowse.addActionListener(this.pkgField);
        this.setLayout(this.mainLayout);
        Insets insets = new Insets(0, 0, 5, 0);
        Insets insets2 = new Insets(0, 8, 5, 8);
        this.add((Component)this.clsLabel, new GridBagConstraints(0, 0, 1, 1, 0.0, 0.0, 17, 0, insets, 0, 0));
        this.add((Component)this.clsField, new GridBagConstraints(1, 0, 1, 1, 0.5, 0.0, 17, 2, insets2, 0, 0));
        insets.bottom = 0;
        insets2.bottom = 0;
        this.add((Component)this.pkgLabel, new GridBagConstraints(0, 1, 1, 1, 0.0, 0.0, 17, 0, insets, 0, 0));
        this.add((Component)this.pkgField, new GridBagConstraints(1, 1, 1, 1, 1.0, 0.0, 10, 2, insets2, 0, 0));
        this.add((Component)this.pkgBrowse, new GridBagConstraints(2, 1, 1, 1, 0.0, 0.0, 10, 0, insets, 0, 0));
    }

    public void initializeFromState(BaliWizardState baliWizardState) {
        InterfaceBuilderModel interfaceBuilderModel;
        this.savedState = interfaceBuilderModel = (InterfaceBuilderModel)baliWizardState;
        this.pkgField.setProject(interfaceBuilderModel.getProject());
        this.clsField.setText(interfaceBuilderModel.getClassName());
        this.pkgField.setText(interfaceBuilderModel.getPackage());
        interfaceBuilderModel.getBuilderDialog().setInitialFocus((Component)this.clsField);
    }

    public boolean validateAndWriteToState(BaliWizardState baliWizardState) {
        String string;
        InterfaceBuilderModel interfaceBuilderModel = (InterfaceBuilderModel)baliWizardState;
        boolean bl = false;
        String string2 = this.pkgField.getText();
        if (string2 != null) {
            string2 = string2.trim();
        }
        if ((string = this.clsField.getText()) != null) {
            string = string.trim();
        }
        try {
            interfaceBuilderModel.setPackage(string2);
            interfaceBuilderModel.setClassName(string);
            bl = true;
        }
        catch (ClassBuilderModel.IllegalPackageNameException illegalPackageNameException) {
            interfaceBuilderModel.reportError(BuilderArb.getString(26), BuilderArb.format(27, string2, BuilderArb.getString(29)), "f1_idedclassnameinvalid_html");
            this.pkgField.requestFocus();
        }
        catch (ClassBuilderModel.IllegalClassNameException illegalClassNameException) {
            interfaceBuilderModel.reportError(BuilderArb.getString(109), BuilderArb.format(27, this._getDisplayName(string, false), BuilderArb.getString(110)), "f1_idedclassnameinvalid_html");
            this.clsField.requestFocus();
        }
        catch (ClassBuilderModel.DuplicateClassException duplicateClassException) {
            this.clsField.requestFocus();
        }
        catch (ClassBuilderModel.InvalidFileException invalidFileException) {
            interfaceBuilderModel.reportError(BuilderArb.getString(19), BuilderArb.format(105, this._getDisplayName(invalidFileException.getPath(), true)), null);
        }
        return bl;
    }

    private String _getDisplayName(String string, boolean bl) {
        String string2 = string;
        if (string.length() > FILENAME_DISPLAY_MAX_LENGTH) {
            string2 = bl ? BuilderArb.format(104, string.substring(0, FILENAME_DISPLAY_MAX_LENGTH / 2), string.substring(string.length() - FILENAME_DISPLAY_MAX_LENGTH / 2)) : BuilderArb.format(103, string.substring(0, FILENAME_DISPLAY_MAX_LENGTH));
        }
        return string2;
    }

    static InterfaceBuilderModel ra$savedState(InterfaceBuilderPanel interfaceBuilderPanel) {
        return interfaceBuilderPanel.savedState;
    }

    private class DataFieldDocumentListener
    implements DocumentListener {
        public void changedUpdate(DocumentEvent documentEvent) {
            this.enableOK(documentEvent);
        }

        public void insertUpdate(DocumentEvent documentEvent) {
            this.enableOK(documentEvent);
        }

        public void removeUpdate(DocumentEvent documentEvent) {
            this.enableOK(documentEvent);
        }

        private void enableOK(DocumentEvent documentEvent) {
            Document document = documentEvent.getDocument();
            try {
                boolean bl = document.getText(0, document.getLength()).trim().length() > 0;
                InterfaceBuilderPanel.ra$savedState(InterfaceBuilderPanel.this).getBuilderDialog().setOKButtonEnabled(bl);
            }
            catch (BadLocationException badLocationException) {
                // empty catch block
            }
        }

        private DataFieldDocumentListener() {
        }

        DataFieldDocumentListener(1 var2_2) {
            this();
        }

        public final class 1 {
        }
    }
}

