/*
 * Decompiled with CFR 0.152.
 */
package oracle.jdeveloper.builder.ui;

import java.util.List;
import java.util.Set;
import oracle.ide.Ide;
import oracle.ide.util.FastStringBuffer;
import oracle.javatools.parser.java.v2.model.JavaType;
import oracle.javatools.parser.java.v2.model.SourceBlock;
import oracle.javatools.parser.java.v2.model.SourceClass;
import oracle.javatools.parser.java.v2.model.SourceElement;
import oracle.javatools.parser.java.v2.model.SourceFieldDeclaration;
import oracle.javatools.parser.java.v2.model.SourceFile;
import oracle.javatools.parser.java.v2.model.SourceMember;
import oracle.javatools.parser.java.v2.model.SourceMethod;
import oracle.javatools.parser.java.v2.model.expression.SourceAssignmentExpression;
import oracle.javatools.parser.java.v2.model.expression.SourceExpression;
import oracle.javatools.parser.java.v2.model.expression.SourceMethodCallExpression;
import oracle.jdeveloper.builder.cls.AbstractGenerator;
import oracle.jdeveloper.java.JavaManager;
import oracle.jdeveloper.java.legacy.JotNames;
import oracle.jdeveloper.java.util.SourceUtils;
import oracle.jdeveloper.uieditor.UIEditorOptions;

public class UIGenerator
extends AbstractGenerator {
    private JavaManager _mgr;
    private SourceFile _file;
    private SourceClass _cls;
    private SourceMethod _init;
    private int _mods;
    private SourceElement _lastAssign;
    private SourceElement _lastPropertySet;

    protected final void addDetails(JavaManager javaManager, SourceFile sourceFile, SourceClass sourceClass) {
        this._mgr = javaManager;
        this._file = sourceFile;
        this._cls = sourceClass;
        UIEditorOptions uIEditorOptions = (UIEditorOptions)Ide.getSettings().getData("UIEditorOptions");
        if (uIEditorOptions != null) {
            switch (uIEditorOptions.getDefaultMemberScope()) {
                case 0: {
                    this._mods = 1;
                    break;
                }
                case 3: {
                    this._mods = 2;
                    break;
                }
                case 1: {
                    this._mods = 4;
                    break;
                }
                default: {
                    this._mods = 0;
                }
            }
        }
        this._init = sourceClass.getSourceMethod("jbInit", new JavaType[0]);
        SourceBlock sourceBlock = this._init.getBlock();
        for (SourceElement sourceElement : sourceBlock.getCodeElements()) {
            if (sourceElement instanceof SourceAssignmentExpression) {
                this._lastAssign = sourceElement;
                continue;
            }
            if (!(sourceElement instanceof SourceMethodCallExpression) || this._isAddCall((SourceExpression)sourceElement)) continue;
            this._lastPropertySet = sourceElement;
        }
        this.addImports();
        this.addInterfaces();
        this.addFields();
        this.setProperties();
        this.addComponents();
        this.addMethods();
        this.addOther();
    }

    protected void addImports() {
    }

    protected void addInterfaces() {
    }

    protected void addFields() {
    }

    protected void setProperties() {
    }

    protected void addComponents() {
    }

    protected void addMethods() {
    }

    protected void addOther() {
    }

    protected final JavaManager getJavaManager() {
        return this._mgr;
    }

    protected final SourceFile getSourceFile() {
        return this._file;
    }

    protected final SourceClass getSourceClass() {
        return this._cls;
    }

    protected final SourceMethod getInitMethod() {
        return this._init;
    }

    protected final void addImport(String string) {
        Set set = this._file.getSourceImportNames();
        if (!set.contains(string)) {
            String string2 = JotNames.getPackageFromFullClassName(string);
            String string3 = JotNames.getShortClassName(string);
            if (string2.length() > 0) {
                String string4 = string2 + ".*";
                if (string3.equals("*") || !set.contains(string4)) {
                    SourceUtils.addImport(this._file, string);
                }
            }
        }
    }

    protected final void addInterface(String string) {
        this._cls.getSourceInterfaces().add(this._file.getFactory().createType(string));
    }

    protected final SourceFieldDeclaration addField(String string, String string2, String string3) {
        SourceFieldDeclaration sourceFieldDeclaration = SourceUtils.createField(this._cls, string, string2, this._mods, string3);
        List list = this._cls.getSourceFieldDeclarations();
        if (list.size() == 0) {
            this._cls.getSourceMembers().add(0, sourceFieldDeclaration);
        } else {
            SourceFieldDeclaration sourceFieldDeclaration2 = (SourceFieldDeclaration)list.get(list.size() - 1);
            SourceUtils.addMember(this._cls, (SourceMember)sourceFieldDeclaration, (SourceMember)sourceFieldDeclaration2, false);
        }
        return sourceFieldDeclaration;
    }

    protected final SourceFieldDeclaration addField(String string, String string2, boolean bl) {
        String string3 = bl ? "new " + string + "()" : null;
        return this.addField(string, string2, string3);
    }

    protected final void addAssignment(String string, String string2) {
        SourceBlock sourceBlock = this._init.getBlock();
        SourceExpression sourceExpression = SourceUtils.createAssign(sourceBlock, string, string2);
        this._lastAssign = SourceUtils.addExpressionStatement(sourceBlock, sourceExpression, this._lastAssign, false);
    }

    protected final void addProperty(String string, String string2) {
        SourceBlock sourceBlock = this._init.getBlock();
        FastStringBuffer fastStringBuffer = new FastStringBuffer();
        fastStringBuffer.append(string);
        fastStringBuffer.append("( ");
        fastStringBuffer.append(string2);
        fastStringBuffer.append(" )");
        this._lastPropertySet = SourceUtils.addExpressionStatement(sourceBlock, fastStringBuffer.toString(), this._lastPropertySet, false);
    }

    protected final void addComponent(String string, String string2) {
        SourceBlock sourceBlock = this._init.getBlock();
        FastStringBuffer fastStringBuffer = new FastStringBuffer();
        fastStringBuffer.append(string);
        fastStringBuffer.append("( ");
        fastStringBuffer.append(string2);
        fastStringBuffer.append(" )");
        SourceUtils.addExpressionStatement(sourceBlock, fastStringBuffer.toString());
    }

    protected final String generateActionListener(String string) {
        FastStringBuffer fastStringBuffer = new FastStringBuffer();
        fastStringBuffer.append("new ActionListener() { public void actionPerformed( ActionEvent ae ) { ");
        fastStringBuffer.append(string);
        fastStringBuffer.append("_ActionPerformed( ae ); } }");
        return fastStringBuffer.toString();
    }

    protected final void clearInitMethod() {
        SourceBlock sourceBlock = this._init.getBlock();
        sourceBlock.getCodeElements().clear();
        this._lastAssign = null;
        this._lastPropertySet = null;
    }

    private boolean _isAddCall(SourceExpression sourceExpression) {
        if (sourceExpression instanceof SourceMethodCallExpression) {
            SourceMethodCallExpression sourceMethodCallExpression = (SourceMethodCallExpression)sourceExpression;
            String string = sourceMethodCallExpression.getName();
            if (string.equals("add")) {
                return true;
            }
            SourceExpression sourceExpression2 = sourceMethodCallExpression.getLhsOperand();
            if (sourceExpression2 != null) {
                return this._isAddCall(sourceExpression2);
            }
        }
        return false;
    }
}

