/*
 * Decompiled with CFR 0.152.
 */
package oracle.jdeveloper.builder.ui.frame;

import javax.swing.JComponent;
import oracle.javatools.parser.java.v2.SourceFactory;
import oracle.javatools.parser.java.v2.model.SourceBlock;
import oracle.javatools.parser.java.v2.model.SourceClass;
import oracle.javatools.parser.java.v2.model.SourceElement;
import oracle.javatools.parser.java.v2.model.SourceFile;
import oracle.javatools.parser.java.v2.model.SourceMethod;
import oracle.jdeveloper.builder.resource.BuilderArb;
import oracle.jdeveloper.builder.ui.UIGenerator;
import oracle.jdeveloper.builder.ui.frame.AboutBoxDialogModel;
import oracle.jdeveloper.builder.ui.frame.FrameAttributePanel;
import oracle.jdeveloper.java.legacy.JotNames;
import oracle.jdeveloper.java.util.SourceUtils;

public class FrameGenerator
extends UIGenerator {
    private FrameAttributePanel panel;

    protected void addFields() {
        if (this._isMenuBar()) {
            this.addField("MenuBar", "menuBar", true);
            this.addField("Menu", "menuFile", true);
            this.addField("MenuItem", "menuFileExit", true);
            if (this._isAboutBox()) {
                this.addField("Menu", "menuHelp", true);
                this.addField("MenuItem", "menuHelpAbout", true);
            }
        }
    }

    protected void setProperties() {
        if (this._isMenuBar()) {
            this.addProperty("this.setMenuBar", "menuBar");
        }
        this.addProperty("this.setLayout", "null");
        this.addProperty("this.setSize", "new Dimension( 400, 300 )");
        String string = this._getTitleString();
        if (string.length() > 0) {
            this.addProperty("this.setTitle", string);
        }
        this.addProperty("this.setBackground", "SystemColor.control");
        if (this._isMenuBar()) {
            this.addProperty("menuFile.setLabel", "\"" + BuilderArb.getString(59) + "\"");
            this.addProperty("menuFileExit.setLabel", "\"" + BuilderArb.getString(60) + "\"");
            this.addProperty("menuFileExit.addActionListener", this.generateActionListener("fileExit"));
            if (this._isAboutBox()) {
                this.addProperty("menuHelp.setLabel", "\"" + BuilderArb.getString(61) + "\"");
                this.addProperty("menuHelpAbout.setLabel", "\"" + BuilderArb.getString(62) + "\"");
                this.addProperty("menuHelpAbout.addActionListener", this.generateActionListener("helpAbout"));
            }
        }
    }

    protected void addComponents() {
        if (this._isMenuBar()) {
            this.addComponent("menuFile.add", "menuFileExit");
            this.addComponent("menuBar.add", "menuFile");
            if (this._isAboutBox()) {
                this.addComponent("menuHelp.add", "menuHelpAbout");
                this.addComponent("menuBar.add", "menuHelp");
            }
        }
    }

    protected void addMethods() {
        String string;
        String string2 = string = this._isAboutBox() ? this.generateAboutBox() : "";
        if (this._isMenuBar()) {
            SourceClass sourceClass = this.getSourceClass();
            SourceMethod sourceMethod = SourceUtils.addMethod(sourceClass, "void", "fileExit_ActionPerformed", 0);
            SourceUtils.addMethodParameter(sourceMethod, "ActionEvent", "e");
            SourceBlock sourceBlock = sourceMethod.getBlock();
            SourceUtils.addExpressionStatement(sourceBlock, "System.exit(0)");
            if (this._isAboutBox()) {
                SourceMethod sourceMethod2 = SourceUtils.addMethod(sourceClass, "void", "helpAbout_ActionPerformed", 0);
                SourceUtils.addMethodParameter(sourceMethod2, "ActionEvent", "e");
                SourceBlock sourceBlock2 = sourceMethod2.getBlock();
                this._addAboutBoxInvocationCode(sourceBlock2, string);
            }
        }
    }

    private String generateAboutBox() {
        SourceClass sourceClass = this.getSourceClass();
        SourceFile sourceFile = this.getSourceFile();
        String string = sourceClass.getName();
        string = JotNames.getShortClassName(string);
        AboutBoxDialogModel aboutBoxDialogModel = new AboutBoxDialogModel(this.getContext());
        aboutBoxDialogModel.initializeModel(sourceFile.getPackageName(), string);
        aboutBoxDialogModel.commitWizardState();
        return aboutBoxDialogModel.getClassName();
    }

    private void _addAboutBoxInvocationCode(SourceBlock sourceBlock, String string) {
        SourceUtils.addLocalVariableDeclaration(sourceBlock, "Dialog", "dlg", "new " + string + "(this, \"" + BuilderArb.getString(62) + "\", true)");
        SourceUtils.addExpressionStatement(sourceBlock, "dlg.pack()");
        SourceUtils.addLocalVariableDeclaration(sourceBlock, "Dimension", "d", "dlg.getSize() ");
        SourceUtils.addLocalVariableDeclaration(sourceBlock, "Dimension", "screen", "Toolkit.getDefaultToolkit().getScreenSize()");
        SourceFactory sourceFactory = SourceUtils.getFactory((SourceElement)sourceBlock);
        SourceBlock sourceBlock2 = sourceFactory.createBlock();
        SourceUtils.addIfStatement(sourceBlock, "d.height > screen.height", sourceBlock2);
        SourceUtils.addExpressionStatement(sourceBlock2, "d.height = screen.height");
        SourceBlock sourceBlock3 = sourceFactory.createBlock();
        SourceUtils.addIfStatement(sourceBlock, "d.width > screen.width", sourceBlock3);
        SourceUtils.addExpressionStatement(sourceBlock3, "d.width = screen.width");
        String[] stringArray = new String[]{"(screen.width - d.width)/2", "(screen.height - d.height)/2"};
        SourceUtils.addMethodCallStatement(sourceBlock, "dlg", "setLocation", stringArray);
        String[] stringArray2 = new String[]{"true"};
        SourceUtils.addMethodCallStatement(sourceBlock, "dlg", "setVisible", stringArray2);
    }

    protected void addImports() {
        boolean bl;
        boolean bl2 = this._isMenuBar();
        boolean bl3 = bl = bl2 && this._isAboutBox();
        if (bl) {
            this.addImport("java.awt.Dialog");
        }
        this.addImport("java.awt.Dimension");
        if (bl2) {
            this.addImport("java.awt.Menu");
            this.addImport("java.awt.MenuBar");
            this.addImport("java.awt.MenuItem");
        }
        this.addImport("java.awt.SystemColor");
        if (bl) {
            this.addImport("java.awt.Toolkit");
        }
        if (bl2) {
            this.addImport("java.awt.event.ActionEvent");
            this.addImport("java.awt.event.ActionListener");
        }
    }

    public JComponent getAttributes(String string) {
        if (this.panel == null) {
            this.panel = new FrameAttributePanel();
        }
        return this.panel;
    }

    public void setEnabled(boolean bl) {
        if (this.panel != null) {
            FrameGenerator.enableTree(this.panel, bl);
        }
    }

    private boolean _isMenuBar() {
        return this.panel != null && this.panel.isMenuBarSelected();
    }

    private boolean _isAboutBox() {
        return this.panel != null && this.panel.isAboutBoxSelected();
    }

    private String _getTitleString() {
        String string = "";
        if (this.panel != null) {
            string = this.escapeString(this.panel.getTitle());
        }
        return string;
    }
}

