/*
 * Decompiled with CFR 0.152.
 */
package oracle.jdeveloper.builder.ui.frame;

import java.io.IOException;
import java.net.URL;
import javax.swing.JComponent;
import oracle.ide.Context;
import oracle.ide.model.Node;
import oracle.ide.model.NodeFactory;
import oracle.ide.model.Project;
import oracle.ide.net.URLFactory;
import oracle.ide.net.URLFileSystem;
import oracle.javatools.parser.java.v2.model.SourceBlock;
import oracle.javatools.parser.java.v2.model.SourceClass;
import oracle.javatools.parser.java.v2.model.SourceFile;
import oracle.javatools.parser.java.v2.model.SourceMethod;
import oracle.jdeveloper.builder.SourceModel;
import oracle.jdeveloper.builder.resource.BuilderArb;
import oracle.jdeveloper.builder.ui.UIGenerator;
import oracle.jdeveloper.builder.ui.frame.JFrameAttributePanel;
import oracle.jdeveloper.builder.ui.panel.PanelBuilderModel;
import oracle.jdeveloper.java.legacy.JotNames;
import oracle.jdeveloper.java.util.SourceUtils;

public class JFrameGenerator
extends UIGenerator {
    private JFrameAttributePanel _panel;
    static final String OPEN_GIF_FILE = "openfile.gif";
    static final String CLOSE_GIF_FILE = "closefile.gif";
    static final String HELP_GIF_FILE = "help.gif";

    protected void addImports() {
        if (this._isStatusBar() || this._isButtonBar()) {
            this.addImport("java.awt.BorderLayout");
            this.addImport("javax.swing.JPanel");
        }
        if (this._isStatusBar()) {
            this.addImport("javax.swing.JLabel");
        }
        if (this._isButtonBar()) {
            this.addImport("javax.swing.ImageIcon");
            this.addImport("javax.swing.JButton");
            this.addImport("javax.swing.JToolBar");
        }
        if (this._isMenuBar()) {
            this.addImport("javax.swing.JMenu");
            this.addImport("javax.swing.JMenuBar");
            this.addImport("javax.swing.JMenuItem");
        }
        this.addImport("java.awt.Dimension");
        if (this._isAboutBox() || this._isMenuBar()) {
            this.addImport("java.awt.event.ActionEvent");
            this.addImport("java.awt.event.ActionListener");
        }
        if (this._isAboutBox()) {
            this.addImport("javax.swing.JOptionPane");
        }
    }

    protected void addFields() {
        if (this._isStatusBar() || this._isButtonBar()) {
            this.addField("BorderLayout", "layoutMain", true);
            this.addField("JPanel", "panelCenter", true);
        }
        if (this._isMenuBar()) {
            this.addField("JMenuBar", "menuBar", true);
            this.addField("JMenu", "menuFile", true);
            this.addField("JMenuItem", "menuFileExit", true);
            if (this._isAboutBox()) {
                this.addField("JMenu", "menuHelp", true);
                this.addField("JMenuItem", "menuHelpAbout", true);
            }
        }
        if (this._isStatusBar()) {
            this.addField("JLabel", "statusBar", true);
        }
        if (this._isButtonBar()) {
            this.addField("JToolBar", "toolBar", true);
            this.addField("JButton", "buttonOpen", true);
            this.addField("JButton", "buttonClose", true);
            this.addField("JButton", "buttonHelp", true);
            this.addField("ImageIcon", "imageOpen", "new ImageIcon(" + this.getClassName() + ".class.getResource(\"" + OPEN_GIF_FILE + "\"))");
            this.addField("ImageIcon", "imageClose", "new ImageIcon(" + this.getClassName() + ".class.getResource(\"" + CLOSE_GIF_FILE + "\"))");
            this.addField("ImageIcon", "imageHelp", "new ImageIcon(" + this.getClassName() + ".class.getResource(\"" + HELP_GIF_FILE + "\"))");
        }
    }

    protected void setProperties() {
        if (this._isMenuBar()) {
            this.addProperty("this.setJMenuBar", "menuBar");
        }
        if (this._isButtonBar() || this._isStatusBar()) {
            this.addProperty("this.getContentPane().setLayout", "layoutMain");
            this.addProperty("panelCenter.setLayout", "null");
        } else {
            this.addProperty("this.getContentPane().setLayout", "null");
        }
        this.addProperty("this.setSize", "new Dimension(400, 300)");
        String string = this._getTitleString();
        if (string.length() > 0) {
            this.addProperty("this.setTitle", string);
        }
        if (this._isMenuBar()) {
            this.addProperty("menuFile.setText", "\"" + BuilderArb.getString(59) + "\"");
            this.addProperty("menuFileExit.setText", "\"" + BuilderArb.getString(60) + "\"");
            this.addProperty("menuFileExit.addActionListener", this.generateActionListener("fileExit"));
            if (this._isAboutBox()) {
                this.addProperty("menuHelp.setText", "\"" + BuilderArb.getString(61) + "\"");
                this.addProperty("menuHelpAbout.setText", "\"" + BuilderArb.getString(62) + "\"");
                this.addProperty("menuHelpAbout.addActionListener", this.generateActionListener("helpAbout"));
            }
        }
        if (this._isStatusBar()) {
            this.addProperty("statusBar.setText", "\"\"");
        }
        if (this._isButtonBar()) {
            this.addProperty("buttonOpen.setToolTipText", "\"Open File\"");
            this.addProperty("buttonOpen.setIcon", "imageOpen");
            this.addProperty("buttonClose.setToolTipText", "\"Close File\"");
            this.addProperty("buttonClose.setIcon", "imageClose");
            this.addProperty("buttonHelp.setToolTipText", "\"About\"");
            this.addProperty("buttonHelp.setIcon", "imageHelp");
        }
    }

    protected void addComponents() {
        if (this._isMenuBar()) {
            this.addComponent("menuFile.add", "menuFileExit");
            this.addComponent("menuBar.add", "menuFile");
            if (this._isAboutBox()) {
                this.addComponent("menuHelp.add", "menuHelpAbout");
                this.addComponent("menuBar.add", "menuHelp");
            }
        }
        if (this._isStatusBar()) {
            this.addComponent("this.getContentPane().add", "statusBar, BorderLayout.SOUTH");
        }
        if (this._isButtonBar()) {
            this.addComponent("toolBar.add", "buttonOpen");
            this.addComponent("toolBar.add", "buttonClose");
            this.addComponent("toolBar.add", "buttonHelp");
            this.addComponent("this.getContentPane().add", "toolBar, BorderLayout.NORTH");
        }
        if (this._isButtonBar() || this._isStatusBar()) {
            this.addComponent("this.getContentPane().add", "panelCenter, BorderLayout.CENTER");
        }
    }

    protected void addMethods() {
        String string;
        String string2 = string = this._isAboutBox() ? this.generateAboutBox() : null;
        if (this._isMenuBar()) {
            SourceClass sourceClass = this.getSourceClass();
            SourceMethod sourceMethod = SourceUtils.addMethod(sourceClass, "void", "fileExit_ActionPerformed", 0);
            SourceUtils.addMethodParameter(sourceMethod, "ActionEvent", "e");
            SourceBlock sourceBlock = sourceMethod.getBlock();
            SourceUtils.addExpressionStatement(sourceBlock, "System.exit(0)");
            if (string != null) {
                SourceMethod sourceMethod2 = SourceUtils.addMethod(sourceClass, "void", "helpAbout_ActionPerformed", 0);
                SourceUtils.addMethodParameter(sourceMethod2, "ActionEvent", "e");
                SourceBlock sourceBlock2 = sourceMethod2.getBlock();
                this._addAboutBoxInvocationCode(sourceBlock2, string);
            }
        }
    }

    protected void addOther() {
        if (this._isButtonBar()) {
            SourceFile sourceFile = this.getSourceFile();
            URL uRL = sourceFile.getURL();
            URL uRL2 = URLFileSystem.getParent((URL)uRL);
            this.copyImage(CLOSE_GIF_FILE, uRL2);
            this.copyImage(OPEN_GIF_FILE, uRL2);
            this.copyImage(HELP_GIF_FILE, uRL2);
        }
    }

    private String getClassName() {
        SourceClass sourceClass = this.getSourceClass();
        String string = sourceClass.getName();
        return JotNames.getShortClassName(string);
    }

    private String generateAboutBox() {
        SourceFile sourceFile = this.getSourceFile();
        AboutBoxJPanelModel aboutBoxJPanelModel = new AboutBoxJPanelModel(this.getContext());
        aboutBoxJPanelModel.initializeModel(sourceFile.getPackageName(), this.getClassName());
        aboutBoxJPanelModel.commitWizardState();
        return aboutBoxJPanelModel.getClassName();
    }

    private void _addAboutBoxInvocationCode(SourceBlock sourceBlock, String string) {
        String[] stringArray = new String[]{"this", "new " + string + "()", "\"" + BuilderArb.getString(62) + "\"", "JOptionPane.PLAIN_MESSAGE"};
        SourceUtils.addMethodCallStatement(sourceBlock, "JOptionPane", "showMessageDialog", stringArray);
    }

    public JComponent getAttributes(String string) {
        if (this._panel == null) {
            this._panel = new JFrameAttributePanel();
        }
        return this._panel;
    }

    public void setEnabled(boolean bl) {
        if (this._panel != null) {
            JFrameGenerator.enableTree(this._panel, bl);
        }
    }

    private boolean _isMenuBar() {
        return this._panel != null && this._panel.isMenuBarSelected();
    }

    private boolean _isAboutBox() {
        return this._panel != null && this._panel.isAboutBoxSelected();
    }

    private boolean _isStatusBar() {
        return this._panel != null && this._panel.isStatusBarSelected();
    }

    private boolean _isButtonBar() {
        return this._panel != null && this._panel.isButtonBarSelected();
    }

    private String _getTitleString() {
        String string = "";
        if (this._panel != null) {
            string = this.escapeString(this._panel.getTitle());
        }
        return string;
    }

    private void copyImage(String string, URL uRL) {
        URL uRL2;
        Class<BuilderArb> clazz = BuilderArb.class;
        URL uRL3 = clazz.getResource("image/" + string);
        if (uRL3 != null && (uRL2 = URLFactory.newURL((URL)uRL, (String)string)) != null && !URLFileSystem.exists((URL)uRL2)) {
            try {
                URLFileSystem.copy((URL)uRL3, (URL)uRL2);
                Node node = NodeFactory.findOrCreate((URL)uRL2);
                if (node != null) {
                    Project project = this.getProject();
                    project.add(node, "oracle.ide.model.ResourcePaths/resourcesContentSet");
                }
            }
            catch (IOException iOException) {
            }
            catch (IllegalAccessException illegalAccessException) {
            }
            catch (InstantiationException instantiationException) {
                // empty catch block
            }
        }
    }

    private static class AboutBoxJPanelModel
    extends PanelBuilderModel {
        public AboutBoxJPanelModel(Context context) {
            super(context);
        }

        protected String getDefaultBaseClass() {
            return "javax.swing.JPanel";
        }

        public String getBuilderType() {
            return "jframeaboutbox";
        }

        public void initializeModel(String string, String string2) {
            this.setPackage(string);
            String string3 = BuilderArb.format(71, string2);
            SourceModel sourceModel = this.getSourceModel();
            sourceModel.generateDefaultFileName(string3);
        }
    }
}

