/*
 * Decompiled with CFR 0.152.
 */
package oracle.jdeveloper.builder.ui.frame;

import java.awt.Component;
import javax.swing.MutableComboBoxModel;
import oracle.ide.Context;
import oracle.ide.Ide;
import oracle.ide.dialogs.MessageDialog;
import oracle.ide.model.Project;
import oracle.javatools.parser.java.v2.model.JavaClass;
import oracle.javatools.parser.java.v2.model.JavaType;
import oracle.jdeveloper.builder.cls.ClassBuilderModel;
import oracle.jdeveloper.builder.cls.GeneratorElement;
import oracle.jdeveloper.builder.resource.BuilderArb;
import oracle.jdeveloper.builder.ui.frame.FrameBuilderModel;
import oracle.jdeveloper.java.JavaManager;

public class TopLevelFrameBuilderModel
extends FrameBuilderModel {
    private String _reservedClassName;
    private static final String[] BASE_CLASSES = new String[]{"java.awt.Frame", "javax.swing.JFrame"};

    public TopLevelFrameBuilderModel(Context context) {
        super(context);
        Project project = this.getProject();
        JavaManager javaManager = JavaManager.getJavaManager(project);
        JavaClass javaClass = javaManager.getClass("java.awt.Frame");
        if (javaClass != null) {
            MutableComboBoxModel mutableComboBoxModel = this.getModel();
            int n = mutableComboBoxModel.getSize() - 1;
            while (n >= 0) {
                GeneratorElement generatorElement = (GeneratorElement)mutableComboBoxModel.getElementAt(n);
                JavaClass javaClass2 = javaManager.getClass(generatorElement.getClassName());
                if (!javaClass.isAssignableFrom((JavaType)javaClass2)) {
                    mutableComboBoxModel.removeElementAt(n);
                }
                --n;
            }
        }
    }

    protected String[] getDefaultBaseClasses() {
        return BASE_CLASSES;
    }

    protected String getDefaultBaseClass() {
        return BASE_CLASSES[1];
    }

    protected void setReservedClassName(String string) {
        this._reservedClassName = string;
    }

    protected void validateClassNameIsUnique() {
        if (this.getQualifiedClassName().equals(this._reservedClassName)) {
            MessageDialog.error((Component)(this.getPanel() != null ? this.getPanel() : Ide.getMainWindow()), (Object)BuilderArb.format(37, this.getClassName()), (String)BuilderArb.getString(36), null);
            throw new ClassBuilderModel.DuplicateClassException();
        }
    }
}

