/*
 * Decompiled with CFR 0.152.
 */
package oracle.jdeveloper.builder.ui.panel;

import oracle.ide.Context;
import oracle.javatools.parser.java.v2.model.JavaType;
import oracle.javatools.parser.java.v2.model.SourceBlock;
import oracle.javatools.parser.java.v2.model.SourceClass;
import oracle.javatools.parser.java.v2.model.SourceFile;
import oracle.javatools.parser.java.v2.model.SourceMethod;
import oracle.jdeveloper.builder.resource.BuilderArb;
import oracle.jdeveloper.builder.ui.UIBuilderModel;
import oracle.jdeveloper.java.util.SourceUtils;

public class PanelBuilderModel
extends UIBuilderModel {
    private static final String[] BASE_CLASSES = new String[]{"java.awt.Panel", "javax.swing.JPanel"};

    public PanelBuilderModel(Context context) {
        super(context);
    }

    protected String getDefaultBaseClass() {
        return BASE_CLASSES[1];
    }

    protected String[] getDefaultBaseClasses() {
        return BASE_CLASSES;
    }

    public String getBuilderType() {
        return "Panel";
    }

    protected String getBaseName() {
        return BuilderArb.getString(55);
    }

    protected void generate(SourceFile sourceFile, SourceClass sourceClass) {
        super.generate(sourceFile, sourceClass);
        JavaType javaType = sourceClass != null ? sourceClass.getSuperclass() : null;
        String string = javaType != null ? javaType.getQualifiedName() : null;
        String[] stringArray = this.getDefaultBaseClasses();
        int n = 0;
        while (n < stringArray.length) {
            if (stringArray[n].equals(string)) {
                SourceMethod sourceMethod = sourceClass.getSourceMethod("jbInit", new JavaType[0]);
                if (sourceMethod == null) break;
                SourceBlock sourceBlock = sourceMethod.getBlock();
                SourceUtils.addExpressionStatement(sourceBlock, "this.setLayout( null )");
                break;
            }
            ++n;
        }
    }
}

