/*
 * Decompiled with CFR 0.152.
 */
package oracle.jdeveloper.ceditor.template;

import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.FlowLayout;
import java.awt.Font;
import java.awt.Rectangle;
import java.awt.Toolkit;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.FocusEvent;
import java.awt.event.FocusListener;
import java.util.List;
import javax.swing.AbstractButton;
import javax.swing.DefaultCellEditor;
import javax.swing.JButton;
import javax.swing.JComboBox;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTabbedPane;
import javax.swing.JTable;
import javax.swing.JTextArea;
import javax.swing.ListSelectionModel;
import javax.swing.UIManager;
import javax.swing.event.DocumentEvent;
import javax.swing.event.DocumentListener;
import javax.swing.event.ListSelectionEvent;
import javax.swing.event.ListSelectionListener;
import javax.swing.table.TableCellEditor;
import javax.swing.table.TableColumn;
import javax.swing.text.AttributeSet;
import javax.swing.text.BadLocationException;
import javax.swing.text.DefaultHighlighter;
import javax.swing.text.Document;
import javax.swing.text.Highlighter;
import javax.swing.text.PlainDocument;
import oracle.ide.Addin;
import oracle.ide.AddinManager;
import oracle.ide.ceditor.CodeEditorAddin;
import oracle.ide.controls.CustomJSplitPane;
import oracle.ide.panels.ApplyEvent;
import oracle.ide.panels.ApplyListener;
import oracle.ide.panels.Navigable;
import oracle.ide.panels.Traversable;
import oracle.ide.panels.TraversableContext;
import oracle.ide.panels.TraversalException;
import oracle.ide.util.ResourceUtils;
import oracle.jdeveloper.ceditor.template.Template;
import oracle.jdeveloper.ceditor.template.TemplateArb;
import oracle.jdeveloper.ceditor.template.TemplateCellRenderer;
import oracle.jdeveloper.ceditor.template.TemplateConfigModel;
import oracle.jdeveloper.ceditor.template.TemplateOptions;
import oracle.jdeveloper.ceditor.template.Templates;
import oracle.jdeveloper.ceditor.template.VariableDataModel;

public final class ConfigPanel
extends JPanel
implements FocusListener,
DocumentListener,
ActionListener,
ListSelectionListener,
ApplyListener,
Traversable {
    private TemplateConfigModel _dataModel;
    private VariableDataModel _variableDataModel;
    private JTable _templateTable;
    private JTable _variableTable;
    private static int _currentRow;
    private JTextArea _text;
    private JTextArea _imports;
    private JButton _butAdd;
    private JButton _butDel;
    private boolean _bValuesChanging;
    private static final Highlighter.HighlightPainter myHighlightPainter;

    static void registerUI() {
        String string = TemplateArb.getString(0);
        Navigable navigable = new Navigable(string, ConfigPanel.class);
        AddinManager addinManager = AddinManager.getAddinManager();
        Addin addin = addinManager.getAddin(CodeEditorAddin.class);
        if (addin != null) {
            CodeEditorAddin codeEditorAddin = (CodeEditorAddin)addin;
            Navigable navigable2 = codeEditorAddin.getEditorNavigable();
            navigable2.addChildNavigable(navigable);
        }
    }

    public ConfigPanel() {
        try {
            this.init();
        }
        catch (Exception exception) {
            exception.printStackTrace();
        }
    }

    private void init() throws Exception {
        this.setLayout(new BorderLayout());
        this._dataModel = new TemplateConfigModel(this);
        this._templateTable = new JTable(this._dataModel);
        this._variableDataModel = new VariableDataModel(null);
        this._variableTable = new JTable(this._variableDataModel);
        TableColumn tableColumn = this._variableTable.getColumnModel().getColumn(1);
        JComboBox<String> jComboBox = new JComboBox<String>();
        jComboBox.addItem("default");
        jComboBox.addItem("smartIndex");
        jComboBox.addItem("curMethod");
        jComboBox.addItem("suggestNameFromType()");
        jComboBox.addItem("typeOf()");
        jComboBox.addItem("elementTypeOf()");
        jComboBox.addItem("smartCollectionContent()");
        jComboBox.addItem("smartListContent()");
        jComboBox.addItem("smartMapValues()");
        jComboBox.addItem("smartMapKeys()");
        jComboBox.addItem("varOfType()");
        jComboBox.addItem("copyOf()");
        jComboBox.addItem("arrayOf()");
        jComboBox.addItem("arrays");
        jComboBox.addItem("date");
        jComboBox.addItem("time");
        jComboBox.addItem("year");
        jComboBox.addItem("curPackage");
        jComboBox.addItem("curProject");
        jComboBox.addItem("curClass");
        jComboBox.addItem("fileName");
        jComboBox.addItem("userName");
        jComboBox.setEditable(true);
        DefaultCellEditor defaultCellEditor = new DefaultCellEditor(jComboBox);
        tableColumn.setCellEditor(defaultCellEditor);
        this._variableTable.setRowHeight(jComboBox.getPreferredSize().height);
        this._templateTable.getColumnModel().getColumn(0).setCellRenderer(new TemplateCellRenderer(this._dataModel));
        JScrollPane jScrollPane = new JScrollPane(this._templateTable);
        JPanel jPanel = new JPanel(new BorderLayout());
        jPanel.add((Component)jScrollPane, "Center");
        FlowLayout flowLayout = new FlowLayout();
        flowLayout.setAlignment(2);
        JPanel jPanel2 = new JPanel(flowLayout);
        this._butAdd = new JButton();
        this._butDel = new JButton();
        ResourceUtils.resButton((AbstractButton)this._butAdd, (String)TemplateArb.getString(3));
        ResourceUtils.resButton((AbstractButton)this._butDel, (String)TemplateArb.getString(4));
        this._butAdd.addActionListener(this);
        this._butDel.addActionListener(this);
        jPanel2.add(this._butAdd);
        jPanel2.add(this._butDel);
        jPanel.add((Component)jPanel2, "South");
        ListSelectionModel listSelectionModel = this._templateTable.getSelectionModel();
        listSelectionModel.setSelectionMode(0);
        listSelectionModel.addListSelectionListener(this);
        JTabbedPane jTabbedPane = new JTabbedPane();
        this._text = new JTextArea();
        this._text.getDocument().addDocumentListener(this);
        this._text.addFocusListener(this);
        this._imports = new ImportTextField();
        this._imports.getDocument().addDocumentListener(this);
        Font font = UIManager.getFont("TextArea.font");
        Font font2 = new Font("MonoSpaced", 0, font.getSize());
        this._text.setFont(font2);
        jTabbedPane.addTab(TemplateArb.getString(1), new JScrollPane(this._text));
        jTabbedPane.addTab(TemplateArb.getString(2), new JScrollPane(this._imports));
        jTabbedPane.addTab("Variables", new JScrollPane(this._variableTable));
        CustomJSplitPane customJSplitPane = new CustomJSplitPane(0, (Component)jPanel, (Component)jTabbedPane);
        customJSplitPane.setDividerLocation(0.5);
        this.add((Component)customJSplitPane, "Center");
    }

    private void setValuesChanging(boolean bl) {
        this._bValuesChanging = bl;
    }

    private boolean isValuesChanging() {
        return this._bValuesChanging;
    }

    private Template getCurrentTemplate() {
        int n = this.getSelectedRow();
        if (n >= 0) {
            return this._dataModel.getTemplate(n);
        }
        return null;
    }

    private void syncDetail(int n) {
        if (n >= 0) {
            try {
                try {
                    this.setValuesChanging(true);
                    this._text.setEnabled(true);
                    this._imports.setEnabled(true);
                    Template template = this._dataModel.getTemplate(n);
                    template.checkVariables();
                    this._variableDataModel.setTemplate(template);
                    this._text.setText(template.getText());
                    this.highlight();
                    List list = template.getImports();
                    StringBuffer stringBuffer = new StringBuffer();
                    int n2 = list.size();
                    int n3 = 0;
                    while (n3 < n2) {
                        String string = (String)list.get(n3);
                        stringBuffer.append(string);
                        stringBuffer.append('\n');
                        ++n3;
                    }
                    this._imports.setText(stringBuffer.toString());
                }
                catch (Exception exception) {
                    exception.printStackTrace();
                }
            }
            finally {
                this.setValuesChanging(false);
            }
        } else {
            this._text.setText("");
            this._text.setEnabled(false);
            this._imports.setText("");
            this._imports.setEnabled(false);
        }
    }

    private void startEdit(int n, int n2) {
        this._templateTable.editCellAt(n, n2);
        Component component = this._templateTable.getEditorComponent();
        if (component != null) {
            component.requestFocus();
        }
    }

    private static Templates getTemplates(TraversableContext traversableContext) {
        TemplateOptions templateOptions = (TemplateOptions)traversableContext.find("code-template-options");
        Templates templates = templateOptions.getTemplates();
        return templates;
    }

    private void setTemplates(Templates templates) {
        this._dataModel.setTemplates(templates);
        ListSelectionModel listSelectionModel = this._templateTable.getSelectionModel();
        Rectangle rectangle = this._templateTable.getCellRect(_currentRow, 0, true);
        this._templateTable.scrollRectToVisible(rectangle);
        listSelectionModel.setSelectionInterval(_currentRow, _currentRow);
    }

    private void whenAddPressed() {
        this.commitTableEditing(true);
        int n = this._dataModel.addEmptyTemplate();
        ListSelectionModel listSelectionModel = this._templateTable.getSelectionModel();
        Rectangle rectangle = this._templateTable.getCellRect(n, 0, true);
        this._templateTable.scrollRectToVisible(rectangle);
        listSelectionModel.setSelectionInterval(n, n);
        this._templateTable.editCellAt(n, 0);
    }

    private void whenDeletePressed() {
        this.commitTableEditing(false);
        int n = this.getSelectedRow();
        if (n >= 0) {
            this._dataModel.removeTemplate(n);
            ListSelectionModel listSelectionModel = this._templateTable.getSelectionModel();
            int n2 = this._dataModel.getRowCount();
            if (n2 != 0) {
                n = Math.min(n2 - 1, n);
                listSelectionModel.setSelectionInterval(n, n);
            } else {
                this.syncDetail(-1);
            }
        }
    }

    private int getSelectedRow() {
        int n = this._dataModel.getRowCount();
        if (n == 0) {
            return -1;
        }
        _currentRow = this._templateTable.getSelectedRow();
        return _currentRow;
    }

    private void setSelectedRow(int n) {
        int n2 = this._dataModel.getRowCount();
        if (n < n2) {
            this._templateTable.setEditingRow(n);
        }
    }

    private void commitTableEditing(boolean bl) {
        if (!bl) {
            this._dataModel.setErrorMessagesEnabled(false);
        }
        try {
            TableCellEditor tableCellEditor = this._templateTable.getCellEditor();
            if (tableCellEditor != null) {
                tableCellEditor.stopCellEditing();
            }
            if ((tableCellEditor = this._variableTable.getCellEditor()) != null) {
                tableCellEditor.stopCellEditing();
            }
        }
        finally {
            if (!bl) {
                this._dataModel.setErrorMessagesEnabled(true);
            }
        }
    }

    public void valueChanged(ListSelectionEvent listSelectionEvent) {
        ListSelectionModel listSelectionModel;
        if (!listSelectionEvent.getValueIsAdjusting() && (listSelectionModel = (ListSelectionModel)listSelectionEvent.getSource()).getSelectionMode() == 0) {
            int n = this.getSelectedRow();
            int n2 = this._templateTable.getSelectedColumn();
            this.syncDetail(n);
            if (n >= 0) {
                this.startEdit(n, n2);
            }
        }
    }

    public void onEntry(TraversableContext traversableContext) {
        Templates templates = ConfigPanel.getTemplates(traversableContext);
        this.setTemplates(templates);
        this.setSelectedRow(_currentRow);
    }

    public Component getComponent() {
        return this;
    }

    public void onExit(TraversableContext traversableContext) throws TraversalException {
        this.commitTableEditing(false);
        this._dataModel.onExit();
    }

    public Object getExitTransition() {
        return null;
    }

    public String getHelpID() {
        return "f1_idedidesetcodetemplates_html";
    }

    public void apply(ApplyEvent applyEvent) {
        TraversableContext traversableContext = (TraversableContext)applyEvent.getSource();
        Templates templates = ConfigPanel.getTemplates(traversableContext);
        templates.save();
    }

    public void cancel(ApplyEvent applyEvent) {
    }

    public void actionPerformed(ActionEvent actionEvent) {
        if (actionEvent.getSource() == this._butAdd) {
            this.whenAddPressed();
        } else if (actionEvent.getSource() == this._butDel) {
            this.whenDeletePressed();
        }
    }

    public void insertUpdate(DocumentEvent documentEvent) {
        this.whenDocumentChanged(documentEvent);
    }

    public void removeUpdate(DocumentEvent documentEvent) {
        this.whenDocumentChanged(documentEvent);
    }

    public void changedUpdate(DocumentEvent documentEvent) {
        this.whenDocumentChanged(documentEvent);
    }

    private void whenDocumentChanged(DocumentEvent documentEvent) {
        if (!this.isValuesChanging()) {
            System.out.println(documentEvent.getOffset());
            Template template = this.getCurrentTemplate();
            if (template != null) {
                Document document = documentEvent.getDocument();
                if (document == this._text.getDocument()) {
                    String string = this._text.getText();
                    this.highlight();
                    template.setText(string);
                } else {
                    String string = this._imports.getText();
                    template.setImports(string);
                }
            }
        }
    }

    static {
        myHighlightPainter = new DefaultHighlighter.DefaultHighlightPainter(Color.LIGHT_GRAY);
    }

    public void highlight() {
        Highlighter highlighter = this._text.getHighlighter();
        highlighter.removeAllHighlights();
        try {
            Document document = this._text.getDocument();
            String string = document.getText(0, document.getLength());
            int n = 0;
            int n2 = -1;
            while ((n = string.indexOf(36, n)) >= 0) {
                if (n2 == -1) {
                    n2 = n++;
                    continue;
                }
                highlighter.addHighlight(n2, ++n, myHighlightPainter);
                n2 = -1;
            }
            if (n2 != -1) {
                highlighter.addHighlight(n2, document.getLength(), myHighlightPainter);
            }
        }
        catch (BadLocationException badLocationException) {
            // empty catch block
        }
    }

    public void focusGained(FocusEvent focusEvent) {
    }

    public void focusLost(FocusEvent focusEvent) {
        Template template = this.getCurrentTemplate();
        if (template != null) {
            template.checkVariables();
            this._variableDataModel.setTemplate(template);
        }
    }

    public static class ImportTextField
    extends JTextArea {
        protected Document createDefaultModel() {
            return new ImportDocument();
        }

        protected class ImportDocument
        extends PlainDocument {
            public void insertString(int n, String string, AttributeSet attributeSet) throws BadLocationException {
                char[] cArray = string.toCharArray();
                char[] cArray2 = new char[cArray.length];
                int n2 = 0;
                int n3 = 0;
                while (n3 < cArray2.length) {
                    if (Character.isJavaIdentifierPart(cArray[n3]) || cArray[n3] == '.' || cArray[n3] == '\n') {
                        cArray2[n2++] = cArray[n3];
                    } else {
                        Toolkit.getDefaultToolkit().beep();
                    }
                    ++n3;
                }
                super.insertString(n, new String(cArray2, 0, n2), attributeSet);
            }

            protected ImportDocument() {
            }
        }
    }
}

