/*
 * Decompiled with CFR 0.152.
 */
package oracle.jdeveloper.ceditor.template;

import java.util.ArrayList;
import javax.swing.text.BadLocationException;
import oracle.ide.Context;
import oracle.ide.ceditor.CodeEditor;
import oracle.javatools.editor.BasicEditorPane;
import oracle.jdeveloper.ceditor.template.Template;
import oracle.jdeveloper.ceditor.template.TemplateController;
import oracle.jdeveloper.ceditor.template.TemplateVariable;

public class PseudoTemplateFactory {
    Template _t;
    private ArrayList _zones;
    private BasicEditorPane _editor;
    private CodeEditor _codeEditor;

    public void setEnd(int n) {
        this.addZoneInternal("end", n, n);
    }

    public int getStartPos() {
        if (this._zones.size() != 0) {
            Zone zone = (Zone)this._zones.get(0);
            return zone._start;
        }
        return 0;
    }

    public int getEndPos() {
        if (this._zones.size() != 0) {
            Zone zone = (Zone)this._zones.get(this._zones.size() - 1);
            return zone._end;
        }
        return 0;
    }

    public void addZone(String string, int n, int n2) {
        this.addZoneInternal(string + string, n, n2);
    }

    private void addZoneInternal(String string, int n, int n2) {
        String string2;
        try {
            string2 = this._editor.getText(n, n2 - n);
        }
        catch (BadLocationException badLocationException) {
            throw new RuntimeException("Bad zones offsets in template");
        }
        TemplateVariable templateVariable = this._t.getVariable(string);
        if (templateVariable == null && !string.equals("end")) {
            this._t.addOrUpdateVariable(string, "default", string2, true);
        }
        int n3 = 0;
        while (n3 < this._zones.size()) {
            Zone zone = (Zone)this._zones.get(n3);
            if (n2 > zone._start && n < zone._end) {
                throw new RuntimeException("Overlaping zones in template");
            }
            if (n <= zone._start) break;
            ++n3;
        }
        this._zones.add(n3, new Zone(string, n, n2));
    }

    public void addVariable(String string, String string2, String string3, boolean bl) {
        string = string + string;
        this._t.addOrUpdateVariable(string, string2, string3, bl);
    }

    public PseudoTemplateFactory(Context context) {
        this._editor = TemplateController.getEditor(context);
        this._t = new Template();
        this._codeEditor = TemplateController.getCodeEditor(context);
        this._zones = new ArrayList();
    }

    public void realize() {
        Zone[] zoneArray = new Zone[this._zones.size()];
        zoneArray = this._zones.toArray(zoneArray);
        try {
            if (zoneArray.length != 0) {
                int n = zoneArray[0]._start;
                int n2 = zoneArray[zoneArray.length - 1]._end;
                int n3 = 0;
                StringBuffer stringBuffer = new StringBuffer(n2 - n + 4 * zoneArray.length);
                while (n3 < zoneArray.length) {
                    if (n == zoneArray[n3]._start) {
                        stringBuffer.append('$');
                        stringBuffer.append(zoneArray[n3]._name);
                        stringBuffer.append('$');
                        n = zoneArray[n3]._end;
                        ++n3;
                        continue;
                    }
                    String string = this._editor.getText(n, zoneArray[n3]._start - n);
                    int n4 = 0;
                    while (n4 < string.length()) {
                        char c = string.charAt(n4);
                        if (c == '$') {
                            stringBuffer.append("$$");
                        } else {
                            stringBuffer.append(c);
                        }
                        ++n4;
                    }
                    n = zoneArray[n3]._start;
                }
                this._t.setText(stringBuffer.toString());
                this._t.parseVariables();
                this._editor.select(this.getStartPos(), this.getEndPos());
                TemplateController.launchEdit(this._editor, this._codeEditor, this._t, this.getStartPos());
            }
        }
        catch (BadLocationException badLocationException) {
            throw new RuntimeException("Unexpected error in realize");
        }
    }

    public static class Zone {
        String _name;
        int _start;
        int _end;

        public Zone(String string, int n, int n2) {
            this._name = string;
            this._start = n;
            this._end = n2;
        }
    }
}

