/*
 * Decompiled with CFR 0.152.
 */
package oracle.jdeveloper.ceditor.template;

import oracle.ide.Context;
import oracle.ide.model.Node;
import oracle.javatools.parser.java.v2.model.SourceFile;
import oracle.javatools.parser.java.v2.model.SourceImport;
import oracle.javatools.parser.java.v2.model.SourcePackage;
import oracle.jdeveloper.java.JavaManager;
import oracle.jdeveloper.model.JavaSourceNode;

class SourceImportsDesc {
    private SourceImport[] _imports;
    private SourcePackage _package;
    private int _nEndImportPos;

    void $init$() {
        this._nEndImportPos = -1;
    }

    private SourceImportsDesc() {
        this.$init$();
    }

    static SourceImportsDesc parse(Context context) {
        SourceImportsDesc sourceImportsDesc = null;
        Node node = context.getNode();
        if (node instanceof JavaSourceNode) {
            JavaManager javaManager = JavaManager.getJavaManager(context.getProject());
            SourceFile sourceFile = javaManager.getSourceFile(node.getURL());
            SourceImportsDesc sourceImportsDesc2 = new SourceImportsDesc();
            sourceImportsDesc2._imports = sourceFile.getSourceImports().toArray(new SourceImport[0]);
            sourceImportsDesc2._package = sourceFile.getSourcePackage();
            sourceImportsDesc = sourceImportsDesc2;
        }
        return sourceImportsDesc;
    }

    int getEndImportPosition() {
        if (this._nEndImportPos == -1) {
            if (this._package != null) {
                this._nEndImportPos = this._package.getEndOffset();
            }
            if (this._imports != null) {
                int n = 0;
                while (n < this._imports.length) {
                    SourceImport sourceImport = this._imports[n];
                    this._nEndImportPos = Math.max(sourceImport.getEndOffset(), this._nEndImportPos);
                    ++n;
                }
            }
        }
        return this._nEndImportPos;
    }

    boolean hasImport(String string) {
        boolean bl = false;
        String string2 = null;
        int n = 0;
        while (!bl && n < this._imports.length) {
            SourceImport sourceImport = this._imports[n];
            String string3 = sourceImport.getName();
            if (string3.endsWith(".*")) {
                if (string2 == null) {
                    string2 = SourceImportsDesc.getPackage(string);
                }
                if (SourceImportsDesc.getPackage(string3).equals(string2)) {
                    bl = true;
                }
            } else if (string3.equals(string)) {
                bl = true;
            }
            ++n;
        }
        return bl;
    }

    private static String getPackage(String string) {
        int n = string.lastIndexOf(46);
        return string.substring(0, n);
    }
}

