/*
 * Decompiled with CFR 0.152.
 */
package oracle.jdeveloper.ceditor.template;

import java.io.PrintWriter;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.StringTokenizer;
import oracle.ide.ceditor.CodeEditor;
import oracle.javatools.buffer.OffsetMark;
import oracle.javatools.util.Copyable;
import oracle.jdeveloper.ceditor.template.HintChoice;
import oracle.jdeveloper.ceditor.template.TemplateContext;
import oracle.jdeveloper.ceditor.template.TemplateVariable;

final class Template
implements Copyable {
    private static StringBuffer BLANKS = new StringBuffer("        ");
    private String _shortcut;
    private String _before;
    private String _desc;
    private ArrayList _imports;
    private ArrayList _variables;
    private boolean _valid;
    private String[] _fields;
    private int[][] _fieldsPosition;
    private int[] _offsets;
    private int _endOffset;
    private String[] _values;
    private boolean[] _entered;
    private OffsetMark[] _fieldOffset;

    void $init$() {
        this._valid = true;
    }

    Template(String string, String string2, String string3) {
        this.$init$();
        this._shortcut = string;
        this._before = string3 == null ? "" : string3;
        this._desc = string2;
    }

    private Template(String string, String string2, String string3, ArrayList arrayList) {
        this.$init$();
        this._shortcut = string == null ? "" : string;
        this._before = string3 == null ? "" : string3;
        this._desc = string2 == null ? "" : string2;
        this._imports = arrayList;
    }

    Template() {
        this("", "", "", null);
    }

    public Template(String string) {
        this("", string, "", null);
    }

    private final void copyToImpl(Template template) {
        template._shortcut = this._shortcut;
        template._before = this._before;
        template._desc = this._desc;
        if (this._imports != null) {
            template._imports = new ArrayList(this._imports.size());
            template._imports.addAll(this._imports);
        } else {
            template._imports = null;
        }
        if (this._variables != null) {
            template._variables = new ArrayList(this._variables.size());
            int n = 0;
            while (n < this._variables.size()) {
                TemplateVariable templateVariable = (TemplateVariable)this._variables.get(n);
                template._variables.add(new TemplateVariable(templateVariable));
                ++n;
            }
        } else {
            template._variables = null;
        }
    }

    void toXML(PrintWriter printWriter) {
        printWriter.println("  <item>");
        printWriter.println("    <abbr><![CDATA[" + this.getShortcut() + "]]></" + "abbr" + ">");
        printWriter.println("    <descr><![CDATA[" + this.getDescription() + "]]></" + "descr" + ">");
        printWriter.println("    <text1><![CDATA[" + this._before + "]]></" + "text1" + ">");
        int n = this._imports == null ? 0 : this._imports.size();
        int n2 = 0;
        while (n2 < n) {
            printWriter.println("    <import>" + this._imports.get(n2).toString() + "</" + "import" + ">");
            ++n2;
        }
        n = this._variables == null ? 0 : this._variables.size();
        int n3 = 0;
        while (n3 < n) {
            TemplateVariable templateVariable = (TemplateVariable)this._variables.get(n3);
            templateVariable.toXML(printWriter);
            ++n3;
        }
        printWriter.println(" </item>");
    }

    String getShortcut() {
        return this._shortcut;
    }

    void setShortcut(String string) {
        this._shortcut = string;
    }

    String getText() {
        return this._before;
    }

    public void checkVariables() {
        HashMap hashMap = new HashMap();
        this.parseToHashMap(hashMap);
        if (this._variables != null) {
            int n = 0;
            while (n < this._variables.size()) {
                TemplateVariable templateVariable = (TemplateVariable)this._variables.get(n);
                if (hashMap.containsKey(templateVariable.getName())) {
                    ++n;
                    continue;
                }
                this._variables.remove(n);
            }
        }
        for (String string : hashMap.keySet()) {
            TemplateVariable templateVariable = this.getVariable(string);
            if (templateVariable != null) continue;
            this.addVariable(new TemplateVariable(string, "default", string, true));
        }
    }

    void setText(String string) {
        this._before = string;
    }

    String getDescription() {
        return this._desc == null ? "" : this._desc;
    }

    void setDescription(String string) {
        this._desc = string;
    }

    int getCursorPos() {
        return this._endOffset;
    }

    public boolean isValid() {
        return this._valid;
    }

    public void setValid(boolean bl) {
        this._valid = bl;
    }

    public void addVariable(TemplateVariable templateVariable) {
        if (this._variables == null) {
            this._variables = new ArrayList(2);
        }
        if (!this._variables.contains(templateVariable)) {
            int n = 0;
            while (n < this._variables.size() && templateVariable.compareTo(this._variables.get(n)) > 0) {
                ++n;
            }
            this._variables.add(n, templateVariable);
        }
    }

    public List getVariables() {
        if (this._variables == null) {
            return Collections.EMPTY_LIST;
        }
        return this._variables;
    }

    public int getVariableIndex(String string) {
        if (this._variables == null) {
            return -1;
        }
        return this._variables.indexOf(new TemplateVariable(string, null, null, false));
    }

    public TemplateVariable getVariable(String string) {
        int n = this.getVariableIndex(string);
        if (n == -1) {
            return null;
        }
        return (TemplateVariable)this._variables.get(n);
    }

    public void removeVariable(String string) {
        int n = this._variables.indexOf(new TemplateVariable(string, null, null, false));
        if (n == -1) {
            this._variables.remove(n);
        }
    }

    public void addOrUpdateVariable(String string, String string2, String string3, boolean bl) {
        TemplateVariable templateVariable = this.getVariable(string);
        if (templateVariable == null) {
            this.addVariable(new TemplateVariable(string, string2, string3, bl));
        } else {
            templateVariable.setType(string2);
            templateVariable.setDefValue(string3);
            templateVariable.setEditable(bl);
        }
    }

    public void addImport(String string) {
        if (this._imports == null) {
            this._imports = new ArrayList(2);
        }
        if (!this._imports.contains(string)) {
            this._imports.add(string);
        }
    }

    public List getImports() {
        if (this._imports == null) {
            return Collections.EMPTY_LIST;
        }
        return this._imports;
    }

    public void setImports(String string) {
        ArrayList<String> arrayList = new ArrayList<String>(2);
        StringTokenizer stringTokenizer = new StringTokenizer(string, "\n");
        while (stringTokenizer.hasMoreTokens()) {
            arrayList.add(stringTokenizer.nextToken());
        }
        this.setImports(arrayList);
    }

    public void setImports(List list) {
        if (this._imports == null) {
            this._imports = new ArrayList(list.size());
        } else {
            this._imports.clear();
        }
        this._imports.addAll(list);
    }

    public boolean isEmpty() {
        return (this._imports == null || this._imports.isEmpty()) && this._shortcut.length() == 0 && this._before.length() == 0 && this._desc.length() == 0;
    }

    Template adjust(String string, boolean bl, int n, int n2, boolean bl2) {
        Template template = new Template();
        this.copyToImpl(template);
        template._before = Template.adjust(this._before, string, bl, n, n2, bl2);
        return template;
    }

    private static String adjust(String string, String string2, boolean bl, int n, int n2, boolean bl2) {
        StringBuffer stringBuffer = Template.indent(string, string2, n, n2, bl2);
        if (bl) {
            stringBuffer = Template.adaptBracesSameLine(stringBuffer);
        }
        return stringBuffer.toString();
    }

    private static StringBuffer indent(String string, String string2, int n, int n2, boolean bl) {
        int n3 = Template.getIndentLevel(string2, n, n2);
        StringBuffer stringBuffer = new StringBuffer();
        int n4 = string.length();
        int n5 = 0;
        while (n5 < n4) {
            char c = string.charAt(n5);
            stringBuffer.append(c);
            if (c == '\n') {
                int n6 = Template.countTabs(string, n5 + 1);
                if (n6 > 0) {
                    n5 += n6;
                    int n7 = n6 * n;
                    int n8 = 0;
                    if (bl) {
                        int n9 = (n6 += n3) * n;
                        n8 = n9 / n2;
                        n7 = n9 % n2;
                    } else {
                        stringBuffer.append(string2);
                    }
                    int n10 = 0;
                    while (n10 < n8) {
                        stringBuffer.append('\t');
                        ++n10;
                    }
                    int n11 = 0;
                    while (n11 < n7) {
                        stringBuffer.append(' ');
                        ++n11;
                    }
                } else {
                    stringBuffer.append(string2);
                }
            }
            ++n5;
        }
        return stringBuffer;
    }

    private static int getIndentLevel(String string, int n, int n2) {
        int n3 = 0;
        int n4 = 0;
        int n5 = string.length();
        int n6 = 0;
        while (n6 < n5) {
            char c = string.charAt(n6);
            if (c == '\t') {
                ++n4;
            } else if (c == ' ') {
                ++n3;
            }
            ++n6;
        }
        int n7 = n3 + n4 * n2;
        return n7 / n;
    }

    private static int countTabs(String string, int n) {
        int n2 = 0;
        int n3 = string.length();
        int n4 = n;
        while (n4 < n3) {
            char c;
            if ((c = string.charAt(n4++)) != '\t') break;
            ++n2;
        }
        return n2;
    }

    private static StringBuffer adaptBracesSameLine(StringBuffer stringBuffer) {
        int n = stringBuffer.length();
        int n2 = -1;
        int n3 = 0;
        int n4 = 0;
        while (n4 < n) {
            char c = stringBuffer.charAt(n4);
            block0 : switch (n3) {
                case 0: {
                    switch (c) {
                        case '\n': {
                            n2 = n4;
                            n3 = 1;
                        }
                    }
                    break;
                }
                case 1: {
                    switch (c) {
                        case '\t': 
                        case ' ': {
                            break block0;
                        }
                        case '{': {
                            n3 = 2;
                            break block0;
                        }
                    }
                    n3 = 0;
                    break;
                }
                case 2: {
                    switch (c) {
                        case '\t': 
                        case ' ': {
                            break block0;
                        }
                        case '\n': {
                            n3 = 0;
                            stringBuffer.replace(n2, n4, " {");
                            n = stringBuffer.length();
                            break block0;
                        }
                    }
                    n3 = 0;
                    break;
                }
                default: {
                    throw new IllegalStateException();
                }
            }
            ++n4;
        }
        return stringBuffer;
    }

    private int parseToHashMap(HashMap hashMap) {
        StringBuffer stringBuffer = new StringBuffer(this.getText());
        int n = 0;
        int n2 = 0;
        int n3 = stringBuffer.length();
        int n4 = 0;
        int n5 = 0;
        while (n5 < n3) {
            char c = stringBuffer.charAt(n5);
            switch (n) {
                case 0: {
                    if (c != '$') break;
                    n2 = n5;
                    n = 1;
                    break;
                }
                case 1: {
                    if (c != '$') break;
                    String string = stringBuffer.substring(n2 + 1, n5);
                    if (!string.equalsIgnoreCase("end") && !string.equals("")) {
                        hashMap.put(string, null);
                        ++n4;
                    }
                    n = 0;
                }
            }
            ++n5;
        }
        return n4;
    }

    public void parseVariables() {
        StringBuffer stringBuffer = new StringBuffer(this.getText());
        HashMap<String, ArrayList<Integer>> hashMap = new HashMap<String, ArrayList<Integer>>();
        this._endOffset = this._before.length();
        int n = 0;
        int n2 = 0;
        int n3 = stringBuffer.length();
        int n4 = this.parseToHashMap(hashMap);
        this._fields = new String[hashMap.size()];
        this._values = new String[hashMap.size()];
        this._entered = new boolean[hashMap.size()];
        this._fieldOffset = new OffsetMark[hashMap.size()];
        this._offsets = new int[n4];
        n4 = 0;
        n3 = stringBuffer.length();
        int n5 = 0;
        int n6 = 0;
        while (n6 < n3) {
            char c = stringBuffer.charAt(n6);
            switch (n) {
                case 0: {
                    if (c != '$') break;
                    n2 = n6;
                    n = 1;
                    break;
                }
                case 1: {
                    if (c != '$') break;
                    String string = stringBuffer.substring(n2 + 1, n6);
                    if (string.equals("")) {
                        stringBuffer.delete(n2, n6);
                        n6 = n2;
                    } else if (string.equalsIgnoreCase("end")) {
                        this._endOffset = n2;
                        stringBuffer.delete(n2, n6 + 1);
                        n6 = n2 - 1;
                    } else {
                        ArrayList<Integer> arrayList = (ArrayList<Integer>)hashMap.get(string);
                        if (arrayList == null) {
                            this._fields[n5++] = string;
                            arrayList = new ArrayList<Integer>();
                            hashMap.put(string, arrayList);
                        }
                        this._offsets[n4] = n2;
                        arrayList.add(new Integer(n4++));
                        stringBuffer.delete(n2, n6 + 1);
                        n6 = n2 - 1;
                    }
                    n3 = stringBuffer.length();
                    n = 0;
                }
            }
            ++n6;
        }
        if (this._endOffset > stringBuffer.length()) {
            this._endOffset = stringBuffer.length();
        }
        this._before = stringBuffer.toString();
        this._fieldsPosition = new int[n5][];
        int n7 = 0;
        while (n7 < n5) {
            ArrayList arrayList = (ArrayList)hashMap.get(this._fields[n7]);
            this._fieldsPosition[n7] = new int[arrayList.size()];
            int n8 = 0;
            while (n8 < arrayList.size()) {
                Integer n9 = (Integer)arrayList.get(n8);
                this._fieldsPosition[n7][n8] = n9;
                ++n8;
            }
            ++n7;
        }
    }

    public int[] getOriginalOffsets() {
        return this._offsets;
    }

    public int getFieldCount() {
        return this._fields.length;
    }

    public int[] getFieldPositions(int n) {
        return this._fieldsPosition[n];
    }

    public String getFieldName(int n) {
        return this._fields[n];
    }

    public void setValueAndOffset(int n, String string, OffsetMark offsetMark, boolean bl) {
        if (bl) {
            this._entered[n] = true;
        }
        this._values[n] = string;
        this._fieldOffset[n] = offsetMark;
    }

    public int getFieldIndex(String string) {
        int n = 0;
        while (n < this._fields.length) {
            if (string.equals(this._fields[n])) {
                return n;
            }
            ++n;
        }
        return -1;
    }

    public String getCurrentValueByName(String string) {
        int n = this.getFieldIndex(string);
        if (n != -1) {
            return this._values[n];
        }
        return null;
    }

    public int getCurrentOffsetByName(String string) {
        int n = this.getFieldIndex(string);
        if (n != -1) {
            return this._fieldOffset[n].getOffset();
        }
        return -1;
    }

    public String guessFieldValue(CodeEditor codeEditor, int n, int n2, String string) {
        if (this._values[n] != null) {
            return this._values[n];
        }
        TemplateVariable templateVariable = this.getVariable(this._fields[n]);
        return templateVariable.guessValue(new TemplateContext(codeEditor, this), n2, string);
    }

    public HintChoice[] getFieldHints(CodeEditor codeEditor, int n, int n2) {
        TemplateVariable templateVariable = this.getVariable(this._fields[n]);
        return templateVariable.getHints(new TemplateContext(codeEditor, this), n2);
    }

    public String getFieldValue(CodeEditor codeEditor, int n, int n2, boolean bl, String string) {
        TemplateVariable templateVariable = this.getVariable(this._fields[n]);
        if (!this.canCalculateField(codeEditor, n)) {
            return templateVariable.getDefValue();
        }
        String string2 = templateVariable.guessValue(new TemplateContext(codeEditor, this), n2, string);
        if (bl && string2 == null) {
            return templateVariable.getDefValue();
        }
        return string2;
    }

    public boolean canEditField(int n) {
        TemplateVariable templateVariable = this.getVariable(this._fields[n]);
        return templateVariable.isEditable();
    }

    public boolean canCalculateField(CodeEditor codeEditor, int n) {
        TemplateVariable templateVariable = this.getVariable(this._fields[n]);
        if (!templateVariable.isEditable()) {
            return true;
        }
        if (this._entered[n]) {
            return false;
        }
        return templateVariable.isCalculatedField(new TemplateContext(codeEditor, this));
    }

    public Object copyTo(Object object) {
        Template template = object != null ? (Template)object : new Template();
        this.copyToImpl(template);
        return template;
    }
}

