/*
 * Decompiled with CFR 0.152.
 */
package oracle.jdeveloper.ceditor.template;

import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import javax.swing.JOptionPane;
import javax.swing.table.AbstractTableModel;
import oracle.ide.panels.TraversalException;
import oracle.jdeveloper.ceditor.template.ConfigPanel;
import oracle.jdeveloper.ceditor.template.Template;
import oracle.jdeveloper.ceditor.template.TemplateArb;
import oracle.jdeveloper.ceditor.template.Templates;

class TemplateConfigModel
extends AbstractTableModel
implements Comparator {
    private Templates _templates;
    private ArrayList _orderedList;
    private ConfigPanel _srcPanel;
    private boolean _errorMessagesEnabled;

    void $init$() {
        this._errorMessagesEnabled = true;
    }

    TemplateConfigModel(ConfigPanel configPanel) {
        this.$init$();
        this._srcPanel = configPanel;
    }

    public void setTemplates(Templates templates) {
        this._templates = templates;
        this.refreshModel();
    }

    void setErrorMessagesEnabled(boolean bl) {
        this._errorMessagesEnabled = bl;
    }

    private void refreshModel() {
        if (this._templates != null) {
            int n = this._templates.getTemplateCount();
            this._orderedList = new ArrayList(n);
            int n2 = 0;
            while (n2 < n) {
                this._orderedList.add(new Integer(n2));
                ++n2;
            }
            Collections.sort(this._orderedList, this);
        }
    }

    public int addEmptyTemplate() {
        int n = this._templates.searchTemplatePosEndingWith("");
        if (n == -1) {
            Template template = new Template();
            n = this._templates.addTemplate(template);
            this._orderedList.add(new Integer(n));
            this.fireTableRowsInserted(n, n);
        }
        return n;
    }

    public int compare(Object object, Object object2) {
        Integer n = (Integer)object;
        Integer n2 = (Integer)object2;
        Template template = this._templates.getTemplate(n);
        Template template2 = this._templates.getTemplate(n2);
        String string = template.getShortcut();
        String string2 = template2.getShortcut();
        return String.CASE_INSENSITIVE_ORDER.compare(string, string2);
    }

    public boolean isCellEditable(int n, int n2) {
        return true;
    }

    public int getColumnCount() {
        return 2;
    }

    public int getRowCount() {
        return this._templates == null ? 0 : this._templates.getTemplateCount();
    }

    Template getTemplate(int n) {
        Integer n2 = (Integer)this._orderedList.get(n);
        return this._templates.getTemplate(n2);
    }

    public Object getValueAt(int n, int n2) {
        String string;
        Template template = this.getTemplate(n);
        switch (n2) {
            case 0: {
                string = template.getShortcut();
                break;
            }
            case 1: {
                string = template.getDescription();
                break;
            }
            default: {
                string = null;
            }
        }
        return string;
    }

    public void setValueAt(Object object, int n, int n2) {
        Template template = this.getTemplate(n);
        String string = object.toString();
        switch (n2) {
            case 0: {
                boolean bl;
                template.setShortcut(string);
                if (this._errorMessagesEnabled && (bl = this._templates.isDuplicateShortcut(template))) {
                    this.showInvalidTemplateMessage(TemplateArb.getString(13));
                }
                if (!this._templates.updateValidities()) break;
                this._srcPanel.repaint();
                break;
            }
            case 1: {
                template.setDescription(string);
                break;
            }
        }
    }

    private void showInvalidTemplateMessage(String string) {
        JOptionPane.showMessageDialog(this._srcPanel, string, TemplateArb.getString(12), 2);
    }

    void isValid() {
        this._templates.updateValidities();
    }

    void removeTemplate(int n) {
        if (n != -1) {
            Integer n2 = (Integer)this._orderedList.get(n);
            this._templates.removeTemplate(n2);
            this.refreshModel();
            this.fireTableRowsDeleted(n, n);
        }
    }

    public String getColumnName(int n) {
        switch (n) {
            case 0: {
                return TemplateArb.getString(5);
            }
            case 1: {
                return TemplateArb.getString(6);
            }
        }
        return null;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public void onExit() throws TraversalException {
        int n = this._templates.getTemplateCount();
        int n2 = n - 1;
        while (n2 >= 0) {
            Template template = this._templates.getTemplate(n2);
            String string = template.getShortcut();
            if (string == null || string.length() == 0) {
                if (!template.isEmpty()) throw new TraversalException(TemplateArb.getString(14), TemplateArb.getString(12));
                this._templates.removeTemplate(n2);
            } else {
                int n3 = n2 - 1;
                while (n3 >= 0) {
                    Template template2 = this._templates.getTemplate(n3);
                    String string2 = template2.getShortcut();
                    if (string.equals(string2)) {
                        throw new TraversalException(TemplateArb.getString(13), TemplateArb.getString(12));
                    }
                    --n3;
                }
            }
            --n2;
        }
    }
}

