/*
 * Decompiled with CFR 0.152.
 */
package oracle.jdeveloper.ceditor.template;

import java.awt.Color;
import java.awt.Rectangle;
import java.awt.Toolkit;
import java.awt.event.FocusEvent;
import java.awt.event.FocusListener;
import java.util.ArrayList;
import java.util.List;
import javax.swing.Icon;
import javax.swing.JComponent;
import javax.swing.JMenuItem;
import javax.swing.ListCellRenderer;
import javax.swing.ListModel;
import javax.swing.SwingUtilities;
import javax.swing.text.BadLocationException;
import javax.swing.text.JTextComponent;
import oracle.ide.Context;
import oracle.ide.Ide;
import oracle.ide.ceditor.CodeEditor;
import oracle.ide.ceditor.CodeMenuConstants;
import oracle.ide.controller.Controller;
import oracle.ide.controller.DynamicMenuListener;
import oracle.ide.controller.IdeAction;
import oracle.ide.controller.Menubar;
import oracle.ide.controls.ToggleAction;
import oracle.ide.util.ArrayResourceBundle;
import oracle.ide.view.View;
import oracle.javatools.buffer.OffsetMark;
import oracle.javatools.buffer.TextBuffer;
import oracle.javatools.buffer.TextBufferListener;
import oracle.javatools.editor.ActionHookInvoker;
import oracle.javatools.editor.BasicDocument;
import oracle.javatools.editor.BasicEditorPane;
import oracle.javatools.editor.EditDescriptor;
import oracle.javatools.editor.highlight.HighlightLayer;
import oracle.javatools.editor.highlight.HighlightStyle;
import oracle.javatools.editor.insight.AbstractInsight;
import oracle.javatools.editor.insight.InsightData;
import oracle.javatools.editor.insight.InsightProvider;
import oracle.javatools.editor.insight.InsightView;
import oracle.javatools.editor.insight.ListDataItem;
import oracle.javatools.editor.insight.ListDataItemListModel;
import oracle.javatools.editor.insight.ListInsightData;
import oracle.javatools.editor.insight.ListInsightView;
import oracle.javatools.editor.plugins.EditorPlugin;
import oracle.jdeveloper.ceditor.template.HintChoice;
import oracle.jdeveloper.ceditor.template.SourceImportsDesc;
import oracle.jdeveloper.ceditor.template.Template;
import oracle.jdeveloper.ceditor.template.TemplateArb;
import oracle.jdeveloper.ceditor.template.TemplateHintCellRenderer;
import oracle.jdeveloper.ceditor.template.TemplateOptions;
import oracle.jdeveloper.ceditor.template.Templates;
import oracle.jdeveloper.style.CodingStyleManager;
import oracle.jdeveloper.style.CodingStyleOptions;

final class TemplateController
implements DynamicMenuListener,
Controller,
CodeMenuConstants {
    private static final boolean DEBUG = true;
    private static final String ACTION_NAME = "CodeTemplate.EXPAND";
    static final int ACTION_ID = Ide.createCmdID((String)"CodeTemplate.EXPAND");
    static IdeAction actionExpand;
    static TemplateListInsight _templateInsight;
    private static TemplateActionHookInvoker _actionHookInvoker;
    private JComponent[] dynamicItems;
    private static final String HIGHLIGHT_STYLE_NAME = "template-variable";
    private static final HighlightStyle HIGHLIGHT_STYLE;

    static {
        String string = TemplateArb.getString(16);
        HIGHLIGHT_STYLE = CodeEditor.createHighlightStyle((String)HIGHLIGHT_STYLE_NAME, (String)string, (int)75, null, (Color)Color.LIGHT_GRAY);
    }

    TemplateController() {
    }

    void initialize() {
        actionExpand = IdeAction.get((int)ACTION_ID, null, (String)TemplateArb.getString(7), (String)CodeMenuConstants.CATEGORY_CODE_MENU, (Integer)new Integer(TemplateArb.getMnemonic(8)), (ArrayResourceBundle)TemplateArb.getInstance(), (int)9, null, (boolean)true);
        actionExpand.addController((Controller)this);
        this.initializeDynamicActions();
        Ide.getMainWindow().addDynamicMenuListener((DynamicMenuListener)this);
    }

    void shutdown() {
        Ide.getMainWindow().removeDynamicMenuListener((DynamicMenuListener)this);
    }

    static void clearHook() {
        _actionHookInvoker = null;
    }

    private static String getIndent(String string) {
        int n = 0;
        while (n < string.length()) {
            char c = string.charAt(n);
            if (c != ' ' && c != '\t') break;
            ++n;
        }
        return string.substring(0, n);
    }

    private static Template adjustTemplate(BasicEditorPane basicEditorPane, Template template, int n) throws BadLocationException {
        int n2 = basicEditorPane.getLineFromOffset(n);
        int n3 = basicEditorPane.getLineStartOffset(n2);
        String string = basicEditorPane.getText(n3, n - n3);
        String string2 = TemplateController.getIndent(string);
        int n4 = basicEditorPane.getIntegerProperty("indent-size");
        Integer n5 = (Integer)basicEditorPane.getProperty("tab-size");
        Boolean bl = (Boolean)basicEditorPane.getProperty("use-tabs");
        CodingStyleManager codingStyleManager = CodingStyleManager.getCodingStyleManager();
        CodingStyleOptions codingStyleOptions = codingStyleManager.getCodingStyleOptions();
        boolean bl2 = codingStyleOptions.getBlockBracePosition() == 0;
        Template template2 = template.adjust(string2, bl2, n4, n5, bl);
        template2.parseVariables();
        return template2;
    }

    private Template getTemplate(Context context, int n, int n2) {
        Template template;
        block8: {
            BasicEditorPane basicEditorPane = TemplateController.getEditor(context);
            template = null;
            try {
                Rectangle rectangle;
                TemplateOptions templateOptions = (TemplateOptions)Ide.getSettings().getData("code-template-options");
                Templates templates = templateOptions.getTemplates();
                String string = null;
                if (n == n2) {
                    int n3 = Math.min(n2, templates.getLongestShortcut());
                    String string2 = basicEditorPane.getText(n2 - n3, n3);
                    template = templates.findTemplateEndingWith(string2);
                    string = string2;
                } else {
                    String string3 = basicEditorPane.getText(n, n2 - n);
                    template = templates.findTemplate(string3);
                    string = string3;
                }
                if (template != null) break block8;
                int n4 = string.length() - 1;
                while (n4 >= 0 && Character.isJavaIdentifierPart(string.charAt(n4))) {
                    --n4;
                }
                string = string.substring(n4 + 1);
                Template[] templateArray = templates.getSortedTemplates();
                TemplateItem[] templateItemArray = new TemplateItem[templateArray.length];
                int n5 = 0;
                while (n5 < templateArray.length) {
                    templateItemArray[n5] = new TemplateItem(templateArray[n5]);
                    ++n5;
                }
                int n6 = basicEditorPane.getCaretPosition();
                try {
                    rectangle = basicEditorPane.getUI().modelToView((JTextComponent)basicEditorPane, n6);
                }
                catch (BadLocationException badLocationException) {
                    rectangle = null;
                }
                _templateInsight = new TemplateListInsight(context, templateItemArray, string, rectangle);
                basicEditorPane.installPlugin((EditorPlugin)_templateInsight);
                _templateInsight.showInsight();
            }
            catch (BadLocationException badLocationException) {
                badLocationException.printStackTrace();
            }
        }
        return template;
    }

    static void replaceFieldAtPos(BasicEditorPane basicEditorPane, int n, String string, OffsetMark[] offsetMarkArray, OffsetMark[] offsetMarkArray2) throws BadLocationException {
        int n2 = offsetMarkArray[n].getOffset();
        int n3 = offsetMarkArray2[n].getOffset();
        basicEditorPane.select(n2, n3);
        basicEditorPane.replaceSelection(string);
        n3 = n2 + string.length();
        offsetMarkArray[n].setOffset(n2);
        offsetMarkArray2[n].setOffset(n3);
        int n4 = n;
        while (--n4 >= 0) {
            if (offsetMarkArray[n4].getOffset() > n2) {
                offsetMarkArray[n4].setOffset(n2);
            }
            if (offsetMarkArray2[n4].getOffset() <= n2) continue;
            offsetMarkArray2[n4].setOffset(n2);
        }
        n4 = n;
        while (++n4 < offsetMarkArray2.length) {
            if (offsetMarkArray[n4].getOffset() < n3) {
                offsetMarkArray[n4].setOffset(n3);
            }
            if (offsetMarkArray2[n4].getOffset() >= n3) continue;
            offsetMarkArray2[n4].setOffset(n3);
        }
    }

    private static OffsetMark addOffsetMark(BasicEditorPane basicEditorPane, int n) throws BadLocationException {
        BasicDocument basicDocument = (BasicDocument)basicEditorPane.getDocument();
        TextBuffer textBuffer = basicDocument.getTextBuffer();
        return textBuffer.addOffsetMark(n);
    }

    private static OffsetMark addStartOffsetMark(BasicEditorPane basicEditorPane, int n) throws BadLocationException {
        BasicDocument basicDocument = (BasicDocument)basicEditorPane.getDocument();
        TextBuffer textBuffer = basicDocument.getTextBuffer();
        return textBuffer.addOffsetMark(n, false);
    }

    private static void removeOffsetMark(BasicEditorPane basicEditorPane, OffsetMark offsetMark) {
        BasicDocument basicDocument = (BasicDocument)basicEditorPane.getDocument();
        TextBuffer textBuffer = basicDocument.getTextBuffer();
        textBuffer.removeOffsetMark(offsetMark);
    }

    private static void replace(BasicEditorPane basicEditorPane, CodeEditor codeEditor, int n, Template template) throws BadLocationException {
        template = TemplateController.adjustTemplate(basicEditorPane, template, n);
        int n2 = n - template.getShortcut().length();
        basicEditorPane.select(n2, n);
        TemplateController.launchEdit(basicEditorPane, codeEditor, template, n2);
    }

    protected static void launchEdit(BasicEditorPane basicEditorPane, CodeEditor codeEditor, Template template, int n) throws BadLocationException {
        basicEditorPane.replaceSelection(template.getText());
        int[] nArray = template.getOriginalOffsets();
        if (nArray.length > 0) {
            boolean bl;
            OffsetMark[] offsetMarkArray = new OffsetMark[nArray.length];
            OffsetMark[] offsetMarkArray2 = new OffsetMark[nArray.length];
            int n2 = 0;
            while (n2 < nArray.length) {
                offsetMarkArray[n2] = TemplateController.addStartOffsetMark(basicEditorPane, n + nArray[n2]);
                offsetMarkArray2[n2] = TemplateController.addOffsetMark(basicEditorPane, n + nArray[n2]);
                ++n2;
            }
            OffsetMark offsetMark = TemplateController.addOffsetMark(basicEditorPane, n + template.getCursorPos());
            String[] stringArray = new String[template.getFieldCount()];
            int n3 = 0;
            while (n3 < template.getFieldCount()) {
                int[] nArray2 = template.getFieldPositions(n3);
                stringArray[n3] = template.getFieldValue(codeEditor, n3, offsetMarkArray[nArray2[0]].getOffset(), true, null);
                int n4 = 0;
                while (n4 < nArray2.length) {
                    TemplateController.replaceFieldAtPos(basicEditorPane, nArray2[n4], stringArray[n3], offsetMarkArray, offsetMarkArray2);
                    ++n4;
                }
                ++n3;
            }
            do {
                bl = false;
                int n5 = 0;
                while (n5 < template.getFieldCount()) {
                    int[] nArray3 = template.getFieldPositions(n5);
                    String string = template.guessFieldValue(codeEditor, n5, offsetMarkArray[nArray3[0]].getOffset(), stringArray[n5]);
                    if (string != null) {
                        template.setValueAndOffset(n5, string, offsetMarkArray[nArray3[0]], false);
                        int n6 = 0;
                        while (n6 < nArray3.length) {
                            TemplateController.replaceFieldAtPos(basicEditorPane, nArray3[n6], string, offsetMarkArray, offsetMarkArray2);
                            ++n6;
                        }
                    } else {
                        bl = true;
                    }
                    ++n5;
                }
            } while (bl);
            _actionHookInvoker = new TemplateActionHookInvoker(basicEditorPane, codeEditor, template, offsetMarkArray, offsetMarkArray2, offsetMark);
            BasicDocument basicDocument = (BasicDocument)basicEditorPane.getDocument();
            TextBuffer textBuffer = basicDocument.getTextBuffer();
            textBuffer.addTextBufferListener((TextBufferListener)_actionHookInvoker);
            basicEditorPane.addFocusListener((FocusListener)_actionHookInvoker);
            basicEditorPane.addActionHookInvoker((ActionHookInvoker)_actionHookInvoker);
            _actionHookInvoker.start();
        } else {
            int n7 = n + template.getCursorPos();
            basicEditorPane.select(n7, n7);
        }
    }

    private static void addImports(BasicEditorPane basicEditorPane, Context context, Template template) {
        SourceImportsDesc sourceImportsDesc = SourceImportsDesc.parse(context);
        if (sourceImportsDesc != null) {
            int n;
            List list = template.getImports();
            StringBuffer stringBuffer = new StringBuffer();
            for (String string : list) {
                if (sourceImportsDesc.hasImport(string)) continue;
                stringBuffer.append("\nimport ");
                stringBuffer.append(string);
                stringBuffer.append(';');
            }
            if (stringBuffer.length() != 0 && (n = sourceImportsDesc.getEndImportPosition()) != -1) {
                int n2 = basicEditorPane.getSelectionStart();
                basicEditorPane.select(n, n);
                String string = stringBuffer.toString();
                basicEditorPane.replaceSelection(string);
                basicEditorPane.select(n2 += string.length(), n2);
            }
        }
    }

    protected static BasicEditorPane getEditor(Context context) {
        View view;
        BasicEditorPane basicEditorPane = null;
        if (context != null && (view = context.getView()) instanceof CodeEditor) {
            CodeEditor codeEditor = (CodeEditor)view;
            basicEditorPane = codeEditor.getFocusedEditorPane();
        }
        return basicEditorPane;
    }

    protected static CodeEditor getCodeEditor(Context context) {
        View view;
        CodeEditor codeEditor = null;
        if (context != null && (view = context.getView()) instanceof CodeEditor) {
            codeEditor = (CodeEditor)view;
        }
        return codeEditor;
    }

    private void initializeDynamicActions() {
        Menubar menubar = Ide.getMenubar();
        JMenuItem jMenuItem = menubar.createMenuItem((ToggleAction)actionExpand, 130.0f);
        jMenuItem.putClientProperty("menu-section-id", new Float(1.0f));
        this.dynamicItems = new JComponent[]{jMenuItem};
    }

    public JComponent[] gatherDynamicActions(Context context) {
        View view = context.getView();
        if (view instanceof CodeEditor) {
            return this.dynamicItems;
        }
        return new JComponent[0];
    }

    public boolean handleEvent(IdeAction ideAction, Context context) {
        boolean bl = false;
        int n = ideAction.getCommandId();
        if (n == ACTION_ID) {
            if (_actionHookInvoker != null) {
                _actionHookInvoker.finished(false);
            }
            if (_templateInsight == null && _actionHookInvoker == null) {
                BasicEditorPane basicEditorPane = TemplateController.getEditor(context);
                if (basicEditorPane != null && basicEditorPane.isEditable()) {
                    int n2;
                    int n3 = basicEditorPane.getSelectionStart();
                    Template template = this.getTemplate(context, n3, n2 = basicEditorPane.getSelectionEnd());
                    if (template != null) {
                        try {
                            try {
                                basicEditorPane.beginEdit(new EditDescriptor(TemplateArb.getString(10)));
                                TemplateController.replace(basicEditorPane, TemplateController.getCodeEditor(context), n2, template);
                                TemplateController.addImports(basicEditorPane, context, template);
                            }
                            catch (BadLocationException badLocationException) {
                                badLocationException.printStackTrace();
                            }
                        }
                        finally {
                            basicEditorPane.endEdit();
                        }
                    } else {
                        Toolkit.getDefaultToolkit().beep();
                    }
                }
                bl = true;
            }
        }
        return bl;
    }

    public static void insertCustomTemplate(Context context, Template template, String string) {
        BasicEditorPane basicEditorPane = TemplateController.getEditor(context);
        if (basicEditorPane != null && basicEditorPane.isEditable()) {
            int n = basicEditorPane.getSelectionEnd();
            if (template != null) {
                try {
                    try {
                        basicEditorPane.beginEdit(new EditDescriptor(string));
                        TemplateController.replace(basicEditorPane, TemplateController.getCodeEditor(context), n, template);
                        TemplateController.addImports(basicEditorPane, context, template);
                    }
                    catch (BadLocationException badLocationException) {
                        badLocationException.printStackTrace();
                    }
                }
                finally {
                    basicEditorPane.endEdit();
                }
            }
        }
    }

    public static void insertCustomTemplate(Context context, Template template) {
        TemplateController.insertCustomTemplate(context, template, TemplateArb.getString(10));
    }

    public boolean update(IdeAction ideAction, Context context) {
        if (ideAction == actionExpand) {
            this.updateActionExpand(context);
            return true;
        }
        return false;
    }

    private void updateActionExpand(Context context) {
        BasicEditorPane basicEditorPane = TemplateController.getEditor(context);
        actionExpand.setEnabled(basicEditorPane != null && basicEditorPane.isEditable());
    }

    static void maS$replace(BasicEditorPane basicEditorPane, CodeEditor codeEditor, int n, Template template) {
        TemplateController.replace(basicEditorPane, codeEditor, n, template);
    }

    static void maS$addImports(BasicEditorPane basicEditorPane, Context context, Template template) {
        TemplateController.addImports(basicEditorPane, context, template);
    }

    static void maS$removeOffsetMark(BasicEditorPane basicEditorPane, OffsetMark offsetMark) {
        TemplateController.removeOffsetMark(basicEditorPane, offsetMark);
    }

    static HighlightStyle ra$HIGHLIGHT_STYLE() {
        return HIGHLIGHT_STYLE;
    }

    static OffsetMark maS$addOffsetMark(BasicEditorPane basicEditorPane, int n) {
        return TemplateController.addOffsetMark(basicEditorPane, n);
    }

    static class TemplateItem
    extends HintChoice {
        private Template _template;

        public TemplateItem(Template template) {
            super(template.getShortcut(), template.getDescription());
            this._template = template;
        }

        public Template getTemplate() {
            return this._template;
        }

        public Icon getIcon() {
            return null;
        }

        public String getDisplayText() {
            return this._template.getShortcut() + " " + this._template.getDescription();
        }
    }

    class TemplateListData
    implements ListInsightData {
        String _filter;
        private ListDataItem[] asData;
        private ListDataItem[] filteredData;
        private ListModel asModel;
        private Template _selectedTemplate;

        void $init$() {
            this._filter = "";
        }

        public TemplateListData(TemplateItem[] templateItemArray, String string) {
            this.$init$();
            this.asData = templateItemArray;
            this._filter = string;
            this.updateFilteredDatas();
        }

        public Template getTemplate() {
            return this._selectedTemplate;
        }

        public String getFilter() {
            return this._filter;
        }

        private void updateFilteredDatas() {
            ArrayList<ListDataItem> arrayList = new ArrayList<ListDataItem>(this.asData.length);
            int n = 0;
            while (n < this.asData.length) {
                ListDataItem listDataItem = this.asData[n];
                if (listDataItem.getName().toLowerCase().startsWith(this._filter)) {
                    arrayList.add(listDataItem);
                }
                ++n;
            }
            this.filteredData = new ListDataItem[arrayList.size()];
            this.filteredData = arrayList.toArray(this.filteredData);
        }

        public boolean backSpace() {
            if (this._filter.length() != 0) {
                this._filter = this._filter.substring(0, this._filter.length() - 1).toLowerCase();
                this.updateFilteredDatas();
                return true;
            }
            return false;
        }

        public void charTyped(char c) {
            this._filter = this._filter + Character.toLowerCase(c);
            this.updateFilteredDatas();
        }

        public ListModel getListModel() {
            if (this.asModel == null) {
                this.asModel = new ListDataItemListModel(this.asData);
            }
            return this.asModel;
        }

        public Object[] getData() {
            return this.asData;
        }

        public Object[] getMatchingData() {
            return this.filteredData;
        }

        public int getMatchingDataCount() {
            return this.filteredData.length;
        }

        public Object getDefault() {
            if (this.filteredData.length > 0) {
                return this.filteredData[0];
            }
            return null;
        }

        public boolean complete(Object object) {
            TemplateItem templateItem = (TemplateItem)((Object)object);
            this._selectedTemplate = templateItem.getTemplate();
            return false;
        }

        public void partialComplete() {
        }
    }

    class TemplateListInsight
    extends AbstractInsight
    implements InsightProvider {
        private BasicEditorPane _editor;
        private Context _context;
        private int _lastOffset;
        private TemplateListData asData;
        private Rectangle asRect;

        TemplateListInsight(Context context, TemplateItem[] templateItemArray, String string, Rectangle rectangle) {
            this._context = context;
            this._editor = TemplateController.getEditor(context);
            this.asData = new TemplateListData(templateItemArray, string);
            this.asRect = rectangle;
        }

        public void install(BasicEditorPane basicEditorPane) {
            super.install(basicEditorPane);
            this._lastOffset = this._editor.getCaretPosition();
        }

        public void deinstall(BasicEditorPane basicEditorPane) {
            super.deinstall(basicEditorPane);
        }

        protected InsightProvider createInsightProvider() {
            return this;
        }

        public boolean isInsightTriggerChar(char c) {
            return false;
        }

        public void characterTyped(BasicEditorPane basicEditorPane, int n, char c) {
            this._lastOffset = this._editor.getCaretPosition();
            this.asData.charTyped(c);
            this.updateInsight();
        }

        public Rectangle getShowRectangle() {
            return this.asRect;
        }

        public void hideInsight() {
            super.hideInsight();
            if (_templateInsight != null) {
                this._editor.deinstallPlugin((EditorPlugin)_templateInsight);
            }
            _templateInsight = null;
        }

        protected int[] getPreferredLocations() {
            return AbstractInsight.COMPLETION_LOCATIONS;
        }

        public InsightData getInsightData(BasicEditorPane basicEditorPane) {
            return this.asData;
        }

        public InsightData updateInsightData(BasicEditorPane basicEditorPane, InsightData insightData) {
            if (this._editor.getCaretPosition() < this._lastOffset - 1 || this._editor.getCaretPosition() > this._lastOffset + 1) {
                return null;
            }
            return insightData;
        }

        public InsightView getInsightView() {
            return new ListInsightView((ListCellRenderer)new TemplateHintCellRenderer());
        }

        public boolean invokeAction(String string) {
            boolean bl = super.invokeAction(string);
            if (string.equals("cancel")) {
                return true;
            }
            if (string.equals("insert-break")) {
                this.hideInsight();
                try {
                    try {
                        Template template = this.asData.getTemplate();
                        String string2 = this.asData.getFilter();
                        String string3 = template.getShortcut();
                        int n = this._editor.getCaretPosition();
                        this._editor.beginEdit(new EditDescriptor(TemplateArb.getString(10)));
                        this._editor.select(n - string2.length(), n);
                        this._editor.replaceSelection(string3);
                        TemplateController.maS$replace(this._editor, TemplateController.getCodeEditor(this._context), n += string3.length() - string2.length(), template);
                        TemplateController.maS$addImports(this._editor, this._context, template);
                    }
                    catch (Exception exception) {
                        exception.printStackTrace();
                    }
                }
                finally {
                    this._editor.endEdit();
                }
                return true;
            }
            if (string.equals("delete-previous")) {
                this._lastOffset = this._editor.getCaretPosition();
                if (this.asData.backSpace()) {
                    this.updateInsight();
                }
                return bl;
            }
            return bl;
        }
    }

    static class TemplateActionHookInvoker
    implements FocusListener,
    TextBufferListener,
    ActionHookInvoker {
        BasicEditorPane _editor;
        Template _t;
        OffsetMark[] _starts;
        OffsetMark[] _ends;
        int _curvar;
        HighlightLayer _highlights;
        OffsetMark _endMark;
        CodeEditor _ce;
        boolean _updating;
        TemplateAssistInsight _assistInsight;

        void $init$() {
            this._curvar = 0;
        }

        public TemplateActionHookInvoker(BasicEditorPane basicEditorPane, CodeEditor codeEditor, Template template, OffsetMark[] offsetMarkArray, OffsetMark[] offsetMarkArray2, OffsetMark offsetMark) {
            this.$init$();
            this._editor = basicEditorPane;
            this._t = template;
            this._ce = codeEditor;
            this._starts = offsetMarkArray;
            this._ends = offsetMarkArray2;
            this._endMark = offsetMark;
            this._highlights = this._editor.createHighlightLayer();
            this._curvar = 0;
        }

        public boolean start() {
            while (this._curvar < this._t.getFieldCount() && !this._t.canEditField(this._curvar)) {
                ++this._curvar;
            }
            if (this._curvar < this._t.getFieldCount()) {
                this.highlightVar(this._curvar);
            } else {
                this.finished(true);
            }
            return true;
        }

        private void highlightVar(int n) {
            int[] nArray = this._t.getFieldPositions(n);
            int n2 = 0;
            while (n2 < nArray.length) {
                this._highlights.addHighlight(TemplateController.ra$HIGHLIGHT_STYLE(), this._starts[nArray[n2]].getOffset(), this._ends[nArray[n2]].getOffset());
                ++n2;
            }
            this._editor.select(this._starts[nArray[0]].getOffset(), this._ends[nArray[0]].getOffset());
            this.showInsight(this._t.getFieldHints(this._ce, n, this._ends[nArray[0]].getOffset()));
        }

        private boolean isUndoDetected() {
            int n = this._endMark.getOffset();
            int n2 = 0;
            while (n2 < this._starts.length) {
                if (this._starts[n2].getOffset() != n) {
                    return false;
                }
                ++n2;
            }
            return true;
        }

        protected void finished(boolean bl) {
            int n = 0;
            while (n < this._starts.length) {
                TemplateController.maS$removeOffsetMark(this._editor, this._starts[n]);
                TemplateController.maS$removeOffsetMark(this._editor, this._ends[n]);
                ++n;
            }
            if (bl) {
                this._editor.select(this._endMark.getOffset(), this._endMark.getOffset());
            }
            TemplateController.maS$removeOffsetMark(this._editor, this._endMark);
            this._editor.removeActionHookInvoker((ActionHookInvoker)this);
            this._editor.removeFocusListener((FocusListener)this);
            BasicDocument basicDocument = (BasicDocument)this._editor.getDocument();
            TextBuffer textBuffer = basicDocument.getTextBuffer();
            textBuffer.removeTextBufferListener((TextBufferListener)this);
            this._editor.destroyHighlightLayer(this._highlights);
            TemplateController.clearHook();
        }

        private String getCurrentZone(int n, int n2) {
            int[] nArray = this._t.getFieldPositions(this._curvar);
            try {
                String string;
                int n3 = this._starts[nArray[0]].getOffset();
                int n4 = this._ends[nArray[0]].getOffset();
                if (n2 < n3 || n > n4) {
                    String string2 = null;
                    return string2;
                }
                String string3 = string = this._editor.getText(n3, n4 - n3);
                return string3;
            }
            catch (Exception exception) {
                exception.printStackTrace();
                return "";
            }
        }

        private void setCurrentField(String string) {
            this._updating = true;
            int[] nArray = this._t.getFieldPositions(this._curvar);
            try {
                this._editor.beginEdit(new EditDescriptor(TemplateArb.getString(10)));
                TemplateController.replaceFieldAtPos(this._editor, nArray[0], string, this._starts, this._ends);
                this.updateRelatedFields();
                this._editor.endEdit(true);
            }
            catch (Exception exception) {
                exception.printStackTrace();
            }
            this._updating = false;
        }

        private void updateRelatedFields() {
            this._updating = true;
            int[] nArray = this._t.getFieldPositions(this._curvar);
            try {
                boolean bl;
                int n = this._starts[nArray[0]].getOffset();
                int n2 = this._ends[nArray[0]].getOffset();
                String string = this._editor.getText(n, n2 - n);
                this._t.setValueAndOffset(this._curvar, string, this._starts[nArray[0]], true);
                int n3 = 1;
                while (n3 < nArray.length) {
                    TemplateController.replaceFieldAtPos(this._editor, nArray[n3], string, this._starts, this._ends);
                    ++n3;
                }
                String[] stringArray = new String[this._t.getFieldCount()];
                int n4 = 0;
                while (n4 < this._t.getFieldCount()) {
                    if (this._t.canCalculateField(this._ce, n4)) {
                        stringArray[n4] = this._t.guessFieldValue(this._ce, n4, 0, null);
                        this._t.setValueAndOffset(n4, null, null, false);
                    }
                    ++n4;
                }
                do {
                    bl = false;
                    int n5 = 0;
                    while (n5 < this._t.getFieldCount()) {
                        if (this._t.canCalculateField(this._ce, n5)) {
                            nArray = this._t.getFieldPositions(n5);
                            string = this._t.getFieldValue(this._ce, n5, this._starts[nArray[0]].getOffset(), false, stringArray[n5]);
                            if (string != null) {
                                int n6 = 0;
                                while (n6 < nArray.length) {
                                    TemplateController.replaceFieldAtPos(this._editor, nArray[n6], string, this._starts, this._ends);
                                    ++n6;
                                }
                                this._t.setValueAndOffset(n5, string, this._starts[nArray[0]], false);
                            } else {
                                bl = true;
                            }
                        }
                        ++n5;
                    }
                } while (bl);
                this.highlightVar(this._curvar);
            }
            catch (Exception exception) {
                exception.printStackTrace();
            }
            this._updating = false;
        }

        private synchronized void dynamicUpdate() {
            this._updating = true;
            if (this.isUndoDetected()) {
                this.finished(true);
            } else {
                SwingUtilities.invokeLater(new 1());
            }
        }

        private void showInsight(HintChoice[] hintChoiceArray) {
            HintChoice[] hintChoiceArray2 = hintChoiceArray;
            if (hintChoiceArray.length > 1) {
                Rectangle rectangle;
                int n = this._ce.getCaretPosition();
                try {
                    rectangle = this._editor.getUI().modelToView((JTextComponent)this._editor, n);
                }
                catch (BadLocationException badLocationException) {
                    rectangle = null;
                }
                if (this._assistInsight == null) {
                    this._assistInsight = new TemplateAssistInsight(hintChoiceArray2, rectangle);
                    this._editor.installPlugin((EditorPlugin)this._assistInsight);
                    this._assistInsight.showInsight();
                }
            }
        }

        void clearInsight() {
            if (this._assistInsight != null) {
                this._editor.deinstallPlugin((EditorPlugin)this._assistInsight);
            }
            this._assistInsight = null;
        }

        public void focusGained(FocusEvent focusEvent) {
        }

        public void focusLost(FocusEvent focusEvent) {
            this.finished(false);
        }

        public void insertUpdate(TextBuffer textBuffer, int n, int n2, char[] cArray) {
            if (this._updating) {
                return;
            }
            String string = this.getCurrentZone(n, n + n2);
            if (string != null) {
                this.dynamicUpdate();
            } else {
                this.finished(false);
            }
        }

        public void removeUpdate(TextBuffer textBuffer, int n, int n2, char[] cArray) {
            if (this.isUndoDetected()) {
                this.finished(true);
                return;
            }
            if (this._updating) {
                return;
            }
            String string = this.getCurrentZone(n, n);
            if (string != null) {
                this.dynamicUpdate();
            } else {
                this.finished(false);
            }
        }

        public void attributeUpdate(TextBuffer textBuffer, int n) {
        }

        private void nextField() {
            this._highlights.removeAllHighlights();
            this.clearInsight();
            ++this._curvar;
            while (this._curvar < this._t.getFieldCount() && !this._t.canEditField(this._curvar)) {
                ++this._curvar;
            }
            if (this._curvar < this._t.getFieldCount()) {
                this.highlightVar(this._curvar);
            } else {
                this.finished(true);
            }
        }

        private void prevField() {
            int n = this._curvar;
            --n;
            while (n >= 0 && !this._t.canEditField(n)) {
                --n;
            }
            if (n >= 0) {
                this._highlights.removeAllHighlights();
                this.clearInsight();
                this._curvar = n;
                this.highlightVar(this._curvar);
            }
        }

        private void waitForUpdatesFinished() {
            while (this._updating) {
                try {
                    Thread.sleep(10);
                }
                catch (Exception exception) {
                    // empty catch block
                }
            }
        }

        public synchronized boolean invokeAction(String string) {
            if (string.equals("cancel")) {
                if (this._assistInsight != null) {
                    return false;
                }
                this._highlights.removeAllHighlights();
                this.finished(true);
                return true;
            }
            if (string.equals("insert-tab")) {
                this.nextField();
                return true;
            }
            if (string.equals("insert-break")) {
                if (this._assistInsight != null) {
                    return false;
                }
                int n = this._editor.getCaretPosition();
                if (this.getCurrentZone(n, n) != null) {
                    this.nextField();
                    return true;
                }
            } else if (string.equals("reverse-tab")) {
                this.prevField();
                return true;
            }
            return false;
        }

        static void mav$setCurrentField(TemplateActionHookInvoker templateActionHookInvoker, String string) {
            templateActionHookInvoker.setCurrentField(string);
        }

        static void mav$nextField(TemplateActionHookInvoker templateActionHookInvoker) {
            templateActionHookInvoker.nextField();
        }

        static boolean mav$isUndoDetected(TemplateActionHookInvoker templateActionHookInvoker) {
            return templateActionHookInvoker.isUndoDetected();
        }

        static void mav$updateRelatedFields(TemplateActionHookInvoker templateActionHookInvoker) {
            templateActionHookInvoker.updateRelatedFields();
        }

        class TemplateAssistData
        implements ListInsightData {
            private ListDataItem[] asData;
            private ListModel asModel;

            public TemplateAssistData(HintChoice[] hintChoiceArray) {
                this.asData = hintChoiceArray;
            }

            public ListModel getListModel() {
                if (this.asModel == null) {
                    this.asModel = new ListDataItemListModel(this.asData);
                }
                return this.asModel;
            }

            public Object[] getData() {
                return this.asData;
            }

            public Object[] getMatchingData() {
                return this.asData;
            }

            public int getMatchingDataCount() {
                return this.asData.length;
            }

            public Object getDefault() {
                return this.asData[0];
            }

            public boolean complete(Object object) {
                HintChoice hintChoice = (HintChoice)((Object)object);
                TemplateActionHookInvoker.mav$setCurrentField(TemplateActionHookInvoker.this, hintChoice.getName());
                return false;
            }

            public void partialComplete() {
            }
        }

        class TemplateAssistInsight
        extends AbstractInsight
        implements InsightProvider {
            private InsightData asData;
            private Rectangle asRect;

            TemplateAssistInsight(HintChoice[] hintChoiceArray, Rectangle rectangle) {
                this.asData = new TemplateAssistData(hintChoiceArray);
                this.asRect = rectangle;
            }

            public void install(BasicEditorPane basicEditorPane) {
                super.install(basicEditorPane);
            }

            public void deinstall(BasicEditorPane basicEditorPane) {
                super.deinstall(basicEditorPane);
            }

            protected InsightProvider createInsightProvider() {
                return this;
            }

            public boolean isInsightTriggerChar(char c) {
                return false;
            }

            public void characterTyped(BasicEditorPane basicEditorPane, int n, char c) {
            }

            public Rectangle getShowRectangle() {
                return this.asRect;
            }

            protected void updateInsight() {
            }

            public void hideInsight() {
                super.hideInsight();
                TemplateActionHookInvoker.this.clearInsight();
            }

            protected int[] getPreferredLocations() {
                return AbstractInsight.COMPLETION_LOCATIONS;
            }

            public InsightData getInsightData(BasicEditorPane basicEditorPane) {
                return this.asData;
            }

            public InsightData updateInsightData(BasicEditorPane basicEditorPane, InsightData insightData) {
                return insightData;
            }

            public InsightView getInsightView() {
                return new ListInsightView((ListCellRenderer)new TemplateHintCellRenderer());
            }

            public boolean invokeAction(String string) {
                if (string.equals("insert-tab")) {
                    TemplateActionHookInvoker.mav$nextField(TemplateActionHookInvoker.this);
                    return true;
                }
                boolean bl = super.invokeAction(string);
                if (string.equals("cancel")) {
                    return true;
                }
                if (string.equals("insert-break")) {
                    TemplateActionHookInvoker.mav$nextField(TemplateActionHookInvoker.this);
                }
                return bl;
            }
        }

        final class 1
        implements Runnable {
            public void run() {
                try {
                    if (!TemplateActionHookInvoker.mav$isUndoDetected(TemplateActionHookInvoker.this)) {
                        TemplateActionHookInvoker.this._editor.beginEdit(new EditDescriptor(TemplateArb.getString(10)));
                        int n = TemplateActionHookInvoker.this._editor.getCaretPosition();
                        OffsetMark offsetMark = TemplateController.maS$addOffsetMark(TemplateActionHookInvoker.this._editor, n);
                        TemplateActionHookInvoker.mav$updateRelatedFields(TemplateActionHookInvoker.this);
                        n = offsetMark.getOffset();
                        TemplateActionHookInvoker.this._editor.select(n, n);
                        TemplateActionHookInvoker.this._editor.endEdit(true);
                    }
                }
                catch (Exception exception) {
                    exception.printStackTrace();
                }
            }
        }
    }
}

