/*
 * Decompiled with CFR 0.152.
 */
package oracle.jdeveloper.ceditor.template;

import java.net.URL;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashSet;
import java.util.Iterator;
import oracle.ide.Context;
import oracle.ide.ceditor.CodeEditor;
import oracle.ide.model.Project;
import oracle.javatools.parser.java.v2.model.JavaClass;
import oracle.javatools.parser.java.v2.model.JavaElement;
import oracle.javatools.parser.java.v2.model.JavaMethod;
import oracle.javatools.parser.java.v2.model.JavaType;
import oracle.javatools.parser.java.v2.model.JavaVariable;
import oracle.javatools.parser.java.v2.model.SourceBlock;
import oracle.javatools.parser.java.v2.model.SourceClass;
import oracle.javatools.parser.java.v2.model.SourceElement;
import oracle.javatools.parser.java.v2.model.SourceFile;
import oracle.javatools.parser.java.v2.model.SourceLocalVariable;
import oracle.javatools.parser.java.v2.model.SourceMethod;
import oracle.javatools.parser.java.v2.model.expression.SourceExpression;
import oracle.javatools.parser.java.v2.model.expression.SourceMethodCallExpression;
import oracle.javatools.parser.java.v2.model.statement.SourceForStatement;
import oracle.jdeveloper.ceditor.template.HintChoice;
import oracle.jdeveloper.ceditor.template.TemplateContext;
import oracle.jdeveloper.java.JavaManager;

public class TemplateJotUtils {
    private static final int WANT_LOCALS = 1;
    private static final int WANT_ARGUMENTS = 2;
    private static final int WANT_FIELDS = 4;
    private static final int WANT_ALL = 7;

    private static SourceFile getSourceFile(Context context) {
        SourceFile sourceFile = null;
        Project project = context.getProject();
        if (project instanceof Project) {
            Project project2 = project;
            JavaManager javaManager = JavaManager.getJavaManager(project2);
            URL uRL = context.getNode().getURL();
            sourceFile = javaManager.getSourceFile(uRL);
        }
        return sourceFile;
    }

    private static JavaType getJavaType(String string, Context context) {
        JavaClass javaClass = null;
        if (string == null) {
            return null;
        }
        Project project = context.getProject();
        if (project instanceof Project) {
            Project project2 = project;
            JavaManager javaManager = JavaManager.getJavaManager(project2);
            int n = string.lastIndexOf(36);
            if (n != -1) {
                return null;
            }
            javaClass = javaManager.getClass(string);
        }
        return javaClass;
    }

    private static SourceElement getDeepestElement(SourceElement sourceElement, int n) {
        SourceElement[] sourceElementArray = sourceElement.getContainedElements();
        int n2 = 0;
        while (n2 < sourceElementArray.length) {
            if (n >= sourceElementArray[n2].getStartOffset() && n < sourceElementArray[n2].getEndOffset()) {
                return TemplateJotUtils.getDeepestElement(sourceElementArray[n2], n);
            }
            ++n2;
        }
        return sourceElement;
    }

    private static SourceElement getCurrentJotElement(CodeEditor codeEditor, int n) {
        SourceFile sourceFile;
        Context context = codeEditor.getContext();
        SourceFile sourceFile2 = sourceFile = TemplateJotUtils.getSourceFile(context);
        return TemplateJotUtils.getDeepestElement((SourceElement)sourceFile2, n);
    }

    private static SourceMethod getCurrentJotMethod(CodeEditor codeEditor, int n) {
        SourceElement sourceElement = TemplateJotUtils.getCurrentJotElement(codeEditor, n);
        while (sourceElement != null && sourceElement.getSymbolKind() != 19 && sourceElement.getSymbolKind() != 6) {
            sourceElement = sourceElement.getParent();
        }
        return (SourceMethod)sourceElement;
    }

    private static SourceClass getCurrentJotClass(CodeEditor codeEditor, int n) {
        SourceElement sourceElement = TemplateJotUtils.getCurrentJotElement(codeEditor, n);
        while (sourceElement != null && sourceElement.getSymbolKind() != 3) {
            sourceElement = sourceElement.getParent();
        }
        return (SourceClass)sourceElement;
    }

    public static String getCurrentMethodName(TemplateContext templateContext, int n) {
        SourceMethod sourceMethod = TemplateJotUtils.getCurrentJotMethod(templateContext.getCodeEditor(), n);
        if (sourceMethod != null) {
            return sourceMethod.getName();
        }
        return "<ERROR>";
    }

    public static String getCurrentClassName(TemplateContext templateContext, int n) {
        JavaClass javaClass;
        SourceClass sourceClass = TemplateJotUtils.getCurrentJotClass(templateContext.getCodeEditor(), n);
        if (sourceClass != null) {
            return sourceClass.getName();
        }
        SourceFile sourceFile = TemplateJotUtils.getSourceFile(templateContext.getCodeEditor().getContext());
        if (sourceFile != null && (javaClass = sourceFile.getPrimaryClass()) != null) {
            return javaClass.getName();
        }
        return "<ERROR>";
    }

    public static String getCurrentPackageName(TemplateContext templateContext, int n) {
        SourceFile sourceFile = TemplateJotUtils.getSourceFile(templateContext.getCodeEditor().getContext());
        if (sourceFile != null) {
            return sourceFile.getPackageName();
        }
        return "<ERROR>";
    }

    private static ArrayList getCurrentMethodJotParameters(CodeEditor codeEditor, int n, JavaType javaType) {
        ArrayList<VarIdentifier> arrayList = new ArrayList<VarIdentifier>();
        SourceMethod sourceMethod = TemplateJotUtils.getCurrentJotMethod(codeEditor, n);
        if (sourceMethod != null) {
            Iterator iterator = sourceMethod.getParameters().iterator();
            while (iterator.hasNext()) {
                VarIdentifier varIdentifier = new VarIdentifier((JavaVariable)iterator.next());
                if (!varIdentifier.isOfType(javaType)) continue;
                arrayList.add(varIdentifier);
            }
        }
        return arrayList;
    }

    public static ArrayList getCurrentMethodJotParameters(CodeEditor codeEditor, int n) {
        return TemplateJotUtils.getCurrentMethodJotParameters(codeEditor, n, null);
    }

    public static String[] getCurrentMethodArguments(TemplateContext templateContext, int n) {
        ArrayList arrayList = TemplateJotUtils.getCurrentMethodJotParameters(templateContext.getCodeEditor(), n);
        String[] stringArray = new String[arrayList.size()];
        int n2 = 0;
        while (n2 < stringArray.length) {
            Identifier identifier = (Identifier)arrayList.get(n2);
            stringArray[n2] = identifier.getName();
            ++n2;
        }
        return stringArray;
    }

    private static ArrayList getCurrentMethodJotFields(CodeEditor codeEditor, int n, JavaType javaType) {
        ArrayList<VarIdentifier> arrayList = new ArrayList<VarIdentifier>();
        boolean bl = false;
        SourceElement sourceElement = TemplateJotUtils.getCurrentJotElement(codeEditor, n);
        int n2 = sourceElement.getSymbolKind();
        while (sourceElement != null && n2 != 11) {
            SourceElement sourceElement2 = sourceElement;
            Iterator iterator = null;
            switch (n2) {
                case 19: {
                    SourceMethod sourceMethod = (SourceMethod)sourceElement2;
                    if ((sourceMethod.getModifiers() & 8) == 0) break;
                    bl = true;
                    break;
                }
                case 3: {
                    SourceClass sourceClass = (SourceClass)sourceElement2;
                    iterator = sourceClass.getDeclaredFields().iterator();
                }
            }
            if (iterator != null) {
                while (iterator.hasNext()) {
                    VarIdentifier varIdentifier;
                    JavaVariable javaVariable = (JavaVariable)iterator.next();
                    if (bl && (javaVariable.getModifiers() & 8) == 0 || !(varIdentifier = new VarIdentifier(javaVariable)).isOfType(javaType)) continue;
                    arrayList.add(varIdentifier);
                }
            }
            sourceElement = sourceElement.getParent();
            n2 = sourceElement.getSymbolKind();
        }
        return arrayList;
    }

    private static ArrayList getCurrentMethodJotFields(CodeEditor codeEditor, int n) {
        return TemplateJotUtils.getCurrentMethodJotFields(codeEditor, n, null);
    }

    private static String typeFromSpecID(ArrayList arrayList, String string) {
        int n = arrayList.size() - 1;
        while (n >= 0) {
            String string2 = (String)arrayList.get(n);
            if (string2.startsWith(string)) {
                return string2.substring(string.length() + 1);
            }
            --n;
        }
        return null;
    }

    private static boolean isPrimitiveType(String string) {
        return string.equals("int") || string.equals("char") || string.equals("byte") || string.equals("short") || string.equals("long") || string.equals("float") || string.equals("double");
    }

    private static void addAssigns(HashSet hashSet, SourceElement sourceElement, SourceElement sourceElement2, String[] stringArray, int[] nArray) {
        if (sourceElement != null) {
            int n = sourceElement.getSymbolKind();
            switch (n) {
                case 54: {
                    JavaMethod javaMethod;
                    SourceElement sourceElement3;
                    SourceMethodCallExpression sourceMethodCallExpression = (SourceMethodCallExpression)sourceElement;
                    SourceExpression sourceExpression = sourceMethodCallExpression.getLhsOperand();
                    if (sourceExpression == null || sourceElement2 != (sourceElement3 = sourceExpression.getCompiledObject().getSourceElement()) || (javaMethod = sourceMethodCallExpression.getResolvedMethod()) == null) break;
                    String string = javaMethod.getName();
                    int n2 = 0;
                    while (n2 < stringArray.length) {
                        SourceExpression sourceExpression2;
                        int n3;
                        if (stringArray[n2].equals(string) && (n3 = (sourceExpression2 = sourceMethodCallExpression.getSecondOperand()).getOperandCount()) >= nArray[n2]) {
                            SourceExpression sourceExpression3 = sourceExpression2.getOperandAt(n3 - nArray[n2]);
                            JavaType javaType = sourceExpression3.getResolvedType();
                            String string2 = javaType.getQualifiedName();
                            hashSet.add(string2);
                        }
                        ++n2;
                    }
                    break;
                }
            }
            Iterator iterator = sourceElement.getChildren().iterator();
            while (iterator.hasNext()) {
                TemplateJotUtils.addAssigns(hashSet, (SourceElement)iterator.next(), sourceElement2, stringArray, nArray);
            }
        }
    }

    public static ArrayList getCurrentAssigns(CodeEditor codeEditor, int n, String string, String[] stringArray, int[] nArray) {
        HashSet hashSet = new HashSet();
        boolean bl = true;
        SourceElement sourceElement = TemplateJotUtils.getCurrentJotElement(codeEditor, n);
        SourceElement sourceElement2 = null;
        while (sourceElement != null && sourceElement2 == null) {
            int n2 = sourceElement.getSymbolKind();
            switch (n2) {
                case 54: {
                    JavaElement javaElement;
                    SourceMethodCallExpression sourceMethodCallExpression = (SourceMethodCallExpression)sourceElement;
                    SourceExpression sourceExpression = sourceMethodCallExpression.getLhsOperand();
                    if (sourceExpression == null || (javaElement = sourceExpression.getCompiledObject()) == null) break;
                    sourceElement2 = javaElement.getSourceElement();
                }
            }
            sourceElement = sourceElement.getParent();
        }
        SourceElement sourceElement3 = null;
        SourceElement sourceElement4 = sourceElement2;
        while (sourceElement4 != null && sourceElement3 == null) {
            int n3 = sourceElement4.getSymbolKind();
            switch (n3) {
                case 2: 
                case 4: {
                    sourceElement3 = sourceElement4;
                }
            }
            sourceElement4 = sourceElement4.getParent();
        }
        TemplateJotUtils.addAssigns(hashSet, sourceElement3, sourceElement2, stringArray, nArray);
        return new ArrayList(hashSet);
    }

    private static ArrayList getCurrentMethodJotLocalVariables(CodeEditor codeEditor, int n, JavaType javaType) {
        ArrayList<VarIdentifier> arrayList = new ArrayList<VarIdentifier>();
        SourceElement sourceElement = TemplateJotUtils.getCurrentJotElement(codeEditor, n);
        int n2 = sourceElement.getSymbolKind();
        while (sourceElement != null && n2 != 3) {
            SourceElement sourceElement2 = sourceElement;
            Iterator iterator = null;
            switch (n2) {
                case 2: {
                    SourceBlock sourceBlock = (SourceBlock)sourceElement;
                    Collection collection = sourceBlock.getLocalVariables();
                    iterator = collection.iterator();
                    break;
                }
                case 39: {
                    SourceForStatement sourceForStatement = (SourceForStatement)sourceElement;
                    if (sourceForStatement.getForType() != 1) break;
                    iterator = sourceForStatement.getForVariables().iterator();
                }
            }
            if (iterator != null) {
                while (iterator.hasNext()) {
                    VarIdentifier varIdentifier;
                    SourceLocalVariable sourceLocalVariable = (SourceLocalVariable)iterator.next();
                    if (sourceLocalVariable.getStartOffset() >= n || !(varIdentifier = new VarIdentifier((JavaVariable)sourceLocalVariable)).isOfType(javaType)) continue;
                    arrayList.add(varIdentifier);
                }
            }
            if ((sourceElement = sourceElement.getParent()) == null) continue;
            n2 = sourceElement.getSymbolKind();
        }
        return arrayList;
    }

    private static void recAddInterfaces(ArrayList arrayList, JavaType javaType, String string) {
        for (JavaType javaType2 : javaType.getInterfaces()) {
            String string2 = javaType2.getName();
            if (arrayList.contains(string2)) continue;
            arrayList.add(string2 + string);
        }
        for (JavaType javaType3 : javaType.getInterfaces()) {
            String string3 = javaType3.getName();
            if (arrayList.contains(string3)) continue;
            TemplateJotUtils.recAddInterfaces(arrayList, javaType3, string);
        }
    }

    public static ArrayList getJotClassesFromClass(String string, CodeEditor codeEditor, int n) {
        ArrayList<String> arrayList = new ArrayList<String>();
        String string2 = "";
        int n2 = string.indexOf(91);
        if (n2 != -1) {
            string2 = string.substring(n2);
            string = string.substring(0, n2);
        }
        JavaType javaType = TemplateJotUtils.getJavaType(string, codeEditor.getContext());
        while (javaType != null) {
            JavaType javaType2;
            String string3 = javaType.getName();
            if (!arrayList.contains(string3)) {
                arrayList.add(string3 + string2);
            }
            if ((javaType2 = javaType.getSuperclass()) != null && !arrayList.contains(string3 = javaType2.getName())) {
                arrayList.add(string3 + string2);
            }
            string3 = javaType.getName();
            TemplateJotUtils.recAddInterfaces(arrayList, javaType, string2);
            javaType = javaType.getSuperclass();
        }
        return arrayList;
    }

    private static ArrayList combineClassesList(ArrayList arrayList, ArrayList arrayList2) {
        if (arrayList == null) {
            return arrayList2;
        }
        if (arrayList2 == null) {
            return arrayList;
        }
        if (arrayList.size() > arrayList2.size()) {
            return TemplateJotUtils.combineClassesList(arrayList2, arrayList);
        }
        ArrayList arrayList3 = new ArrayList();
        int n = 0;
        while (n < arrayList.size()) {
            if (arrayList2.contains(arrayList.get(n))) {
                arrayList3.add(arrayList.get(n));
            }
            ++n;
        }
        return arrayList3;
    }

    public static ArrayList getCurrentMethodJotLocalVariables(CodeEditor codeEditor, int n) {
        return TemplateJotUtils.getCurrentMethodJotLocalVariables(codeEditor, n, null);
    }

    private static ArrayList getCurrentJotIdentifierOfType(CodeEditor codeEditor, int n, int n2, JavaType javaType) {
        ArrayList arrayList;
        ArrayList arrayList2 = new ArrayList();
        if ((n2 & 1) != 0) {
            arrayList = TemplateJotUtils.getCurrentMethodJotLocalVariables(codeEditor, n, javaType);
            arrayList2.addAll(arrayList);
        }
        if ((n2 & 2) != 0) {
            arrayList = TemplateJotUtils.getCurrentMethodJotParameters(codeEditor, n, javaType);
            arrayList2.addAll(arrayList);
        }
        if ((n2 & 4) != 0) {
            arrayList = TemplateJotUtils.getCurrentMethodJotFields(codeEditor, n, javaType);
            arrayList2.addAll(arrayList);
        }
        return arrayList2;
    }

    public static String[] getCurrentMethodLocals(TemplateContext templateContext, int n) {
        ArrayList arrayList = TemplateJotUtils.getCurrentMethodJotLocalVariables(templateContext.getCodeEditor(), n);
        String[] stringArray = new String[arrayList.size()];
        int n2 = 0;
        while (n2 < stringArray.length) {
            Identifier identifier = (Identifier)arrayList.get(n2);
            stringArray[n2] = identifier.getName();
            ++n2;
        }
        return stringArray;
    }

    public static String shortClassName(String string) {
        string = string.substring(string.lastIndexOf(46) + 1);
        string = string.substring(string.lastIndexOf(36) + 1);
        return string;
    }

    public static HintChoice[] getCurrentHintsArraysIdentifiersOfType(TemplateContext templateContext, int n, String string) {
        CodeEditor codeEditor = templateContext.getCodeEditor();
        JavaType javaType = TemplateJotUtils.getJavaType(string, codeEditor.getContext());
        ArrayList<HintChoice> arrayList = new ArrayList<HintChoice>();
        ArrayList arrayList2 = TemplateJotUtils.getCurrentMethodJotLocalVariables(codeEditor, n, javaType);
        int n2 = 0;
        while (n2 < arrayList2.size()) {
            Identifier identifier = (Identifier)arrayList2.get(n2);
            if (identifier.isArray()) {
                arrayList.add(new HintChoice(identifier.getName(), TemplateJotUtils.shortClassName(identifier.getType().getName()), 1));
            }
            ++n2;
        }
        arrayList2 = TemplateJotUtils.getCurrentMethodJotParameters(codeEditor, n, javaType);
        int n3 = 0;
        while (n3 < arrayList2.size()) {
            Identifier identifier = (Identifier)arrayList2.get(n3);
            if (identifier.isArray()) {
                arrayList.add(new HintChoice(identifier.getName(), TemplateJotUtils.shortClassName(identifier.getType().getName()), 2));
            }
            ++n3;
        }
        arrayList2 = TemplateJotUtils.getCurrentMethodJotFields(codeEditor, n, javaType);
        int n4 = 0;
        while (n4 < arrayList2.size()) {
            Identifier identifier = (Identifier)arrayList2.get(n4);
            if (identifier.isArray()) {
                arrayList.add(new HintChoice(identifier.getName(), TemplateJotUtils.shortClassName(identifier.getType().getName()), 0));
            }
            ++n4;
        }
        HintChoice[] hintChoiceArray = new HintChoice[arrayList.size()];
        hintChoiceArray = arrayList.toArray(hintChoiceArray);
        return hintChoiceArray;
    }

    public static String[] getCurrentIdentifiersOfType(TemplateContext templateContext, int n, String string) {
        CodeEditor codeEditor = templateContext.getCodeEditor();
        JavaType javaType = TemplateJotUtils.getJavaType(string, codeEditor.getContext());
        ArrayList arrayList = TemplateJotUtils.getCurrentJotIdentifierOfType(codeEditor, n, 7, javaType);
        String[] stringArray = new String[arrayList.size()];
        int n2 = 0;
        int n3 = 0;
        while (n3 < stringArray.length) {
            Identifier identifier = (Identifier)arrayList.get(n3);
            stringArray[n2++] = identifier.getName();
            ++n3;
        }
        return stringArray;
    }

    public static HintChoice[] getCurrentHintsIdentifiersOfType(TemplateContext templateContext, int n, String string) {
        CodeEditor codeEditor = templateContext.getCodeEditor();
        JavaType javaType = TemplateJotUtils.getJavaType(string, codeEditor.getContext());
        ArrayList<HintChoice> arrayList = new ArrayList<HintChoice>();
        ArrayList arrayList2 = TemplateJotUtils.getCurrentMethodJotLocalVariables(codeEditor, n, javaType);
        int n2 = 0;
        while (n2 < arrayList2.size()) {
            Identifier identifier = (Identifier)arrayList2.get(n2);
            arrayList.add(new HintChoice(identifier.getName(), TemplateJotUtils.shortClassName(identifier.getType().getName()), 1));
            ++n2;
        }
        arrayList2 = TemplateJotUtils.getCurrentMethodJotParameters(codeEditor, n, javaType);
        int n3 = 0;
        while (n3 < arrayList2.size()) {
            Identifier identifier = (Identifier)arrayList2.get(n3);
            arrayList.add(new HintChoice(identifier.getName(), TemplateJotUtils.shortClassName(identifier.getType().getName()), 2));
            ++n3;
        }
        arrayList2 = TemplateJotUtils.getCurrentMethodJotFields(codeEditor, n, javaType);
        int n4 = 0;
        while (n4 < arrayList2.size()) {
            Identifier identifier = (Identifier)arrayList2.get(n4);
            arrayList.add(new HintChoice(identifier.getName(), TemplateJotUtils.shortClassName(identifier.getType().getName()), 0));
            ++n4;
        }
        HintChoice[] hintChoiceArray = new HintChoice[arrayList.size()];
        hintChoiceArray = arrayList.toArray(hintChoiceArray);
        return hintChoiceArray;
    }

    public static String getTypeOf(TemplateContext templateContext, int n, String string) {
        CodeEditor codeEditor = templateContext.getCodeEditor();
        ArrayList arrayList = TemplateJotUtils.getCurrentJotIdentifierOfType(codeEditor, n, 7, null);
        int n2 = 0;
        while (n2 < arrayList.size()) {
            Identifier identifier = (Identifier)arrayList.get(n2);
            if (string.equals(identifier.getName())) {
                String string2 = identifier.getType().getComponentType().getName();
                int n3 = string2.lastIndexOf(46);
                string2 = string2.substring(n3 + 1);
                string2 = string2.substring(string2.lastIndexOf(36) + 1);
                return string2;
            }
            ++n2;
        }
        return "Object";
    }

    public static String getElementTypeOf(TemplateContext templateContext, int n, String string) {
        CodeEditor codeEditor = templateContext.getCodeEditor();
        ArrayList arrayList = TemplateJotUtils.getCurrentJotIdentifierOfType(codeEditor, n, 7, null);
        int n2 = 0;
        while (n2 < arrayList.size()) {
            Identifier identifier = (Identifier)arrayList.get(n2);
            if (string.equals(identifier.getName())) {
                String string2 = identifier.getType().getComponentType().getName();
                int n3 = string2.lastIndexOf(46);
                if ((string2 = string2.substring(n3 + 1)).endsWith("[]")) {
                    string2 = string2.substring(0, string2.length() - 2);
                }
                string2 = string2.substring(string2.lastIndexOf(36) + 1);
                return string2;
            }
            ++n2;
        }
        return "Object";
    }

    public static ArrayList getSmartContent(TemplateContext templateContext, int n, String string, String[] stringArray, int[] nArray) {
        CodeEditor codeEditor = templateContext.getCodeEditor();
        ArrayList arrayList = TemplateJotUtils.getCurrentAssigns(codeEditor, n, string, stringArray, nArray);
        String[] stringArray2 = new String[arrayList.size()];
        stringArray2 = arrayList.toArray(stringArray2);
        ArrayList arrayList2 = null;
        int n2 = 0;
        while (n2 < stringArray2.length) {
            ArrayList arrayList3 = TemplateJotUtils.getJotClassesFromClass(stringArray2[n2], codeEditor, 0);
            arrayList2 = TemplateJotUtils.combineClassesList(arrayList2, arrayList3);
            ++n2;
        }
        if (arrayList2 == null) {
            arrayList2 = new ArrayList();
            arrayList2.add("java.lang.Object");
        }
        return arrayList2;
    }

    public static abstract class Identifier {
        abstract String getName();

        abstract JavaType getType();

        abstract int getModifiers();

        boolean isArray() {
            JavaType javaType = this.getType();
            if (javaType != null) {
                return javaType.isArray();
            }
            return false;
        }

        static boolean isAssignable(JavaType javaType, JavaType javaType2) {
            if (javaType2.equals((Object)javaType)) {
                return true;
            }
            return javaType2.getHierarchy().contains(javaType);
        }

        boolean isOfType(JavaType javaType) {
            if (javaType == null) {
                return true;
            }
            JavaType javaType2 = this.getType();
            if (javaType2 == null) {
                return false;
            }
            return Identifier.isAssignable(javaType, javaType2);
        }

        Identifier() {
        }
    }

    public static class VarIdentifier
    extends Identifier {
        private JavaVariable _var;

        public VarIdentifier(JavaVariable javaVariable) {
            this._var = javaVariable;
        }

        String getName() {
            return this._var.getName();
        }

        JavaType getType() {
            return this._var.getResolvedType();
        }

        int getModifiers() {
            return this._var.getModifiers();
        }
    }
}

