/*
 * Decompiled with CFR 0.152.
 */
package oracle.jdeveloper.ceditor.template;

import java.io.PrintWriter;
import java.util.ArrayList;
import oracle.jdeveloper.ceditor.template.DefaultVariableProcessor;
import oracle.jdeveloper.ceditor.template.HintChoice;
import oracle.jdeveloper.ceditor.template.TemplateContext;
import oracle.jdeveloper.ceditor.template.TemplateVariableProcessor;

public class TemplateVariable
implements Comparable {
    public static final String XML_VARIABLE = "variable";
    public static final String XML_NAME = "name";
    public static final String XML_TYPE = "type";
    public static final String XML_VALUE = "value";
    public static final String XML_ISEDIT = "editable";
    private static ArrayList _registeredProcessors = new ArrayList();
    private String _name;
    private String _type;
    private String _defValue;
    private boolean _editable;
    private TemplateVariableProcessor _processor;

    static {
        TemplateVariable.registerVariableProcessor(new DefaultVariableProcessor());
    }

    void $init$() {
        this._processor = null;
    }

    public TemplateVariable(String string, String string2, String string3, boolean bl) {
        this.$init$();
        this._name = string;
        this._type = string2;
        this._defValue = string3;
        this._editable = bl;
    }

    public TemplateVariable(TemplateVariable templateVariable) {
        this(templateVariable._name, templateVariable._type, templateVariable._defValue, templateVariable._editable);
    }

    public int compareTo(Object object) {
        TemplateVariable templateVariable = (TemplateVariable)object;
        return this._name.compareTo(templateVariable._name);
    }

    public void setName(String string) {
        this._name = string;
    }

    public String getName() {
        return this._name;
    }

    public void setType(String string) {
        this._type = string;
    }

    public String getType() {
        return this._type;
    }

    public void setDefValue(String string) {
        this._defValue = string;
    }

    public String getDefValue() {
        return this._defValue;
    }

    public void setEditable(boolean bl) {
        this._editable = bl;
    }

    public boolean isEditable() {
        return this._editable;
    }

    public boolean equals(Object object) {
        return this.compareTo(object) == 0;
    }

    public static void registerVariableProcessor(TemplateVariableProcessor templateVariableProcessor) {
        _registeredProcessors.add(0, templateVariableProcessor);
    }

    private void checkProcessor(TemplateContext templateContext) {
        if (this._processor == null) {
            int n = 0;
            while (n < _registeredProcessors.size()) {
                TemplateVariableProcessor templateVariableProcessor = (TemplateVariableProcessor)_registeredProcessors.get(n);
                if (templateVariableProcessor.canProcessVariable(templateContext, this)) {
                    this._processor = templateVariableProcessor;
                    return;
                }
                ++n;
            }
            System.out.println("Warning can't find variable processor for " + this.getType());
        }
    }

    public String arrayToList(Object[] objectArray) {
        if (objectArray == null) {
            return "<NULL_LIST>";
        }
        StringBuffer stringBuffer = new StringBuffer();
        int n = 0;
        while (n < objectArray.length) {
            if (n > 0) {
                stringBuffer.append(", ");
            }
            stringBuffer.append(objectArray[n]);
            ++n;
        }
        return stringBuffer.toString();
    }

    public HintChoice[] getHints(TemplateContext templateContext, int n) {
        this.checkProcessor(templateContext);
        return this._processor.getHints(templateContext, this, n);
    }

    public boolean isCalculatedField(TemplateContext templateContext) {
        this.checkProcessor(templateContext);
        return this._processor.canProcessVariable(templateContext, this);
    }

    public String guessValue(TemplateContext templateContext, int n) {
        return this.guessValue(templateContext, n, null);
    }

    public String guessValue(TemplateContext templateContext, int n, String string) {
        this.checkProcessor(templateContext);
        return this._processor.guessValue(templateContext, this, n, string);
    }

    public void toXML(PrintWriter printWriter) {
        printWriter.println("  <variable>");
        printWriter.println("    <name><![CDATA[" + this._name + "]]></" + XML_NAME + ">");
        printWriter.println("    <type><![CDATA[" + this._type + "]]></" + XML_TYPE + ">");
        printWriter.println("    <value><![CDATA[" + this._defValue + "]]></" + XML_VALUE + ">");
        printWriter.println("    <editable>" + this._editable + "</" + XML_ISEDIT + ">");
        printWriter.println("  </variable>");
    }
}

