/*
 * Decompiled with CFR 0.152.
 */
package oracle.jdeveloper.ceditor.template;

import java.io.BufferedReader;
import java.io.BufferedWriter;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileWriter;
import java.io.InputStreamReader;
import java.io.PrintWriter;
import java.io.Reader;
import java.net.URL;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.Comparator;
import oracle.ide.ExtensionRegistry;
import oracle.ide.config.ChangeEventSource;
import oracle.javatools.util.Copyable;
import oracle.jdeveloper.ceditor.template.Template;
import oracle.jdeveloper.ceditor.template.TemplateVariable;
import oracle.xml.parser.v2.DOMParser;
import oracle.xml.parser.v2.DTD;
import oracle.xml.parser.v2.XMLDocument;
import org.w3c.dom.Element;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;

final class Templates
extends ChangeEventSource
implements Copyable {
    public static final String KEY_SETTINGS = "code-template-options";
    static final String TEMPLATES_FILE = "java.tpl";
    private static final String LANGAGE = "java";
    static final String XML_TEMPLATE = "template";
    static final String XML_ITEM = "item";
    static final String XML_ABBR = "abbr";
    static final String XML_TEXT = "text";
    static final String XML_TEXT1 = "text1";
    static final String XML_TEXT2 = "text2";
    static final String XML_IMPORT = "import";
    static final String XML_VARIABLES = "variables";
    static final String XML_DESCR = "descr";
    private ArrayList _templates;
    private int _nLongestShortcut;
    private static final String END_VARIABLE = "$end$";

    Templates() {
    }

    protected final void copyToImpl(Templates templates) {
        int n = this.getTemplateCount();
        templates._templates = new ArrayList(n);
        int n2 = 0;
        while (n2 < n) {
            Template template = this.getTemplate(n2);
            Template template2 = (Template)template.copyTo(null);
            templates._templates.add(template2);
            ++n2;
        }
        templates.postModification();
        templates.fireChangeEvent();
    }

    void toXML(PrintWriter printWriter) {
        printWriter.println("<template langage=\"java\">");
        int n = this.getTemplateCount();
        int n2 = 0;
        while (n2 < n) {
            Template template = this.getTemplate(n2);
            template.toXML(printWriter);
            ++n2;
        }
        printWriter.println("</template>");
    }

    int getTemplateCount() {
        return this._templates.size();
    }

    Template getTemplate(int n) {
        return (Template)this._templates.get(n);
    }

    public Template[] getSortedTemplates() {
        Template[] templateArray = new Template[this._templates.size()];
        templateArray = this._templates.toArray(templateArray);
        Arrays.sort(templateArray, new 2());
        return templateArray;
    }

    private int getTemplatePosByShortcut(String string) {
        int n = 0;
        while (n < this._templates.size()) {
            Template template = (Template)this._templates.get(n);
            if (string.equalsIgnoreCase(template.getShortcut())) {
                return n;
            }
            ++n;
        }
        return -1;
    }

    int addTemplate(Template template) {
        int n = this.searchTemplatePosEndingWith(template.getShortcut());
        if (n == -1) {
            n = this.getTemplateCount();
            this._templates.add(template);
        } else {
            this._templates.set(n, template);
        }
        return n;
    }

    void removeTemplate(Template template) {
        int n = this.searchTemplatePosEndingWith(template.getShortcut());
        this.removeTemplate(n);
    }

    void removeTemplate(int n) {
        if (n != -1) {
            this._templates.remove(n);
        }
    }

    private void postModification() {
        Collections.sort(this._templates, new 1());
        this.recalcLongestShortcut();
    }

    private void recalcLongestShortcut() {
        Template template;
        String string;
        this._nLongestShortcut = 0;
        if (this._templates.size() != 0 && (string = (template = this.getTemplate(0)).getShortcut()) != null) {
            this._nLongestShortcut = string.length();
        }
    }

    void load() {
        ExtensionRegistry extensionRegistry = ExtensionRegistry.getOracleRegistry();
        URL uRL = extensionRegistry.getSystemDirectory("oracle.jdeveloper");
        File file = new File(uRL.getPath(), TEMPLATES_FILE);
        this.load(file);
    }

    void save() {
        ExtensionRegistry extensionRegistry = ExtensionRegistry.getOracleRegistry();
        URL uRL = extensionRegistry.getSystemDirectory("oracle.jdeveloper");
        File file = new File(uRL.getPath(), TEMPLATES_FILE);
        this.save(file);
    }

    void load(File file) {
        this._templates = new ArrayList();
        this._nLongestShortcut = 0;
        try {
            try {
                FileInputStream fileInputStream = new FileInputStream(file);
                InputStreamReader inputStreamReader = new InputStreamReader(fileInputStream);
                BufferedReader bufferedReader = new BufferedReader(inputStreamReader);
                DOMParser dOMParser = new DOMParser();
                dOMParser.setPreserveWhitespace(false);
                dOMParser.setDoctype(new DTD());
                dOMParser.parse((Reader)bufferedReader);
                bufferedReader.close();
                XMLDocument xMLDocument = dOMParser.getDocument();
                Element element = xMLDocument.getDocumentElement();
                this.loadTemplates(element);
            }
            catch (Exception exception) {
                exception.printStackTrace();
            }
        }
        finally {
            this.postModification();
        }
    }

    void save(File file) {
        try {
            FileWriter fileWriter = new FileWriter(file);
            BufferedWriter bufferedWriter = new BufferedWriter(fileWriter);
            PrintWriter printWriter = new PrintWriter(bufferedWriter);
            this.toXML(printWriter);
            printWriter.close();
        }
        catch (Exception exception) {
            exception.printStackTrace();
        }
    }

    private void loadTemplates(Element element) {
        NodeList nodeList = element.getElementsByTagName(XML_ITEM);
        int n = nodeList.getLength();
        int n2 = 0;
        while (n2 < n) {
            Element element2 = (Element)nodeList.item(n2);
            this.loadTemplate(element2);
            ++n2;
        }
    }

    private void loadTemplate(Element element) {
        String string = this.getValue(element, XML_ABBR);
        if (string != null) {
            String string2 = this.getValue(element, XML_DESCR);
            String string3 = this.getValue(element, XML_TEXT);
            if (string3 == null) {
                String string4;
                String string5 = this.getValue(element, XML_TEXT1);
                if (string5 == null) {
                    string5 = "";
                }
                if ((string4 = this.getValue(element, XML_TEXT2)) != null && string5.indexOf(END_VARIABLE) == -1) {
                    string5 = string5 + END_VARIABLE + string4;
                }
                string3 = string5;
            }
            Template template = new Template(string, string2, string3);
            NodeList nodeList = element.getElementsByTagName(XML_IMPORT);
            int n = nodeList.getLength();
            int n2 = 0;
            while (n2 < n) {
                Node node = nodeList.item(n2);
                String string6 = this.getValue(node);
                if (string6 != null) {
                    template.addImport(string6);
                }
                ++n2;
            }
            nodeList = element.getElementsByTagName("variable");
            n = nodeList.getLength();
            int n3 = 0;
            while (n3 < n) {
                Element element2 = (Element)nodeList.item(n3);
                String string7 = this.getValue(element2, "name");
                String string8 = this.getValue(element2, "type");
                String string9 = this.getValue(element2, "value");
                String string10 = this.getValue(element2, "editable");
                template.addVariable(new TemplateVariable(string7, string8, string9, string10.equals("true")));
                ++n3;
            }
            this._templates.add(template);
        }
    }

    private String getValue(Element element, String string) {
        String string2 = null;
        NodeList nodeList = element.getElementsByTagName(string);
        if (nodeList.getLength() > 0) {
            Node node = nodeList.item(0);
            string2 = this.getValue(node);
        }
        return string2;
    }

    private String getValue(Node node) {
        Node node2;
        String string = null;
        if (node != null && (node2 = node.getFirstChild()) != null) {
            string = node2.getNodeValue();
        }
        return string;
    }

    int getLongestShortcut() {
        return this._nLongestShortcut;
    }

    int searchTemplatePosEndingWith(String string) {
        int n = this._templates.size();
        int n2 = 0;
        while (n2 < n) {
            Template template = (Template)this._templates.get(n2);
            String string2 = template.getShortcut();
            if (string.endsWith(string2)) {
                return n2;
            }
            ++n2;
        }
        return -1;
    }

    int searchTemplatePos(String string) {
        int n = this._templates.size();
        int n2 = 0;
        while (n2 < n) {
            Template template = (Template)this._templates.get(n2);
            String string2 = template.getShortcut();
            if (string.equals(string2)) {
                return n2;
            }
            ++n2;
        }
        return -1;
    }

    Template findTemplate(String string) {
        Template template = null;
        int n = this.searchTemplatePos(string);
        if (n != -1) {
            template = this.getTemplate(n);
        }
        return template;
    }

    Template findTemplateEndingWith(String string) {
        Template template = null;
        int n = this.searchTemplatePosEndingWith(string);
        if (n != -1) {
            template = this.getTemplate(n);
        }
        return template;
    }

    boolean isDuplicateShortcut(Template template) {
        int n = 0;
        String string = template.getShortcut();
        int n2 = this._templates.size();
        int n3 = 0;
        while (n3 < n2 && n < 2) {
            Template template2 = (Template)this._templates.get(n3);
            if (template2.getShortcut().equals(string)) {
                ++n;
            }
            ++n3;
        }
        return n >= 2;
    }

    boolean updateValidities() {
        int n = this._templates.size();
        boolean[] blArray = new boolean[n];
        int n2 = 0;
        while (n2 < n) {
            Template template = (Template)this._templates.get(n2);
            blArray[n2] = template.isValid();
            template.setValid(true);
            ++n2;
        }
        int n3 = 0;
        while (n3 < n) {
            Template template = (Template)this._templates.get(n3);
            String string = template.getShortcut();
            int n4 = n3 + 1;
            while (n4 < n) {
                Template template2 = (Template)this._templates.get(n4);
                String string2 = template2.getShortcut();
                if (string.equals(string2)) {
                    template.setValid(false);
                    template2.setValid(false);
                }
                ++n4;
            }
            ++n3;
        }
        int n5 = 0;
        while (n5 < n) {
            Template template = (Template)this._templates.get(n5);
            if (blArray[n5] != template.isValid()) {
                return true;
            }
            ++n5;
        }
        return false;
    }

    void merge(Templates templates) {
        int n = 0;
        while (n < templates._templates.size()) {
            Template template = (Template)templates._templates.get(n);
            String string = template.getShortcut();
            int n2 = this.getTemplatePosByShortcut(string);
            if (n2 == -1) {
                this.addTemplate(template);
            }
            ++n;
        }
    }

    public Object copyTo(Object object) {
        Templates templates = object != null ? (Templates)((Object)object) : new Templates();
        this.copyToImpl(templates);
        return templates;
    }

    final class 2
    implements Comparator {
        public int compare(Object object, Object object2) {
            Template template = (Template)object;
            Template template2 = (Template)object2;
            String string = template.getShortcut();
            String string2 = template2.getShortcut();
            return String.CASE_INSENSITIVE_ORDER.compare(string, string2);
        }
    }

    final class 1
    implements Comparator {
        public int compare(Object object, Object object2) {
            Template template = (Template)object;
            Template template2 = (Template)object2;
            return template2.getShortcut().length() - template.getShortcut().length();
        }
    }
}

