/*
 * Decompiled with CFR 0.152.
 */
package oracle.jdeveloper.ceditor.template;

import javax.swing.table.AbstractTableModel;
import oracle.jdeveloper.ceditor.template.Template;
import oracle.jdeveloper.ceditor.template.TemplateVariable;

class VariableDataModel
extends AbstractTableModel {
    private Template _currentTemplate;

    public VariableDataModel(Template template) {
        this._currentTemplate = template;
    }

    public void setTemplate(Template template) {
        this._currentTemplate = template;
        this.fireTableDataChanged();
    }

    public int getRowCount() {
        if (this._currentTemplate == null) {
            return 0;
        }
        return this._currentTemplate.getVariables().size();
    }

    public int getColumnCount() {
        return 4;
    }

    public String getColumnName(int n) {
        switch (n) {
            case 0: {
                return "Name";
            }
            case 1: {
                return "Type";
            }
            case 2: {
                return "Default Value";
            }
            case 3: {
                return "Editable";
            }
        }
        return "Unknown";
    }

    public boolean isCellEditable(int n, int n2) {
        return n2 >= 1;
    }

    public void setValueAt(Object object, int n, int n2) {
        if (n >= this._currentTemplate.getVariables().size()) {
            return;
        }
        TemplateVariable templateVariable = (TemplateVariable)this._currentTemplate.getVariables().get(n);
        switch (n2) {
            case 0: {
                return;
            }
            case 1: {
                templateVariable.setType((String)object);
                return;
            }
            case 2: {
                templateVariable.setDefValue((String)object);
                return;
            }
            case 3: {
                templateVariable.setEditable((Boolean)object);
                return;
            }
        }
    }

    public Class getColumnClass(int n) {
        return this.getValueAt(0, n).getClass();
    }

    public Object getValueAt(int n, int n2) {
        TemplateVariable templateVariable = (TemplateVariable)this._currentTemplate.getVariables().get(n);
        switch (n2) {
            case 0: {
                return templateVariable.getName();
            }
            case 1: {
                return templateVariable.getType();
            }
            case 2: {
                return templateVariable.getDefValue();
            }
            case 3: {
                if (templateVariable.isEditable()) {
                    return Boolean.TRUE;
                }
                return Boolean.FALSE;
            }
        }
        return "Unknown";
    }
}

