/*
 * Decompiled with CFR 0.152.
 */
package oracle.jdeveloper.cmd;

import java.awt.Component;
import java.awt.Window;
import java.io.IOException;
import java.net.URL;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import oracle.ide.Context;
import oracle.ide.Ide;
import oracle.ide.IdeMainWindow;
import oracle.ide.controller.Command;
import oracle.ide.dialogs.MessageDialog;
import oracle.ide.model.Element;
import oracle.ide.model.Node;
import oracle.ide.model.NodeFactory;
import oracle.ide.model.Project;
import oracle.ide.model.ProjectContent;
import oracle.ide.model.ProjectMigrator;
import oracle.ide.model.ProjectVersion;
import oracle.ide.model.Workspace;
import oracle.ide.net.URLFileSystem;
import oracle.ide.panels.TraversalException;
import oracle.ide.resource.ComponentArb;
import oracle.ide.resource.ModelArb;
import oracle.ide.util.IdeUtil;
import oracle.javatools.data.PropertyStorage;
import oracle.javatools.dialogs.ExceptionDialog;
import oracle.javatools.util.StringUtil;
import oracle.jdeveloper.compiler.OjcConfiguration;
import oracle.jdeveloper.model.JavaProject;
import oracle.jdevimpl.resource.WizardsArb;
import oracle.jdevimpl.wizard.project.NewProjectPanel;

public class NewEmptyProjectCommand
extends Command {
    private static List initializers;
    public static final String WORKSPACE_PACKAGE_COUNTER_PROPERTY = "packageCounter";

    public NewEmptyProjectCommand() {
        super(3);
    }

    public final int doit() throws Exception {
        Context context = this.getContext();
        NewProjectPanel newProjectPanel = new NewProjectPanel();
        newProjectPanel.setContext(context);
        2 var3_3 = new 2(this, newProjectPanel, context);
        URL uRL = newProjectPanel.getProjectURL(var3_3);
        if (uRL == null) {
            return 1;
        }
        return 0;
    }

    public static Project createProjectInWorkspace(URL uRL, Workspace workspace) throws IllegalAccessException, InstantiationException {
        return NewEmptyProjectCommand.createProjectInWorkspace(uRL, workspace, null);
    }

    public static Project createProjectInWorkspace(URL uRL, Workspace workspace, String string) throws IllegalAccessException, InstantiationException {
        Project project;
        Project project2 = Ide.getDefaultProject();
        Project project3 = (Project)NodeFactory.find((URL)uRL);
        if (project2 != null) {
            if (project2.isDirty()) {
                try {
                    project2.save();
                }
                catch (IOException iOException) {
                    IdeMainWindow ideMainWindow = Ide.getMainWindow();
                    if (ideMainWindow != null) {
                        ExceptionDialog.showExceptionDialog((Window)ideMainWindow, (Exception)iOException);
                    }
                    throw new InstantiationException();
                }
            }
            project = (Project)NodeFactory.clone((Node)project2, (URL)uRL);
        } else {
            project = (Project)NodeFactory.findOrCreate(Project.class, (URL)uRL);
        }
        if (project != null) {
            Project project4 = project;
            project.applyBatchChanges((Runnable)new 1(project4, workspace, string));
            if (project3 != null) {
                try {
                    project3.close();
                    NewEmptyProjectCommand.setPackage(project, string, workspace);
                    project.save();
                    project.close();
                    project3.open();
                }
                catch (IOException iOException) {
                    iOException.printStackTrace();
                }
                project = project3;
                NodeFactory.recache((URL)uRL, (URL)uRL, (Node)project);
            }
            if (workspace != null) {
                workspace.add((Element)project, true);
            }
        } else {
            NewEmptyProjectCommand._showError(uRL);
        }
        return project;
    }

    public static String getProjectPackage(Workspace workspace) {
        String string;
        Map map = workspace.getTransientProperties();
        if (map.containsKey("defaultPackage") && (string = (String)map.get("defaultPackage")) != null) {
            return string;
        }
        Project project = Ide.getDefaultProject();
        string = project != null ? JavaProject.getInstance(project).getDefaultPackage() : ModelArb.getString((int)4);
        return string;
    }

    public static void setProjectPackage(String string, Project project, Workspace workspace) {
        if (string == null) {
            string = "";
        }
        project.getProperties().putString("defaultPackage", string);
        JavaProject.getInstance(project).setMostRecentPackage(string);
    }

    public static synchronized void registerProjectInitializer(ProjectInitializer projectInitializer) {
        if (initializers == null) {
            initializers = new ArrayList();
        }
        if (!initializers.contains(projectInitializer)) {
            initializers.add(projectInitializer);
        }
    }

    public static synchronized void unregisterProjectInitializer(ProjectInitializer projectInitializer) {
        if (initializers != null) {
            initializers.remove(projectInitializer);
        }
    }

    private static void _showError(URL uRL) {
        String string = URLFileSystem.getPlatformPathName((URL)uRL);
        if (string.length() > 80) {
            string = ComponentArb.format((int)32, (Object)StringUtil.truncateFileNameForMessage((String)string));
        }
        String string2 = ComponentArb.format((int)36, (Object)WizardsArb.getString(5), (Object)string);
        IdeMainWindow ideMainWindow = Ide.getMainWindow();
        if (ideMainWindow != null) {
            MessageDialog.error((Component)ideMainWindow, (Object)string2, (String)ComponentArb.getString((int)35), null);
        } else {
            System.err.println(string2);
        }
    }

    private static int _getNextWorkspacePackageCount(Workspace workspace) {
        String string = workspace.getProperty(WORKSPACE_PACKAGE_COUNTER_PROPERTY);
        int n = 1;
        try {
            if (string != null) {
                n = Integer.parseInt(string);
            }
        }
        catch (NumberFormatException numberFormatException) {
            numberFormatException.printStackTrace();
        }
        return n;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static void initializeProject(Project project, Workspace workspace) {
        ProjectInitializer[] projectInitializerArray = null;
        Class<NewEmptyProjectCommand> clazz = NewEmptyProjectCommand.class;
        synchronized (NewEmptyProjectCommand.class) {
            if (initializers != null) {
                projectInitializerArray = initializers.toArray(new ProjectInitializer[initializers.size()]);
            }
            // ** MonitorExit[var4_3] (shouldn't be in output)
            if (projectInitializerArray != null) {
                int n = 0;
                while (n < projectInitializerArray.length) {
                    projectInitializerArray[n].initializeProject(project, workspace);
                    ++n;
                }
            }
            return;
        }
    }

    private static void setPackage(Project project, String string, Workspace workspace) {
        Map map;
        String string2 = null;
        if (string != null) {
            string2 = string;
        } else if (workspace != null && (map = workspace.getTransientProperties()).containsKey("defaultPackage")) {
            string2 = (String)map.get("defaultPackage");
        }
        if (string2 == null) {
            string2 = JavaProject.generateDefaultPackageName(project);
        }
        NewEmptyProjectCommand.setProjectPackage(string2, project, workspace);
    }

    static void maS$initializeProject(Project project, Workspace workspace) {
        NewEmptyProjectCommand.initializeProject(project, workspace);
    }

    static void maS$setPackage(Project project, String string, Workspace workspace) {
        NewEmptyProjectCommand.setPackage(project, string, workspace);
    }

    public final class 2
    implements Runnable {
        private final /* synthetic */ NewProjectPanel v$newProjectPanel;
        private final /* synthetic */ Context v$ctx;
        final /* synthetic */ NewEmptyProjectCommand this$0;

        public void run() {
            block5: {
                try {
                    URL uRL = this.v$newProjectPanel.getFileURL(false);
                    if (uRL == null) break block5;
                    try {
                        Workspace workspace = this.v$ctx.getWorkspace();
                        Project project = NewEmptyProjectCommand.createProjectInWorkspace(uRL, workspace);
                        if (project != null) {
                            project.save();
                        }
                    }
                    catch (Exception exception) {
                        ExceptionDialog.showExceptionDialog((Component)((Object)this.v$newProjectPanel), (Throwable)exception, (String)("An error occured creating the project " + URLFileSystem.getPlatformPathName((URL)uRL)));
                    }
                }
                catch (TraversalException traversalException) {
                    traversalException.showMessageDialog((Component)((Object)this.v$newProjectPanel));
                }
            }
        }

        public 2(NewEmptyProjectCommand newEmptyProjectCommand, NewProjectPanel newProjectPanel, Context context) {
            this.v$ctx = context;
            this.v$newProjectPanel = newProjectPanel;
            this.this$0 = newEmptyProjectCommand;
        }
    }

    public static final class 1
    implements Runnable {
        private final /* synthetic */ Project v$final_newProject;
        private final /* synthetic */ Workspace v$workspace;
        private final /* synthetic */ String v$defaultPackage;

        public void run() {
            OjcConfiguration ojcConfiguration = OjcConfiguration.getInstance((PropertyStorage)this.v$final_newProject);
            if (ojcConfiguration != null) {
                ojcConfiguration.setCurrentEncoding(IdeUtil.getIdeEncoding());
            }
            ProjectContent.initializeContentSets((Project)this.v$final_newProject);
            ProjectVersion.initializeVersions((PropertyStorage)this.v$final_newProject, (String)ProjectMigrator.MIGRATOR_NAME);
            NewEmptyProjectCommand.maS$initializeProject(this.v$final_newProject, this.v$workspace);
            NewEmptyProjectCommand.maS$setPackage(this.v$final_newProject, this.v$defaultPackage, this.v$workspace);
        }

        public 1(Project project, Workspace workspace, String string) {
            this.v$defaultPackage = string;
            this.v$workspace = workspace;
            this.v$final_newProject = project;
        }
    }

    public static interface ProjectInitializer {
        public void initializeProject(Project var1, Workspace var2);
    }
}

