/*
 * Decompiled with CFR 0.152.
 */
package oracle.jdeveloper.common;

import java.awt.Component;
import java.awt.Container;
import java.awt.Dimension;
import java.awt.Insets;
import java.awt.LayoutManager2;
import java.io.Serializable;
import javax.swing.JComponent;
import javax.swing.border.Border;
import oracle.jdeveloper.common.BorderComponentPanel;

public class BorderComponentLayout
implements Serializable,
LayoutManager2 {
    public static final String BORDER = "BorderComponent";
    public static final String CONTENT = "ContentComponent";
    protected BorderComponentPanel container;
    protected Component contentComponent;
    protected Component borderComponent;
    protected static final int EDGE_SPACING = 2;
    protected static final int COMPONENT_OFFSET = 2;
    protected static final int COMPONENT_H_SPACING = 5;

    public BorderComponentLayout(BorderComponentPanel borderComponentPanel) {
        this.container = borderComponentPanel;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void addLayoutComponent(Component component, Object object) {
        Object object2 = component.getTreeLock();
        synchronized (object2) {
            if (object != null && !(object instanceof String)) {
                throw new IllegalArgumentException("Illegal Constraint");
            }
            this.addLayoutComponent((String)object, component);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void addLayoutComponent(String string, Component component) {
        Object object = component.getTreeLock();
        synchronized (object) {
            if (string == null) {
                string = CONTENT;
            }
            if (BORDER.equals(string)) {
                this.borderComponent = component;
                this.container.setBorderComponentImpl((JComponent)component);
            } else if (CONTENT.equals(string)) {
                this.contentComponent = component;
            } else {
                throw new IllegalArgumentException("Illegal Name");
            }
        }
    }

    public void removeLayoutComponent(Component component) {
        if (component == this.contentComponent) {
            this.contentComponent = null;
        }
        if (component == this.borderComponent) {
            this.borderComponent = null;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Dimension minimumLayoutSize(Container container) {
        Object object = container.getTreeLock();
        synchronized (object) {
            Dimension dimension = new Dimension(0, 0);
            if (this.contentComponent != null && this.contentComponent.isVisible()) {
                dimension = new Dimension(this.contentComponent.getMinimumSize());
            }
            if (this.borderComponent != null && this.borderComponent.isVisible()) {
                Dimension dimension2 = this.borderComponent.getMinimumSize();
                dimension.width = Math.max(dimension.width, dimension2.width);
            }
            Insets insets = container.getInsets();
            dimension.width += insets.left + insets.right;
            dimension.height += insets.top + insets.bottom;
            Dimension dimension3 = dimension;
            return dimension3;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Dimension preferredLayoutSize(Container container) {
        Object object = container.getTreeLock();
        synchronized (object) {
            Dimension dimension = new Dimension(0, 0);
            if (this.contentComponent != null && this.contentComponent.isVisible()) {
                dimension = new Dimension(this.contentComponent.getPreferredSize());
            }
            if (this.borderComponent != null && this.borderComponent.isVisible()) {
                Dimension dimension2 = this.borderComponent.getPreferredSize();
                dimension.width = Math.max(dimension.width, dimension2.width);
            }
            Insets insets = container.getInsets();
            dimension.width += insets.left + insets.right;
            dimension.height += insets.top + insets.bottom;
            Dimension dimension3 = dimension;
            return dimension3;
        }
    }

    public Dimension maximumLayoutSize(Container container) {
        return new Dimension(Integer.MAX_VALUE, Integer.MAX_VALUE);
    }

    public float getLayoutAlignmentX(Container container) {
        return 0.5f;
    }

    public float getLayoutAlignmentY(Container container) {
        return 0.5f;
    }

    public void invalidateLayout(Container container) {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void layoutContainer(Container container) {
        Object object = container.getTreeLock();
        synchronized (object) {
            this.layoutBorder(container);
            this.layoutContent(container);
        }
    }

    public void layoutBorder(Container container) {
        if (this.borderComponent == null || !this.borderComponent.isVisible()) {
            return;
        }
        Border border = this.container.getBorder();
        int n = 0;
        int n2 = 0;
        Dimension dimension = this.borderComponent.getPreferredSize();
        Dimension dimension2 = this.container.getSize();
        Insets insets = border == null ? new Insets(0, 0, 0, 0) : border.getBorderInsets(this.container);
        switch (this.container.getBorderComponentLocation()) {
            case 1: {
                n2 = 2;
                break;
            }
            case 0: {
                n2 = Math.max((insets.top - dimension.height) / 2, 2);
                break;
            }
            case 2: {
                n2 = insets.top + 2 + 2;
                break;
            }
            case 4: {
                n2 = dimension2.height - insets.bottom - 2 - 2 - dimension.height;
                break;
            }
            case 3: {
                n2 = dimension2.height - dimension.height - Math.max((insets.bottom - dimension.height) / 2, 2);
                break;
            }
            case 5: {
                n2 = dimension2.height - dimension.height - 2;
            }
        }
        switch (this.container.getBorderComponentJustification()) {
            case 6: {
                n = insets.left + 5 + 2;
                break;
            }
            case 7: {
                n = Math.max((dimension2.width - dimension.width) / 2, 0);
                break;
            }
            case 8: {
                n = dimension2.width - insets.right - dimension.width - 5 - 2;
            }
        }
        this.borderComponent.setLocation(n, n2);
        this.borderComponent.setSize(dimension);
    }

    public void layoutContent(Container container) {
        Insets insets = container.getInsets();
        Dimension dimension = container.getSize();
        int n = insets.top;
        int n2 = dimension.height - insets.bottom;
        int n3 = insets.left;
        int n4 = dimension.width - insets.right;
        if (this.contentComponent != null && this.contentComponent.isVisible()) {
            this.contentComponent.setBounds(n3, n, n4 - n3, n2 - n);
        }
    }

    public String toString() {
        return this.getClass().getName();
    }
}

