/*
 * Decompiled with CFR 0.152.
 */
package oracle.jdeveloper.common;

import java.awt.Color;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.Graphics;
import java.awt.Insets;
import java.awt.Point;
import java.awt.event.ContainerEvent;
import java.awt.event.ContainerListener;
import javax.swing.BorderFactory;
import javax.swing.JComponent;
import javax.swing.JPanel;
import javax.swing.border.Border;
import oracle.jdeveloper.common.BorderComponentLayout;

public class BorderComponentPanel
extends JPanel
implements ContainerListener {
    public static final int TOP = 0;
    public static final int ABOVE_TOP = 1;
    public static final int BELOW_TOP = 2;
    public static final int BOTTOM = 3;
    public static final int ABOVE_BOTTOM = 4;
    public static final int BELOW_BOTTOM = 5;
    public static final int LEFT = 6;
    public static final int CENTER = 7;
    public static final int RIGHT = 8;
    protected static final int EDGE_SPACING = 2;
    protected static final int COMPONENT_OFFSET = 2;
    protected static final int COMPONENT_H_SPACING = 5;
    protected JComponent borderComponent;
    protected int borderComponentLocation;
    protected int borderComponentJustification;

    void $init$() {
        this.borderComponentLocation = 0;
        this.borderComponentJustification = 6;
    }

    public BorderComponentPanel() {
        this.$init$();
        this.setLayout(new BorderComponentLayout(this));
        this.setBorder(BorderFactory.createEtchedBorder());
    }

    void setBorderComponentImpl(JComponent jComponent) {
        if (this.borderComponent == jComponent) {
            return;
        }
        if (this.borderComponent != null) {
            this.borderComponent.removeContainerListener(this);
        }
        jComponent.addContainerListener(this);
        this.borderComponent = jComponent;
    }

    public JComponent getBorderComponent() {
        return this.borderComponent;
    }

    public int getBorderComponentLocation() {
        return this.borderComponentLocation;
    }

    public void setBorderComponentLocation(int n) {
        switch (n) {
            case 0: 
            case 1: 
            case 2: 
            case 3: 
            case 4: 
            case 5: {
                this.borderComponentLocation = n;
                this.doLayout();
                break;
            }
            default: {
                throw new IllegalArgumentException();
            }
        }
    }

    public int getBorderComponentJustification() {
        return this.borderComponentJustification;
    }

    public void setBorderComponentJustification(int n) {
        switch (n) {
            case 6: 
            case 7: 
            case 8: {
                this.borderComponentJustification = n;
                this.doLayout();
                break;
            }
            default: {
                throw new IllegalArgumentException();
            }
        }
    }

    public Insets getInsets() {
        Border border = this.getBorder();
        if (border == null || this.borderComponent == null) {
            return super.getInsets();
        }
        Insets insets = (Insets)border.getBorderInsets(this).clone();
        Dimension dimension = this.borderComponent.getPreferredSize();
        switch (this.borderComponentLocation) {
            case 1: {
                insets.top += 2 + dimension.height;
                break;
            }
            case 2: {
                insets.top += 4 + dimension.height;
                break;
            }
            case 0: {
                insets.top = Math.max(4 + dimension.height, insets.top) - 2;
                break;
            }
            case 3: {
                insets.bottom = Math.max(4 + dimension.height, insets.bottom) - 2;
                break;
            }
            case 4: {
                insets.bottom += 4 + dimension.height;
                break;
            }
            case 5: {
                insets.bottom += 2 + dimension.height;
            }
        }
        insets.top += 2;
        insets.bottom += 2;
        insets.left += 2;
        insets.right += 2;
        return insets;
    }

    protected void paintBorder(Graphics graphics) {
        Border border = this.getBorder();
        if (border == null) {
            return;
        }
        Insets insets = border.getBorderInsets(this);
        int n = 2;
        int n2 = 2;
        int n3 = this.getWidth() - 4;
        int n4 = this.getHeight() - 4;
        if (this.borderComponent == null) {
            border.paintBorder(this, graphics, n, n2, n3, n4);
            return;
        }
        Dimension dimension = this.borderComponent.getPreferredSize();
        switch (this.borderComponentLocation) {
            case 1: {
                int n5 = 2 + dimension.height;
                n2 += n5;
                n4 -= n5;
                break;
            }
            case 0: {
                n2 = Math.max(dimension.height / 2, 2);
                n4 += 2 - n2;
                break;
            }
            case 3: {
                if (insets.bottom >= dimension.height) break;
                n4 -= dimension.height / 2;
                break;
            }
            case 5: {
                n4 -= 2 + dimension.height;
            }
        }
        Color color = graphics.getColor();
        Font font = graphics.getFont();
        Point point = this.borderComponent.getLocation();
        border.paintBorder(this, graphics, n, n2, n3, n4);
        graphics.setColor(this.getBackground());
        graphics.fillRect(point.x - 2, point.y - 2, dimension.width + 4, dimension.height + 4);
        graphics.setColor(color);
        graphics.setFont(font);
    }

    public void componentAdded(ContainerEvent containerEvent) {
        this.doLayout();
    }

    public void componentRemoved(ContainerEvent containerEvent) {
        this.doLayout();
    }
}

