/*
 * Decompiled with CFR 0.152.
 */
package oracle.jdeveloper.common;

import java.awt.Component;
import java.awt.Dimension;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.FocusEvent;
import java.awt.event.FocusListener;
import java.awt.event.ItemEvent;
import java.awt.event.ItemListener;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import javax.swing.ComboBoxEditor;
import javax.swing.DefaultComboBoxModel;
import javax.swing.JComboBox;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JTextField;
import javax.swing.MutableComboBoxModel;
import oracle.ide.resource.IdeArb;
import oracle.jdeveloper.common.OracleButton;
import oracle.jdeveloper.common.PickerResultValidator;
import oracle.jdeveloper.common.PickerValueEncoder;
import oracle.jdeveloper.common.Res;

public class PickerPanel
extends JPanel {
    private GridBagLayout gridBagLayout1;
    protected JComboBox cmbPicker;
    protected OracleButton btnBrowse;
    protected PickerResultValidator validator;
    protected PickerValueEncoder encoder;
    protected MutableComboBoxModel model;
    protected ComboBoxEditor editor;
    private Object oldCurrentValue;
    private boolean editing;
    public static final String PROPERTY_CURRENT_VALUE = "currentValue";

    void $init$() {
        this.gridBagLayout1 = new GridBagLayout();
        this.cmbPicker = new JComboBox();
        this.btnBrowse = new OracleButton();
        this.validator = null;
        this.encoder = null;
        this.model = new DefaultComboBoxModel();
        this.editing = false;
    }

    public PickerPanel() {
        this.$init$();
        try {
            this.jbInit();
            this.editor = this.cmbPicker.getEditor();
            if (this.editor != null) {
                this.editor.addActionListener(new 4());
                Component component = this.editor.getEditorComponent();
                component.addFocusListener(new 3(this, component));
            }
        }
        catch (Exception exception) {
            exception.printStackTrace();
        }
    }

    public String getButtonText() {
        return this.btnBrowse.getText();
    }

    public void setButtonText(String string) {
        this.btnBrowse.setText(string);
    }

    public void setButtonMnemonic(int n) {
        this.btnBrowse.setMnemonic(n);
    }

    public int getButtonMnemonic() {
        return this.btnBrowse.getMnemonic();
    }

    public void setButtonVisible(boolean bl) {
        this.btnBrowse.setVisible(bl);
    }

    public boolean isButtonVisible() {
        return this.btnBrowse.isVisible();
    }

    public boolean isPickerEditable() {
        return this.cmbPicker.isEditable();
    }

    public void setPickerEditable(boolean bl) {
        this.cmbPicker.setEditable(bl);
    }

    public MutableComboBoxModel getPickerModel() {
        return this.model;
    }

    public void setPickerModel(MutableComboBoxModel mutableComboBoxModel) {
        this.model = mutableComboBoxModel;
        this.cmbPicker.setModel(mutableComboBoxModel);
    }

    public PickerResultValidator getValidator() {
        return this.validator;
    }

    public void setValidator(PickerResultValidator pickerResultValidator) {
        this.validator = pickerResultValidator;
    }

    public PickerValueEncoder getEncoder() {
        return this.encoder;
    }

    public void setEncoder(PickerValueEncoder pickerValueEncoder) {
        this.encoder = pickerValueEncoder;
    }

    public void addActionListener(ActionListener actionListener) {
        this.btnBrowse.addActionListener(actionListener);
    }

    public void removeActionListener(ActionListener actionListener) {
        this.btnBrowse.removeActionListener(actionListener);
    }

    public final void setBrowseResult(Object object) {
        if (object == null) {
            return;
        }
        if (this.validator == null || this.validator.isResultValid(object)) {
            Object object2 = this.encoder != null ? this.encoder.encodeValue(object) : object;
            this.setCurrentValue(object2);
        } else {
            JOptionPane.showMessageDialog(this, this.validator.getInvalidValueMsg(object), IdeArb.getString((int)235), 0);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void addValue(Object object) {
        MutableComboBoxModel mutableComboBoxModel = this.model;
        synchronized (mutableComboBoxModel) {
            int n = 0;
            while (n < this.model.getSize()) {
                if (this.model.getElementAt(n).equals(object)) {
                    return;
                }
                ++n;
            }
            this.model.addElement(object);
        }
    }

    public Dimension getMinimumSize() {
        Dimension dimension = super.getMinimumSize();
        return new Dimension(Math.max(dimension.width, 200), dimension.height);
    }

    public void setEnabled(boolean bl) {
        this.btnBrowse.setEnabled(bl);
        this.cmbPicker.setEnabled(bl);
        super.setEnabled(bl);
    }

    private void jbInit() throws Exception {
        this.setLayout(this.gridBagLayout1);
        this.btnBrowse.setText(Res.getString(12));
        this.cmbPicker.setModel(this.model);
        this.cmbPicker.addItemListener(new 2());
        this.cmbPicker.addPropertyChangeListener(new 1());
        this.add((Component)this.cmbPicker, new GridBagConstraints(0, 0, 1, 1, 1.0, 0.0, 10, 2, new Insets(0, 0, 0, 0), 0, 0));
        this.add((Component)this.btnBrowse, new GridBagConstraints(1, 0, 1, 1, 0.0, 0.0, 13, 0, new Insets(0, 5, 0, 0), 0, 0));
    }

    private void cmbPicker_propertyChange(PropertyChangeEvent propertyChangeEvent) {
        Object object;
        String string = propertyChangeEvent.getPropertyName();
        if ("model".equals(string) && (object = propertyChangeEvent.getNewValue()) != this.model) {
            this.model = (MutableComboBoxModel)object;
        }
    }

    private void editFinished() {
        this.editing = false;
        Object object = this.editor.getItem();
        Object object2 = this.encoder != null ? this.encoder.encodeValue(object) : object;
        this.setCurrentValue(object2);
    }

    public Object getCurrentValue() {
        if (this.editing) {
            this.editFinished();
        }
        return this.model.getSelectedItem();
    }

    public void setCurrentValue(Object object) {
        Object object2 = this.getCurrentValue();
        this.addValue(object);
        this.model.setSelectedItem(object);
    }

    void cmbPicker_itemStateChanged(ItemEvent itemEvent) {
        int n = itemEvent.getStateChange();
        switch (n) {
            case 2: {
                this.oldCurrentValue = itemEvent.getItem();
                break;
            }
            case 1: {
                this.firePropertyChange(PROPERTY_CURRENT_VALUE, this.oldCurrentValue, itemEvent.getItem());
                break;
            }
        }
    }

    public void requestFocus() {
        if (this.isPickerEditable()) {
            if (this.editor != null) {
                this.editor.getEditorComponent().requestFocus();
            }
        } else {
            this.cmbPicker.requestFocus();
        }
    }

    static void mav$editFinished(PickerPanel pickerPanel) {
        pickerPanel.editFinished();
    }

    static void wa$editing(PickerPanel pickerPanel, boolean bl) {
        pickerPanel.editing = bl;
    }

    static void mav$cmbPicker_propertyChange(PickerPanel pickerPanel, PropertyChangeEvent propertyChangeEvent) {
        pickerPanel.cmbPicker_propertyChange(propertyChangeEvent);
    }

    public final class 4
    implements ActionListener {
        public void actionPerformed(ActionEvent actionEvent) {
            PickerPanel.mav$editFinished(PickerPanel.this);
        }
    }

    public final class 3
    implements FocusListener {
        private final /* synthetic */ Component v$editComp;
        final /* synthetic */ PickerPanel this$0;

        public void focusGained(FocusEvent focusEvent) {
            PickerPanel.wa$editing(this.this$0, true);
        }

        public void focusLost(FocusEvent focusEvent) {
            ((JTextField)this.v$editComp).postActionEvent();
        }

        public 3(PickerPanel pickerPanel, Component component) {
            this.v$editComp = component;
            this.this$0 = pickerPanel;
        }
    }

    public final class 2
    implements ItemListener {
        public void itemStateChanged(ItemEvent itemEvent) {
            PickerPanel.this.cmbPicker_itemStateChanged(itemEvent);
        }
    }

    public final class 1
    implements PropertyChangeListener {
        public void propertyChange(PropertyChangeEvent propertyChangeEvent) {
            PickerPanel.mav$cmbPicker_propertyChange(PickerPanel.this, propertyChangeEvent);
        }
    }
}

