/*
 * Decompiled with CFR 0.152.
 */
package oracle.jdeveloper.compare;

import java.io.IOException;
import java.net.URL;
import javax.naming.InitialContext;
import javax.naming.NamingException;
import javax.swing.JMenu;
import oracle.ide.config.DocumentExtensions;
import oracle.ide.model.ContentType;
import oracle.ide.net.URLFileSystem;
import oracle.javatools.compare.CompareContributor;
import oracle.jdeveloper.compare.URLContributor;

public abstract class CompareViewer {
    public static final float COMPARE_WITH_SECTION_MULTI = 2.0f;
    public static final float COMPARE_WITH_SECTION_SINGLE = 1.0f;
    public static final float COMPARE_WITH_WEIGHT_EACH_OTHER = 1.0f;
    public static final float COMPARE_WITH_WEIGHT_FILE_ON_DISK = 1.0f;
    public static final float COMPARE_WITH_WEIGHT_OTHER_FILE = 2.0f;
    public static final String COMPARE_FILE_ON_DISK_COMMAND = "compare.CompareDirty";
    public static final String COMPARE_OTHER_FILE_COMMAND = "compare.CompareOther";
    public static final String COMPARE_EACH_OTHER_COMMAND = "compare.CompareEachOther";

    public static final CompareViewer get() {
        try {
            InitialContext initialContext = new InitialContext();
            CompareViewer compareViewer = (CompareViewer)initialContext.lookup("jdeveloper/compareviewer");
            return compareViewer;
        }
        catch (NamingException namingException) {
            CompareViewer compareViewer = null;
            return compareViewer;
        }
    }

    public static final boolean isContentComparable(URL uRL) {
        return DocumentExtensions.findContentTypeFromExtension((String)URLFileSystem.getSuffix((URL)uRL)) != ContentType.BINARY;
    }

    public abstract JMenu getMainCompareMenu();

    public abstract JMenu getContextCompareMenu();

    public abstract void show(CompareContributor var1, CompareContributor var2);

    public final void show(URL uRL, URL uRL2) {
        try {
            URLContributor uRLContributor = new URLContributor(uRL);
            URLContributor uRLContributor2 = new URLContributor(uRL2);
            this.show((CompareContributor)uRLContributor, (CompareContributor)uRLContributor2);
        }
        catch (IOException iOException) {
            iOException.printStackTrace();
        }
    }
}

