/*
 * Decompiled with CFR 0.152.
 */
package oracle.jdeveloper.compare;

import java.io.BufferedInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.Reader;
import java.net.URL;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import oracle.ide.Ide;
import oracle.ide.config.DocumentExtensions;
import oracle.ide.net.URLFileSystem;
import oracle.ide.util.IdeUtil;
import oracle.jdeveloper.compare.StreamDecoderHelper;
import oracle.jsp.parse.JspUtils;

public final class StreamDecoder {
    private static final int ENCODING_SCAN_SIZE = 512;
    private static final Collection _decoderHelpers = new ArrayList();

    public static final void registerDecoderHelper(StreamDecoderHelper streamDecoderHelper) {
        _decoderHelpers.add(streamDecoderHelper);
    }

    public static final void deregisterDecoderHelper(StreamDecoderHelper streamDecoderHelper) {
        _decoderHelpers.remove(streamDecoderHelper);
    }

    public static final String getDefaultEncoding(URL uRL) {
        Iterator iterator = _decoderHelpers.iterator();
        while (iterator.hasNext()) {
            String string = ((StreamDecoderHelper)iterator.next()).getDefaultEncoding(uRL);
            if (string == null) continue;
            return string;
        }
        return IdeUtil.getIdeEncoding();
    }

    public static Reader getReader(URL uRL) throws IOException {
        return StreamDecoder.getReader(URLFileSystem.getSuffix((URL)uRL), uRL);
    }

    public static Reader getReader(String string, URL uRL) throws IOException {
        return StreamDecoder.getReader(string, uRL.openStream(), StreamDecoder.getDefaultEncoding(uRL));
    }

    public static Reader getReader(String string, InputStream inputStream) throws IOException {
        return StreamDecoder.getReader(string, inputStream, IdeUtil.getIdeEncoding());
    }

    public static Reader getReader(String string, InputStream inputStream, String string2) throws IOException {
        BufferedInputStream bufferedInputStream = new BufferedInputStream(inputStream);
        bufferedInputStream.mark(Integer.MAX_VALUE);
        if (StreamDecoder.isXMLFile(string)) {
            String string3 = null;
            try {
                string3 = StreamDecoder.getXMLEncoding(bufferedInputStream);
            }
            catch (RuntimeException runtimeException) {
                runtimeException.printStackTrace();
            }
            if (string3 == null) {
                string3 = string2;
            }
            bufferedInputStream.reset();
            return new InputStreamReader((InputStream)bufferedInputStream, string3);
        }
        if (StreamDecoder.isHTMLFile(string) || StreamDecoder.isJSPFile(string)) {
            InputStreamReader inputStreamReader = new InputStreamReader(bufferedInputStream);
            char[] cArray = new char[512];
            int n = inputStreamReader.read(cArray, 0, 512);
            String string4 = StreamDecoder.getEncoding(StreamDecoder.isJSPFile(string), cArray);
            if (string4 == null) {
                string4 = string2;
            }
            bufferedInputStream.reset();
            return new InputStreamReader((InputStream)bufferedInputStream, string4);
        }
        String string5 = string2;
        return new InputStreamReader((InputStream)bufferedInputStream, string5);
    }

    private static String getEncoding(boolean bl, char[] cArray) {
        String string = new String(cArray);
        byte[] byArray = string.getBytes();
        return bl ? StreamDecoder.scanForJSPEncoding(byArray, 0, byArray.length) : StreamDecoder.scanForEncoding(byArray, 0, byArray.length);
    }

    private static String scanForJSPEncoding(byte[] byArray, int n, int n2) {
        String string = null;
        String string2 = new String(byArray);
        String string3 = "pageEncoding=\"";
        int n3 = string2.indexOf("pageEncoding=\"");
        if (n3 != -1 && (string = string2.substring(n3 + "pageEncoding=\"".length())) != null && (string = (n3 = string.indexOf(34)) != -1 ? string.substring(0, n3) : null) != null) {
            return string;
        }
        string = JspUtils.extractEncoding((String)string2);
        if (string != null) {
            n3 = string.indexOf(34);
            string = n3 != -1 ? string.substring(0, n3) : null;
        }
        return string;
    }

    private static String getXMLEncoding(InputStream inputStream) throws IOException {
        char[] cArray = new char[512];
        InputStreamReader inputStreamReader = new InputStreamReader(inputStream);
        inputStreamReader.read(cArray, 0, 512);
        boolean bl = true;
        int n = 2;
        int n2 = 5;
        int n3 = 6;
        int n4 = 7;
        int n5 = 8;
        int n6 = 0;
        StringBuffer stringBuffer = new StringBuffer();
        int n7 = 0;
        while (n7 < cArray.length) {
            char c = cArray[n7];
            switch (n6) {
                case 0: {
                    if (c != '<') break;
                    n6 = 1;
                    break;
                }
                case 1: {
                    if (c != '?') break;
                    n6 = 2;
                    break;
                }
                case 2: {
                    if (c != 'x' || cArray.length <= n7 + 2 || cArray[n7 + 1] != 'm' || cArray[n7 + 2] != 'l') break;
                    n7 += 2;
                    n6 = 5;
                    break;
                }
                case 5: {
                    String string;
                    if (c != 'e' || cArray.length <= n7 + 7 || !"encoding".equals(string = new String(cArray, n7, 8))) break;
                    n7 += 7;
                    n6 = 6;
                    break;
                }
                case 6: {
                    if (c != '=') break;
                    n6 = 7;
                    break;
                }
                case 7: {
                    if (Character.isWhitespace(c)) break;
                    n6 = 8;
                    if (c == '\'' || c == '\"') break;
                    stringBuffer.append(c);
                    break;
                }
                case 8: {
                    if (Character.isWhitespace(c) || c == '\'' || c == '\"') {
                        return stringBuffer.toString();
                    }
                    stringBuffer.append(c);
                }
            }
            ++n7;
        }
        return null;
    }

    /*
     * Enabled aggressive block sorting
     */
    private static String scanForEncoding(byte[] byArray, int n, int n2) {
        if (n2 <= 0) {
            return null;
        }
        String string = null;
        int n3 = n2;
        int n4 = 0;
        boolean bl = true;
        int n5 = 2;
        int n6 = 3;
        int n7 = 4;
        int n8 = 5;
        int n9 = 6;
        int n10 = 7;
        int n11 = 8;
        int n12 = 9;
        int n13 = 10;
        int n14 = 11;
        int n15 = 12;
        int n16 = 0;
        while (n != n3) {
            byte by = byArray[n];
            ++n;
            switch (n16) {
                case 0: {
                    if (by != 60) break;
                    n16 = 1;
                    break;
                }
                case 1: {
                    n16 = by == 98 || by == 66 ? 2 : (by == 109 || by == 77 ? 5 : 0);
                    break;
                }
                case 2: {
                    n16 = by == 111 || by == 79 ? 3 : 0;
                    break;
                }
                case 3: {
                    n16 = by == 100 || by == 68 ? 4 : 0;
                    break;
                }
                case 4: {
                    if (by == 121) return string;
                    if (by == 89) {
                        return string;
                    }
                    n16 = 0;
                    break;
                }
                case 5: {
                    n16 = by == 101 || by == 69 ? 6 : 0;
                    break;
                }
                case 6: {
                    n16 = by == 116 || by == 84 ? 7 : 0;
                    break;
                }
                case 7: {
                    n16 = by == 97 || by == 65 ? 8 : 0;
                    break;
                }
                case 8: {
                    if (by == 62) {
                        n16 = 0;
                        break;
                    }
                    if (by != 99 && by != 67) break;
                    if (n + 6 > n3) {
                        return string;
                    }
                    by = byArray[n];
                    if (by != 104 && by != 72 || (by = byArray[n + 1]) != 97 && by != 65 || (by = byArray[n + 2]) != 114 && by != 82 || (by = byArray[n + 3]) != 115 && by != 83 || (by = byArray[n + 4]) != 101 && by != 69 || (by = byArray[n + 5]) != 116 && by != 84) break;
                    n += 6;
                    n16 = 9;
                    break;
                }
                case 9: {
                    if (by == 62) {
                        n16 = 0;
                        break;
                    }
                    if (by == 61) {
                        n16 = 11;
                        break;
                    }
                    if (StreamDecoder.isWhiteSpace(by)) {
                        n16 = 10;
                        break;
                    }
                    if (StreamDecoder.isWhiteSpace(by)) break;
                    n16 = 8;
                    break;
                }
                case 10: {
                    if (by == 62) {
                        n16 = 0;
                        break;
                    }
                    if (by == 61) {
                        n16 = 11;
                        break;
                    }
                    if (StreamDecoder.isWhiteSpace(by)) break;
                    n16 = 0;
                    break;
                }
                case 11: {
                    if (by == 62) {
                        n16 = 0;
                        break;
                    }
                    if (StreamDecoder.isWhiteSpace(by)) break;
                    n16 = 12;
                    n4 = --n;
                    break;
                }
                case 12: {
                    if (by != 62 && by != 39 && by != 34) break;
                    int n17 = n - 1 - n4;
                    return new String(byArray, n4, n17);
                }
            }
        }
        return string;
    }

    private static boolean isWhiteSpace(int n) {
        return n == 32 || n == 9 || n == 10 || n == 13 || n == 12;
    }

    private static boolean isXMLFile(String string) {
        if (string == null || string.length() == 0) {
            return false;
        }
        return StreamDecoder.getDocClassName(string).indexOf("XML") >= 0;
    }

    private static boolean isHTMLFile(String string) {
        if (string == null || string.length() == 0) {
            return false;
        }
        return StreamDecoder.getDocClassName(string).indexOf("Html") >= 0;
    }

    private static boolean isJSPFile(String string) {
        if (string == null || string.length() == 0) {
            return false;
        }
        return StreamDecoder.getDocClassName(string).indexOf("Jsp") >= 0;
    }

    private static String getDocClassName(String string) {
        DocumentExtensions documentExtensions = (DocumentExtensions)Ide.getSettings().getData("document-extensions-options");
        DocumentExtensions.DocRecord docRecord = documentExtensions.findDocumentFromExtension(string);
        if (docRecord != null) {
            return docRecord.getDocClassName();
        }
        return "";
    }
}

