/*
 * Decompiled with CFR 0.152.
 */
package oracle.jdeveloper.compare;

import java.net.URL;
import oracle.ide.model.TextNode;
import oracle.ide.net.URLFileSystem;
import oracle.javatools.buffer.TextBuffer;
import oracle.javatools.compare.EditableContributor;
import oracle.javatools.compare.algorithm.text.TextCompareContributor;
import oracle.jdeveloper.compare.PatchCompareContributor;
import oracle.jdeveloper.compare.PatchCompareDescriptor;
import oracle.jdeveloper.compare.URLContributor;
import oracle.jdeveloper.resource.CompareArb;

public class TextNodeContributor
extends TextCompareContributor
implements PatchCompareContributor,
EditableContributor {
    private final TextNode _node;
    private final String _type;
    private PatchCompareDescriptor _patchDescriptor;

    public TextNodeContributor(TextNode textNode) {
        this._node = textNode;
        this._type = URLContributor.getPlatformPathSuffix(this._node.getURL());
        this.addTextBufferListeners();
    }

    public TextBuffer getTextBuffer() {
        return this._node.acquireTextBuffer();
    }

    public String getType() {
        return this._type;
    }

    public String getShortLabel() {
        if (this._node.isDirty()) {
            return CompareArb.format(2, URLFileSystem.getFileName((URL)this._node.getURL()));
        }
        return CompareArb.format(3, URLFileSystem.getFileName((URL)this._node.getURL()));
    }

    public String getLongLabel() {
        return URLFileSystem.getPlatformPathName((URL)this._node.getURL());
    }

    public boolean isEditable() {
        return this.getTextBuffer().isReadOnly() ^ true;
    }

    public boolean isModified() {
        return this.getTextBuffer().isModified();
    }

    public PatchCompareDescriptor getPatchDescriptor() {
        if (this._patchDescriptor == null) {
            this._patchDescriptor = new PatchCompareDescriptor(URLFileSystem.getFileName((URL)this._node.getURL()));
            this._patchDescriptor.setPatchParentURL(URLFileSystem.getParent((URL)this._node.getURL()));
        }
        this._patchDescriptor.setLastModified(this._node.isDirty() ? System.currentTimeMillis() : URLFileSystem.lastModified((URL)this._node.getURL()));
        return this._patchDescriptor;
    }
}

