/*
 * Decompiled with CFR 0.152.
 */
package oracle.jdeveloper.compare;

import java.io.IOException;
import java.io.Reader;
import java.net.URL;
import oracle.ide.net.URLFileSystem;
import oracle.javatools.buffer.TextBuffer;
import oracle.javatools.buffer.TextBufferFactory;
import oracle.javatools.compare.algorithm.text.TextCompareContributor;
import oracle.jdeveloper.compare.PatchCompareContributor;
import oracle.jdeveloper.compare.PatchCompareDescriptor;
import oracle.jdeveloper.compare.StreamDecoder;

public class URLContributor
extends TextCompareContributor
implements PatchCompareContributor {
    private final URL _url;
    private final TextBuffer _buffer;
    private final String _type;
    private PatchCompareDescriptor _patchDescriptor;

    public URLContributor(URL uRL) throws IOException {
        this(null, uRL);
    }

    public URLContributor(URL uRL, URL uRL2) throws IOException {
        this(URLFileSystem.getSuffix((URL)(uRL != null ? uRL : uRL2)), uRL, uRL2);
    }

    public URLContributor(String string, URL uRL, URL uRL2) throws IOException {
        this._url = uRL2;
        Reader reader = StreamDecoder.getReader(string, uRL2.openStream(), StreamDecoder.getDefaultEncoding(uRL != null ? uRL : uRL2));
        this._buffer = TextBufferFactory.createTextBuffer();
        this._buffer.read(reader);
        this._type = URLContributor.getPlatformPathSuffix(this._url);
    }

    protected static String getPlatformPathSuffix(URL uRL) {
        String string = URLFileSystem.getPlatformPathName((URL)uRL);
        int n = string.lastIndexOf(46);
        if (n < 0 || n > string.length() - 2) {
            return "";
        }
        return string.substring(n + 1);
    }

    public TextBuffer getTextBuffer() {
        return this._buffer;
    }

    public String getType() {
        return this._type;
    }

    public String getShortLabel() {
        return URLFileSystem.getFileName((URL)this._url);
    }

    public String getLongLabel() {
        return URLFileSystem.getPlatformPathName((URL)this._url);
    }

    public PatchCompareDescriptor getPatchDescriptor() {
        if (this._patchDescriptor != null) {
            return this._patchDescriptor;
        }
        this._patchDescriptor = new PatchCompareDescriptor(URLFileSystem.getFileName((URL)this._url));
        this._patchDescriptor.setPatchParentURL(URLFileSystem.getParent((URL)this._url));
        this._patchDescriptor.setLastModified(URLFileSystem.lastModified((URL)this._url));
        return this._patchDescriptor;
    }
}

