/*
 * Decompiled with CFR 0.152.
 */
package oracle.jdeveloper.compiler;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import oracle.jdeveloper.compiler.BuildNode;
import oracle.jdeveloper.compiler.Translator;

class BuildGraph {
    ArrayList buildRoots;
    HashMap buildNodes;

    void $init$() {
        this.buildRoots = new ArrayList(5);
        this.buildNodes = new HashMap(19);
    }

    BuildGraph() {
        this.$init$();
    }

    static boolean isPreprocessor(Translator translator) {
        ArrayList arrayList = translator.getInputTypes();
        ArrayList arrayList2 = translator.getOutputTypes();
        if (arrayList.size() >= 1 && arrayList.size() == arrayList2.size()) {
            int n = 0;
            while (n < arrayList.size()) {
                if (!arrayList2.contains(arrayList.get(n))) {
                    return false;
                }
                ++n;
            }
            return true;
        }
        return false;
    }

    private void walkAndInsertInOrderedList(BuildNode buildNode, ArrayList arrayList) {
        if (buildNode.marker == 0 && buildNode.translator != null) {
            int n = 0;
            while (n < buildNode.children.size()) {
                BuildNode buildNode2 = (BuildNode)buildNode.children.get(n);
                this.walkAndInsertInOrderedList(buildNode2, arrayList);
                ++n;
            }
            buildNode.marker = 1;
            int n2 = 0;
            while (n2 < arrayList.size()) {
                if (arrayList.get(n2) == buildNode.translator) break;
                ++n2;
            }
            if (n2 >= arrayList.size()) {
                arrayList.add(0, buildNode.translator);
                if (buildNode.preProcessors != null) {
                    int n3 = 0;
                    while (n3 < buildNode.preProcessors.size()) {
                        Translator translator = (Translator)buildNode.preProcessors.get(n3);
                        if (!arrayList.contains(translator)) {
                            arrayList.add(0, translator);
                        }
                        ++n3;
                    }
                }
            }
        }
    }

    public ArrayList getOrderedTranslatorList() {
        ArrayList arrayList = new ArrayList();
        int n = 0;
        while (n < this.buildRoots.size()) {
            BuildNode buildNode = (BuildNode)this.buildRoots.get(n);
            this.walkAndInsertInOrderedList(buildNode, arrayList);
            ++n;
        }
        Iterator iterator = this.buildNodes.values().iterator();
        while (iterator.hasNext()) {
            ((BuildNode)iterator.next()).marker = 0;
        }
        return arrayList;
    }

    private boolean walkChildren(BuildNode buildNode, int n) {
        if (buildNode.marker == n) {
            System.out.println("error: walkGraph: circularity detected with node");
            return false;
        }
        buildNode.marker = n;
        int n2 = 0;
        while (n2 < buildNode.children.size()) {
            if (!this.walkChildren((BuildNode)buildNode.children.get(n2), n)) {
                return false;
            }
            ++n2;
        }
        if (buildNode.children.size() != 0 ^ buildNode.translator != null && buildNode.translator != null && buildNode.translator.getOutputTypes().size() > 0 && !BuildGraph.isPreprocessor(buildNode.translator)) {
            System.out.println("internal error: walkGraph: node with children should have a translator && node without them shouldn't have one");
        }
        buildNode.marker = -1;
        return true;
    }

    private boolean checkGraph() {
        boolean bl = true;
        int n = 0;
        while (n < this.buildRoots.size()) {
            if (!this.walkChildren((BuildNode)this.buildRoots.get(n), n + 1)) {
                bl = false;
            }
            ++n;
        }
        for (BuildNode buildNode : this.buildNodes.values()) {
            if (buildNode.marker == 0) {
                System.out.println("checkGraph: node is not reachable");
                bl = false;
            }
            buildNode.marker = 0;
        }
        return bl;
    }

    boolean rebuild(HashMap hashMap) {
        this.buildNodes.clear();
        this.buildRoots.clear();
        for (String string : hashMap.keySet()) {
            ArrayList arrayList = (ArrayList)hashMap.get(string);
            int n = 0;
            while (n < arrayList.size()) {
                Translator translator = (Translator)arrayList.get(n);
                BuildNode buildNode = (BuildNode)this.buildNodes.get(string);
                if (buildNode == null) {
                    buildNode = new BuildNode(string, translator);
                    this.buildNodes.put(string, buildNode);
                    this.buildRoots.add(buildNode);
                } else if (buildNode != null && !buildNode.containsTranslator(translator)) {
                    buildNode.addTranslator(translator);
                }
                if (!BuildGraph.isPreprocessor(translator)) {
                    ArrayList arrayList2 = translator.getOutputTypes();
                    int n2 = 0;
                    while (n2 < arrayList2.size()) {
                        String string2 = (String)arrayList2.get(n2);
                        BuildNode buildNode2 = (BuildNode)this.buildNodes.get(string2);
                        if (buildNode2 == null) {
                            buildNode2 = new BuildNode(string2, (ArrayList)hashMap.get(string2));
                            this.buildNodes.put(string2, buildNode2);
                        }
                        if (buildNode2 != buildNode) {
                            int n3 = 0;
                            while (n3 < buildNode2.parents.size()) {
                                if (buildNode2.parents.get(n3) == buildNode) break;
                                ++n3;
                            }
                            if (n3 >= buildNode2.parents.size()) {
                                buildNode2.parents.add(buildNode);
                            }
                            n3 = 0;
                            while (n3 < buildNode.children.size()) {
                                if (buildNode.children.get(n3) == buildNode2) break;
                                ++n3;
                            }
                            if (n3 >= buildNode.children.size()) {
                                buildNode.children.add(buildNode2);
                            }
                        }
                        ++n2;
                    }
                }
                ++n;
            }
        }
        int n = 0;
        while (n < this.buildRoots.size()) {
            BuildNode buildNode = (BuildNode)this.buildRoots.get(n);
            if (buildNode.parents.size() > 0) {
                this.buildRoots.remove(n);
                continue;
            }
            ++n;
        }
        return this.checkGraph() && this.buildRoots.size() > 0;
    }
}

