/*
 * Decompiled with CFR 0.152.
 */
package oracle.jdeveloper.compiler;

import java.util.ArrayList;
import oracle.jdeveloper.compiler.BuildGraph;
import oracle.jdeveloper.compiler.Translator;

class BuildNode {
    int marker = 0;
    ArrayList parents;
    ArrayList children;
    String name;
    ArrayList preProcessors;
    Translator translator;
    static final /* synthetic */ boolean $assertionsDisabled;

    BuildNode(String string, Translator translator) {
        this.name = string;
        this.translator = translator;
        this.preProcessors = null;
        this.parents = new ArrayList(1);
        this.children = new ArrayList(1);
    }

    BuildNode(String string, ArrayList arrayList) {
        this.name = string;
        this.parents = new ArrayList(1);
        this.children = new ArrayList(1);
        int n = arrayList != null ? arrayList.size() : 0;
        this.preProcessors = n > 1 ? new ArrayList(n - 1) : null;
        this.translator = null;
        int n2 = 0;
        while (n2 < n) {
            Translator translator = (Translator)arrayList.get(n2);
            if (this.translator == null && !BuildGraph.isPreprocessor(translator)) {
                this.translator = translator;
            } else if (n2 == n - 1 && this.translator == null) {
                this.translator = translator;
            } else {
                this.preProcessors.add(translator);
            }
            ++n2;
        }
    }

    boolean containsTranslator(Translator translator) {
        return translator == this.translator || this.preProcessors != null && this.preProcessors.contains(translator);
    }

    static {
        $assertionsDisabled = BuildNode.class.desiredAssertionStatus() ^ true;
    }

    void addTranslator(Translator translator) {
        if (this.preProcessors == null) {
            this.preProcessors = new ArrayList(1);
        }
        if (BuildGraph.isPreprocessor(translator)) {
            this.preProcessors.add(translator);
        } else {
            if (!$assertionsDisabled && !BuildGraph.isPreprocessor(this.translator)) {
                throw new AssertionError();
            }
            this.preProcessors.add(this.translator);
            this.translator = translator;
        }
    }
}

