/*
 * Decompiled with CFR 0.152.
 */
package oracle.jdeveloper.compiler;

import java.awt.Component;
import java.awt.Toolkit;
import java.awt.Window;
import java.awt.datatransfer.StringSelection;
import java.io.File;
import java.net.URL;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.Map;
import java.util.Set;
import javax.swing.Icon;
import javax.swing.JComponent;
import javax.swing.JTree;
import javax.swing.SwingUtilities;
import javax.swing.tree.DefaultMutableTreeNode;
import javax.swing.tree.DefaultTreeCellRenderer;
import javax.swing.tree.DefaultTreeModel;
import javax.swing.tree.TreeNode;
import javax.swing.tree.TreePath;
import oracle.bali.ewt.help.HelpUtils;
import oracle.ide.Context;
import oracle.ide.Ide;
import oracle.ide.ceditor.CodeEditor;
import oracle.ide.ceditor.CodeNavigationPoint;
import oracle.ide.editor.Editor;
import oracle.ide.editor.EditorManager;
import oracle.ide.help.HelpInfo;
import oracle.ide.layout.ViewId;
import oracle.ide.log.DefaultLogPage;
import oracle.ide.log.LogManager;
import oracle.ide.log.LogPage;
import oracle.ide.model.Node;
import oracle.ide.model.NodeFactory;
import oracle.ide.model.Observer;
import oracle.ide.model.Project;
import oracle.ide.model.TextNode;
import oracle.ide.model.UpdateMessage;
import oracle.ide.model.Workspace;
import oracle.ide.navigation.DefaultNavigationPoint;
import oracle.ide.navigation.NavigationManager;
import oracle.ide.navigation.NavigationPoint;
import oracle.ide.net.URLFactory;
import oracle.ide.net.URLFileSystem;
import oracle.ide.util.IdeUtil;
import oracle.ide.view.ActiveViewEvent;
import oracle.ide.view.ActiveViewListener;
import oracle.ide.view.View;
import oracle.javatools.buffer.LineMap;
import oracle.javatools.buffer.OffsetMark;
import oracle.javatools.buffer.TextBuffer;
import oracle.javatools.dialogs.ExceptionDialog;
import oracle.javatools.resource.CommonIconsUtils;
import oracle.jdeveloper.compiler.CompArb;
import oracle.jdeveloper.compiler.IdeLog;
import oracle.jdeveloper.compiler.IdeStorage;
import oracle.jdeveloper.compiler.JarStorage;
import oracle.ojc.interfaces.Storage;

public class CompilerPage
extends DefaultLogPage
implements Observer,
ActiveViewListener {
    private DefaultMutableTreeNode root;
    private DefaultTreeModel model;
    private HashMap urlOffsetMarkTable;
    private HashMap urlTreeNodeTable;
    private boolean createWorkspaceNodes;
    private boolean createProjectNodes;
    private static final int MAX_ASYNC_MESSAGES = 100;
    private static final int ASYNC_THREAD_SLEEP = 1000;
    private ArrayList asyncMessages;
    private Thread updateThread;

    void $init$() {
        this.root = new DefaultMutableTreeNode("root");
        this.model = new DefaultTreeModel(this.root);
        this.urlOffsetMarkTable = new HashMap();
        this.urlTreeNodeTable = new HashMap();
        this.createProjectNodes = true;
        this.asyncMessages = new ArrayList(100);
        this.updateThread = null;
    }

    public CompilerPage() {
        this("CompilerPageId", CompArb.getString(39), null);
    }

    public CompilerPage(String string, String string2, Icon icon, int n) {
        super(new ViewId(string, string2), icon, false, n);
        this.$init$();
        this.setModel(this.model);
        this.getTree().setCellRenderer(new MessageCellRenderer(null));
        Ide.getMainWindow().addActiveViewListener((ActiveViewListener)this);
    }

    public CompilerPage(String string, String string2, Icon icon) {
        this(string, string2, icon, DefaultLogPage.HIDE_FIX_SOURCE_MENU);
    }

    public void log(Object object) {
        if (!(object instanceof IdeLog.Message)) {
            this.requestShow();
        }
        this.logMsg(object);
    }

    protected void setCreateWorkspaceNodes(boolean bl) {
        this.createWorkspaceNodes = bl;
    }

    protected void setCreateProjectNodes(boolean bl) {
        this.createProjectNodes = bl;
    }

    protected Icon getLeafIcon(IdeLog.Message message) {
        if (message != null) {
            if (message.isWarning()) {
                return CommonIconsUtils.getWarningIcon();
            }
            if (message.isError()) {
                return CommonIconsUtils.getErrorIcon();
            }
        }
        return null;
    }

    protected String treeNodeToString(Object object) {
        if (object instanceof DefaultMutableTreeNode && ((DefaultMutableTreeNode)object).isLeaf() && (object = ((DefaultMutableTreeNode)object).getUserObject()) instanceof MsgTreeNode && (object = ((MsgTreeNode)object).getMessage()) instanceof IdeLog.Message) {
            object = ((IdeLog.Message)object).msg;
        }
        return super.treeNodeToString(object);
    }

    private void copyPartialImportWarningToClipboard(IdeLog.Message message) {
        if (IdeLog.isPartiallyUsedImportWarning(message)) {
            String string = message.msg;
            StringBuffer stringBuffer = new StringBuffer(256);
            int n = string.indexOf("\n");
            if (n == -1) {
                return;
            }
            n = string.indexOf("import ", n);
            while (n > -1) {
                int n2 = string.indexOf("\n", n);
                if (n2 == -1) {
                    stringBuffer.append(string.substring(n));
                    stringBuffer.append("\n");
                    n2 = string.length() - 1;
                } else {
                    stringBuffer.append(string.substring(n, n2 + 1));
                }
                n = string.indexOf("import ", n2);
            }
            Toolkit.getDefaultToolkit().getSystemClipboard().setContents(new StringSelection(stringBuffer.toString()), null);
        }
    }

    protected String fixMessages(IdeLog.Message message) {
        int n;
        String string = message.msg;
        if (IdeLog.isPartiallyUsedImportWarning(message) && (n = string.indexOf("\n")) > -1) {
            string = string.substring(0, n) + " (dbl-click will copy replacement to clipboard)" + string.substring(n);
        }
        string = string.replace('\r', ' ').replace('\n', ' ').replace('\t', ' ');
        return string;
    }

    private Editor openPreferredEditor(Context context) {
        EditorManager editorManager = EditorManager.getEditorManager();
        try {
            Editor editor = editorManager.openEditorInFrame(CodeEditor.class, context);
            if (editor != null) {
                Editor editor2 = editor;
                return editor2;
            }
        }
        catch (Exception exception) {
            exception.printStackTrace();
        }
        return editorManager.openDefaultEditorInFrame(context);
    }

    private Editor openPreferredEditor(URL uRL, Workspace workspace, Project project) {
        try {
            Node node = NodeFactory.findOrCreate((URL)uRL);
            Context context = Context.newIdeContext((Node)node);
            context.setWorkspace(workspace);
            context.setProject(project);
            Editor editor = this.openPreferredEditor(context);
            return editor;
        }
        catch (Exception exception) {
            ExceptionDialog.showExceptionDialog((Window)Ide.getMainWindow(), (Exception)exception);
            return null;
        }
    }

    private Editor getEditorFromTreeNode(DefaultMutableTreeNode defaultMutableTreeNode, Workspace workspace, Project project) {
        MsgTreeNode msgTreeNode = (MsgTreeNode)defaultMutableTreeNode.getUserObject();
        Object object = msgTreeNode.getNodeData();
        Editor editor = null;
        Project project2 = Ide.getActiveProject();
        Project project3 = msgTreeNode.getProject();
        if (project3 != null) {
            Ide.setActiveProject((Project)project3);
        }
        Workspace workspace2 = Ide.getActiveWorkspace();
        Workspace workspace3 = msgTreeNode.getWorkspace();
        if (workspace3 != null) {
            Ide.setActiveWorkspace((Workspace)workspace3);
        }
        if (object instanceof Storage) {
            EditorManager editorManager = EditorManager.getEditorManager();
            Storage storage = (Storage)object;
            if (storage instanceof IdeStorage) {
                Context context = Context.newIdeContext((Node)((IdeStorage)storage).node);
                context.setWorkspace(workspace);
                context.setProject(project);
                editor = this.openPreferredEditor(context);
            } else if (storage instanceof JarStorage) {
                editor = this.openPreferredEditor(((JarStorage)storage).getURL(), workspace, project);
            } else {
                File file = new File(storage.getPath());
                if (file.exists()) {
                    editor = this.openPreferredEditor(URLFactory.newFileURL((File)file), workspace, project);
                }
            }
        }
        Ide.setActiveProject((Project)project2);
        Ide.setActiveWorkspace((Workspace)workspace2);
        return editor;
    }

    protected void fixObject(Object object) {
        this.activateObject(object);
        DefaultMutableTreeNode defaultMutableTreeNode = (DefaultMutableTreeNode)object;
        MsgTreeNode msgTreeNode = (MsgTreeNode)defaultMutableTreeNode.getUserObject();
        msgTreeNode.invokeFixEvent();
    }

    protected boolean canFixObject(DefaultMutableTreeNode defaultMutableTreeNode) {
        MsgTreeNode msgTreeNode = (MsgTreeNode)defaultMutableTreeNode.getUserObject();
        return msgTreeNode.canInvokeFixEvent();
    }

    /*
     * Unable to fully structure code
     */
    protected void activateObject(Object var1_1) {
        var2_2 = (DefaultMutableTreeNode)var1_1;
        var3_3 = (MsgTreeNode)var2_2.getUserObject();
        if (var3_3.invokeActivateEvent()) {
            return;
        }
        var4_4 = var3_3.getMessage();
        this.copyPartialImportWarningToClipboard(var4_4);
        var5_5 = null;
        var6_6 = this.getEditorFromTreeNode((DefaultMutableTreeNode)var2_2.getParent(), var4_4.workspace, var4_4.project);
        if (var6_6 instanceof CodeEditor) {
            var7_7 = (CodeEditor)var6_6;
            var8_8 = var4_4.line;
            var9_9 = var4_4.col;
            if (var3_3.offsetMark == null) {
                this.activeViewChanged(null);
            }
            if (var3_3.offsetMark != null && var3_3.getURL() != null) {
                var10_10 = (TextNode)NodeFactory.find((URL)var3_3.getURL());
                try {
                    try {
                        var11_11 = var10_10.acquireTextBuffer();
                        var12_12 = var11_11.getLineMap();
                        var8_8 = var12_12.getLineFromOffset(var3_3.offsetMark.getOffset()) + 1;
                        if (var9_9 <= 0) ** GOTO lbl37
                        --var9_9;
                    }
                    catch (Throwable var13_13) {}
                }
                finally {
                    var10_10.releaseTextBuffer();
                }
            } else if (var8_8 == 0 && var9_9 > 0) {
                var8_8 = var7_7.getLineFromOffset(var9_9) + 1;
                var14_15 = var7_7.getLineStartOffset(var8_8 - 1);
                var9_9 = var14_15 < var9_9 ? var9_9 - var14_15 : 1;
            } else if (var9_9 > 0) {
                --var9_9;
            }
lbl37:
            // 7 sources

            var7_7.gotoLine(var8_8, var9_9, IdeLog.isPartiallyUsedImportWarning(var4_4) != false || IdeLog.isUnusedImportWarning(var4_4) != false);
            Ide.getStatusBar().setText(var4_4.msg);
            var5_5 = new CodeNavigationPoint();
        } else if (var6_6 != null) {
            var5_5 = new DefaultNavigationPoint();
        }
        if (var5_5 != null && (var15_16 = NavigationManager.getNavigationManager()) != null) {
            var5_5.setContext(var6_6.getContext());
            try {
                var15_16.navigateTo((NavigationPoint)var5_5);
            }
            catch (Exception var16_17) {
                var16_17.printStackTrace();
            }
        }
    }

    public HelpInfo getHelpInfo() {
        return new HelpInfo("f1_com_logwindow_html");
    }

    private JTree inScopeGetTree() {
        return this.getTree();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void logMsg(Object object) {
        if (object instanceof IdeLog.Message) {
            ArrayList arrayList = this.asyncMessages;
            synchronized (arrayList) {
                this.asyncMessages.add(object);
                if (this.asyncMessages.size() == 100) {
                    this.processAsyncMsgQueue(100);
                }
            }
        } else {
            super.logMsg(object);
        }
    }

    public void startAsynchronousLogging() {
        this.updateThread = new 2("Log Page Updater");
        this.updateThread.setPriority(this.updateThread.getPriority() - 1);
        this.updateThread.start();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void cancelAsynchronousLogging() {
        this.updateThread = null;
        ArrayList arrayList = this.asyncMessages;
        synchronized (arrayList) {
            this.asyncMessages.clear();
        }
    }

    public void finishAsynchronousLogging() {
        this.updateThread = null;
        this.processAsyncMsgQueue(-1);
        if (this.root.getChildCount() > 0) {
            this.requestShow();
        }
    }

    public boolean isShowingTree() {
        return this.getCurrentView() == this.getTree();
    }

    private void processAsyncMsgQueue(int n) {
        1 var2_2 = new 1(this, n);
        if (SwingUtilities.isEventDispatchThread()) {
            var2_2.run();
        } else {
            SwingUtilities.invokeLater(var2_2);
        }
    }

    private void removeMessages(IdeLog.Message message) {
        DefaultMutableTreeNode defaultMutableTreeNode;
        DefaultMutableTreeNode defaultMutableTreeNode2 = defaultMutableTreeNode = this.getProjectNode(this.root, message.project, false);
        if (defaultMutableTreeNode == null) {
            return;
        }
        if (message.fname != null) {
            DefaultMutableTreeNode defaultMutableTreeNode3 = defaultMutableTreeNode;
            if ((defaultMutableTreeNode = this.getFileNode(defaultMutableTreeNode3, message.fname, false)) == null) {
                return;
            }
            if (defaultMutableTreeNode3.getChildCount() == 1) {
                defaultMutableTreeNode = defaultMutableTreeNode3;
            }
        }
        this.recursivelyRemoveNode(defaultMutableTreeNode, true);
        if (defaultMutableTreeNode == defaultMutableTreeNode2 && message.project != null) {
            message.project.detach((Observer)this);
        }
    }

    private void addMsg(IdeLog.Message message) {
        JTree jTree = this.inScopeGetTree();
        if (this.getCurrentView() != jTree) {
            this.setCurrentView(jTree);
        }
        if (message.isStarting()) {
            int n = this.root.getChildCount() - 1;
            while (n >= 0) {
                DefaultMutableTreeNode defaultMutableTreeNode = (DefaultMutableTreeNode)this.root.getChildAt(n);
                if (((MsgTreeNode)defaultMutableTreeNode.getUserObject()).getMessage() != null) {
                    this.recursivelyRemoveNode(defaultMutableTreeNode, true);
                }
                --n;
            }
            return;
        }
        if (message.isCompleted()) {
            if (this.root.getChildCount() == 0) {
                View view = Ide.getMainWindow().getLastActiveView();
                LogManager.getLogManager().removePage((LogPage)this);
                if (view == this) {
                    IdeUtil.tryToRestoreFocus(null);
                }
            }
            return;
        }
        if (message.isRemove()) {
            this.removeMessages(message);
            return;
        }
        if (this.root.getChildCount() == 0) {
            if (!LogManager.getLogManager().isLogVisible()) {
                LogManager.getLogManager().showLog();
            }
            if (!this.isVisible()) {
                this.requestShow();
            }
        }
        if (Ide.getMainWindow().getLastActiveView() == LogManager.getLogManager().getLogWindow()) {
            IdeUtil.tryToRestoreFocus((Component)jTree);
        } else {
            this.requestShow();
        }
        DefaultMutableTreeNode defaultMutableTreeNode = this.root;
        if (this.createWorkspaceNodes && message.workspace != null) {
            defaultMutableTreeNode = this.getWorkspaceNode(defaultMutableTreeNode, message.workspace.getURL(), true);
        }
        if (this.createProjectNodes && message.project != null) {
            defaultMutableTreeNode = this.getProjectNode(defaultMutableTreeNode, message.project, true);
        }
        if (message.fname != null) {
            defaultMutableTreeNode = this.getFileNode(defaultMutableTreeNode, message.fname, true);
        }
        if (message.isNoDetails()) {
            jTree.makeVisible(new TreePath(defaultMutableTreeNode.getPath()));
            return;
        }
        String string = this.fixMessages(message);
        DefaultMutableTreeNode defaultMutableTreeNode2 = new DefaultMutableTreeNode(new MsgTreeNode(string, message));
        if (message.isError()) {
            int n = this.getLastErrorIndex(defaultMutableTreeNode, false);
            if (n == -1) {
                if (message.fname != null) {
                    int n2;
                    DefaultMutableTreeNode defaultMutableTreeNode3 = (DefaultMutableTreeNode)defaultMutableTreeNode.getParent();
                    int n3 = defaultMutableTreeNode3.getIndex(defaultMutableTreeNode);
                    int n4 = this.getLastErrorIndex(defaultMutableTreeNode3, true);
                    int n5 = n2 = n4 == -1 ? 0 : n4 + 1;
                    if (n2 != n3) {
                        DefaultTreeModel defaultTreeModel = (DefaultTreeModel)jTree.getModel();
                        defaultMutableTreeNode3.remove(defaultMutableTreeNode);
                        defaultTreeModel.nodesWereRemoved(defaultMutableTreeNode3, new int[]{n3}, new Object[]{defaultMutableTreeNode});
                        defaultMutableTreeNode3.insert(defaultMutableTreeNode, n2);
                        defaultTreeModel.nodesWereInserted(defaultMutableTreeNode3, new int[]{n2});
                    }
                }
                defaultMutableTreeNode.insert(defaultMutableTreeNode2, 0);
            } else {
                defaultMutableTreeNode.insert(defaultMutableTreeNode2, n + 1);
            }
        } else {
            String string2 = defaultMutableTreeNode2.toString();
            int n = defaultMutableTreeNode.getChildCount() - 1;
            while (n >= 0) {
                DefaultMutableTreeNode defaultMutableTreeNode4 = (DefaultMutableTreeNode)defaultMutableTreeNode.getChildAt(n);
                if (defaultMutableTreeNode4.toString().equals(string2)) {
                    return;
                }
                --n;
            }
            defaultMutableTreeNode.add(defaultMutableTreeNode2);
        }
        DefaultMutableTreeNode defaultMutableTreeNode5 = defaultMutableTreeNode;
        DefaultTreeModel defaultTreeModel = (DefaultTreeModel)jTree.getModel();
        defaultTreeModel.nodesWereInserted(defaultMutableTreeNode5, new int[]{defaultMutableTreeNode5.getIndex(defaultMutableTreeNode2)});
        jTree.makeVisible(new TreePath(defaultMutableTreeNode2.getPath()));
    }

    private int getLastErrorIndex(DefaultMutableTreeNode defaultMutableTreeNode, boolean bl) {
        int n = -1;
        Enumeration<TreeNode> enumeration = defaultMutableTreeNode.children();
        int n2 = 0;
        while (enumeration.hasMoreElements()) {
            DefaultMutableTreeNode defaultMutableTreeNode2;
            IdeLog.Message message;
            DefaultMutableTreeNode defaultMutableTreeNode3 = (DefaultMutableTreeNode)enumeration.nextElement();
            Object object = defaultMutableTreeNode3.getUserObject();
            if (object instanceof MsgTreeNode && ((MsgTreeNode)object).getMessage() != null && ((MsgTreeNode)object).getMessage().isError()) {
                n = n2;
            } else if (bl && defaultMutableTreeNode3.getChildCount() > 0 && (message = ((MsgTreeNode)(defaultMutableTreeNode2 = (DefaultMutableTreeNode)defaultMutableTreeNode3.getChildAt(0)).getUserObject()).getMessage()) != null && message.isError()) {
                n = n2;
            }
            ++n2;
        }
        return n;
    }

    private DefaultMutableTreeNode getWorkspaceNode(DefaultMutableTreeNode defaultMutableTreeNode, URL uRL, boolean bl) {
        DefaultMutableTreeNode defaultMutableTreeNode2 = null;
        Enumeration<TreeNode> enumeration = defaultMutableTreeNode.children();
        while (enumeration.hasMoreElements()) {
            DefaultMutableTreeNode defaultMutableTreeNode3 = (DefaultMutableTreeNode)enumeration.nextElement();
            URL uRL2 = ((MsgTreeNode)defaultMutableTreeNode3.getUserObject()).getURL();
            if (!URLFileSystem.equals((URL)uRL2, (URL)uRL)) continue;
            defaultMutableTreeNode2 = defaultMutableTreeNode3;
            break;
        }
        if (defaultMutableTreeNode2 == null && bl) {
            String string = CompArb.format(74, URLFileSystem.getPlatformPathName((URL)uRL));
            MsgTreeNode msgTreeNode = new MsgTreeNode(string, null);
            msgTreeNode.setURL(uRL);
            defaultMutableTreeNode2 = new DefaultMutableTreeNode(msgTreeNode);
            defaultMutableTreeNode.add(defaultMutableTreeNode2);
            DefaultMutableTreeNode defaultMutableTreeNode4 = defaultMutableTreeNode2;
            DefaultTreeModel defaultTreeModel = (DefaultTreeModel)this.inScopeGetTree().getModel();
            defaultTreeModel.nodesWereInserted(defaultMutableTreeNode, new int[]{defaultMutableTreeNode.getIndex(defaultMutableTreeNode4)});
        }
        return defaultMutableTreeNode2;
    }

    private DefaultMutableTreeNode getProjectNode(DefaultMutableTreeNode defaultMutableTreeNode, Project project, boolean bl) {
        URL uRL = project.getURL();
        DefaultMutableTreeNode defaultMutableTreeNode2 = null;
        Enumeration<TreeNode> enumeration = defaultMutableTreeNode.children();
        while (enumeration.hasMoreElements()) {
            DefaultMutableTreeNode defaultMutableTreeNode3 = (DefaultMutableTreeNode)enumeration.nextElement();
            URL uRL2 = ((MsgTreeNode)defaultMutableTreeNode3.getUserObject()).getURL();
            if (!URLFileSystem.equals((URL)uRL2, (URL)uRL)) continue;
            defaultMutableTreeNode2 = defaultMutableTreeNode3;
            break;
        }
        if (defaultMutableTreeNode2 == null && bl) {
            String string = CompArb.format(71, URLFileSystem.getPlatformPathName((URL)uRL));
            MsgTreeNode msgTreeNode = new MsgTreeNode(string, null);
            msgTreeNode.setURL(uRL);
            defaultMutableTreeNode2 = new DefaultMutableTreeNode(msgTreeNode);
            defaultMutableTreeNode.add(defaultMutableTreeNode2);
            DefaultMutableTreeNode defaultMutableTreeNode4 = defaultMutableTreeNode2;
            DefaultTreeModel defaultTreeModel = (DefaultTreeModel)this.inScopeGetTree().getModel();
            defaultTreeModel.nodesWereInserted(defaultMutableTreeNode, new int[]{defaultMutableTreeNode.getIndex(defaultMutableTreeNode4)});
            project.attach((Observer)this);
        }
        return defaultMutableTreeNode2;
    }

    protected DefaultMutableTreeNode getFileNode(DefaultMutableTreeNode defaultMutableTreeNode, Storage storage, boolean bl) {
        URL uRL = URLFactory.newURL((String)storage.getPath());
        DefaultMutableTreeNode defaultMutableTreeNode2 = (DefaultMutableTreeNode)this.urlTreeNodeTable.get(uRL);
        if (defaultMutableTreeNode2 == null && bl) {
            MsgTreeNode msgTreeNode = new MsgTreeNode(storage, null);
            msgTreeNode.setURL(uRL);
            defaultMutableTreeNode2 = new DefaultMutableTreeNode(msgTreeNode);
            defaultMutableTreeNode.add(defaultMutableTreeNode2);
            DefaultMutableTreeNode defaultMutableTreeNode3 = defaultMutableTreeNode2;
            DefaultTreeModel defaultTreeModel = (DefaultTreeModel)this.inScopeGetTree().getModel();
            defaultTreeModel.nodesWereInserted(defaultMutableTreeNode, new int[]{defaultMutableTreeNode.getIndex(defaultMutableTreeNode3)});
            this.urlTreeNodeTable.put(uRL, defaultMutableTreeNode2);
        }
        return defaultMutableTreeNode2;
    }

    protected void updateTreeModel(Collection collection) {
        try {
            HelpUtils.setHelpID((JComponent)this.inScopeGetTree(), (String)"f1_com_logwindow_html");
            SwingUtilities.invokeLater(new CreateLogTree(collection));
        }
        catch (Exception exception) {
            exception.printStackTrace();
        }
    }

    protected void setOffsetMarkTable(URL uRL, DefaultMutableTreeNode defaultMutableTreeNode) {
        Node node = NodeFactory.find((URL)uRL);
        if (node instanceof TextNode) {
            TextNode textNode = (TextNode)node;
            try {
                try {
                    TextBuffer textBuffer = textNode.acquireTextBuffer();
                    LineMap lineMap = textBuffer.getLineMap();
                    int n = defaultMutableTreeNode.getChildCount();
                    OffsetMark[] offsetMarkArray = new OffsetMark[n];
                    int n2 = 0;
                    while (n2 < n) {
                        DefaultMutableTreeNode defaultMutableTreeNode2 = (DefaultMutableTreeNode)defaultMutableTreeNode.getChildAt(n2);
                        MsgTreeNode msgTreeNode = (MsgTreeNode)defaultMutableTreeNode2.getUserObject();
                        IdeLog.Message message = msgTreeNode.getMessage();
                        int n3 = message.line == 0 && message.col > 0 ? message.col : lineMap.getLineStartOffset(message.line - 1);
                        msgTreeNode.setURL(uRL);
                        offsetMarkArray[n2] = msgTreeNode.offsetMark = textBuffer.addOffsetMark(n3);
                        ++n2;
                    }
                    textNode.attach((Observer)this);
                    this.urlOffsetMarkTable.put(uRL, offsetMarkArray);
                }
                catch (Throwable throwable) {}
            }
            finally {
                textNode.releaseTextBuffer();
            }
        }
    }

    protected void clearUrlOffsetMarkNode(Node node, OffsetMark[] offsetMarkArray) {
        if (node instanceof TextNode) {
            TextBuffer textBuffer;
            TextNode textNode = (TextNode)node;
            if (textNode != null && textNode.isOpen() && (textBuffer = textNode.acquireTextBuffer()) != null) {
                int n = 0;
                while (n < offsetMarkArray.length) {
                    textBuffer.removeOffsetMark(offsetMarkArray[n]);
                    ++n;
                }
            }
            textNode.detach((Observer)this);
        }
    }

    protected void clearUrlOffsetMarkTable() {
        Set set = this.urlOffsetMarkTable.entrySet();
        if (set != null && set.size() > 0) {
            Object[] objectArray = set.toArray();
            int n = 0;
            while (n < objectArray.length) {
                Map.Entry entry = (Map.Entry)objectArray[n];
                URL uRL = (URL)entry.getKey();
                Node node = NodeFactory.find((URL)uRL);
                OffsetMark[] offsetMarkArray = (OffsetMark[])entry.getValue();
                if (offsetMarkArray != null) {
                    this.clearUrlOffsetMarkNode(node, offsetMarkArray);
                }
                ++n;
            }
        }
        this.urlOffsetMarkTable.clear();
        this.urlTreeNodeTable.clear();
    }

    private void removeNode(DefaultMutableTreeNode defaultMutableTreeNode) {
        Object object = defaultMutableTreeNode.getUserObject();
        if (object instanceof MsgTreeNode) {
            this.urlTreeNodeTable.remove(((MsgTreeNode)object).getURL());
        }
        defaultMutableTreeNode.setUserObject(null);
        this.model.removeNodeFromParent(defaultMutableTreeNode);
    }

    private void recursivelyRemoveNode(DefaultMutableTreeNode defaultMutableTreeNode, boolean bl) {
        int n = defaultMutableTreeNode.getChildCount();
        while (n > 0) {
            DefaultMutableTreeNode defaultMutableTreeNode2 = (DefaultMutableTreeNode)defaultMutableTreeNode.getChildAt(n - 1);
            if (!defaultMutableTreeNode2.isLeaf()) {
                this.recursivelyRemoveNode(defaultMutableTreeNode2, false);
            }
            this.removeNode(defaultMutableTreeNode2);
            --n;
        }
        if (bl) {
            this.removeNode(defaultMutableTreeNode);
        }
    }

    private void clearNodes() {
        this.recursivelyRemoveNode(this.root, false);
        this.getTree().setModel(this.model);
        this.clearUrlOffsetMarkTable();
    }

    public void clearAll() {
        this.getTree().scrollRowToVisible(0);
        super.clearAll();
        this.clearNodes();
        this.logText("");
    }

    public String getToolTip() {
        return CompArb.getString(40);
    }

    public void activeViewChanged(ActiveViewEvent activeViewEvent) {
        View view;
        View view2 = view = activeViewEvent != null ? activeViewEvent.getNewView() : Ide.getMainWindow().getLastActiveView();
        if (view == null || !(view instanceof CodeEditor)) {
            return;
        }
        Context context = ((CodeEditor)view).getContext();
        if (context == null || context.getNode() == null || context.getNode().getURL() == null) {
            return;
        }
        URL uRL = context.getNode().getURL();
        DefaultMutableTreeNode defaultMutableTreeNode = (DefaultMutableTreeNode)this.urlTreeNodeTable.get(uRL);
        if (defaultMutableTreeNode != null && this.urlOffsetMarkTable.get(uRL) == null) {
            this.setOffsetMarkTable(uRL, defaultMutableTreeNode);
        }
    }

    public void update(Object object, UpdateMessage updateMessage) {
        int n = updateMessage.getMessageID();
        if (n == UpdateMessage.OBJECT_RELOADED) {
            if (object instanceof TextNode) {
                DefaultMutableTreeNode defaultMutableTreeNode;
                URL uRL = ((TextNode)object).getURL();
                OffsetMark[] offsetMarkArray = (OffsetMark[])this.urlOffsetMarkTable.get(uRL);
                if (offsetMarkArray != null) {
                    this.clearUrlOffsetMarkNode((Node)object, offsetMarkArray);
                }
                if ((defaultMutableTreeNode = (DefaultMutableTreeNode)this.urlTreeNodeTable.get(uRL)) != null) {
                    this.setOffsetMarkTable(uRL, defaultMutableTreeNode);
                }
            }
            return;
        }
        if (n == UpdateMessage.OBJECT_CLOSED) {
            if (object instanceof Project) {
                ((Project)object).detach((Observer)this);
                IdeLog.Message message = new IdeLog.Message(null, (Project)object, null, null, 0, 0, 0, 3);
                this.addMsg(message);
                message = new IdeLog.Message(null, null, null, null, 0, 0, 0, 4);
                this.addMsg(message);
                return;
            }
            if (object instanceof TextNode) {
                DefaultMutableTreeNode defaultMutableTreeNode;
                URL uRL = ((TextNode)object).getURL();
                OffsetMark[] offsetMarkArray = (OffsetMark[])this.urlOffsetMarkTable.remove(uRL);
                if (offsetMarkArray != null) {
                    this.clearUrlOffsetMarkNode((Node)object, offsetMarkArray);
                }
                if ((defaultMutableTreeNode = (DefaultMutableTreeNode)this.urlTreeNodeTable.get(uRL)) != null) {
                    int n2 = defaultMutableTreeNode.getChildCount();
                    int n3 = 0;
                    while (n3 < n2) {
                        DefaultMutableTreeNode defaultMutableTreeNode2 = (DefaultMutableTreeNode)defaultMutableTreeNode.getChildAt(n3);
                        MsgTreeNode msgTreeNode = (MsgTreeNode)defaultMutableTreeNode2.getUserObject();
                        msgTreeNode.offsetMark = null;
                        ++n3;
                    }
                }
                return;
            }
        }
    }

    static ArrayList ra$asyncMessages(CompilerPage compilerPage) {
        return compilerPage.asyncMessages;
    }

    static void mav$processAsyncMsgQueue(CompilerPage compilerPage, int n) {
        compilerPage.processAsyncMsgQueue(n);
    }

    static Thread ra$updateThread(CompilerPage compilerPage) {
        return compilerPage.updateThread;
    }

    static void mav$addMsg(CompilerPage compilerPage, IdeLog.Message message) {
        compilerPage.addMsg(message);
    }

    static void mav$clearNodes(CompilerPage compilerPage) {
        compilerPage.clearNodes();
    }

    private final class MessageCellRenderer
    extends DefaultTreeCellRenderer {
        public Component getTreeCellRendererComponent(JTree jTree, Object object, boolean bl, boolean bl2, boolean bl3, int n, boolean bl4) {
            MsgTreeNode msgTreeNode;
            Icon icon;
            super.getTreeCellRendererComponent(jTree, object, bl, bl2, bl3, n, bl4);
            Object object2 = ((DefaultMutableTreeNode)object).getUserObject();
            if (bl3 && object2 instanceof MsgTreeNode) {
                Icon icon2;
                MsgTreeNode msgTreeNode2 = (MsgTreeNode)object2;
                if (msgTreeNode2 != null && (icon2 = CompilerPage.this.getLeafIcon(msgTreeNode2.getMessage())) != null) {
                    this.setIcon(icon2);
                }
            } else if (object2 instanceof MsgTreeNode && (icon = (msgTreeNode = (MsgTreeNode)object2).getIcon()) != null) {
                this.setIcon(icon);
            }
            return this;
        }

        private MessageCellRenderer() {
        }

        MessageCellRenderer(1 var2_2) {
            this();
        }

        public final class 1 {
        }
    }

    public final class 2
    extends Thread {
        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void run() {
            while (CompilerPage.ra$updateThread(CompilerPage.this) == this) {
                try {
                    Thread.sleep(1000L);
                    ArrayList arrayList = CompilerPage.ra$asyncMessages(CompilerPage.this);
                    synchronized (arrayList) {
                        if (CompilerPage.ra$asyncMessages(CompilerPage.this).size() > 0) {
                            CompilerPage.mav$processAsyncMsgQueue(CompilerPage.this, 100);
                        }
                    }
                }
                catch (InterruptedException interruptedException) {
                    // empty catch block
                }
            }
        }

        public 2(String string) {
            super(string);
        }
    }

    public final class 1
    implements Runnable {
        private final /* synthetic */ int v$max;
        final /* synthetic */ CompilerPage this$0;

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void run() {
            ArrayList arrayList = CompilerPage.ra$asyncMessages(this.this$0);
            synchronized (arrayList) {
                int n = CompilerPage.ra$asyncMessages(this.this$0).size();
                int n2 = this.v$max > 0 && n > this.v$max ? this.v$max : n;
                int n3 = 0;
                while (n3 < n2) {
                    CompilerPage.mav$addMsg(this.this$0, (IdeLog.Message)CompilerPage.ra$asyncMessages(this.this$0).remove(0));
                    ++n3;
                }
            }
        }

        public 1(CompilerPage compilerPage, int n) {
            this.v$max = n;
            this.this$0 = compilerPage;
        }
    }

    public final class CreateLogTree
    implements Runnable {
        private final Collection msgs;

        CreateLogTree(Collection collection) {
            this.msgs = collection;
        }

        public void run() {
            ArrayList<IdeLog.Message> arrayList = this.msgs;
            if (this.msgs == null) {
                return;
            }
            CompilerPage.mav$clearNodes(CompilerPage.this);
            ArrayList<IdeLog.Message> arrayList2 = new ArrayList<IdeLog.Message>(arrayList.size());
            for (IdeLog.Message message : arrayList) {
                if (!message.isError()) continue;
                arrayList2.add(message);
            }
            for (IdeLog.Message message : arrayList) {
                if (message.isError()) continue;
                arrayList2.add(message);
            }
            arrayList = arrayList2;
            for (IdeLog.Message message : arrayList) {
                CompilerPage.mav$addMsg(CompilerPage.this, message);
            }
        }
    }

    protected static final class MsgTreeNode {
        private Object nodeData;
        private IdeLog.Message msg;
        private URL url;
        private Icon icon;
        OffsetMark offsetMark;

        MsgTreeNode(Object object, IdeLog.Message message) {
            this.nodeData = object;
            this.msg = message;
            this.url = null;
            this.offsetMark = null;
        }

        public Object getNodeData() {
            return this.nodeData;
        }

        public IdeLog.Message getMessage() {
            return this.msg;
        }

        public Project getProject() {
            return this.msg != null ? this.msg.project : null;
        }

        public Workspace getWorkspace() {
            return this.msg != null ? this.msg.workspace : null;
        }

        public boolean invokeFixEvent() {
            if (this.msg != null && this.msg.fixEvent != null) {
                this.msg.fixEvent.fix(this.msg);
                return true;
            }
            return false;
        }

        public boolean canInvokeFixEvent() {
            if (this.msg != null && this.msg.fixEvent != null) {
                return this.msg.fixEvent.canFix(this.msg);
            }
            return false;
        }

        public boolean invokeActivateEvent() {
            if (this.msg != null && this.msg.activateEvent != null) {
                this.msg.activateEvent.activate(this.msg);
                return true;
            }
            return false;
        }

        public String toString() {
            return this.nodeData.toString();
        }

        public URL getURL() {
            return this.url;
        }

        public void setURL(URL uRL) {
            this.url = uRL;
            Node node = NodeFactory.find((URL)this.url);
            boolean bl = false;
            if (node == null) {
                try {
                    node = NodeFactory.findOrCreate((URL)uRL);
                    bl = true;
                }
                catch (Exception exception) {
                    // empty catch block
                }
            }
            if (node != null) {
                this.icon = node.getIcon();
            }
            if (bl) {
                NodeFactory.uncache((URL)this.url);
            }
        }

        public Icon getIcon() {
            return this.icon;
        }
    }
}

