/*
 * Decompiled with CFR 0.152.
 */
package oracle.jdeveloper.compiler;

import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.lang.reflect.Method;
import java.net.URL;
import java.util.ArrayList;
import oracle.ide.Addin;
import oracle.ide.compiler.Compiler;
import oracle.ide.compiler.CopyListener;
import oracle.ide.model.Node;
import oracle.ide.model.Project;
import oracle.ide.model.ResourcePaths;
import oracle.ide.model.TextNode;
import oracle.ide.net.URLFactory;
import oracle.ide.net.URLFileSystem;
import oracle.ide.net.URLPath;
import oracle.ide.util.IdeUtil;
import oracle.javatools.data.PropertyStorage;
import oracle.jdeveloper.compiler.CompArb;
import oracle.jdeveloper.compiler.IdeStorage;
import oracle.jdeveloper.compiler.JCompiler;
import oracle.jdeveloper.compiler.Translator;
import oracle.jdeveloper.compiler.UnifiedBuildSystem;
import oracle.jdeveloper.model.J2eeSettings;
import oracle.jdeveloper.model.JavaProject;
import oracle.jdeveloper.model.PathsConfiguration;
import oracle.ojc.interfaces.Storage;

public class CopyTranslator
implements Addin,
Translator {
    private Translator.Log log;
    private String[] copyResSpec;
    private boolean reverseCopyRes;
    private boolean native2asciiAvailable;
    private Method native2asciiMainDotConvert;
    private Object native2asciiMainInstance;

    void $init$() {
        this.log = null;
        this.copyResSpec = null;
        this.reverseCopyRes = false;
        this.native2asciiAvailable = true;
        this.native2asciiMainDotConvert = null;
        this.native2asciiMainInstance = null;
    }

    public CopyTranslator() {
        this.$init$();
    }

    public String getName() {
        return "CopyTranslator";
    }

    public ArrayList getInputTypes() {
        if (this.copyResSpec != null && !this.reverseCopyRes) {
            ArrayList<String> arrayList = new ArrayList<String>(this.copyResSpec.length);
            int n = 0;
            while (n < this.copyResSpec.length) {
                arrayList.add(this.copyResSpec[n]);
                ++n;
            }
            return arrayList;
        }
        return new ArrayList(0);
    }

    public ArrayList getOutputTypes() {
        ArrayList arrayList = new ArrayList(0);
        return arrayList;
    }

    public boolean canBuild(Storage storage) {
        return JCompiler.isCopyable(storage.getName(), this.copyResSpec, this.reverseCopyRes);
    }

    public boolean needToBuild(Storage storage) {
        return false;
    }

    public void setLog(Translator.Log log) {
        this.log = log;
    }

    public void setParameter(String string, String string2) {
        throw new Error();
    }

    public void setProject(Project project) {
        if (project != null) {
            this.copyResSpec = JCompiler.getCopyRes(project);
            this.reverseCopyRes = JCompiler.getReverseCopyRes(project);
        }
    }

    public void updateProject(Project project) {
        this.setProject(project);
    }

    private void initializeListeners(Project project) {
        ArrayList arrayList = JCompiler.getInstance().copyListeners;
        int n = 0;
        while (n < arrayList.size()) {
            ((CopyListener)arrayList.get(n)).initialize(project);
            ++n;
        }
    }

    private boolean handledByListeners(URL uRL, URL[] uRLArray) {
        ArrayList arrayList = JCompiler.getInstance().copyListeners;
        int n = 0;
        while (n < arrayList.size()) {
            if (((CopyListener)arrayList.get(n)).handleCopy(uRL, uRLArray)) {
                return true;
            }
            ++n;
        }
        return false;
    }

    private void terminateListeners() {
        ArrayList arrayList = JCompiler.getInstance().copyListeners;
        int n = 0;
        while (n < arrayList.size()) {
            ((CopyListener)arrayList.get(n)).terminate();
            ++n;
        }
    }

    private boolean native2ascii(Storage storage, URL uRL, URL uRL2) {
        String string = new File(uRL.getPath()).getPath();
        File file = new File(uRL2.getPath());
        File file2 = file.getParentFile();
        String string2 = file.getPath();
        Throwable throwable = null;
        try {
            Object[] objectArray;
            if (this.native2asciiMainInstance == null) {
                Class<?> clazz = Class.forName("sun.tools.native2ascii.Main");
                this.native2asciiMainDotConvert = clazz.getMethod("convert", String[].class);
                this.native2asciiMainInstance = clazz.newInstance();
            }
            if (!file2.exists()) {
                file2.mkdirs();
            }
            if (((Boolean)this.native2asciiMainDotConvert.invoke(this.native2asciiMainInstance, objectArray = new Object[]{new String[]{"-encoding", IdeUtil.getIdeEncoding(), string, string2}})).booleanValue()) {
                boolean bl = true;
                return bl;
            }
        }
        catch (Throwable throwable2) {
            throwable = throwable2;
            this.native2asciiAvailable = false;
        }
        String string3 = throwable != null ? throwable.getMessage() : "";
        String string4 = CompArb.format(76, storage.getName(), string3);
        this.log.error(storage, 0, 0, 0, string4);
        return false;
    }

    private void performCopy(Storage storage, URL uRL, String string, Node node, URL uRL2) throws IOException {
        boolean bl;
        UnifiedBuildSystem.getInstance().markTranslated(storage);
        boolean bl2 = bl = this.native2asciiAvailable && string.endsWith(".properties");
        if (UnifiedBuildSystem.showCompileProgress) {
            int n = bl ? 75 : 72;
            Compiler.getCompiler().logOutMsg("  ");
            Compiler.getCompiler().logOutMsg(CompArb.format(n, string));
            Compiler.getCompiler().logOutMsg("\n");
        }
        URL uRL3 = null;
        if (bl) {
            File file = File.createTempFile("JDev", null);
            uRL3 = uRL2;
            uRL2 = URLFactory.newFileURL((String)file.toString());
        }
        if (node != null) {
            InputStream inputStream = node instanceof TextNode ? ((TextNode)node).getInputStream(false) : node.getInputStream();
            URLFileSystem.copy((InputStream)inputStream, (URL)uRL2);
            inputStream.close();
        } else {
            URLFileSystem.copy((URL)uRL, (URL)uRL2);
        }
        if (!(!bl || this.native2asciiAvailable && this.native2ascii(storage, uRL2, uRL3))) {
            URLFileSystem.copy((URL)uRL2, (URL)uRL3);
        }
    }

    public int translate(Project project, boolean bl, ArrayList arrayList, ArrayList arrayList2) {
        UnifiedBuildSystem.getInstance().beginMarking();
        Project project2 = project;
        URL uRL = JavaProject.getInstance(project2).getOutputDirectory();
        String string = uRL != null ? new File(uRL.getPath()).getPath() : null;
        URLPath uRLPath = new URLPath(J2eeSettings.getInstance(project2).getHtmlRootDirectory());
        this.initializeListeners(project);
        URLPath uRLPath2 = PathsConfiguration.getInstance(project2).getSourcePath();
        URLPath uRLPath3 = ResourcePaths.getInstance((PropertyStorage)project2).getProjectResourcesPath();
        int n = 0;
        int n2 = 0;
        while (n2 < arrayList.size() && !Thread.currentThread().isInterrupted()) {
            block19: {
                Storage storage = (Storage)arrayList.get(n2);
                try {
                    URL uRL2;
                    Node node = storage instanceof IdeStorage ? ((IdeStorage)storage).node : null;
                    URL uRL3 = uRL2 = node != null ? node.getURL() : URLFactory.newFileURL((String)storage.getPath());
                    if (string != null && new File(uRL2.getPath()).getPath().startsWith(string)) break block19;
                    URL[] uRLArray = new URL[]{null};
                    if (this.handledByListeners(uRL2, uRLArray)) {
                        UnifiedBuildSystem.getInstance().markTranslated(storage);
                        break block19;
                    }
                    URL uRL4 = uRLArray[0];
                    String string2 = null;
                    if (uRLPath2 != null) {
                        string2 = uRLPath2.toRelativePath(uRL2);
                    }
                    if (uRL4 == null && string2 == null && uRLPath.toRelativePath(uRL2) != null) break block19;
                    if (string2 == null && uRLPath3 != null) {
                        string2 = uRLPath3.toRelativePath(uRL2);
                    }
                    if (uRL4 == null) {
                        if (string2 == null) {
                            if (UnifiedBuildSystem.showCompileProgress) {
                                Compiler.getCompiler().logOutMsg("  ");
                                Compiler.getCompiler().logOutMsg(CompArb.format(73, storage.toString()));
                                Compiler.getCompiler().logOutMsg("\n");
                            }
                            break block19;
                        }
                        uRL4 = URLFactory.newURL((URL)uRL, (String)string2);
                    } else if (string2 == null) {
                        string2 = uRL2.getPath();
                    }
                    if (node == null && !URLFileSystem.exists((URL)uRL2)) {
                        int n3 = 66;
                        String string3 = CompArb.format(66, storage.getName());
                        this.log.error(storage, 0, 0, 0, string3);
                    } else if (uRL == null) {
                        this.log.error(storage, 0, 0, 0, CompArb.getString(68));
                    } else {
                        long l;
                        long l2 = l = node != null ? node.getTimestamp() : URLFileSystem.lastModified((URL)uRL2);
                        if (!(!bl && l <= URLFileSystem.lastModified((URL)uRL4) || node != null && node.getURL().equals(uRL4) || node == null && uRL2.equals(uRL4))) {
                            if (!URLFileSystem.isReadOnly((URL)uRL4)) {
                                this.performCopy(storage, uRL2, string2, node, uRL4);
                            } else {
                                this.log.error(storage, 0, 0, 0, CompArb.getString(64));
                                ++n;
                            }
                        }
                    }
                }
                catch (IOException iOException) {
                    this.log.error(storage, 0, 0, 0, CompArb.getString(65));
                    ++n;
                }
                catch (Exception exception) {
                    String string4 = CompArb.format(67, storage.toString());
                    this.log.error(storage, 0, 0, 0, string4);
                    ++n;
                }
            }
            ++n2;
        }
        this.terminateListeners();
        return n;
    }

    public void initialize() {
        JCompiler.getInstance().registerTranslator(this);
    }
}

