/*
 * Decompiled with CFR 0.152.
 */
package oracle.jdeveloper.compiler;

import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.DataInputStream;
import java.io.DataOutputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.net.MalformedURLException;
import java.net.URL;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Date;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import oracle.ide.natives.NativeHandler;
import oracle.ide.net.URLFactory;
import oracle.javatools.buffer.ReadTextBuffer;
import oracle.javatools.parser.java.v2.JavaParser;
import oracle.javatools.parser.java.v2.model.SourceClass;
import oracle.javatools.parser.java.v2.model.SourceFile;
import oracle.javatools.parser.java.v2.model.SourceImport;
import oracle.jdeveloper.compiler.InputReadTextBuffer;

public class DependencyProvider {
    private ArrayList data;
    private HashMap classMap;
    private HashMap urlMap;
    private static final int MAGIC_HEADER_10_1_3 = 0x10010300;
    static final /* synthetic */ boolean $assertionsDisabled;
    private long tickHolder;

    void $init$() {
        this.data = new ArrayList();
        this.classMap = new HashMap();
        this.urlMap = new HashMap();
    }

    public DependencyProvider() {
        this.$init$();
    }

    public void reinit() {
        this.data.clear();
        this.classMap.clear();
        this.urlMap.clear();
    }

    private Long getLastModified(URL uRL) throws IOException {
        long l = new File(uRL.getPath()).lastModified();
        if (l == 0L) {
            l = uRL.openConnection().getLastModified();
        }
        return new Long(l);
    }

    private void collectSourceFile(SourceFile sourceFile, URL uRL, boolean bl, int n) throws IOException {
        if (n == -1) {
            this.data.ensureCapacity(this.data.size() + 7);
            n = this.data.size();
            int n2 = 0;
            while (n2 < 7) {
                this.data.add(null);
                ++n2;
            }
        }
        this.data.set(n, uRL);
        this.data.set(n + 1, this.getLastModified(uRL));
        String string = sourceFile.getPackageName();
        this.data.set(n + 2, string);
        List list = sourceFile.getPossibleTypes();
        String[] stringArray = new String[list.size()];
        list.toArray(stringArray);
        this.data.set(n + 3, stringArray);
        List list2 = sourceFile.getSourceClasses();
        Iterator iterator = list2.iterator();
        String[] stringArray2 = new String[list2.size()];
        int n3 = 0;
        while (iterator.hasNext()) {
            stringArray2[n3] = ((SourceClass)iterator.next()).getName();
            ++n3;
        }
        this.data.set(n + 4, stringArray2);
        List list3 = sourceFile.getSourceImports();
        iterator = list3.iterator();
        String[] stringArray3 = new String[list3.size()];
        int n4 = 0;
        while (iterator.hasNext()) {
            stringArray3[n4] = ((SourceImport)iterator.next()).getName();
            ++n4;
        }
        this.data.set(n + 5, stringArray3);
        this.data.set(n + 6, bl ? Boolean.TRUE : Boolean.FALSE);
    }

    private static String[] resolveTypes(String string, String[] stringArray, String[] stringArray2, HashMap hashMap, HashMap hashMap2) {
        HashMap<String, String> hashMap3 = new HashMap<String, String>();
        ArrayList<String> arrayList = new ArrayList<String>();
        boolean bl = false;
        int n = 0;
        while (n < stringArray2.length) {
            String string2 = stringArray2[n];
            int n2 = string2.lastIndexOf(46);
            if (n2 >= 0) {
                if (string2.endsWith("*")) {
                    String string3 = string2.substring(0, n2);
                    if (hashMap.get(string3) != null) {
                        arrayList.add(string3);
                    }
                    bl = string3.equals("java.lang");
                } else {
                    hashMap3.put(string2.substring(n2 + 1), string2);
                }
            }
            ++n;
        }
        if (!bl && hashMap.get("java.lang") != null) {
            arrayList.add("java.lang");
        }
        int n3 = 0;
        while (n3 < stringArray.length) {
            block16: {
                String string4;
                String string5;
                block15: {
                    string5 = stringArray[n3];
                    int n4 = string5.indexOf(46);
                    if (n4 < 0) break block15;
                    if (hashMap2.get(string5) != null) break block16;
                    string5 = string5.substring(0, n4);
                }
                if ((string4 = (String)hashMap3.get(string5)) != null) {
                    stringArray[n3] = string4;
                } else {
                    String string6;
                    boolean bl2 = false;
                    int n5 = 0;
                    while (n5 < arrayList.size()) {
                        String string7 = (String)arrayList.get(n5) + string5;
                        if (hashMap2.get(string7) != null) {
                            stringArray[n3] = string7;
                            bl2 = true;
                            break;
                        }
                        ++n5;
                    }
                    if (!bl2 && hashMap2.get(string6 = string + '.' + string5) != null) {
                        stringArray[n3] = string6;
                    }
                }
            }
            ++n3;
        }
        return stringArray;
    }

    public void computeDependencies() {
        this.classMap.clear();
        HashMap<String, String> hashMap = new HashMap<String, String>();
        int n = 0;
        while (n < this.data.size()) {
            String string = (String)this.data.get(n + 2);
            if (hashMap.get(string) == null) {
                hashMap.put(string, string);
            }
            URL uRL = (URL)this.data.get(n);
            String[] stringArray = (String[])this.data.get(n + 4);
            int n2 = 0;
            while (n2 < stringArray.length) {
                String string2 = string + '.' + stringArray[n2];
                if (this.classMap.get(string2) == null) {
                    HashMap<String, URL> hashMap2 = new HashMap<String, URL>();
                    hashMap2.put(" sourcefile ", uRL);
                    this.classMap.put(string2, hashMap2);
                } else {
                    URL uRL2 = (URL)((HashMap)this.classMap.get(string2)).get(" sourcefile ");
                    System.out.println("DependencyProvider Error: class " + string2 + " from source " + new File(uRL.getPath()).getPath() + " already defined in source " + new File(uRL2.getPath()).getPath());
                }
                ++n2;
            }
            n += 7;
        }
        int n3 = 0;
        while (n3 < this.data.size()) {
            URL uRL = (URL)this.data.get(n3);
            String string = (String)this.data.get(n3 + 2);
            String[] stringArray = (String[])this.data.get(n3 + 3);
            String[] stringArray2 = (String[])this.data.get(n3 + 5);
            this.data.set(n3 + 3, DependencyProvider.resolveTypes(string, stringArray, stringArray2, hashMap, this.classMap));
            n3 += 7;
        }
        int n4 = 0;
        while (n4 < this.data.size()) {
            URL uRL = (URL)this.data.get(n4);
            String[] stringArray = (String[])this.data.get(n4 + 3);
            int n5 = 0;
            while (n5 < stringArray.length) {
                HashMap hashMap3 = (HashMap)this.classMap.get(stringArray[n5]);
                if (hashMap3 != null && hashMap3.get(uRL) == null) {
                    hashMap3.put(uRL, uRL);
                }
                ++n5;
            }
            n4 += 7;
        }
    }

    static {
        $assertionsDisabled = DependencyProvider.class.desiredAssertionStatus() ^ true;
    }

    private static String[] readStringArray(DataInputStream dataInputStream, ArrayList arrayList) throws IOException {
        String[] stringArray = new String[dataInputStream.readInt()];
        int n = 0;
        while (n < stringArray.length) {
            stringArray[n] = (String)arrayList.get(dataInputStream.readInt());
            ++n;
        }
        return stringArray;
    }

    public void load(InputStream inputStream, boolean bl) throws IOException {
        DataInputStream dataInputStream = new DataInputStream(inputStream);
        if (dataInputStream.readInt() != 0x10010300) {
            throw new IOException("invalid magic signature");
        }
        int n = dataInputStream.readInt();
        ArrayList<String> arrayList = new ArrayList<String>(n);
        int n2 = 0;
        while (n2 < n) {
            arrayList.add(dataInputStream.readUTF());
            ++n2;
        }
        byte[] byArray = new byte[dataInputStream.readInt()];
        dataInputStream.read(byArray);
        dataInputStream.close();
        inputStream.close();
        dataInputStream = new DataInputStream(new ByteArrayInputStream(byArray));
        int n3 = dataInputStream.readInt();
        if (!$assertionsDisabled && n3 % 7 != 0) {
            throw new AssertionError();
        }
        int n4 = 0;
        while (n4 < n3) {
            this.data.add(new URL((String)arrayList.get(dataInputStream.readInt())));
            this.data.add(new Long(dataInputStream.readLong()));
            this.data.add((String)arrayList.get(dataInputStream.readInt()));
            this.data.add(DependencyProvider.readStringArray(dataInputStream, arrayList));
            this.data.add(DependencyProvider.readStringArray(dataInputStream, arrayList));
            this.data.add(DependencyProvider.readStringArray(dataInputStream, arrayList));
            boolean bl2 = dataInputStream.readBoolean();
            this.data.add(bl || bl2 ? Boolean.TRUE : Boolean.FALSE);
            n4 += 7;
        }
        dataInputStream.close();
    }

    private static int indexedStr(String string, HashMap hashMap, ArrayList arrayList) {
        Integer n = (Integer)hashMap.get(string);
        if (n != null) {
            return n;
        }
        int n2 = arrayList.size();
        arrayList.add(string);
        hashMap.put(string, new Integer(n2));
        return n2;
    }

    private static void writeStringArray(String[] stringArray, DataOutputStream dataOutputStream, HashMap hashMap, ArrayList arrayList) throws IOException {
        dataOutputStream.writeInt(stringArray.length);
        int n = 0;
        while (n < stringArray.length) {
            dataOutputStream.writeInt(DependencyProvider.indexedStr(stringArray[n], hashMap, arrayList));
            ++n;
        }
    }

    public void save(OutputStream outputStream, boolean bl) throws IOException {
        ByteArrayOutputStream byteArrayOutputStream = new ByteArrayOutputStream(this.data.size() / 6 * 32);
        DataOutputStream dataOutputStream = new DataOutputStream(byteArrayOutputStream);
        HashMap hashMap = new HashMap();
        ArrayList arrayList = new ArrayList();
        dataOutputStream.writeInt(this.data.size());
        int n = 0;
        while (n < this.data.size()) {
            dataOutputStream.writeInt(DependencyProvider.indexedStr(((URL)this.data.get(n)).toString(), hashMap, arrayList));
            dataOutputStream.writeLong((Long)this.data.get(n + 1));
            dataOutputStream.writeInt(DependencyProvider.indexedStr((String)this.data.get(n + 2), hashMap, arrayList));
            DependencyProvider.writeStringArray((String[])this.data.get(n + 3), dataOutputStream, hashMap, arrayList);
            DependencyProvider.writeStringArray((String[])this.data.get(n + 4), dataOutputStream, hashMap, arrayList);
            DependencyProvider.writeStringArray((String[])this.data.get(n + 5), dataOutputStream, hashMap, arrayList);
            dataOutputStream.writeBoolean((Boolean)this.data.get(n + 6));
            n += 7;
        }
        dataOutputStream.close();
        byteArrayOutputStream.close();
        dataOutputStream = new DataOutputStream(outputStream);
        dataOutputStream.writeInt(0x10010300);
        dataOutputStream.writeInt(arrayList.size());
        int n2 = 0;
        while (n2 < hashMap.size()) {
            dataOutputStream.writeUTF((String)arrayList.get(n2));
            ++n2;
        }
        dataOutputStream.writeInt(byteArrayOutputStream.size());
        dataOutputStream.write(byteArrayOutputStream.toByteArray());
        dataOutputStream.close();
        outputStream.close();
    }

    public ArrayList updateData(ArrayList arrayList, boolean bl, boolean bl2) throws IOException {
        ArrayList<URL> arrayList2 = new ArrayList<URL>();
        this.urlMap.clear();
        int n = 0;
        while (n < this.data.size()) {
            this.urlMap.put(this.data.get(n), new Integer(n));
            n += 7;
        }
        int n2 = 0;
        this.startTiming();
        int n3 = 0;
        while (n3 < arrayList.size()) {
            block17: {
                InputReadTextBuffer inputReadTextBuffer;
                Integer n4;
                URL uRL;
                block16: {
                    uRL = (URL)arrayList.get(n3);
                    n4 = (Integer)this.urlMap.get(arrayList.get(n3));
                    if (n4 == null) break block16;
                    Long l = (Long)this.data.get(n4 + 1);
                    Long l2 = this.getLastModified(uRL);
                    if (!bl && l >= l2) break block17;
                }
                if ((inputReadTextBuffer = InputReadTextBuffer.init(uRL)) != null) {
                    SourceFile sourceFile = JavaParser.parse((ReadTextBuffer)inputReadTextBuffer);
                    this.collectSourceFile(sourceFile, uRL, false, n4 != null ? n4 : -1);
                    arrayList2.add(uRL);
                    ++n2;
                } else {
                    System.out.println("error: unable to open: " + new File(uRL.getPath()).getPath());
                }
            }
            ++n3;
        }
        if (bl2) {
            this.startTiming();
            HashMap hashMap = new HashMap();
            int n5 = 0;
            while (n5 < arrayList.size()) {
                hashMap.put(arrayList.get(n5), arrayList.get(n5));
                ++n5;
            }
            int n6 = 0;
            int n7 = 0;
            while (n7 < this.data.size()) {
                if (!((Boolean)this.data.get(n7 + 6)).booleanValue() && hashMap.get(this.data.get(n7)) == null) {
                    int n8 = 0;
                    while (n8 < 7) {
                        this.data.set(n7 + n8, null);
                        ++n8;
                    }
                    n6 += 7;
                }
                n7 += 7;
            }
            if (n6 > 0) {
                ArrayList arrayList3 = new ArrayList(this.data.size() - n6);
                int n9 = 0;
                while (n9 < this.data.size()) {
                    Object e = this.data.get(n9);
                    if (e != null) {
                        arrayList3.add(e);
                    }
                    ++n9;
                }
                this.data = arrayList3;
            }
            this.urlMap.clear();
            int n10 = 0;
            while (n10 < this.data.size()) {
                this.urlMap.put(this.data.get(n10), new Integer(n10));
                n10 += 7;
            }
        }
        this.startTiming();
        this.computeDependencies();
        return arrayList2;
    }

    public Collection getDependants(ArrayList arrayList, boolean bl) {
        HashMap<Object, Object> hashMap = new HashMap<Object, Object>();
        if (bl) {
            int n = 0;
            while (n < arrayList.size()) {
                Object e = arrayList.get(n);
                hashMap.put(e, e);
                ++n;
            }
        }
        int n = 0;
        while (n < arrayList.size()) {
            URL uRL = (URL)arrayList.get(n);
            Integer n2 = (Integer)this.urlMap.get(uRL);
            if (n2 == null) {
                throw new IllegalArgumentException(uRL.getPath() + " not found in table");
            }
            int n3 = n2;
            String[] stringArray = (String[])this.data.get(n3 + 4);
            int n4 = 0;
            while (n4 < stringArray.length) {
                String string = (String)this.data.get(n3 + 2) + '.' + stringArray[n4];
                HashMap hashMap2 = (HashMap)this.classMap.get(string);
                Collection collection = hashMap2.values();
                for (Object v : collection) {
                    if (hashMap.get(v) != null) continue;
                    hashMap.put(v, v);
                }
                ++n4;
            }
            ++n;
        }
        return hashMap.values();
    }

    private void startTiming() {
        this.tickHolder = NativeHandler.getHiPerfTick();
    }

    private long elapsedTimeMs() {
        return (NativeHandler.getHiPerfTick() - this.tickHolder) * 1000L / NativeHandler.getHiPerfFreq();
    }

    private static void recurse(File file, ArrayList arrayList) throws IOException {
        File[] fileArray = file.listFiles();
        if (fileArray != null) {
            int n = 0;
            while (n < fileArray.length) {
                if (fileArray[n].isDirectory()) {
                    DependencyProvider.recurse(fileArray[n], arrayList);
                } else if (fileArray[n].getName().endsWith(".java")) {
                    arrayList.add(URLFactory.newFileURL((String)fileArray[n].getPath()));
                }
                ++n;
            }
        }
    }

    public static void test1() throws MalformedURLException, IOException {
        String string = "d:\\oracle\\T.java";
        File file = new File(string);
        URL uRL = URLFactory.newFileURL((String)string);
        long l = NativeHandler.getHiPerfTick();
        long l2 = 0L;
        int n = 0;
        while (n < 100000) {
            long l3 = file.lastModified();
            long l4 = l3 != 0L ? l3 : uRL.openConnection().getLastModified();
            l2 += l4;
            ++n;
        }
        System.out.println(NativeHandler.getHiPerfTick() - l + "ms for " + l2);
        System.exit(0);
    }

    public static void main(String[] stringArray) throws IOException {
        ArrayList<URL> arrayList = new ArrayList<URL>();
        int n = 0;
        while (n < stringArray.length) {
            File file = new File(stringArray[n]);
            if (file.exists()) {
                if (file.isDirectory()) {
                    DependencyProvider.recurse(file, arrayList);
                } else if (file.getName().endsWith(".java")) {
                    arrayList.add(URLFactory.newFileURL((String)stringArray[n]));
                } else {
                    System.out.println("error: " + stringArray[n] + " doesn't exist");
                }
            }
            ++n;
        }
        DependencyProvider dependencyProvider = new DependencyProvider();
        ArrayList arrayList2 = dependencyProvider.updateData(arrayList, false, false);
        dependencyProvider.save(new FileOutputStream("c:\\test.cdi"), false);
        URL uRL = URLFactory.newFileURL((String)"L:/ferrari/ojc/java/oracle/ojc/frontend/JavaCompiler.java");
        File file = new File(uRL.getPath());
        file.setLastModified(new Date().getTime());
        ArrayList<URL> arrayList3 = new ArrayList<URL>();
        arrayList3.add(uRL);
        arrayList2 = dependencyProvider.updateData(arrayList3, false, false);
        Collection collection = dependencyProvider.getDependants(arrayList2, true);
        long l = NativeHandler.getHiPerfTick();
        dependencyProvider.reinit();
        System.out.println("Reinit = " + (NativeHandler.getHiPerfTick() - l) * 1000L / NativeHandler.getHiPerfFreq());
        l = NativeHandler.getHiPerfTick();
        dependencyProvider.load(new FileInputStream("c:\\test.cdi"), false);
        System.out.println("Loading = " + (NativeHandler.getHiPerfTick() - l) * 1000L / NativeHandler.getHiPerfFreq());
        l = NativeHandler.getHiPerfTick();
        dependencyProvider.save(new FileOutputStream("c:\\test2.cdi"), false);
        System.out.println("Saving = " + (NativeHandler.getHiPerfTick() - l) * 1000L / NativeHandler.getHiPerfFreq());
        l = NativeHandler.getHiPerfTick();
        System.out.println("Total and average number of lines are: " + InputReadTextBuffer.totalLineCount + "," + InputReadTextBuffer.averageLineCount);
        System.in.read();
    }
}

