/*
 * Decompiled with CFR 0.152.
 */
package oracle.jdeveloper.compiler;

import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.FileWriter;
import java.io.IOException;
import java.io.InputStream;
import java.io.PrintStream;
import java.io.PrintWriter;
import java.net.URL;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Properties;
import oracle.ide.marshal.xml.HashStructureIO;
import oracle.ide.model.ContentSet;
import oracle.ide.model.ProjectContent;
import oracle.ide.net.URLFactory;
import oracle.javatools.data.HashStructure;
import oracle.javatools.data.ListStructure;
import oracle.xml.parser.v2.DOMParser;
import oracle.xml.parser.v2.NSResolver;
import oracle.xml.parser.v2.XMLDocument;
import oracle.xml.parser.v2.XMLNode;
import oracle.xml.parser.v2.XMLParseException;
import oracle.xml.parser.v2.XSLException;
import org.w3c.dom.NodeList;
import org.xml.sax.SAXException;

public final class GenRspFile {
    private static final boolean COMPILE_BY_FILE = false;
    private static final String BASE_NAMESPACE_URI = "http://xmlns.oracle.com/jdeveloper/10130/";
    private static final String ROOT_QNAME = "jpr:project";
    private static final String NAMESPACE_URI;
    static final /* synthetic */ boolean $assertionsDisabled;

    static {
        $assertionsDisabled = GenRspFile.class.desiredAssertionStatus() ^ true;
        NAMESPACE_URI = GenRspFile.toNamespaceURI("project");
    }

    private GenRspFile() {
    }

    private static String toNamespaceURI(String string) {
        StringBuffer stringBuffer = new StringBuffer(BASE_NAMESPACE_URI);
        stringBuffer.append(string);
        return stringBuffer.toString();
    }

    private static String[] retrievePathList(XMLDocument xMLDocument, String string, NSResolver nSResolver, String string2) {
        try {
            NodeList nodeList = xMLDocument.selectNodes(string, nSResolver);
            int n = nodeList.getLength();
            String[] stringArray = new String[n];
            int n2 = 0;
            while (n2 < n) {
                XMLNode xMLNode = (XMLNode)nodeList.item(n2);
                String string3 = xMLNode.getNodeValue();
                if (!new File(string3).isAbsolute()) {
                    File file = new File(string2, string3);
                    stringArray[n2] = file.getPath();
                } else {
                    stringArray[n2] = string3;
                }
                ++n2;
            }
            String[] stringArray2 = stringArray;
            return stringArray2;
        }
        catch (XSLException xSLException) {
            xSLException.printStackTrace();
            return null;
        }
    }

    private static String[] processLibrary(URL uRL, String string, String string2) {
        try {
            File file = new File(uRL.getPath());
            DOMParser dOMParser = new DOMParser();
            String string3 = file.getParentFile().getPath();
            dOMParser.parse((InputStream)new FileInputStream(file));
            XMLDocument xMLDocument = dOMParser.getDocument();
            1 var7_7 = new 1(string);
            String[] stringArray = GenRspFile.retrievePathList(xMLDocument, string2, var7_7, string3);
            return stringArray;
        }
        catch (FileNotFoundException fileNotFoundException) {
            fileNotFoundException.printStackTrace();
        }
        catch (IOException iOException) {
            iOException.printStackTrace();
        }
        catch (XMLParseException xMLParseException) {
            xMLParseException.printStackTrace();
        }
        catch (SAXException sAXException) {
            sAXException.printStackTrace();
        }
        return null;
    }

    private static void processJpr(Arguments arguments, CompilerInfo compilerInfo, List list) throws IOException {
        ListStructure listStructure;
        File file = arguments.getProjectFile();
        HashStructureIO hashStructureIO = new HashStructureIO(NAMESPACE_URI, ROOT_QNAME);
        HashStructure hashStructure = HashStructure.newInstance();
        hashStructureIO.open(URLFactory.newFileURL((String)file.getPath()), (Object)hashStructure);
        compilerInfo.sourcePaths = new HashMap();
        compilerInfo.packages = new HashMap();
        ProjectContent projectContent = ProjectContent.getInstance((HashStructure)hashStructure);
        ListStructure listStructure2 = projectContent.getContentSetList();
        if (listStructure2.size() == 0) {
            listStructure2.add((Object)"oracle.jdeveloper.model.PathsConfiguration/javaContentSet");
        }
        ContentSet contentSet = projectContent.getAllContents();
        URL[] uRLArray = contentSet.getAllRootDirs().getEntries();
        int n = 0;
        while (uRLArray != null && n < uRLArray.length) {
            File file2 = new File(uRLArray[n].getPath());
            if (file2.isDirectory()) {
                String string = file2.getPath();
                compilerInfo.sourcePaths.put(string, string);
            }
            ++n;
        }
        Iterator iterator = contentSet.urlIterator("");
        while (iterator.hasNext()) {
            String string;
            String string2;
            URL uRL = (URL)iterator.next();
            String string3 = contentSet.toRelativePath(uRL);
            int n2 = string3.lastIndexOf(47);
            String string4 = string2 = n2 > 0 ? string3.substring(0, n2) : null;
            if (string2 != null && string2.indexOf(46) < 0) {
                compilerInfo.packages.put(string2, string2);
            }
            if (list == null || !(string = contentSet.toRelativePath(uRL)).toLowerCase().endsWith(".rts")) continue;
            list.add(string);
        }
        HashStructure hashStructure2 = hashStructure.getHashStructure("oracle.jdevimpl.config.JProjectLibraries");
        if (hashStructure2 != null) {
            compilerInfo.jdkRefUrl = hashStructure2.getURL("jdkReference/id");
            compilerInfo.librariesRefUrl = new ArrayList();
            compilerInfo.librariesRefMap = new HashMap();
            listStructure = hashStructure2.getListStructure("libraryReferences");
            if (listStructure != null) {
                int n3 = 0;
                while (n3 < listStructure.size()) {
                    HashStructure hashStructure3 = (HashStructure)listStructure.get(n3);
                    Object object = hashStructure3.getObject("id");
                    if (object instanceof URL) {
                        compilerInfo.librariesRefUrl.add(object);
                    } else if (object instanceof String) {
                        compilerInfo.librariesRefMap.put(object, object);
                    } else {
                        System.out.println("libraryReferences: unknown reference type --> " + object.getClass().toString());
                    }
                    ++n3;
                }
            }
            if ((listStructure = hashStructure2.getListStructure("internalDefinitions/libraryDefinitions")) != null) {
                int n4 = 0;
                while (n4 < listStructure.size()) {
                    HashStructure hashStructure4 = (HashStructure)listStructure.get(n4);
                    Object object = hashStructure4.getObject("id");
                    if (object instanceof String && compilerInfo.librariesRefMap.get(object) != null && compilerInfo.librariesRefMap.get(object).equals(object)) {
                        ListStructure listStructure3 = hashStructure4.getListStructure("sourcePath");
                        ListStructure listStructure4 = hashStructure4.getListStructure("classPath");
                        String[] stringArray = new String[(listStructure3 == null ? 0 : listStructure3.size()) + (listStructure4 == null ? 0 : listStructure4.size())];
                        if (listStructure3 != null) {
                            int n5 = 0;
                            while (n5 < listStructure3.size()) {
                                stringArray[n5] = new File(((URL)listStructure3.get(n5)).getPath()).getPath();
                                ++n5;
                            }
                        }
                        if (listStructure4 != null) {
                            int n6 = 0;
                            while (n6 < listStructure4.size()) {
                                stringArray[n6] = new File(((URL)listStructure4.get(n6)).getPath()).getPath();
                                ++n6;
                            }
                        }
                        compilerInfo.librariesRefMap.put(object, stringArray);
                    } else {
                        System.out.println("internalDefinitions/libraryDefinitions: unknown id type --> " + object.getClass().toString());
                    }
                    ++n4;
                }
            }
        }
        HashStructure hashStructure5 = hashStructure.getHashStructure("oracle.jdeveloper.compiler.OjcConfiguration");
        if (!$assertionsDisabled && hashStructure5 == null) {
            throw new AssertionError();
        }
        compilerInfo.debugInfo = hashStructure5.getBoolean("debugInformation", true);
        compilerInfo.showWarnings = hashStructure5.getBoolean("showWarnings", true);
        compilerInfo.showPartialImportWarnings = hashStructure5.getBoolean("showPartialImportWarnings", false);
        compilerInfo.showUnusedImportWarnings = hashStructure5.getBoolean("showUnusedImportWarnings", false);
        compilerInfo.showObjectDotStaticWarnings = hashStructure5.getBoolean("showObjectDotStaticWarnings", false);
        compilerInfo.showDeprecations = hashStructure5.getBoolean("showDeprecations", true);
        compilerInfo.showSelfDeprecations = hashStructure5.getBoolean("showSelfDeprecations", true);
        compilerInfo.useJavac = hashStructure5.getBoolean("useJavac", false);
        compilerInfo.source = hashStructure5.getString("source");
        compilerInfo.target = hashStructure5.getString("target");
        compilerInfo.internalEncoding = hashStructure5.getString("internalEncoding");
        listStructure = hashStructure5.getListStructure("copyRes");
        compilerInfo.copyRes = new String[listStructure != null ? listStructure.size() : 0];
        if (listStructure != null) {
            listStructure.toArray((Object[])compilerInfo.copyRes);
        }
        compilerInfo.excludedClasses = new String[(listStructure = hashStructure5.getListStructure("excludedClasses")) != null ? listStructure.size() : 0];
        if (listStructure != null) {
            listStructure.toArray((Object[])compilerInfo.excludedClasses);
        }
        HashStructure hashStructure6 = hashStructure.getHashStructure("oracle.jdevimpl.config.JProjectPaths");
        if (!$assertionsDisabled && hashStructure6 == null) {
            throw new AssertionError();
        }
        compilerInfo.outputDirectory = new File(hashStructure6.getURL("outputDirectory").getPath()).getPath();
        ListStructure listStructure5 = hashStructure.getListStructure("oracle.ide.model.DependencyConfiguration/dependencyList");
        if (listStructure5 != null && listStructure5.size() > 0) {
            compilerInfo.dependentProjectsOutputDirs = new ArrayList();
            for (HashStructure hashStructure7 : listStructure5) {
                String string;
                URL uRL = hashStructure7.getURL("sourceURL");
                if (uRL == null || (string = GenRspFile.getOutputDirectoryStr(uRL)) == null) continue;
                compilerInfo.dependentProjectsOutputDirs.add(string);
            }
        }
        compilerInfo.additionalClassPath = new URL[(listStructure = hashStructure6.getListStructure("additionalClassPath")) != null ? listStructure.size() : 0];
        if (listStructure != null) {
            listStructure.toArray((Object[])compilerInfo.additionalClassPath);
        }
    }

    private static String getOutputDirectoryStr(URL uRL) {
        HashStructureIO hashStructureIO = new HashStructureIO(NAMESPACE_URI, ROOT_QNAME);
        try {
            HashStructure hashStructure = HashStructure.newInstance();
            hashStructureIO.open(uRL, (Object)hashStructure);
            URL uRL2 = hashStructure.getURL("oracle.jdevimpl.config.JProjectPaths/outputDirectory");
            if (uRL2 != null) {
                String string = new File(uRL2.getPath()).getPath();
                return string;
            }
        }
        catch (Exception exception) {
            exception.printStackTrace();
        }
        return null;
    }

    private static void appendCharSepList(StringBuffer stringBuffer, String[] stringArray) {
        int n = 0;
        while (n < stringArray.length) {
            stringBuffer.append(stringArray[n]);
            stringBuffer.append(File.pathSeparator);
            ++n;
        }
    }

    private static String[] getJdkPaths(URL uRL) {
        return GenRspFile.processLibrary(uRL, "jdknode", "/lib:JDKNode/lib:classPath/lib:entries/lib:Item/@path");
    }

    private static String[] getLibraryPaths(URL uRL) {
        return GenRspFile.processLibrary(uRL, "jlibrarynode", "/lib:JLibraryNode/lib:classPath/lib:entries/lib:Item/@path");
    }

    private static String cleanPaths(StringBuffer stringBuffer) {
        int n;
        String string = File.separator + ".." + File.separator;
        int n2 = 0;
        int n3 = stringBuffer.length();
        while ((n = stringBuffer.indexOf(string, n2)) >= 0 && (n != n2 || stringBuffer.length() != n3)) {
            n3 = stringBuffer.length();
            int n4 = n - 1;
            while (n4 >= 0 && stringBuffer.charAt(n4) == File.separatorChar) {
                --n4;
            }
            while (n4 >= 0 && stringBuffer.charAt(n4) != File.separatorChar) {
                --n4;
            }
            if (n4 >= 0 && n4 < n) {
                stringBuffer.delete(n4, n + 3);
            }
            n2 = n4;
        }
        return stringBuffer.toString();
    }

    private static void buildResponseFile(PrintStream printStream, CompilerInfo compilerInfo) {
        printStream.println("-msglimit:-1");
        if (compilerInfo.debugInfo) {
            printStream.println("-g");
        }
        if (compilerInfo.showDeprecations) {
            printStream.println("-deprecation" + (compilerInfo.showSelfDeprecations ? ":self" : ""));
        }
        if (compilerInfo.showWarnings) {
            printStream.println("-warn");
            if (!compilerInfo.showObjectDotStaticWarnings) {
                printStream.println("-nowarn:320");
            }
            if (!compilerInfo.showUnusedImportWarnings) {
                printStream.println("-nowarn:486");
            }
            if (!compilerInfo.showPartialImportWarnings) {
                printStream.println("-nowarn:487");
            }
            printStream.println("-nowarn:376");
            printStream.println("-nowarn:412");
            printStream.println("-nowarn:414");
            printStream.println("-nowarn:415");
            printStream.println("-nowarn:558");
            printStream.println("-nowarn:560");
        } else {
            printStream.println("-nowarn");
        }
        if (compilerInfo.source != null && compilerInfo.source.length() > 0) {
            printStream.println("-source " + compilerInfo.source);
        }
        if (compilerInfo.target != null && compilerInfo.target.length() > 0) {
            printStream.println("-target " + compilerInfo.target);
        }
        if (compilerInfo.internalEncoding != null && compilerInfo.internalEncoding.length() > 0) {
            printStream.println("-encoding " + compilerInfo.internalEncoding);
        }
        if (compilerInfo.copyRes != null && compilerInfo.copyRes.length > 0) {
            StringBuffer stringBuffer = new StringBuffer("-deploy " + compilerInfo.copyRes[0]);
            int n = 1;
            while (n < compilerInfo.copyRes.length) {
                stringBuffer.append(File.pathSeparator);
                stringBuffer.append(compilerInfo.copyRes[n]);
                ++n;
            }
            printStream.println(stringBuffer.toString());
        }
        if (compilerInfo.excludedClasses != null && compilerInfo.excludedClasses.length > 0) {
            StringBuffer stringBuffer = new StringBuffer("-exclude " + compilerInfo.excludedClasses[0]);
            int n = 1;
            while (n < compilerInfo.excludedClasses.length) {
                stringBuffer.append(File.pathSeparator);
                stringBuffer.append(compilerInfo.excludedClasses[n]);
                ++n;
            }
            printStream.println(stringBuffer.toString());
        }
        StringBuffer stringBuffer = new StringBuffer("-classpath ");
        ArrayList<String> arrayList = new ArrayList<String>();
        if (compilerInfo.outputDirectory != null) {
            arrayList.add(compilerInfo.outputDirectory);
            printStream.println("-d " + compilerInfo.outputDirectory);
            GenRspFile.appendCharSepList(stringBuffer, new String[]{compilerInfo.outputDirectory});
        }
        if (compilerInfo.dependentProjectsOutputDirs != null) {
            for (String string : compilerInfo.dependentProjectsOutputDirs) {
                if (string == null || arrayList.contains(string)) continue;
                arrayList.add(string);
                GenRspFile.appendCharSepList(stringBuffer, new String[]{string});
            }
        }
        if (compilerInfo.jdkRefUrl != null) {
            String[] stringArray = GenRspFile.getJdkPaths(compilerInfo.jdkRefUrl);
            if (stringArray != null) {
                GenRspFile.appendCharSepList(stringBuffer, stringArray);
            } else {
                System.err.println("warning: " + compilerInfo.jdkRefUrl.getPath() + " not found in libraries.xml");
            }
        }
        if (compilerInfo.librariesRefUrl != null) {
            int n = 0;
            while (n < compilerInfo.librariesRefUrl.size()) {
                URL uRL = (URL)compilerInfo.librariesRefUrl.get(n);
                String[] stringArray = GenRspFile.getLibraryPaths(uRL);
                if (stringArray != null) {
                    GenRspFile.appendCharSepList(stringBuffer, stringArray);
                } else {
                    System.err.println("warning: " + uRL.getPath() + " not found");
                }
                ++n;
            }
        }
        if (compilerInfo.librariesRefMap != null) {
            for (Object v : compilerInfo.librariesRefMap.values()) {
                if (v instanceof String[]) {
                    GenRspFile.appendCharSepList(stringBuffer, (String[])v);
                    continue;
                }
                System.out.println("warning: reference library " + v + " not defined");
            }
        }
        if (compilerInfo.additionalClassPath != null) {
            int n = 0;
            while (n < compilerInfo.additionalClassPath.length) {
                stringBuffer.append(new File(compilerInfo.additionalClassPath[n].getPath()).getPath());
                stringBuffer.append(File.pathSeparator);
                ++n;
            }
        }
        if (stringBuffer.charAt(stringBuffer.length() - 1) == File.pathSeparatorChar) {
            stringBuffer.setLength(stringBuffer.length() - 1);
        }
        printStream.println(GenRspFile.cleanPaths(stringBuffer));
        String[] stringArray = new String[compilerInfo.sourcePaths.size()];
        compilerInfo.sourcePaths.values().toArray(stringArray);
        if (stringArray.length > 0) {
            StringBuffer stringBuffer2 = new StringBuffer("-sourcepath " + stringArray[0]);
            int n = 1;
            while (n < stringArray.length) {
                stringBuffer2.append(File.pathSeparator);
                stringBuffer2.append(stringArray[n]);
                ++n;
            }
            printStream.println(GenRspFile.cleanPaths(stringBuffer2));
        }
        Object[] objectArray = new String[compilerInfo.packages.size()];
        compilerInfo.packages.values().toArray(objectArray);
        if (objectArray.length > 0) {
            Arrays.sort(objectArray);
            printStream.println("-p");
            int n = 0;
            while (n < objectArray.length) {
                printStream.println(((String)objectArray[n]).replace('/', '.'));
                ++n;
            }
        }
    }

    public static void main(String[] stringArray) throws Exception {
        try {
            String string;
            if (stringArray.length < 1 || stringArray.length > 3) {
                System.err.println("usage: GenRspFile <projectFile> [-ideproperties:<IdePropertiesPathName>] [<responseFile>]");
                System.out.println();
                System.out.println("\tIdePropertiesPathName is the full qualified pathname to the file ide.properties");
                System.out.println("\twhich is used to get the value of Ide.GlobalIgnoreListFilters");
                System.exit(1);
            }
            Arguments arguments = new Arguments();
            arguments.setProjectFile(new File(stringArray[0]));
            String string2 = null;
            int n = 1;
            if (stringArray.length > n && (stringArray[n].startsWith("-dir:") || stringArray[n].startsWith("-ideproperties:"))) {
                int n2 = stringArray[n].indexOf(58) + 1;
                if (n2 == 5) {
                    System.out.println("Warning: -dir argument is obsolete, use -ideproperties to specify the location of ide.properties");
                    string2 = new File(stringArray[n].substring(n2)).getParentFile().getParent() + "/java/oracle/jdeveloper/ide.properties";
                } else {
                    string2 = stringArray[n].substring(n2);
                }
                ++n;
            }
            if (string2 != null) {
                arguments.setIdePropsFile(new File(string2));
            }
            String string3 = string = stringArray.length > n ? stringArray[n] : null;
            if (string != null) {
                arguments.setOutputFile(new File(string));
            }
            GenRspFile.generateRSPFile(arguments);
        }
        catch (Exception exception) {
            exception.printStackTrace();
            System.exit(1);
            throw exception;
        }
        System.exit(0);
    }

    public static void generateRSPFile(Arguments arguments) throws IOException {
        long l = System.currentTimeMillis();
        if (!arguments.getProjectFile().exists() || !arguments.getProjectFile().canRead()) {
            throw new FileNotFoundException("Project file " + arguments.getProjectFile() + " does not exist, or could not be read.");
        }
        if (arguments.getOutputFile() != null) {
            System.out.println("Generating .rsp file: " + arguments.getOutputFile());
        }
        Properties properties = new Properties();
        InputStream inputStream = null;
        try {
            try {
                if (arguments.getIdePropsFile() == null) {
                    inputStream = GenRspFile.class.getResourceAsStream("/oracle/jdeveloper/ide.properties");
                    if (inputStream == null) {
                        inputStream = new FileInputStream(new File(arguments.getProjectFile().getParentFile().getParentFile(), "jdeveloper/oracle/jdeveloper/ide.properties"));
                    }
                } else {
                    inputStream = new FileInputStream(arguments.getIdePropsFile());
                }
                properties.load(inputStream);
                System.setProperty("Ide.GlobalIgnoreListFilters", properties.getProperty("Ide.GlobalIgnoreListFilters"));
            }
            catch (FileNotFoundException fileNotFoundException) {
                System.setProperty("Ide.GlobalIgnoreListFilters", "**/.ade_path/**;**/.ade_path");
            }
        }
        finally {
            if (inputStream != null) {
                inputStream.close();
            }
        }
        CompilerInfo compilerInfo = new CompilerInfo(null);
        ArrayList arrayList = null;
        if (arguments.getRtsListFile() != null) {
            arrayList = new ArrayList();
        }
        GenRspFile.processJpr(arguments, compilerInfo, arrayList);
        PrintStream printStream = null;
        try {
            if (arguments.getOutputFile() != null) {
                arguments.getOutputFile().getParentFile().mkdirs();
                printStream = new PrintStream(new FileOutputStream(arguments.getOutputFile()));
            } else {
                printStream = System.out;
            }
            GenRspFile.buildResponseFile(printStream, compilerInfo);
            if (compilerInfo.outputDirectory != null) {
                System.out.println("Output directory is " + compilerInfo.outputDirectory);
            }
        }
        finally {
            if (printStream != null && arguments.getOutputFile() != null) {
                printStream.close();
            }
        }
        if (arrayList != null) {
            arguments.getRtsListFile().getParentFile().mkdirs();
            PrintWriter printWriter = null;
            try {
                printWriter = new PrintWriter(new FileWriter(arguments.getRtsListFile()));
                Iterator iterator = arrayList.iterator();
                while (iterator.hasNext()) {
                    printWriter.println(iterator.next());
                }
                System.out.println("Generated " + arguments.getRtsListFile());
            }
            finally {
                if (printWriter != null) {
                    printWriter.close();
                }
            }
        }
        long l2 = System.currentTimeMillis();
        if (arguments.getOutputFile() != null) {
            System.out.println("Finished generating rsp (" + (l2 - l) + " ms)");
        }
    }

    static String maS$toNamespaceURI(String string) {
        return GenRspFile.toNamespaceURI(string);
    }

    private static class CompilerInfo {
        boolean debugInfo;
        boolean showWarnings;
        boolean showPartialImportWarnings;
        boolean showUnusedImportWarnings;
        boolean showObjectDotStaticWarnings;
        boolean showDeprecations;
        boolean showSelfDeprecations;
        boolean useJavac;
        String source;
        String target;
        String internalEncoding;
        String[] copyRes;
        String[] excludedClasses;
        HashMap sourcePaths;
        HashMap packages;
        String outputDirectory;
        ArrayList dependentProjectsOutputDirs;
        URL[] additionalClassPath;
        ArrayList librariesRefUrl;
        HashMap librariesRefMap;
        URL jdkRefUrl;

        private CompilerInfo() {
        }

        CompilerInfo(1 var1_1) {
            this();
        }

        public final class 1 {
        }
    }

    public static final class 1
    implements NSResolver {
        private final /* synthetic */ String v$nodeName;

        public String resolveNamespacePrefix(String string) {
            if ("lib".equals(string)) {
                return GenRspFile.maS$toNamespaceURI(this.v$nodeName);
            }
            return null;
        }

        public 1(String string) {
            this.v$nodeName = string;
        }
    }

    public static class Arguments {
        private File _projectFile;
        private File _idePropsFile;
        private File _outputFile;
        private File _rtsListFile;

        public File getRtsListFile() {
            return this._rtsListFile;
        }

        public void setRtsListFile(File file) {
            this._rtsListFile = file;
        }

        public File getProjectFile() {
            return this._projectFile;
        }

        public void setProjectFile(File file) {
            this._projectFile = file;
        }

        public File getIdePropsFile() {
            return this._idePropsFile;
        }

        public void setIdePropsFile(File file) {
            this._idePropsFile = file;
        }

        public File getOutputFile() {
            return this._outputFile;
        }

        public void setOutputFile(File file) {
            this._outputFile = file;
        }
    }
}

