/*
 * Decompiled with CFR 0.152.
 */
package oracle.jdeveloper.compiler;

import java.io.File;
import java.net.URL;
import java.util.ArrayList;
import java.util.HashMap;
import oracle.ide.net.JarUtil;
import oracle.ide.net.URLPath;
import oracle.jdeveloper.compiler.JarStorage;
import oracle.ojc.interfaces.Storage;
import oracle.ojc.storage.DirectoryStorage;
import oracle.ojc.storage.FileStorage;

public class Helpers {
    public static Storage createFileStorage(String string) {
        return new FileStorage(new File(string));
    }

    public static Storage createFileStorage(File file) {
        return new FileStorage(file);
    }

    public static boolean isFileStorage(Storage storage) {
        return storage instanceof FileStorage;
    }

    static String arrayToString(String[] stringArray, String string) {
        if (stringArray == null) {
            return null;
        }
        int n = 0;
        int n2 = 0;
        while (n2 < stringArray.length) {
            if (stringArray[n2] != null) {
                n += stringArray[n2].length();
            }
            ++n2;
        }
        StringBuffer stringBuffer = new StringBuffer(n += stringArray.length == 0 ? 0 : stringArray.length * string.length());
        int n3 = 0;
        while (n3 < stringArray.length) {
            if (stringArray[n3] != null) {
                stringBuffer.append(stringArray[n3]);
            }
            if (n3 + 1 < stringArray.length) {
                stringBuffer.append(string);
            }
            ++n3;
        }
        return stringBuffer.toString();
    }

    static String[] stringToArray(String string, String string2) {
        if (string == null) {
            return null;
        }
        int n = string.length();
        int n2 = 0;
        int n3 = 0;
        while (n2 < n) {
            int n4 = string.indexOf(string2, n2);
            if (n4 < 0) {
                n4 = n;
            }
            if (n2 < n4) {
                ++n3;
            }
            n2 = n4 + 1;
        }
        String[] stringArray = new String[n3];
        n2 = 0;
        n3 = 0;
        while (n2 < n) {
            int n5 = string.indexOf(string2, n2);
            if (n5 < 0) {
                n5 = n;
            }
            if (n2 < n5) {
                stringArray[n3++] = string.substring(n2, n5);
            }
            n2 = n5 + 1;
        }
        return stringArray;
    }

    static Storage[] stringToStorageArray(String string) {
        String[] stringArray = Helpers.stringToArray(string, File.pathSeparator);
        if (stringArray == null) {
            return null;
        }
        Storage[] storageArray = new Storage[stringArray.length];
        int n = 0;
        while (n < stringArray.length) {
            storageArray[n] = stringArray[n].endsWith(".jar") || stringArray[n].endsWith(".zip") ? new oracle.ojc.storage.JarStorage(new File(stringArray[n])) : new FileStorage(new File(stringArray[n]));
            ++n;
        }
        return storageArray;
    }

    static ArrayList listOfUniqueClassPathElement(ArrayList arrayList) {
        ArrayList<URL> arrayList2 = null;
        HashMap<URL, URL> hashMap = null;
        if (arrayList != null) {
            int n = 0;
            while (n < arrayList.size()) {
                Storage storage = (Storage)arrayList.get(n);
                ArrayList arrayList3 = (ArrayList)storage.getProperty("dependantClassPathURLList");
                if (arrayList3 != null) {
                    if (hashMap == null) {
                        hashMap = new HashMap<URL, URL>();
                    }
                    int n2 = 0;
                    while (n2 < arrayList3.size()) {
                        URL uRL = (URL)arrayList3.get(n2);
                        if (hashMap.get(uRL) == null) {
                            hashMap.put(uRL, uRL);
                            if (arrayList2 == null) {
                                arrayList2 = new ArrayList<URL>();
                            }
                            arrayList2.add(uRL);
                        }
                        ++n2;
                    }
                }
                ++n;
            }
        }
        return arrayList2;
    }

    private static void addStoragePath(Storage[] storageArray, int n, URL uRL) {
        File file;
        storageArray[n] = JarUtil.isJarURL((URL)uRL) ? new JarStorage(uRL) : ((file = new File(uRL.getPath())).isDirectory() ? new DirectoryStorage(file) : new FileStorage(file));
    }

    static Storage[] urlPathAndDependantPathToStorageArray(URLPath uRLPath, ArrayList arrayList) {
        int n;
        ArrayList arrayList2 = Helpers.listOfUniqueClassPathElement(arrayList);
        int n2 = arrayList2 == null ? 0 : arrayList2.size();
        URL[] uRLArray = uRLPath == null ? null : uRLPath.getEntries();
        int n3 = n = uRLArray == null ? 0 : uRLArray.length;
        if (n + n2 == 0) {
            return null;
        }
        Storage[] storageArray = new Storage[n + n2];
        int n4 = 0;
        while (n4 < n) {
            Helpers.addStoragePath(storageArray, n4, uRLArray[n4]);
            ++n4;
        }
        if (arrayList2 != null) {
            int n5 = 0;
            while (n5 < n2) {
                Helpers.addStoragePath(storageArray, n + n5, (URL)arrayList2.get(n5));
                ++n5;
            }
        }
        return storageArray;
    }

    static Storage[] urlPathToStorageArray(URLPath uRLPath) {
        return Helpers.urlPathAndDependantPathToStorageArray(uRLPath, null);
    }

    private static void addStringPath(StringBuffer stringBuffer, URL uRL, String string) {
        if (JarUtil.isJarURL((URL)uRL)) {
            uRL = JarUtil.getJarFileURL((URL)uRL);
        }
        stringBuffer.append(new File(uRL.getPath()).getPath());
        stringBuffer.append(string);
    }

    static String urlPathAndDependantPathToString(URLPath uRLPath, ArrayList arrayList, String string) {
        ArrayList arrayList2 = Helpers.listOfUniqueClassPathElement(arrayList);
        URL[] uRLArray = uRLPath == null ? null : uRLPath.getEntries();
        StringBuffer stringBuffer = new StringBuffer(30);
        if (uRLArray != null) {
            int n = 0;
            while (n < uRLArray.length) {
                Helpers.addStringPath(stringBuffer, uRLArray[n], string);
                ++n;
            }
        }
        if (arrayList2 != null) {
            int n = 0;
            while (n < arrayList2.size()) {
                Helpers.addStringPath(stringBuffer, (URL)arrayList2.get(n), string);
                ++n;
            }
        }
        if (stringBuffer.length() > 0) {
            stringBuffer.deleteCharAt(stringBuffer.length() - 1);
        }
        return stringBuffer.toString();
    }

    static String urlPathToString(URLPath uRLPath, String string) {
        return Helpers.urlPathAndDependantPathToString(uRLPath, null, string);
    }
}

