/*
 * Decompiled with CFR 0.152.
 */
package oracle.jdeveloper.compiler;

import java.util.ArrayList;
import java.util.HashMap;
import oracle.ide.log.LogPage;
import oracle.ide.model.Project;
import oracle.ide.model.Workspace;
import oracle.jdeveloper.compiler.CompArb;
import oracle.jdeveloper.compiler.CompilerPage;
import oracle.jdeveloper.compiler.Translator;
import oracle.ojc.interfaces.Storage;

public class IdeLog
implements Translator.Log {
    private int errCnt;
    private int wrnCnt;
    private Workspace workspace;
    private Project project;
    private HashMap asyncLogPages;
    private ArrayList msgList;
    private HashMap clearCache;

    void $init$() {
        this.errCnt = 0;
        this.wrnCnt = 0;
        this.workspace = null;
        this.project = null;
        this.asyncLogPages = new HashMap();
        this.msgList = new ArrayList();
        this.clearCache = new HashMap();
    }

    public void reinit() {
        this.errCnt = 0;
        this.wrnCnt = 0;
        this.workspace = null;
        this.project = null;
        this.asyncLogPages.clear();
        this.msgList.clear();
        this.clearCache.clear();
        this.starting();
    }

    public Project getProject() {
        return this.project;
    }

    public void setProject(Project project) {
        this.project = project;
    }

    public Workspace getWorkspace() {
        return this.workspace;
    }

    public void setWorkspace(Workspace workspace) {
        this.workspace = workspace;
    }

    public static int getPartialUsedStarImportCode() {
        if (oracle.ojc.compiler.Message.warningPartialUsedStarImport != null) {
            return oracle.ojc.compiler.Message.warningPartialUsedStarImport.getNumber();
        }
        return -1;
    }

    public static int getUnusedImportCode() {
        if (oracle.ojc.compiler.Message.warningUnusedImport != null) {
            return oracle.ojc.compiler.Message.warningUnusedImport.getNumber();
        }
        return -1;
    }

    public static boolean isPartiallyUsedImportWarning(Message message) {
        return message.code == IdeLog.getPartialUsedStarImportCode();
    }

    public static boolean isUnusedImportWarning(Message message) {
        return message.code == IdeLog.getUnusedImportCode();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void logMessages() {
        HashMap hashMap = this.asyncLogPages;
        synchronized (hashMap) {
            if (this.asyncLogPages.size() > 0) {
                for (LogPage logPage : this.asyncLogPages.keySet()) {
                    int n = 0;
                    while (n < this.msgList.size()) {
                        logPage.log((Object)((Message)this.msgList.get(n)));
                        ++n;
                    }
                }
                this.msgList.clear();
            }
        }
    }

    private void printMsg(boolean bl, Storage storage, int n, int n2, int n3, String string) {
        StringBuffer stringBuffer = new StringBuffer(CompArb.getString(bl ? 38 : 37));
        if (n > 0) {
            stringBuffer.append('(');
            stringBuffer.append(n);
            if (n2 > 0) {
                stringBuffer.append(',');
                stringBuffer.append(n2);
            }
            stringBuffer.append(')');
        }
        stringBuffer.append(": ");
        stringBuffer.append(string);
        Message message = new Message(this.workspace, storage == null ? null : this.project, storage, stringBuffer.toString(), n3, n, n2, bl ? 2 : 1);
        this.msgList.add(message);
        this.logMessages();
    }

    public void error(Storage storage, int n, int n2, int n3, String string) {
        this.printMsg(false, storage, n, n2, n3, string);
        ++this.errCnt;
    }

    public void warning(Storage storage, int n, int n2, int n3, String string) {
        this.printMsg(true, storage, n, n2, n3, string);
        ++this.wrnCnt;
    }

    public void clear(Storage storage) {
        if (storage != null) {
            if (this.clearCache.get(storage.getPath()) != null) {
                return;
            }
            this.clearCache.put(storage.getPath(), storage.getPath());
        }
        Message message = new Message(this.workspace, this.project, storage, null, -1, 0, 0, 3);
        this.msgList.add(message);
        this.logMessages();
    }

    private void starting() {
        Message message = new Message(this.workspace, this.project, null, null, -1, 0, 0, 6);
        this.msgList.add(message);
        this.logMessages();
    }

    public void completed() {
        Message message = new Message(this.workspace, this.project, null, null, -1, 0, 0, 4);
        this.msgList.add(message);
        this.logMessages();
    }

    public int nerrors() {
        return this.errCnt;
    }

    public int nwarnings() {
        return this.wrnCnt;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void registerAsynchronousLogPage(LogPage logPage) {
        HashMap hashMap = this.asyncLogPages;
        synchronized (hashMap) {
            Integer n = (Integer)this.asyncLogPages.get(logPage);
            if (n == null) {
                n = new Integer(1);
                if (logPage instanceof CompilerPage) {
                    ((CompilerPage)logPage).startAsynchronousLogging();
                }
            } else {
                n = new Integer(n + 1);
            }
            this.asyncLogPages.put(logPage, n);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void unregisterAsynchronousLogPage(LogPage logPage) {
        HashMap hashMap = this.asyncLogPages;
        synchronized (hashMap) {
            this.logMessages();
            Integer n = (Integer)this.asyncLogPages.get(logPage);
            if (n != null) {
                if (n > 1) {
                    this.asyncLogPages.put(logPage, new Integer(n - 1));
                } else {
                    this.asyncLogPages.remove(logPage);
                    if (logPage instanceof CompilerPage) {
                        ((CompilerPage)logPage).finishAsynchronousLogging();
                    }
                }
            }
        }
    }

    public IdeLog() {
        this.$init$();
    }

    public static interface ActivateEvent {
        public void activate(Message var1);
    }

    public static interface FixEvent {
        public void fix(Message var1);

        public boolean canFix(Message var1);
    }

    public static class Message {
        static final int Normal = 0;
        static final int Error = 1;
        static final int Warning = 2;
        static final int Remove = 3;
        static final int Completed = 4;
        static final int NoDetails = 5;
        static final int Starting = 6;
        public ActivateEvent activateEvent;
        public FixEvent fixEvent;
        public Object userData;
        Workspace workspace;
        Project project;
        Storage fname;
        String msg;
        int line;
        int col;
        int code;
        int kind;

        void $init$() {
            this.activateEvent = null;
            this.fixEvent = null;
            this.userData = null;
        }

        private Message() {
            this.$init$();
        }

        public Message(Workspace workspace, Project project, Storage storage, String string, int n, int n2, int n3, int n4) {
            this.$init$();
            this.fname = storage;
            this.msg = string;
            this.workspace = workspace;
            this.project = project;
            this.code = n;
            this.line = n2;
            this.col = n3;
            this.kind = n4;
        }

        public Message(Workspace workspace, Project project, Storage storage, String string, int n, int n2, int n3) {
            this(workspace, project, storage, string, n, n2, n3, 0);
        }

        public String toString() {
            return this.msg;
        }

        public boolean isWarning() {
            return this.kind == 2;
        }

        public boolean isError() {
            return this.kind == 1;
        }

        public boolean isRemove() {
            return this.kind == 3;
        }

        public boolean isStarting() {
            return this.kind == 6;
        }

        public boolean isCompleted() {
            return this.kind == 4;
        }

        public boolean isNoDetails() {
            return this.kind == 5;
        }

        public Project getProject() {
            return this.project;
        }

        public Workspace getWorkspace() {
            return this.workspace;
        }

        public String getMessage() {
            return this.msg;
        }
    }
}

