/*
 * Decompiled with CFR 0.152.
 */
package oracle.jdeveloper.compiler;

import java.net.URL;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import oracle.ide.model.Node;
import oracle.ide.model.NodeFactory;
import oracle.ide.net.URLFileSystem;
import oracle.ide.net.URLPath;

class IdeStorageMap {
    private HashMap hash;

    private IdeStorageMap(HashMap hashMap) {
        this.hash = hashMap;
    }

    public static IdeStorageMap create(URLPath uRLPath) {
        HashMap hashMap = new HashMap();
        Iterator iterator = NodeFactory.getCachedNodes();
        while (iterator.hasNext()) {
            URL uRL;
            URL uRL2;
            String string;
            Node node = (Node)iterator.next();
            if (!node.isOpen() || !node.isDirty() || !node.isNew() || (string = (uRL2 = node.getURL()).getProtocol()) == null || !string.equals("file") || (uRL = IdeStorageMap.getBaseFor(uRLPath, uRL2)) == null) continue;
            URL uRL3 = URLFileSystem.getParent((URL)uRL2);
            while (uRL3 != null && !uRL.equals(uRL2) && URLFileSystem.isBaseURLFor((URL)uRL, (URL)uRL2)) {
                String string2 = URLFileSystem.getFileName((URL)uRL2);
                ArrayList<String> arrayList = (ArrayList<String>)hashMap.get(uRL3);
                if (arrayList == null) {
                    arrayList = new ArrayList<String>();
                    arrayList.add(string2);
                    hashMap.put(uRL3, arrayList);
                } else if (!arrayList.contains(string2)) {
                    arrayList.add(string2);
                }
                uRL2 = uRL3;
                uRL3 = URLFileSystem.getParent((URL)uRL2);
            }
        }
        return hashMap.size() > 0 ? new IdeStorageMap(hashMap) : null;
    }

    public ArrayList get(URL uRL) {
        ArrayList arrayList = (ArrayList)this.hash.get(uRL);
        return arrayList == null ? null : (ArrayList)arrayList.clone();
    }

    public void destroy() {
        this.hash.clear();
        this.hash = null;
    }

    private static URL getBaseFor(URLPath uRLPath, URL uRL) {
        URL[] uRLArray = uRLPath.getEntries();
        int n = 0;
        while (n < uRLArray.length) {
            URL uRL2 = uRLArray[n];
            if (URLFileSystem.isBaseURLFor((URL)uRL2, (URL)uRL)) {
                return uRL2;
            }
            ++n;
        }
        return null;
    }
}

